/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.libraries.asm.tree.analysis;

import org.eclipse.persistence.internal.libraries.asm.Type;
import org.eclipse.persistence.internal.libraries.asm.tree.analysis.AnalyzerException;
import org.eclipse.persistence.internal.libraries.asm.tree.analysis.BasicValue;
import org.eclipse.persistence.internal.libraries.asm.tree.analysis.BasicVerifier;
import org.eclipse.persistence.internal.libraries.asm.tree.analysis.Value;

public class SimpleVerifier
extends BasicVerifier {
    public Value newValue(Type type) {
        Value value = super.newValue(type);
        if (value == BasicValue.REFERENCE_VALUE) {
            if (type.getSort() == 9) {
                value = this.newValue(type.getElementType());
                String string = ((BasicValue)value).getType().getDescriptor();
                for (int i = 0; i < type.getDimensions(); ++i) {
                    string = "[" + string;
                }
                value = new BasicValue(Type.getType(string));
            } else {
                value = new BasicValue(type);
            }
        }
        return value;
    }

    protected boolean isArrayValue(Value value) {
        Type type = ((BasicValue)value).getType();
        if (type != null) {
            return type.getDescriptor().equals("Lnull;") || type.getSort() == 9;
        }
        return false;
    }

    protected Value getElementValue(Value value) throws AnalyzerException {
        Type type = ((BasicValue)value).getType();
        if (type != null) {
            if (type.getSort() == 9) {
                return this.newValue(Type.getType(type.getDescriptor().substring(1)));
            }
            if (type.getDescriptor().equals("Lnull;")) {
                return value;
            }
        }
        throw new AnalyzerException("Not an array type");
    }

    protected boolean isSubTypeOf(Value value, Value value2) {
        Type type = ((BasicValue)value2).getType();
        Type type2 = ((BasicValue)value).getType();
        if (type == null) {
            return type2 == null;
        }
        switch (type.getSort()) {
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                return type2 == type;
            }
            case 9: 
            case 10: {
                if (type.getDescriptor().equals("Lnull;")) {
                    return type2.getSort() == 10 || type2.getSort() == 9;
                }
                Class clazz = this.getClass(type);
                if (type2.getDescriptor().equals("Lnull;")) {
                    return !clazz.isPrimitive();
                }
                if (type2.getSort() == 10 || type2.getSort() == 9) {
                    Class clazz2 = this.getClass(type2);
                    return clazz.isAssignableFrom(clazz2);
                }
                return false;
            }
        }
        throw new RuntimeException("Internal error");
    }

    public Value merge(Value value, Value value2) {
        if (!value.equals(value2)) {
            Type type = ((BasicValue)value).getType();
            Type type2 = ((BasicValue)value2).getType();
            if (!(type == null || type.getSort() != 10 && type.getSort() != 9 || type2 == null || type2.getSort() != 10 && type2.getSort() != 9)) {
                Class clazz;
                if (type.getDescriptor().equals("Lnull;")) {
                    return value2;
                }
                if (type2.getDescriptor().equals("Lnull;")) {
                    return value;
                }
                Class clazz2 = this.getClass(type);
                if (clazz2.isAssignableFrom(clazz = this.getClass(type2))) {
                    return value;
                }
                if (clazz.isAssignableFrom(clazz2)) {
                    return value2;
                }
                do {
                    if (clazz2 != null && !clazz2.isInterface()) continue;
                    return BasicValue.REFERENCE_VALUE;
                } while (!(clazz2 = clazz2.getSuperclass()).isAssignableFrom(clazz));
                return this.newValue(Type.getType(clazz2));
            }
            return BasicValue.UNINITIALIZED_VALUE;
        }
        return value;
    }

    protected Class getClass(Type type) {
        try {
            if (type.getSort() == 9) {
                return Class.forName(type.getDescriptor().replace('/', '.'));
            }
            return Class.forName(type.getClassName());
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new RuntimeException(classNotFoundException.toString());
        }
    }
}

