/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.metadata.sequencing;

import java.lang.annotation.Annotation;
import org.eclipse.persistence.internal.jpa.metadata.sequencing.MetadataHelper;

public class SequenceGeneratorMetadata {
    private boolean m_loadedFromXML;
    private Integer m_allocationSize;
    private Integer m_initialValue;
    private String m_location;
    private String m_name;
    private String m_sequenceName;

    public SequenceGeneratorMetadata() {
        this.m_loadedFromXML = true;
    }

    public SequenceGeneratorMetadata(Annotation sequenceGenerator, String entityClassName) {
        this.m_loadedFromXML = false;
        this.m_location = entityClassName;
        this.m_allocationSize = (Integer)MetadataHelper.invokeMethod("allocationSize", sequenceGenerator);
        this.m_initialValue = (Integer)MetadataHelper.invokeMethod("initialValue", sequenceGenerator);
        this.m_name = (String)MetadataHelper.invokeMethod("name", sequenceGenerator);
        this.m_sequenceName = (String)MetadataHelper.invokeMethod("sequenceName", sequenceGenerator);
    }

    public boolean equals(Object objectToCompare) {
        if (objectToCompare instanceof SequenceGeneratorMetadata) {
            SequenceGeneratorMetadata generator = (SequenceGeneratorMetadata)objectToCompare;
            if (!generator.getName().equals(this.getName())) {
                return false;
            }
            if (!generator.getInitialValue().equals(this.getInitialValue())) {
                return false;
            }
            if (!generator.getAllocationSize().equals(this.getAllocationSize())) {
                return false;
            }
            return generator.getSequenceName().equals(this.getSequenceName());
        }
        return false;
    }

    public Integer getAllocationSize() {
        return this.m_allocationSize;
    }

    public Integer getInitialValue() {
        return this.m_initialValue;
    }

    public String getLocation() {
        return this.m_location;
    }

    public String getName() {
        return this.m_name;
    }

    public String getSequenceName() {
        return this.m_sequenceName;
    }

    public boolean loadedFromAnnotations() {
        return !this.loadedFromXML();
    }

    public boolean loadedFromXML() {
        return this.m_loadedFromXML;
    }

    public void setAllocationSize(Integer allocationSize) {
        this.m_allocationSize = allocationSize;
    }

    public void setInitialValue(Integer initialValue) {
        this.m_initialValue = initialValue;
    }

    public void setLocation(String location) {
        this.m_location = location;
    }

    public void setName(String name) {
        this.m_name = name;
    }

    public void setSequenceName(String sequenceName) {
        this.m_sequenceName = sequenceName;
    }
}

