/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.metadata.listeners;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;
import org.eclipse.persistence.descriptors.DescriptorEvent;
import org.eclipse.persistence.descriptors.DescriptorEventAdapter;
import org.eclipse.persistence.descriptors.DescriptorEventManager;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.internal.jpa.metadata.MetadataHelper;
import org.eclipse.persistence.internal.security.PrivilegedAccessHelper;
import org.eclipse.persistence.internal.security.PrivilegedMethodInvoker;

public class EntityListenerMetadata
extends DescriptorEventAdapter {
    public static final String POST_BUILD = "postBuild";
    public static final String POST_CLONE = "postClone";
    public static final String POST_DELETE = "postDelete";
    public static final String POST_INSERT = "postInsert";
    public static final String POST_REFRESH = "postRefresh";
    public static final String POST_UPDATE = "postUpdate";
    public static final String PRE_PERSIST = "prePersist";
    public static final String PRE_REMOVE = "preRemove";
    public static final String PRE_UPDATE_WITH_CHANGES = "preUpdateWithChanges";
    private Object m_listener;
    private Class m_entityClass;
    private Hashtable<String, Method> m_methods = new Hashtable();
    private Hashtable<Integer, Boolean> m_overriddenEvents = new Hashtable();
    private static Hashtable<Integer, String> m_eventStrings;
    private String m_className;
    private String m_postLoad;
    private String m_postPersist;
    private String m_postRemove;
    private String m_postUpdate;
    private String m_prePersist;
    private String m_preRemove;
    private String m_preUpdate;

    protected EntityListenerMetadata() {
        if (m_eventStrings == null) {
            m_eventStrings = new Hashtable();
            m_eventStrings.put(new Integer(8), POST_BUILD);
            m_eventStrings.put(new Integer(10), POST_CLONE);
            m_eventStrings.put(new Integer(3), POST_DELETE);
            m_eventStrings.put(new Integer(5), POST_INSERT);
            m_eventStrings.put(new Integer(9), POST_REFRESH);
            m_eventStrings.put(new Integer(7), POST_UPDATE);
            m_eventStrings.put(new Integer(15), PRE_PERSIST);
            m_eventStrings.put(new Integer(16), PRE_REMOVE);
            m_eventStrings.put(new Integer(17), PRE_UPDATE_WITH_CHANGES);
        }
    }

    protected EntityListenerMetadata(Class entityClass) {
        this();
        this.m_entityClass = entityClass;
    }

    public EntityListenerMetadata(Class listenerClass, Class entityClass) {
        this(entityClass);
        this.initializeListenerClass(listenerClass);
    }

    public void addEventMethod(String event, Method method) {
        if (this.m_methods.containsKey(event)) {
            Method existingMethod = (Method)this.getMethods().get(event);
            if (!existingMethod.getName().equals(method.getName())) {
                throw ValidationException.multipleLifecycleCallbackMethodsForSameLifecycleEvent(this.getListenerClass(), method, this.getEventMethod(event));
            }
        } else {
            this.validateMethod(method);
            this.m_methods.put(event, method);
        }
    }

    public Object clone() {
        EntityListenerMetadata listener = new EntityListenerMetadata();
        listener.setClassName(this.getClassName());
        listener.setPostLoad(this.getPostLoad());
        listener.setPostPersist(this.getPostPersist());
        listener.setPostRemove(this.getPostRemove());
        listener.setPostUpdate(this.getPostUpdate());
        listener.setPrePersist(this.getPrePersist());
        listener.setPreRemove(this.getPreRemove());
        listener.setPreUpdate(this.getPreUpdate());
        return listener;
    }

    public String getClassName() {
        return this.m_className;
    }

    public Class getEntityClass() {
        return this.m_entityClass;
    }

    protected Method getEventMethod(int eventCode) {
        String eventString = m_eventStrings.get(eventCode);
        if (eventString != null) {
            return this.getEventMethod(eventString);
        }
        return null;
    }

    protected Method getEventMethod(String event) {
        return this.m_methods.get(event);
    }

    protected String getEventMethodName(String eventName) {
        Method method = this.getEventMethod(eventName);
        if (method != null) {
            return method.getName();
        }
        return null;
    }

    public Class getListenerClass() {
        return this.m_listener.getClass();
    }

    public Hashtable getMethods() {
        return this.m_methods;
    }

    public String getPostBuildMethodName() {
        return this.getEventMethodName(POST_BUILD);
    }

    public String getPostCloneMethodName() {
        return this.getEventMethodName(POST_CLONE);
    }

    public String getPostDeleteMethodName() {
        return this.getEventMethodName(POST_DELETE);
    }

    public String getPostInsertMethodName() {
        return this.getEventMethodName(POST_INSERT);
    }

    public String getPostLoad() {
        return this.m_postLoad;
    }

    public String getPostPersist() {
        return this.m_postPersist;
    }

    public String getPostRefreshMethodName() {
        return this.getEventMethodName(POST_REFRESH);
    }

    public String getPostRemove() {
        return this.m_postRemove;
    }

    public String getPostUpdate() {
        return this.m_postUpdate;
    }

    public String getPostUpdateMethodName() {
        return this.getEventMethodName(POST_UPDATE);
    }

    public String getPrePersist() {
        return this.m_prePersist;
    }

    public String getPrePersistMethodName() {
        return this.getEventMethodName(PRE_PERSIST);
    }

    public String getPreRemove() {
        return this.m_preRemove;
    }

    public String getPreRemoveMethodName() {
        return this.getEventMethodName(PRE_REMOVE);
    }

    public String getPreUpdate() {
        return this.m_preUpdate;
    }

    public String getPreUpdateWithChangesMethodName() {
        return this.getEventMethodName(PRE_UPDATE_WITH_CHANGES);
    }

    public boolean hasCallbackMethods() {
        return this.m_methods.size() > 0;
    }

    public boolean hasOverriddenEventMethod(Method eventMethod, int eventCode) {
        return this.hasOverriddenEventMethod(this.getEventMethod(eventCode), eventMethod);
    }

    protected boolean hasOverriddenEventMethod(Method eventMethod1, Method eventMethod2) {
        return eventMethod1 != null && eventMethod1.getName().equals(eventMethod2.getName());
    }

    public boolean hasOverriddenEventMethod(Method eventMethod, String eventCode) {
        return this.hasOverriddenEventMethod(this.getEventMethod(eventCode), eventMethod);
    }

    public void initializeListenerClass(Class listenerClass) {
        this.m_listener = MetadataHelper.getClassInstance(listenerClass);
    }

    protected void invokeMethod(Method method, Object onObject, Object[] objectList, DescriptorEvent event) {
        block10: {
            if (method != null) {
                try {
                    if (PrivilegedAccessHelper.shouldUsePrivilegedAccess()) {
                        try {
                            AccessController.doPrivileged(new PrivilegedMethodInvoker(method, onObject, objectList));
                            break block10;
                        }
                        catch (PrivilegedActionException exception) {
                            Exception throwableException = exception.getException();
                            if (throwableException instanceof IllegalAccessException) {
                                throw ValidationException.invalidCallbackMethod(onObject.getClass(), method.toString());
                            }
                            Throwable cause = throwableException.getCause();
                            if (cause instanceof RuntimeException) {
                                throw (RuntimeException)cause;
                            }
                            throw (Error)cause;
                        }
                    }
                    PrivilegedAccessHelper.invokeMethod(method, onObject, objectList);
                }
                catch (IllegalAccessException exception) {
                    throw ValidationException.invalidCallbackMethod(onObject.getClass(), method.toString());
                }
                catch (InvocationTargetException e) {
                    Throwable cause = e.getCause();
                    if (cause instanceof RuntimeException) {
                        throw (RuntimeException)cause;
                    }
                    throw (Error)cause;
                }
            }
        }
    }

    protected void invokeMethod(String event, DescriptorEvent descriptorEvent) {
        Object[] objectList = new Object[]{descriptorEvent.getSource()};
        this.invokeMethod(this.getEventMethod(event), this.m_listener, objectList, descriptorEvent);
    }

    public boolean isOverriddenEvent(DescriptorEvent event, Vector eventManagers) {
        int eventCode = event.getEventCode();
        if (!this.m_overriddenEvents.containsKey(eventCode)) {
            this.m_overriddenEvents.put(eventCode, false);
            Method eventMethod = this.getEventMethod(eventCode);
            if (eventMethod != null) {
                DescriptorEventManager eventManager;
                EntityListenerMetadata childListener;
                Iterator i$ = eventManagers.iterator();
                while (i$.hasNext() && (childListener = (EntityListenerMetadata)(eventManager = (DescriptorEventManager)i$.next()).getEntityEventListener()) != this) {
                    if (!childListener.hasOverriddenEventMethod(eventMethod, eventCode)) continue;
                    this.m_overriddenEvents.put(eventCode, true);
                    break;
                }
            }
        }
        return this.m_overriddenEvents.get(eventCode);
    }

    protected boolean isSessionPostBuildEvent(DescriptorEvent event) {
        if (m_eventStrings.get(event.getEventCode()).equals(POST_BUILD)) {
            return !event.getSession().isUnitOfWork();
        }
        return false;
    }

    public void postBuild(DescriptorEvent event) {
        this.invokeMethod(POST_BUILD, event);
    }

    public void postClone(DescriptorEvent event) {
        this.invokeMethod(POST_CLONE, event);
    }

    public void postDelete(DescriptorEvent event) {
        this.invokeMethod(POST_DELETE, event);
    }

    public void postInsert(DescriptorEvent event) {
        this.invokeMethod(POST_INSERT, event);
    }

    public void postRefresh(DescriptorEvent event) {
        this.invokeMethod(POST_REFRESH, event);
    }

    public void postUpdate(DescriptorEvent event) {
        this.invokeMethod(POST_UPDATE, event);
    }

    public void prePersist(DescriptorEvent event) {
        this.invokeMethod(PRE_PERSIST, event);
    }

    public void preRemove(DescriptorEvent event) {
        this.invokeMethod(PRE_REMOVE, event);
    }

    public void preUpdateWithChanges(DescriptorEvent event) {
        this.invokeMethod(PRE_UPDATE_WITH_CHANGES, event);
    }

    public void setClassName(String className) {
        this.m_className = className;
    }

    public void setEntityClass(Class entityClass) {
        this.m_entityClass = entityClass;
    }

    public void setListener(Object listener) {
        this.m_listener = listener;
    }

    public void setPostBuildMethod(Method method) {
        this.addEventMethod(POST_BUILD, method);
    }

    public void setPostCloneMethod(Method method) {
        this.addEventMethod(POST_CLONE, method);
    }

    public void setPostDeleteMethod(Method method) {
        this.addEventMethod(POST_DELETE, method);
    }

    public void setPostInsertMethod(Method method) {
        this.addEventMethod(POST_INSERT, method);
    }

    public void setPostLoad(String postLoad) {
        this.m_postLoad = postLoad;
    }

    public void setPostPersist(String postPersist) {
        this.m_postPersist = postPersist;
    }

    public void setPostRefreshMethod(Method method) {
        this.addEventMethod(POST_REFRESH, method);
    }

    public void setPostRemove(String postRemove) {
        this.m_postRemove = postRemove;
    }

    public void setPostUpdate(String postUpdate) {
        this.m_postUpdate = postUpdate;
    }

    public void setPostUpdateMethod(Method method) {
        this.addEventMethod(POST_UPDATE, method);
    }

    public void setPrePersist(String prePersist) {
        this.m_prePersist = prePersist;
    }

    public void setPrePersistMethod(Method method) {
        this.addEventMethod(PRE_PERSIST, method);
    }

    public void setPreRemove(String preRemove) {
        this.m_preRemove = preRemove;
    }

    public void setPreRemoveMethod(Method method) {
        this.addEventMethod(PRE_REMOVE, method);
    }

    public void setPreUpdate(String preUpdate) {
        this.m_preUpdate = preUpdate;
    }

    public void setPreUpdateWithChangesMethod(Method method) {
        this.addEventMethod(PRE_UPDATE_WITH_CHANGES, method);
    }

    protected void validateMethod(Method method) {
        int numberOfParameters = method.getParameterTypes().length;
        if (numberOfParameters != 1 || !method.getParameterTypes()[0].isAssignableFrom(this.m_entityClass)) {
            Class<?> parameterClass = numberOfParameters == 0 ? null : method.getParameterTypes()[0];
            throw ValidationException.invalidEntityListenerCallbackMethodArguments(this.m_entityClass, parameterClass, this.m_listener.getClass(), method.getName());
        }
        this.validateMethodModifiers(method);
    }

    protected void validateMethodModifiers(Method method) {
        int modifiers = method.getModifiers();
        if (Modifier.isStatic(modifiers) || Modifier.isFinal(modifiers)) {
            throw ValidationException.invalidCallbackMethodModifier(this.getListenerClass(), method.getName());
        }
    }
}

