/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.metadata.converters;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Constructor;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.internal.jpa.metadata.MetadataHelper;
import org.eclipse.persistence.internal.jpa.metadata.accessors.DirectAccessor;
import org.eclipse.persistence.internal.jpa.metadata.converters.ConversionValueMetadata;
import org.eclipse.persistence.internal.jpa.metadata.converters.TypeConverterMetadata;
import org.eclipse.persistence.internal.security.PrivilegedAccessHelper;
import org.eclipse.persistence.internal.security.PrivilegedGetConstructorFor;
import org.eclipse.persistence.internal.security.PrivilegedInvokeConstructor;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.mappings.converters.EnumTypeConverter;
import org.eclipse.persistence.mappings.converters.ObjectTypeConverter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ObjectTypeConverterMetadata
extends TypeConverterMetadata {
    private List<ConversionValueMetadata> m_conversionValues;
    private String m_defaultObjectValue;

    public ObjectTypeConverterMetadata() {
        this.setLoadedFromXML();
    }

    public ObjectTypeConverterMetadata(Annotation objectTypeConverter, AnnotatedElement annotatedElement) {
        this.setLoadedFromAnnotation();
        this.setLocation(annotatedElement);
        this.setName((String)this.invokeMethod("name", objectTypeConverter));
        this.setDataType((Class)this.invokeMethod("dataType", objectTypeConverter));
        this.setObjectType((Class)this.invokeMethod("objectType", objectTypeConverter));
        this.setConversionValues((Annotation[])this.invokeMethod("conversionValues", objectTypeConverter));
        this.m_defaultObjectValue = (String)this.invokeMethod("defaultObjectValue", objectTypeConverter);
    }

    @Override
    public boolean equals(Object objectToCompare) {
        if (objectToCompare instanceof ObjectTypeConverterMetadata) {
            ObjectTypeConverterMetadata objectTypeConverter = (ObjectTypeConverterMetadata)objectToCompare;
            if (!MetadataHelper.valuesMatch(this.getName(), objectTypeConverter.getName())) {
                return false;
            }
            if (!MetadataHelper.valuesMatch(this.getDataType(), objectTypeConverter.getDataType())) {
                return false;
            }
            if (!MetadataHelper.valuesMatch(this.getObjectType(), objectTypeConverter.getObjectType())) {
                return false;
            }
            if (this.m_conversionValues.size() != objectTypeConverter.getConversionValues().size()) {
                return false;
            }
            for (ConversionValueMetadata conversionValue : this.m_conversionValues) {
                if (objectTypeConverter.hasConversionValue(conversionValue)) continue;
                return false;
            }
            return MetadataHelper.valuesMatch(this.m_defaultObjectValue, objectTypeConverter.getDefaultObjectValue());
        }
        return false;
    }

    public List<ConversionValueMetadata> getConversionValues() {
        return this.m_conversionValues;
    }

    public String getDefaultObjectValue() {
        return this.m_defaultObjectValue;
    }

    protected boolean hasConversionValue(ConversionValueMetadata conversionValue) {
        for (ConversionValueMetadata myConversionValue : this.m_conversionValues) {
            if (!MetadataHelper.valuesMatch(myConversionValue.getDataValue(), conversionValue.getDataValue()) || !MetadataHelper.valuesMatch(myConversionValue.getObjectValue(), conversionValue.getObjectValue())) continue;
            return true;
        }
        return false;
    }

    public boolean hasConversionValues() {
        return !this.m_conversionValues.isEmpty();
    }

    private Object initObject(Class type, String value, DirectAccessor accessor, boolean isData) {
        if (PrivilegedAccessHelper.shouldUsePrivilegedAccess()) {
            try {
                Constructor constructor = (Constructor)AccessController.doPrivileged(new PrivilegedGetConstructorFor(type, new Class[]{String.class}, false));
                return AccessController.doPrivileged(new PrivilegedInvokeConstructor(constructor, new Object[]{value}));
            }
            catch (PrivilegedActionException exception) {
                this.throwInitObjectException(exception, type, value, isData);
            }
        } else {
            try {
                Constructor constructor = PrivilegedAccessHelper.getConstructorFor(type, new Class[]{String.class}, false);
                return PrivilegedAccessHelper.invokeConstructor(constructor, new Object[]{value});
            }
            catch (Exception exception) {
                this.throwInitObjectException(exception, type, value, isData);
            }
        }
        return null;
    }

    @Override
    public void process(DatabaseMapping mapping, DirectAccessor accessor) {
        ObjectTypeConverter converter;
        Class dataType = this.getDataType(accessor);
        Class<String> objectType = this.getObjectType(accessor);
        if (objectType.isEnum()) {
            converter = new EnumTypeConverter(mapping, objectType.getName());
            objectType = String.class;
        } else {
            converter = new ObjectTypeConverter(mapping);
        }
        HashMap<String, String> dataToObjectValues = new HashMap<String, String>();
        HashMap<String, String> objectToDataValues = new HashMap<String, String>();
        if (this.hasConversionValues()) {
            for (ConversionValueMetadata conversionValue : this.getConversionValues()) {
                String dataValue = conversionValue.getDataValue();
                String objectValue = conversionValue.getObjectValue();
                if (dataToObjectValues.containsKey(dataValue)) {
                    throw ValidationException.multipleObjectValuesForDataValue(accessor.getJavaClass(), this.getName(), dataValue);
                }
                dataToObjectValues.put(dataValue, objectValue);
                if (objectToDataValues.containsKey(objectValue)) continue;
                objectToDataValues.put(objectValue, dataValue);
            }
        }
        for (String dataValue : dataToObjectValues.keySet()) {
            String objectValue = (String)dataToObjectValues.get(dataValue);
            Object data = this.initObject(dataType, dataValue, accessor, true);
            Object object = this.initObject(objectType, objectValue, accessor, false);
            if (objectToDataValues.containsKey(objectValue)) {
                converter.addConversionValue(data, object);
                continue;
            }
            converter.addToAttributeOnlyConversionValue(data, object);
        }
        if (!this.getDefaultObjectValue().equals("")) {
            converter.setDefaultAttributeValue(this.initObject(objectType, this.getDefaultObjectValue(), accessor, false));
        }
        accessor.setConverter(mapping, converter);
    }

    public void setConversionValues(List<ConversionValueMetadata> conversionValues) {
        this.m_conversionValues = conversionValues;
    }

    protected void setConversionValues(Annotation[] conversionValues) {
        this.m_conversionValues = new ArrayList<ConversionValueMetadata>();
        for (Annotation conversionValue : conversionValues) {
            this.m_conversionValues.add(new ConversionValueMetadata(conversionValue));
        }
    }

    public void setDefaultObjectValue(String defaultObjectValue) {
        this.m_defaultObjectValue = defaultObjectValue;
    }

    protected void throwInitObjectException(Exception exception, Class type, String value, boolean isData) {
        if (isData) {
            throw ValidationException.errorInstantiatingConversionValueData(this.getName(), value, type, exception);
        }
        throw ValidationException.errorInstantiatingConversionValueObject(this.getName(), value, type, exception);
    }
}

