/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.metadata.columns;

import java.lang.annotation.Annotation;
import org.eclipse.persistence.internal.helper.DatabaseField;
import org.eclipse.persistence.internal.jpa.metadata.columns.MetadataHelper;

public class PrimaryKeyJoinColumnMetadata {
    private String m_name;
    private String m_columnDefinition;
    private String m_referencedColumnName;

    public PrimaryKeyJoinColumnMetadata() {
    }

    public PrimaryKeyJoinColumnMetadata(Annotation primaryKeyJoinColumn) {
        if (primaryKeyJoinColumn != null) {
            this.setReferencedColumnName((String)MetadataHelper.invokeMethod("referencedColumnName", primaryKeyJoinColumn));
            this.setName((String)MetadataHelper.invokeMethod("name", primaryKeyJoinColumn));
            this.setColumnDefinition((String)MetadataHelper.invokeMethod("columnDefinition", primaryKeyJoinColumn));
        }
    }

    public String getColumnDefinition() {
        return this.m_columnDefinition;
    }

    public DatabaseField getForeignKeyField() {
        DatabaseField fkField = new DatabaseField();
        fkField.setName(this.m_name == null ? "" : this.m_name);
        fkField.setColumnDefinition(this.m_columnDefinition == null ? "" : this.m_columnDefinition);
        return fkField;
    }

    public String getName() {
        return this.m_name;
    }

    public DatabaseField getPrimaryKeyField() {
        DatabaseField pkField = new DatabaseField();
        pkField.setName(this.m_referencedColumnName == null ? "" : this.m_referencedColumnName);
        return pkField;
    }

    public String getReferencedColumnName() {
        return this.m_referencedColumnName;
    }

    public boolean isForeignKeyFieldNotSpecified() {
        return this.m_name == null || this.m_name.equals("");
    }

    public boolean isPrimaryKeyFieldNotSpecified() {
        return this.m_referencedColumnName == null || this.m_referencedColumnName.equals("");
    }

    public void setColumnDefinition(String columnDefinition) {
        this.m_columnDefinition = columnDefinition;
    }

    public void setName(String name) {
        this.m_name = name;
    }

    public void setReferencedColumnName(String referencedColumnName) {
        this.m_referencedColumnName = referencedColumnName;
    }
}

