/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.metadata.columns;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.persistence.internal.jpa.metadata.MetadataDescriptor;
import org.eclipse.persistence.internal.jpa.metadata.columns.JoinColumnMetadata;
import org.eclipse.persistence.internal.jpa.metadata.columns.MetadataHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JoinColumnsMetadata {
    private List<JoinColumnMetadata> m_joinColumns;

    public JoinColumnsMetadata(List<JoinColumnMetadata> joinColumns) {
        this.m_joinColumns = joinColumns == null ? new ArrayList<JoinColumnMetadata>() : joinColumns;
    }

    public JoinColumnsMetadata(Annotation joinColumns, Annotation joinColumn) {
        this.m_joinColumns = new ArrayList<JoinColumnMetadata>();
        if (joinColumns != null) {
            for (Annotation jColumn : (Annotation[])MetadataHelper.invokeMethod("value", joinColumns)) {
                this.m_joinColumns.add(new JoinColumnMetadata(jColumn));
            }
        }
        if (joinColumn != null) {
            this.m_joinColumns.add(new JoinColumnMetadata(joinColumn));
        }
    }

    public boolean loadedFromXML() {
        return false;
    }

    public List<JoinColumnMetadata> values(MetadataDescriptor descriptor) {
        if (this.m_joinColumns.isEmpty()) {
            if (descriptor.hasCompositePrimaryKey()) {
                for (String primaryKeyField : descriptor.getPrimaryKeyFieldNames()) {
                    JoinColumnMetadata joinColumn = new JoinColumnMetadata();
                    joinColumn.setReferencedColumnName(primaryKeyField);
                    joinColumn.setName(primaryKeyField);
                    this.m_joinColumns.add(joinColumn);
                }
            } else {
                this.m_joinColumns.add(new JoinColumnMetadata());
            }
        } else {
            for (JoinColumnMetadata joinColumn : this.m_joinColumns) {
                joinColumn.setReferencedColumnName(descriptor.getPrimaryKeyJoinColumnAssociation(joinColumn.getReferencedColumnName()));
            }
        }
        return this.m_joinColumns;
    }
}

