/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.metadata.accessors;

import org.eclipse.persistence.descriptors.TimestampLockingPolicy;
import org.eclipse.persistence.descriptors.VersionLockingPolicy;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.internal.jpa.metadata.MetadataHelper;
import org.eclipse.persistence.internal.jpa.metadata.accessors.BasicAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.ClassAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataAccessibleObject;

public class VersionAccessor
extends BasicAccessor {
    public VersionAccessor() {
    }

    public VersionAccessor(MetadataAccessibleObject accessibleObject, ClassAccessor classAccessor) {
        super(accessibleObject, classAccessor);
    }

    public void process() {
        super.process();
        if (this.getDescriptor().usesOptimisticLocking()) {
            this.getLogger().logWarningMessage("metadata_warning_ignore_version_locking", this);
        } else {
            Class lockType = this.getRawClass();
            this.getField().setType(lockType);
            if (MetadataHelper.isValidVersionLockingType(lockType) || MetadataHelper.isValidTimestampVersionLockingType(lockType)) {
                VersionLockingPolicy policy = MetadataHelper.isValidVersionLockingType(lockType) ? new VersionLockingPolicy(this.getField()) : new TimestampLockingPolicy(this.getField());
                policy.storeInObject();
                policy.setIsCascaded(this.getDescriptor().usesCascadedOptimisticLocking());
                this.getDescriptor().setOptimisticLockingPolicy(policy);
            } else {
                throw ValidationException.invalidTypeForVersionAttribute(this.getAttributeName(), lockType, this.getJavaClass());
            }
        }
    }
}

