/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.metadata.accessors;

import java.lang.annotation.Annotation;
import javax.persistence.GeneratedValue;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.internal.helper.DatabaseField;
import org.eclipse.persistence.internal.jpa.metadata.accessors.BasicAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.ClassAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataAccessibleObject;
import org.eclipse.persistence.internal.jpa.metadata.sequencing.GeneratedValueMetadata;

public class IdAccessor
extends BasicAccessor {
    private GeneratedValueMetadata m_generatedValue;

    public IdAccessor() {
    }

    public IdAccessor(MetadataAccessibleObject accessibleObject, ClassAccessor classAccessor) {
        super(accessibleObject, classAccessor);
    }

    public GeneratedValueMetadata getGeneratedValue() {
        return this.m_generatedValue;
    }

    public void process() {
        super.process();
        String attributeName = this.getAttributeName();
        if (this.getDescriptor().hasEmbeddedIdAttribute()) {
            throw ValidationException.embeddedIdAndIdAnnotationFound(this.getJavaClass(), this.getDescriptor().getEmbeddedIdAttributeName(), attributeName);
        }
        this.getDescriptor().validatePKClassId(attributeName, this.getReferenceClass());
        this.getDescriptor().addIdAttributeName(attributeName);
        this.getDescriptor().addPrimaryKeyField(this.getField());
        this.processGeneratedValue();
        this.processTableGenerator();
        this.processSequenceGenerator();
    }

    protected void processGeneratedValue() {
        if (this.m_generatedValue == null) {
            if (this.isAnnotationPresent(GeneratedValue.class)) {
                this.processGeneratedValue(new GeneratedValueMetadata((Annotation)this.getAnnotation(GeneratedValue.class)), this.getField());
            }
        } else {
            this.processGeneratedValue(this.m_generatedValue, this.getField());
        }
    }

    protected void processGeneratedValue(GeneratedValueMetadata generatedValue, DatabaseField sequenceNumberField) {
        DatabaseField existingSequenceNumberField = this.getDescriptor().getSequenceNumberField();
        if (existingSequenceNumberField != null) {
            throw ValidationException.onlyOneGeneratedValueIsAllowed(this.getJavaClass(), existingSequenceNumberField.getQualifiedName(), sequenceNumberField.getQualifiedName());
        }
        this.getDescriptor().setSequenceNumberField(sequenceNumberField);
        this.getProject().addGeneratedValue(generatedValue, this.getJavaClass());
    }

    public void setGeneratedValue(GeneratedValueMetadata value) {
        this.m_generatedValue = value;
    }
}

