/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.metadata.accessors;

import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.AssociationOverride;
import javax.persistence.AssociationOverrides;
import javax.persistence.AttributeOverride;
import javax.persistence.AttributeOverrides;
import javax.persistence.DiscriminatorColumn;
import javax.persistence.DiscriminatorValue;
import javax.persistence.Entity;
import javax.persistence.EntityListeners;
import javax.persistence.ExcludeDefaultListeners;
import javax.persistence.ExcludeSuperclassListeners;
import javax.persistence.IdClass;
import javax.persistence.Inheritance;
import javax.persistence.JoinColumn;
import javax.persistence.MappedSuperclass;
import javax.persistence.NamedNativeQueries;
import javax.persistence.NamedNativeQuery;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.PostLoad;
import javax.persistence.PostPersist;
import javax.persistence.PostRemove;
import javax.persistence.PostUpdate;
import javax.persistence.PrePersist;
import javax.persistence.PreRemove;
import javax.persistence.PreUpdate;
import javax.persistence.PrimaryKeyJoinColumn;
import javax.persistence.PrimaryKeyJoinColumns;
import javax.persistence.SecondaryTable;
import javax.persistence.SecondaryTables;
import javax.persistence.SqlResultSetMapping;
import javax.persistence.SqlResultSetMappings;
import javax.persistence.Table;
import javax.persistence.Transient;
import org.eclipse.persistence.annotations.Cache;
import org.eclipse.persistence.annotations.ChangeTracking;
import org.eclipse.persistence.annotations.Customizer;
import org.eclipse.persistence.annotations.NamedStoredProcedureQueries;
import org.eclipse.persistence.annotations.NamedStoredProcedureQuery;
import org.eclipse.persistence.annotations.OptimisticLocking;
import org.eclipse.persistence.annotations.ReadOnly;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.internal.helper.DatabaseField;
import org.eclipse.persistence.internal.helper.DatabaseTable;
import org.eclipse.persistence.internal.helper.Helper;
import org.eclipse.persistence.internal.jpa.metadata.MetadataDescriptor;
import org.eclipse.persistence.internal.jpa.metadata.MetadataHelper;
import org.eclipse.persistence.internal.jpa.metadata.MetadataProject;
import org.eclipse.persistence.internal.jpa.metadata.accessors.BasicAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.BasicCollectionAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.BasicMapAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.EmbeddedAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.EmbeddedIdAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.IdAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.ManyToManyAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.ManyToOneAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.MappedSuperclassAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.MetadataAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.NonRelationshipAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.OneToManyAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.OneToOneAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.VersionAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataAccessibleObject;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataClass;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataField;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataMethod;
import org.eclipse.persistence.internal.jpa.metadata.cache.CacheMetadata;
import org.eclipse.persistence.internal.jpa.metadata.changetracking.ChangeTrackingMetadata;
import org.eclipse.persistence.internal.jpa.metadata.columns.AssociationOverrideMetadata;
import org.eclipse.persistence.internal.jpa.metadata.columns.AttributeOverrideMetadata;
import org.eclipse.persistence.internal.jpa.metadata.columns.DiscriminatorColumnMetadata;
import org.eclipse.persistence.internal.jpa.metadata.columns.JoinColumnMetadata;
import org.eclipse.persistence.internal.jpa.metadata.columns.PrimaryKeyJoinColumnMetadata;
import org.eclipse.persistence.internal.jpa.metadata.columns.PrimaryKeyJoinColumnsMetadata;
import org.eclipse.persistence.internal.jpa.metadata.inheritance.InheritanceMetadata;
import org.eclipse.persistence.internal.jpa.metadata.listeners.EntityClassListenerMetadata;
import org.eclipse.persistence.internal.jpa.metadata.listeners.EntityListenerMetadata;
import org.eclipse.persistence.internal.jpa.metadata.locking.OptimisticLockingMetadata;
import org.eclipse.persistence.internal.jpa.metadata.queries.NamedNativeQueryMetadata;
import org.eclipse.persistence.internal.jpa.metadata.queries.NamedQueryMetadata;
import org.eclipse.persistence.internal.jpa.metadata.queries.NamedStoredProcedureQueryMetadata;
import org.eclipse.persistence.internal.jpa.metadata.queries.SQLResultSetMappingMetadata;
import org.eclipse.persistence.internal.jpa.metadata.tables.SecondaryTableMetadata;
import org.eclipse.persistence.internal.jpa.metadata.tables.TableMetadata;
import org.eclipse.persistence.internal.jpa.metadata.xml.XMLAttributes;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassAccessor
extends NonRelationshipAccessor {
    private boolean m_excludeDefaultListeners;
    private boolean m_excludeSuperclassListeners;
    private Boolean m_metadataComplete;
    private Boolean m_readOnly;
    private CacheMetadata m_cache;
    private ChangeTrackingMetadata m_changeTracking;
    private Class m_customizerClass;
    private DiscriminatorColumnMetadata m_discriminatorColumn;
    private InheritanceMetadata m_inheritance;
    private List<AssociationOverrideMetadata> m_associationOverrides;
    private List<AttributeOverrideMetadata> m_attributeOverrides;
    private List<NamedQueryMetadata> m_namedQueries;
    private List<NamedNativeQueryMetadata> m_namedNativeQueries;
    private List<NamedStoredProcedureQueryMetadata> m_namedStoredProcedureQueries;
    private List<SecondaryTableMetadata> m_secondaryTables;
    private List<SQLResultSetMappingMetadata> m_sqlResultSetMappings;
    private List<EntityListenerMetadata> m_entityListeners;
    private OptimisticLockingMetadata m_optimisticLocking;
    private String m_access;
    private String m_className;
    private String m_customizerClassName;
    private String m_description;
    private String m_discriminatorValue;
    private String m_entityName;
    private String m_idClassName;
    private String m_mappingFile;
    private String m_prePersist;
    private String m_postPersist;
    private String m_preRemove;
    private String m_postRemove;
    private String m_preUpdate;
    private String m_postUpdate;
    private String m_postLoad;
    private TableMetadata m_table;
    private XMLAttributes m_attributes;

    public ClassAccessor() {
    }

    public ClassAccessor(Class cls, MetadataProject project) {
        super(new MetadataClass(cls), new MetadataDescriptor(cls), project);
        this.getDescriptor().setClassAccessor(this);
    }

    protected ClassAccessor(Class cls, MetadataDescriptor descriptor, MetadataProject project) {
        super(new MetadataClass(cls), descriptor, project);
    }

    protected void addMultipleTableKeyFields(PrimaryKeyJoinColumnsMetadata primaryKeyJoinColumns, DatabaseTable sourceTable, DatabaseTable targetTable, String PK_CTX, String FK_CTX) {
        for (PrimaryKeyJoinColumnMetadata primaryKeyJoinColumn : this.processPrimaryKeyJoinColumns(primaryKeyJoinColumns)) {
            String defaultPKFieldName = this.getDescriptor().getPrimaryKeyFieldName();
            DatabaseField pkField = primaryKeyJoinColumn.getPrimaryKeyField();
            pkField.setName(this.getName(pkField, defaultPKFieldName, PK_CTX));
            pkField.setTable(sourceTable);
            DatabaseField fkField = primaryKeyJoinColumn.getForeignKeyField();
            fkField.setName(this.getName(fkField, pkField.getName(), FK_CTX));
            fkField.setTable(targetTable);
            this.getDescriptor().addForeignKeyFieldForMultipleTable(fkField, pkField);
        }
    }

    protected MetadataAccessor buildAccessor(MetadataAccessibleObject accessibleObject) {
        MetadataAccessor accessor = this.getDescriptor().getAccessorFor(accessibleObject.getAttributeName());
        if (accessor == null) {
            if (MetadataHelper.isBasicCollection(accessibleObject, this.getDescriptor())) {
                return new BasicCollectionAccessor(accessibleObject, this);
            }
            if (MetadataHelper.isBasicMap(accessibleObject, this.getDescriptor())) {
                return new BasicMapAccessor(accessibleObject, this);
            }
            if (MetadataHelper.isId(accessibleObject, this.getDescriptor())) {
                return new IdAccessor(accessibleObject, this);
            }
            if (MetadataHelper.isVersion(accessibleObject, this.getDescriptor())) {
                return new VersionAccessor(accessibleObject, this);
            }
            if (MetadataHelper.isBasic(accessibleObject, this.getDescriptor())) {
                return new BasicAccessor(accessibleObject, this);
            }
            if (MetadataHelper.isEmbedded(accessibleObject, this.getDescriptor())) {
                return new EmbeddedAccessor(accessibleObject, this);
            }
            if (MetadataHelper.isEmbeddedId(accessibleObject, this.getDescriptor())) {
                return new EmbeddedIdAccessor(accessibleObject, this);
            }
            if (MetadataHelper.isManyToMany(accessibleObject, this.getDescriptor())) {
                return new ManyToManyAccessor(accessibleObject, this);
            }
            if (MetadataHelper.isManyToOne(accessibleObject, this.getDescriptor())) {
                return new ManyToOneAccessor(accessibleObject, this);
            }
            if (MetadataHelper.isOneToMany(accessibleObject, this.getDescriptor())) {
                return new OneToManyAccessor(accessibleObject, this);
            }
            if (MetadataHelper.isOneToOne(accessibleObject, this.getDescriptor())) {
                return new OneToOneAccessor(accessibleObject, this);
            }
            return new BasicAccessor(accessibleObject, this);
        }
        return accessor;
    }

    public boolean excludeDefaultListeners() {
        return this.m_excludeDefaultListeners;
    }

    public boolean excludeSuperclassListeners() {
        return this.m_excludeSuperclassListeners;
    }

    public String getAccess() {
        return this.m_access;
    }

    public List<AssociationOverrideMetadata> getAssociationOverrides() {
        return this.m_associationOverrides;
    }

    public List<AttributeOverrideMetadata> getAttributeOverrides() {
        return this.m_attributeOverrides;
    }

    public XMLAttributes getAttributes() {
        return this.m_attributes;
    }

    public CacheMetadata getCache() {
        return this.m_cache;
    }

    public ChangeTrackingMetadata getChangeTracking() {
        return this.m_changeTracking;
    }

    public String getClassName() {
        return this.m_className;
    }

    public Class getCustomizerClass() {
        return this.m_customizerClass;
    }

    public String getCustomizerClassName() {
        return this.m_customizerClassName;
    }

    public String getDescription() {
        return this.m_description;
    }

    public DiscriminatorColumnMetadata getDiscriminatorColumn() {
        return this.m_discriminatorColumn;
    }

    public String getDiscriminatorValue() {
        return this.m_discriminatorValue;
    }

    public List<EntityListenerMetadata> getEntityListeners() {
        return this.m_entityListeners;
    }

    public String getEntityName() {
        return this.m_entityName;
    }

    public String getExcludeDefaultListeners() {
        return null;
    }

    public String getExcludeSuperclassListeners() {
        return null;
    }

    public String getIdClassName() {
        return this.m_idClassName;
    }

    public InheritanceMetadata getInheritance() {
        return this.m_inheritance;
    }

    @Override
    public Class getJavaClass() {
        return (Class)this.getAnnotatedElement();
    }

    @Override
    public String getJavaClassName() {
        return this.getJavaClass().getName();
    }

    public List<MappedSuperclassAccessor> getMappedSuperclasses() {
        ArrayList<MappedSuperclassAccessor> mappedSuperclasses = new ArrayList<MappedSuperclassAccessor>();
        for (Class parent = this.getJavaClass().getSuperclass(); !(parent == Object.class || this.getDescriptor().isInheritanceSubclass() && this.getProject().hasEntity(parent)); parent = parent.getSuperclass()) {
            MappedSuperclassAccessor accessor = this.getProject().getMappedSuperclass(parent);
            if (accessor == null) {
                if (!MetadataHelper.isAnnotationPresent(MappedSuperclass.class, parent)) continue;
                mappedSuperclasses.add(new MappedSuperclassAccessor(parent, this.getDescriptor(), this.getProject()));
                continue;
            }
            mappedSuperclasses.add(accessor.getEntityMappings().reloadMappedSuperclass(accessor, this.getDescriptor(), this.getJavaClass().getClassLoader()));
        }
        return mappedSuperclasses;
    }

    public String getMappingFile() {
        return this.m_mappingFile;
    }

    public Boolean getMetadataComplete() {
        return this.m_metadataComplete;
    }

    protected MetadataMethod getMetadataMethod(Method method, boolean userSpecified) {
        MetadataMethod metadataMethod = null;
        if (MetadataHelper.isValidPersistenceMethodName(method.getName())) {
            if (method.getParameterTypes().length > 0) {
                if (userSpecified) {
                    throw ValidationException.mappingMetadataAppliedToMethodWithArguments(method, this.getJavaClass());
                }
            } else {
                Method setMethod = MetadataHelper.getSetMethod(method, this.getJavaClass());
                if (setMethod == null) {
                    if (userSpecified) {
                        throw ValidationException.noCorrespondingSetterMethodDefined(this.getJavaClass(), method);
                    }
                } else {
                    metadataMethod = new MetadataMethod(method, setMethod);
                }
            }
        }
        return metadataMethod;
    }

    public List<NamedNativeQueryMetadata> getNamedNativeQueries() {
        return this.m_namedNativeQueries;
    }

    public List<NamedQueryMetadata> getNamedQueries() {
        return this.m_namedQueries;
    }

    public List<NamedStoredProcedureQueryMetadata> getNamedStoredProcedureQueries() {
        return this.m_namedStoredProcedureQueries;
    }

    public OptimisticLockingMetadata getOptimisticLocking() {
        return this.m_optimisticLocking;
    }

    public String getPostLoad() {
        return this.m_postLoad;
    }

    public String getPostPersist() {
        return this.m_postPersist;
    }

    public String getPostRemove() {
        return this.m_postRemove;
    }

    public String getPostUpdate() {
        return this.m_postUpdate;
    }

    public String getPrePersist() {
        return this.m_prePersist;
    }

    public String getPreRemove() {
        return this.m_preRemove;
    }

    public String getPreUpdate() {
        return this.m_preUpdate;
    }

    public Boolean getReadOnly() {
        return this.m_readOnly;
    }

    public List<SecondaryTableMetadata> getSecondaryTables() {
        return this.m_secondaryTables;
    }

    public List<SQLResultSetMappingMetadata> getSqlResultSetMappings() {
        return this.m_sqlResultSetMappings;
    }

    public TableMetadata getTable() {
        return this.m_table;
    }

    protected boolean hasInheritance() {
        if (this.m_inheritance == null) {
            return this.isAnnotationPresent(Inheritance.class);
        }
        return true;
    }

    public boolean isInheritanceSubclass() {
        MetadataAccessor lastParent = null;
        for (Class parent = this.getJavaClass().getSuperclass(); parent != Object.class; parent = parent.getSuperclass()) {
            ClassAccessor parentAccessor = this.getProject().getAccessor(parent.getName());
            if (parentAccessor == null) continue;
            if (lastParent == null) {
                this.getDescriptor().setParentClass(parent);
            }
            lastParent = parentAccessor;
            if (parentAccessor.hasInheritance()) break;
        }
        if (lastParent == null) {
            return false;
        }
        this.getDescriptor().setInheritanceParentDescriptor(lastParent.getDescriptor());
        return true;
    }

    public boolean isMetadataComplete() {
        return this.m_metadataComplete != null && this.m_metadataComplete != false;
    }

    protected boolean isValidPersistenceElement(AnnotatedElement annotatedElement, int modifiers) {
        return !Modifier.isTransient(modifiers) && !Modifier.isStatic(modifiers) && !Modifier.isAbstract(modifiers);
    }

    @Override
    public void process() {
        this.processEntity();
        this.processTableAndInheritance();
        this.processClassMetadata();
        this.processMappedSuperclasses();
        this.processAccessors();
        this.validatePrimaryKey();
        this.validateOptimisticLocking();
        this.processBasicCollectionAccessors();
        this.processSecondaryTables();
    }

    protected void processAccessor(MetadataAccessor accessor) {
        if (!accessor.isProcessed()) {
            this.getDescriptor().addAccessor(accessor);
            accessor.processConverters();
            if (accessor.isBasicCollection()) {
                this.getDescriptor().addBasicCollectionAccessor(accessor);
            } else if (accessor.isRelationship()) {
                this.getDescriptor().addRelationshipAccessor(accessor);
            } else {
                accessor.process();
                accessor.setIsProcessed();
            }
        }
    }

    protected void processAccessorFields() {
        for (Field field : MetadataHelper.getFields(this.getJavaClass())) {
            if (this.isAnnotationPresent(Transient.class, field)) {
                if (MetadataHelper.getDeclaredAnnotationsCount(field, this.getDescriptor()) <= 1) continue;
                throw ValidationException.mappingAnnotationsAppliedToTransientAttribute(field);
            }
            if (this.isValidPersistenceElement(field, field.getModifiers())) {
                this.processAccessor(this.buildAccessor(new MetadataField(field)));
                continue;
            }
            if (MetadataHelper.getDeclaredAnnotationsCount(field, this.getDescriptor()) <= 0) continue;
            throw ValidationException.mappingMetadataAppliedToInvalidAttribute(field, this.getJavaClass());
        }
    }

    protected void processAccessorMethods() {
        for (Method method : MetadataHelper.getDeclaredMethods(this.getJavaClass())) {
            if (this.isAnnotationPresent(Transient.class, method)) {
                if (MetadataHelper.getDeclaredAnnotationsCount(method, this.getDescriptor()) <= 1) continue;
                throw ValidationException.mappingAnnotationsAppliedToTransientAttribute(method);
            }
            if (this.isValidPersistenceElement(method, method.getModifiers())) {
                MetadataMethod metadataMethod = this.getMetadataMethod(method, MetadataHelper.getDeclaredAnnotationsCount(method, this.getDescriptor()) > 0);
                if (metadataMethod == null) continue;
                this.processAccessor(this.buildAccessor(metadataMethod));
                continue;
            }
            if (MetadataHelper.getDeclaredAnnotationsCount(method, this.getDescriptor()) <= 0) continue;
            throw ValidationException.mappingMetadataAppliedToInvalidAttribute(method, this.getJavaClass());
        }
    }

    protected void processAccessors() {
        if (this.m_attributes != null) {
            for (MetadataAccessor accessor : this.m_attributes.getAccessors()) {
                MetadataAccessibleObject accessibleObject;
                if (this.getDescriptor().usesPropertyAccess()) {
                    Method method = MetadataHelper.getMethodForPropertyName(accessor.getName(), this.getJavaClass());
                    if (method == null) {
                        throw ValidationException.invalidPropertyForClass(accessor.getName(), this.getJavaClass());
                    }
                    if (!this.isValidPersistenceElement(method, method.getModifiers())) {
                        throw ValidationException.mappingMetadataAppliedToInvalidAttribute(method, this.getJavaClass());
                    }
                    accessibleObject = this.getMetadataMethod(method, true);
                } else {
                    Field field = MetadataHelper.getFieldForName(accessor.getName(), this.getJavaClass());
                    if (field == null) {
                        throw ValidationException.invalidFieldForClass(accessor.getName(), this.getJavaClass());
                    }
                    if (!this.isValidPersistenceElement(field, field.getModifiers())) {
                        throw ValidationException.mappingMetadataAppliedToInvalidAttribute(field, this.getJavaClass());
                    }
                    accessibleObject = new MetadataField(field);
                }
                accessor.init(accessibleObject, this);
                this.processAccessor(accessor);
            }
        }
        if (this.getDescriptor().usesPropertyAccess()) {
            this.processAccessorMethods();
        } else {
            this.processAccessorFields();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void processAssociationOverride(AssociationOverrideMetadata associationOverride) {
        if (this.getDescriptor().hasAssociationOverrideFor(associationOverride.getName())) {
            AssociationOverrideMetadata otherAssociationOverride = this.getDescriptor().getAssociationOverrideFor(associationOverride.getName());
            if (otherAssociationOverride.getJavaClassName().equals(associationOverride.getJavaClassName())) {
                if (!otherAssociationOverride.loadedFromXML()) throw ValidationException.multipleAssociationOverrideWithSameNameFound(associationOverride.getName(), associationOverride.getJavaClassName(), associationOverride.getLocation());
                if (associationOverride.loadedFromXML()) {
                    throw ValidationException.multipleAssociationOverrideWithSameNameFound(associationOverride.getName(), associationOverride.getJavaClassName(), associationOverride.getLocation());
                }
                this.getLogger().logWarningMessage("annotation_warning_ignore_association_override", associationOverride.getName(), associationOverride.getJavaClassName(), associationOverride.getLocation());
                return;
            } else {
                this.getLogger().logWarningMessage("annotation_warning_ignore_association_override_on_mapped_superclass", associationOverride.getName(), associationOverride.getJavaClassName(), this.getDescriptor().getJavaClassName());
            }
            return;
        } else {
            this.getDescriptor().addAssociationOverride(associationOverride);
        }
    }

    protected void processAssociationOverrides() {
        Object t;
        Object associationOverrides;
        if (this.m_associationOverrides != null) {
            for (AssociationOverrideMetadata associationOverrideMetadata : this.m_associationOverrides) {
                associationOverrideMetadata.setJavaClassName(this.getJavaClassName());
                associationOverrideMetadata.setLocation(this.getEntityMappings().getMappingFileName());
                this.processAssociationOverride(associationOverrideMetadata);
            }
        }
        if ((associationOverrides = this.getAnnotation(AssociationOverrides.class)) != null) {
            for (Object associationOverride3 : (Object[])this.invokeMethod("value", associationOverrides)) {
                this.processAssociationOverride(new AssociationOverrideMetadata((Annotation)associationOverride3, this.getJavaClassName()));
            }
        }
        if ((t = this.getAnnotation(AssociationOverride.class)) != null) {
            this.processAssociationOverride(new AssociationOverrideMetadata((Annotation)t, this.getJavaClassName()));
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void processAttributeOverride(AttributeOverrideMetadata attributeOverride) {
        if (this.getDescriptor().hasAttributeOverrideFor(attributeOverride.getName())) {
            AttributeOverrideMetadata otherAttributeOverride = this.getDescriptor().getAttributeOverrideFor(attributeOverride.getName());
            if (otherAttributeOverride.getJavaClassName().equals(attributeOverride.getJavaClassName())) {
                if (!otherAttributeOverride.loadedFromXML()) throw ValidationException.multipleAttributeOverrideWithSameNameFound(attributeOverride.getName(), attributeOverride.getJavaClassName(), attributeOverride.getLocation());
                if (attributeOverride.loadedFromXML()) {
                    throw ValidationException.multipleAttributeOverrideWithSameNameFound(attributeOverride.getName(), attributeOverride.getJavaClassName(), attributeOverride.getLocation());
                }
                this.getLogger().logWarningMessage("annotation_warning_ignore_attribute_override", attributeOverride.getName(), attributeOverride.getJavaClassName(), attributeOverride.getLocation());
                return;
            } else {
                this.getLogger().logWarningMessage("annotation_warning_ignore_attribute_override_on_mapped_superclass", attributeOverride.getName(), attributeOverride.getJavaClassName(), this.getDescriptor().getJavaClassName());
            }
            return;
        } else {
            this.getDescriptor().addAttributeOverride(attributeOverride);
        }
    }

    protected void processAttributeOverrides() {
        Object t;
        Object attributeOverrides;
        if (this.m_attributeOverrides != null) {
            for (AttributeOverrideMetadata attributeOverrideMetadata : this.m_attributeOverrides) {
                attributeOverrideMetadata.setLocation(this.getEntityMappings().getMappingFileName());
                attributeOverrideMetadata.setJavaClassName(this.getJavaClassName());
                attributeOverrideMetadata.getColumn().setAttributeName(attributeOverrideMetadata.getName());
                this.processAttributeOverride(attributeOverrideMetadata);
            }
        }
        if ((attributeOverrides = this.getAnnotation(AttributeOverrides.class)) != null) {
            for (Annotation attributeOverride3 : (Annotation[])this.invokeMethod("value", attributeOverrides)) {
                this.processAttributeOverride(new AttributeOverrideMetadata(attributeOverride3, this.getJavaClassName()));
            }
        }
        if ((t = this.getAnnotation(AttributeOverride.class)) != null) {
            this.processAttributeOverride(new AttributeOverrideMetadata((Annotation)t, this.getJavaClassName()));
        }
    }

    protected void processBasicCollectionAccessors() {
        for (BasicCollectionAccessor accessor : this.getDescriptor().getBasicCollectionAccessors()) {
            accessor.process();
            accessor.setIsProcessed();
        }
    }

    protected void processCache() {
        if (this.m_cache != null || this.isAnnotationPresent(Cache.class)) {
            if (this.getDescriptor().isEmbeddable()) {
                throw ValidationException.cacheNotSupportedWithEmbeddable(this.getJavaClass());
            }
            if (this.getDescriptor().isInheritanceSubclass()) {
                this.getLogger().logWarningMessage("metadata_warning_ignore_inheritance_subclass_cache", this.getJavaClass());
            } else if (this.getDescriptor().hasCache()) {
                this.getLogger().logWarningMessage("metadata_warning_ignore_mapped_superclass_cache", this.getDescriptor().getJavaClass(), this.getJavaClass());
            } else if (this.m_cache == null) {
                new CacheMetadata((Annotation)this.getAnnotation(Cache.class)).process(this.getDescriptor(), this.getJavaClass());
            } else {
                this.m_cache.process(this.getDescriptor(), this.getJavaClass());
            }
        }
    }

    protected Method processCallbackMethodName(EntityListenerMetadata listener, String methodName, Method[] methods) {
        Method method = MetadataHelper.getMethodForName(methods, methodName);
        if (method == null) {
            throw ValidationException.invalidCallbackMethod(listener.getListenerClass(), methodName);
        }
        return method;
    }

    protected void processCallbackMethodNames(Method[] methods, EntityListenerMetadata listener) {
        if (listener.getPrePersist() != null) {
            this.setPrePersist(this.processCallbackMethodName(listener, listener.getPrePersist(), methods), listener);
        }
        if (listener.getPostPersist() != null) {
            this.setPostPersist(this.processCallbackMethodName(listener, listener.getPostPersist(), methods), listener);
        }
        if (listener.getPreRemove() != null) {
            this.setPreRemove(this.processCallbackMethodName(listener, listener.getPreRemove(), methods), listener);
        }
        if (listener.getPostRemove() != null) {
            this.setPostRemove(this.processCallbackMethodName(listener, listener.getPostRemove(), methods), listener);
        }
        if (listener.getPreUpdate() != null) {
            this.setPreUpdate(this.processCallbackMethodName(listener, listener.getPreUpdate(), methods), listener);
        }
        if (listener.getPostUpdate() != null) {
            this.setPostUpdate(this.processCallbackMethodName(listener, listener.getPostUpdate(), methods), listener);
        }
        if (listener.getPostLoad() != null) {
            this.setPostLoad(this.processCallbackMethodName(listener, listener.getPostLoad(), methods), listener);
        }
    }

    protected void processCallbackMethods(Method[] candidateMethods, EntityListenerMetadata listener) {
        for (Method method : candidateMethods) {
            if (this.isAnnotationPresent(PostLoad.class, method)) {
                this.setPostLoad(method, listener);
            }
            if (this.isAnnotationPresent(PostPersist.class, method)) {
                this.setPostPersist(method, listener);
            }
            if (this.isAnnotationPresent(PostRemove.class, method)) {
                this.setPostRemove(method, listener);
            }
            if (this.isAnnotationPresent(PostUpdate.class, method)) {
                this.setPostUpdate(method, listener);
            }
            if (this.isAnnotationPresent(PrePersist.class, method)) {
                this.setPrePersist(method, listener);
            }
            if (this.isAnnotationPresent(PreRemove.class, method)) {
                this.setPreRemove(method, listener);
            }
            if (!this.isAnnotationPresent(PreUpdate.class, method)) continue;
            this.setPreUpdate(method, listener);
        }
    }

    protected void processChangeTracking() {
        if (this.m_changeTracking != null || this.isAnnotationPresent(ChangeTracking.class)) {
            if (this.getDescriptor().hasChangeTracking()) {
                this.getLogger().logWarningMessage("metadata_warning_ignore_mapped_superclass_change_tracking", this.getDescriptor().getJavaClass(), this.getJavaClass());
            } else if (this.m_changeTracking == null) {
                new ChangeTrackingMetadata((Annotation)this.getAnnotation(ChangeTracking.class)).process(this.getDescriptor());
            } else {
                if (this.isAnnotationPresent(ChangeTracking.class)) {
                    this.getLogger().logWarningMessage("annotation_warning_ignore_change_tracking", this.getDescriptor().getJavaClass(), this.getJavaClass());
                }
                this.m_changeTracking.process(this.getDescriptor());
            }
        }
    }

    protected void processClassMetadata() {
        this.processAttributeOverrides();
        this.processAssociationOverrides();
        this.processNamedQueries();
        this.processNamedNativeQueries();
        this.processNamedStoredProcedureQueries();
        this.processSqlResultSetMappings();
        this.processTableGenerator();
        this.processSequenceGenerator();
        this.processIdClass();
        this.processExcludeDefaultListeners();
        this.processExcludeSuperclassListeners();
        this.processConverters();
        this.processOptimisticLocking();
        this.processCache();
        this.processChangeTracking();
        this.processReadOnly();
        this.processCustomizer();
    }

    protected void processCustomizer() {
        if (this.m_customizerClassName != null || this.isAnnotationPresent(Customizer.class)) {
            if (this.getDescriptor().hasCustomizer()) {
                this.getLogger().logWarningMessage("metadata_warning_ignore_mapped_superclass_customizer", this.getDescriptor().getJavaClass(), this.getJavaClass());
            } else if (this.m_customizerClassName == null) {
                Object customizer = this.getAnnotation(Customizer.class);
                if (customizer != null) {
                    this.m_customizerClass = (Class)this.invokeMethod("value", customizer);
                    this.getProject().addAccessorWithCustomizer(this);
                }
            } else {
                if (this.isAnnotationPresent(Customizer.class)) {
                    this.getLogger().logWarningMessage("annotation_warning_ignore_customizer", this.getDescriptor().getJavaClass(), this.getJavaClass());
                }
                this.m_customizerClass = this.getEntityMappings().getClassForName(this.m_customizerClassName);
                this.getProject().addAccessorWithCustomizer(this);
            }
        }
    }

    protected void processDefaultListeners() {
        for (EntityListenerMetadata defaultListener : this.getProject().getDefaultListeners().values()) {
            EntityListenerMetadata listener = (EntityListenerMetadata)defaultListener.clone();
            listener.setEntityClass(this.getJavaClass());
            listener.initializeListenerClass(MetadataHelper.getClassForName(listener.getClassName(), this.getJavaClass().getClassLoader()));
            Method[] candidateMethods = MetadataHelper.getCandidateCallbackMethodsForDefaultListener(listener);
            this.processCallbackMethodNames(candidateMethods, listener);
            this.processCallbackMethods(candidateMethods, listener);
            this.getDescriptor().addDefaultEventListener(listener);
        }
    }

    protected void processDiscriminatorValue() {
        if (!Modifier.isAbstract(this.getJavaClass().getModifiers())) {
            if (this.m_discriminatorValue == null) {
                Object discriminatorValue = this.getAnnotation(DiscriminatorValue.class);
                if (discriminatorValue == null) {
                    this.getDescriptor().addClassIndicator(this.getJavaClass(), Helper.getShortClassName(this.getJavaClassName()));
                } else {
                    this.getDescriptor().addClassIndicator(this.getJavaClass(), (String)this.invokeMethod("value", discriminatorValue));
                }
            } else {
                this.getDescriptor().addClassIndicator(this.getJavaClass(), this.m_discriminatorValue);
            }
        }
    }

    protected void processEntity() {
        if (this.getDescriptor().getAlias().equals("")) {
            ClassDescriptor existingDescriptor;
            Object entity;
            String alias = this.m_entityName == null ? ((entity = this.getAnnotation(Entity.class)) == null ? "" : (String)this.invokeMethod("name", entity)) : this.m_entityName;
            if (alias.equals("")) {
                alias = Helper.getShortClassName(this.getJavaClassName());
                this.getLogger().logConfigMessage("metadata_default_alias", this.getDescriptor(), (Object)alias);
            }
            if ((existingDescriptor = this.getProject().getSession().getProject().getDescriptorForAlias(alias)) != null) {
                throw ValidationException.nonUniqueEntityName(existingDescriptor.getJavaClassName(), this.getDescriptor().getJavaClassName(), alias);
            }
            this.getDescriptor().setAlias(alias);
            this.getProject().getSession().getProject().addAlias(alias, this.getDescriptor().getClassDescriptor());
        }
    }

    public EntityListenerMetadata processEntityEventListener() {
        EntityClassListenerMetadata listener = new EntityClassListenerMetadata(this);
        Method[] candidateMethods = MetadataHelper.getCandidateCallbackMethodsForEntityClass(this.getJavaClass());
        this.processCallbackMethodNames(candidateMethods, listener);
        this.processCallbackMethods(candidateMethods, listener);
        return listener;
    }

    public void processEntityListeners(Class entityClass) {
        block3: {
            block2: {
                if (this.m_entityListeners != null && !this.m_entityListeners.isEmpty()) break block2;
                Object entityListeners = this.getAnnotation(EntityListeners.class);
                if (entityListeners == null) break block3;
                for (Class entityListener : (Class[])this.invokeMethod("value", entityListeners)) {
                    EntityListenerMetadata listener = new EntityListenerMetadata(entityListener, entityClass);
                    this.processCallbackMethods(MetadataHelper.getCandidateCallbackMethodsForEntityListener(listener), listener);
                    this.getDescriptor().addEntityListenerEventListener(listener);
                }
                break block3;
            }
            for (EntityListenerMetadata listener : this.m_entityListeners) {
                listener.setEntityClass(entityClass);
                listener.initializeListenerClass(this.getEntityMappings().getClassForName(listener.getClassName()));
                Method[] candidateMethods = MetadataHelper.getCandidateCallbackMethodsForEntityListener(listener);
                this.processCallbackMethodNames(candidateMethods, listener);
                this.processCallbackMethods(candidateMethods, listener);
                this.getDescriptor().addEntityListenerEventListener(listener);
            }
        }
    }

    protected void processExcludeDefaultListeners() {
        if (this.excludeDefaultListeners()) {
            this.getDescriptor().setExcludeDefaultListeners(true);
        } else if (this.isAnnotationPresent(ExcludeDefaultListeners.class)) {
            this.getDescriptor().setExcludeDefaultListeners(true);
        }
    }

    protected void processExcludeSuperclassListeners() {
        if (this.excludeSuperclassListeners()) {
            this.getDescriptor().setExcludeSuperclassListeners(true);
        } else if (this.isAnnotationPresent(ExcludeSuperclassListeners.class)) {
            this.getDescriptor().setExcludeSuperclassListeners(true);
        }
    }

    protected void processIdClass() {
        Class pkClass;
        if (this.m_idClassName == null) {
            Object idClass = this.getAnnotation(IdClass.class);
            if (idClass == null) {
                return;
            }
            pkClass = (Class)this.invokeMethod("value", idClass);
        } else {
            if (this.isAnnotationPresent(IdClass.class)) {
                this.getLogger().logWarningMessage("annotation_warning_ignore_id_class", this.getDescriptor());
            }
            pkClass = this.getEntityMappings().getClassForName(this.m_idClassName);
        }
        this.getDescriptor().setPKClass(pkClass);
        if (this.getDescriptor().usesPropertyAccess()) {
            for (AccessibleObject accessibleObject : MetadataHelper.getDeclaredMethods(pkClass)) {
                String methodName = ((Method)accessibleObject).getName();
                if (!MetadataHelper.isValidPersistenceMethodName(methodName)) continue;
                this.getDescriptor().addPKClassId(MetadataHelper.getAttributeNameFromMethodName(methodName), MetadataHelper.getGenericReturnType((Method)accessibleObject));
            }
        } else {
            for (AccessibleObject accessibleObject : MetadataHelper.getFields(pkClass)) {
                this.getDescriptor().addPKClassId(((Field)accessibleObject).getName(), MetadataHelper.getGenericType((Field)accessibleObject));
            }
        }
    }

    protected void processInheritance() {
        if (this.m_inheritance == null) {
            new InheritanceMetadata((Annotation)this.getAnnotation(Inheritance.class)).process(this.getDescriptor(), this.getJavaClass());
        } else {
            this.m_inheritance.process(this.getDescriptor(), this.getJavaClass());
        }
        if (this.m_discriminatorColumn == null) {
            new DiscriminatorColumnMetadata((Annotation)this.getAnnotation(DiscriminatorColumn.class)).process(this.getDescriptor(), this.getAnnotatedElementName());
        } else {
            this.m_discriminatorColumn.process(this.getDescriptor(), this.getAnnotatedElementName());
        }
        this.processDiscriminatorValue();
    }

    protected void processInheritanceSubclass(MetadataDescriptor parentDescriptor) {
        if (parentDescriptor.usesSingleTableInheritanceStrategy() && !this.hasInheritance()) {
            this.getDescriptor().setSingleTableInheritanceStrategy();
        } else {
            PrimaryKeyJoinColumnsMetadata pkJoinColumns;
            if (this.getPrimaryKeyJoinColumns() == null) {
                Object primaryKeyJoinColumn = this.getAnnotation(PrimaryKeyJoinColumn.class);
                Object primaryKeyJoinColumns = this.getAnnotation(PrimaryKeyJoinColumns.class);
                pkJoinColumns = new PrimaryKeyJoinColumnsMetadata((Annotation)primaryKeyJoinColumns, (Annotation)primaryKeyJoinColumn);
            } else {
                pkJoinColumns = new PrimaryKeyJoinColumnsMetadata(this.getPrimaryKeyJoinColumns());
            }
            this.addMultipleTableKeyFields(pkJoinColumns, this.getDescriptor().getPrimaryKeyTable(), this.getDescriptor().getPrimaryTable(), "metadata_default_inheritance_pk_column", "metadata_default_inheritance_fk_column");
        }
        if (!this.hasInheritance()) {
            this.processDiscriminatorValue();
        }
        if (parentDescriptor.hasCompositePrimaryKey()) {
            this.getDescriptor().setPKClass(parentDescriptor.getPKClassName());
        }
    }

    protected List<JoinColumnMetadata> processJoinColumns(JoinColumn[] joinColumns) {
        ArrayList<JoinColumnMetadata> list = new ArrayList<JoinColumnMetadata>();
        for (JoinColumn joinColumn : joinColumns) {
            list.add(new JoinColumnMetadata((Annotation)joinColumn));
        }
        return list;
    }

    public void processListeners(ClassLoader loader) {
        this.processDefaultListeners();
        if (!this.getDescriptor().excludeSuperclassListeners()) {
            List<MappedSuperclassAccessor> mappedSuperclasses = this.getMappedSuperclasses();
            int mappedSuperclassesSize = mappedSuperclasses.size();
            for (int i = mappedSuperclassesSize - 1; i >= 0; --i) {
                mappedSuperclasses.get(i).processEntityListeners(this.getJavaClass());
            }
        }
        this.processEntityListeners(this.getJavaClass());
        EntityListenerMetadata listener = this.processEntityEventListener();
        if (!this.getDescriptor().excludeSuperclassListeners()) {
            for (MappedSuperclassAccessor mappedSuperclass : this.getMappedSuperclasses()) {
                mappedSuperclass.processMappedSuperclassEventListener(listener, this.getJavaClass(), loader);
            }
        }
        if (listener.hasCallbackMethods()) {
            this.getDescriptor().setEntityEventListener(listener);
        }
    }

    protected void processMappedSuperclasses() {
        for (MappedSuperclassAccessor mappedSuperclass : this.getMappedSuperclasses()) {
            mappedSuperclass.process();
        }
    }

    public void processMappedSuperclassEventListener(EntityListenerMetadata listener, Class entityClass, ClassLoader classLoader) {
        Method[] candidateMethods = MetadataHelper.getCandidateCallbackMethodsForMappedSuperclass(this.getJavaClass(), entityClass);
        this.processCallbackMethodNames(candidateMethods, listener);
        this.processCallbackMethods(candidateMethods, listener);
    }

    protected void processNamedNativeQueries() {
        Object namedNativeQuery;
        Object namedNativeQueries;
        if (this.m_namedNativeQueries != null) {
            this.getEntityMappings().processNamedNativeQueries(this.m_namedNativeQueries, this.getJavaClassName());
        }
        if ((namedNativeQueries = this.getAnnotation(NamedNativeQueries.class)) != null) {
            for (Annotation namedNativeQuery2 : (Annotation[])this.invokeMethod("value", namedNativeQueries)) {
                this.getProject().addNamedNativeQuery(new NamedNativeQueryMetadata(namedNativeQuery2, this.getJavaClassName()));
            }
        }
        if ((namedNativeQuery = this.getAnnotation(NamedNativeQuery.class)) != null) {
            this.getProject().addNamedNativeQuery(new NamedNativeQueryMetadata((Annotation)namedNativeQuery, this.getJavaClassName()));
        }
    }

    protected void processNamedQueries() {
        Object namedQuery;
        Object namedQueries;
        if (this.m_namedQueries != null) {
            this.getEntityMappings().processNamedQueries(this.m_namedQueries, this.getJavaClassName());
        }
        if ((namedQueries = this.getAnnotation(NamedQueries.class)) != null) {
            for (Annotation namedQuery2 : (Annotation[])this.invokeMethod("value", namedQueries)) {
                this.getProject().addNamedQuery(new NamedQueryMetadata(namedQuery2, this.getJavaClassName()));
            }
        }
        if ((namedQuery = this.getAnnotation(NamedQuery.class)) != null) {
            this.getProject().addNamedQuery(new NamedQueryMetadata((Annotation)namedQuery, this.getJavaClassName()));
        }
    }

    protected void processNamedStoredProcedureQueries() {
        Object namedStoredProcedureQuery;
        Object namedStoredProcedureQueries;
        if (this.m_namedStoredProcedureQueries != null) {
            this.getEntityMappings().processNamedStoredProcedureQueries(this.m_namedStoredProcedureQueries, this.getJavaClassName());
        }
        if ((namedStoredProcedureQueries = this.getAnnotation(NamedStoredProcedureQueries.class)) != null) {
            for (Annotation namedStoredProcedureQuery2 : (Annotation[])this.invokeMethod("value", namedStoredProcedureQueries)) {
                this.getProject().addNamedStoredProcedureQuery(new NamedStoredProcedureQueryMetadata(namedStoredProcedureQuery2, this.getJavaClassName()));
            }
        }
        if ((namedStoredProcedureQuery = this.getAnnotation(NamedStoredProcedureQuery.class)) != null) {
            this.getProject().addNamedStoredProcedureQuery(new NamedStoredProcedureQueryMetadata((Annotation)namedStoredProcedureQuery, this.getJavaClassName()));
        }
    }

    protected void processOptimisticLocking() {
        if (this.getDescriptor().usesOptimisticLocking()) {
            if (this.m_optimisticLocking != null || this.isAnnotationPresent(OptimisticLocking.class)) {
                this.getLogger().logWarningMessage("metadata_warning_ignore_mapped_superclass_optimistic_locking", this.getDescriptor().getJavaClass(), this.getJavaClass());
            }
        } else if (this.m_optimisticLocking == null) {
            Object optimisticLocking = this.getAnnotation(OptimisticLocking.class);
            if (optimisticLocking != null) {
                new OptimisticLockingMetadata(optimisticLocking).process(this.getDescriptor());
            }
        } else {
            if (this.isAnnotationPresent(OptimisticLocking.class)) {
                this.getLogger().logWarningMessage("annotation_warning_ignore_optimistic_locking", this.getJavaClass(), this.getMappingFile());
            }
            this.m_optimisticLocking.process(this.getDescriptor());
        }
    }

    protected void processReadOnly() {
        if (this.m_readOnly != null || this.isAnnotationPresent(ReadOnly.class)) {
            if (this.getDescriptor().isInheritanceSubclass()) {
                this.getLogger().logWarningMessage("metadata_warning_ignore_inheritance_read_only", this.getJavaClass());
            } else if (this.getDescriptor().hasReadOnly()) {
                this.getLogger().logWarningMessage("metadata_warning_ignore_mapped_superclass_read_only", this.getJavaClass());
            } else if (this.m_readOnly == null) {
                this.getDescriptor().setReadOnly(true);
            } else {
                if (this.isAnnotationPresent(ReadOnly.class)) {
                    this.getLogger().logWarningMessage("annotation_warning_ignore_read_only", this.getJavaClass());
                }
                this.getDescriptor().setReadOnly(this.m_readOnly);
            }
        }
    }

    protected void processSecondaryTable(SecondaryTableMetadata secondaryTable) {
        this.processTable(secondaryTable, secondaryTable.getName());
        this.getDescriptor().addTable(secondaryTable.getDatabaseTable());
        this.addMultipleTableKeyFields(new PrimaryKeyJoinColumnsMetadata(secondaryTable.getPrimaryKeyJoinColumns()), this.getDescriptor().getPrimaryTable(), secondaryTable.getDatabaseTable(), "metadata_default_secondary_table_pk_column", "metadata_default_secondary_table_fk_column");
    }

    protected void processSecondaryTables() {
        block5: {
            block3: {
                block4: {
                    if (this.m_secondaryTables != null && !this.m_secondaryTables.isEmpty()) break block3;
                    Object secondaryTables = this.getAnnotation(SecondaryTables.class);
                    if (secondaryTables == null) break block4;
                    for (Annotation secondaryTable : (Annotation[])this.invokeMethod("value", secondaryTables)) {
                        this.processSecondaryTable(new SecondaryTableMetadata(secondaryTable, this.getJavaClassName()));
                    }
                    break block5;
                }
                Object secondaryTable = this.getAnnotation(SecondaryTable.class);
                if (secondaryTable == null) break block5;
                this.processSecondaryTable(new SecondaryTableMetadata((Annotation)secondaryTable, this.getJavaClassName()));
                break block5;
            }
            if (this.isAnnotationPresent(SecondaryTables.class) || this.isAnnotationPresent(SecondaryTable.class)) {
                this.getLogger().logWarningMessage("annotation_warning_ignore_secondary_table", this.getJavaClass());
            }
            for (SecondaryTableMetadata secondaryTable : this.m_secondaryTables) {
                secondaryTable.setLocation(this.getJavaClassName());
                this.processSecondaryTable(secondaryTable);
            }
        }
    }

    protected void processSqlResultSetMappings() {
        Object sqlResultSetMappings;
        if (this.m_sqlResultSetMappings != null) {
            this.getEntityMappings().processSqlResultSetMappings(this.m_sqlResultSetMappings);
        }
        if ((sqlResultSetMappings = this.getAnnotation(SqlResultSetMappings.class)) != null) {
            for (Annotation sqlResultSetMapping : (Annotation[])this.invokeMethod("value", sqlResultSetMappings)) {
                new SQLResultSetMappingMetadata(sqlResultSetMapping).process(this.getProject());
            }
        } else {
            Object sqlResultSetMapping = this.getAnnotation(SqlResultSetMapping.class);
            if (sqlResultSetMapping != null) {
                new SQLResultSetMappingMetadata((Annotation)sqlResultSetMapping).process(this.getProject());
            }
        }
    }

    protected void processTable() {
        if (this.m_table == null) {
            Object table = this.getAnnotation(Table.class);
            this.processTable(new TableMetadata((Annotation)table, this.getJavaClassName()));
        } else {
            if (this.isAnnotationPresent(Table.class)) {
                this.getLogger().logWarningMessage("annotation_warning_ignore_table", this.getJavaClass());
            }
            this.m_table.setLocation(this.getJavaClassName());
            this.processTable(this.m_table);
        }
    }

    protected void processTable(TableMetadata table) {
        this.processTable(table, this.getDescriptor().getDefaultTableName());
        this.getDescriptor().setPrimaryTable(table.getDatabaseTable());
    }

    protected void processTableAndInheritance() {
        if (this.isInheritanceSubclass()) {
            MetadataDescriptor parentDescriptor = this.getDescriptor().getInheritanceParentDescriptor();
            ClassAccessor parentAccessor = parentDescriptor.getClassAccessor();
            if (!parentAccessor.isProcessed()) {
                parentAccessor.process();
                parentAccessor.setIsProcessed();
            }
            if (!parentAccessor.hasInheritance()) {
                parentAccessor.processInheritance();
            }
            if (this.hasInheritance()) {
                this.processTable();
                this.processInheritance();
                this.processInheritanceSubclass(parentDescriptor);
            } else {
                if (parentDescriptor.usesJoinedInheritanceStrategy()) {
                    this.processTable();
                }
                this.processInheritanceSubclass(parentDescriptor);
            }
        } else {
            this.processTable();
            if (this.hasInheritance()) {
                this.processInheritance();
            }
        }
    }

    public void setAccess(String access) {
        this.m_access = access;
    }

    public void setAssociationOverrides(List<AssociationOverrideMetadata> associationOverrides) {
        this.m_associationOverrides = associationOverrides;
    }

    public void setAttributeOverrides(List<AttributeOverrideMetadata> attributeOverrides) {
        this.m_attributeOverrides = attributeOverrides;
    }

    public void setAttributes(XMLAttributes attributes) {
        this.m_attributes = attributes;
    }

    public void setCache(CacheMetadata cache) {
        this.m_cache = cache;
    }

    public void setChangeTracking(ChangeTrackingMetadata changeTracking) {
        this.m_changeTracking = changeTracking;
    }

    public void setClassName(String className) {
        this.m_className = className;
    }

    public void setCustomizerClassName(String customizerClassName) {
        this.m_customizerClassName = customizerClassName;
    }

    public void setDescription(String description) {
        this.m_description = description;
    }

    public void setDiscriminatorColumn(DiscriminatorColumnMetadata discriminatorColumn) {
        this.m_discriminatorColumn = discriminatorColumn;
    }

    public void setDiscriminatorValue(String discriminatorValue) {
        this.m_discriminatorValue = discriminatorValue;
    }

    public void setEntityListeners(List<EntityListenerMetadata> entityListeners) {
        this.m_entityListeners = entityListeners;
    }

    public void setEntityName(String entityName) {
        this.m_entityName = entityName;
    }

    public void setExcludeDefaultListeners(String ignore) {
        this.m_excludeDefaultListeners = true;
    }

    public void setExcludeSuperclassListeners(String ignore) {
        this.m_excludeSuperclassListeners = true;
    }

    public void setIdClassName(String idClassName) {
        this.m_idClassName = idClassName;
    }

    public void setInheritance(InheritanceMetadata inheritance) {
        this.m_inheritance = inheritance;
    }

    public void setJavaClass(Class cls) {
        this.setAnnotatedElement(cls);
        this.getDescriptor().setJavaClass(cls);
    }

    public void setMappingFile(String mappingFile) {
        this.m_mappingFile = mappingFile;
    }

    public void setMetadataComplete(Boolean metadataComplete) {
        this.m_metadataComplete = metadataComplete;
    }

    public void setNamedNativeQueries(List<NamedNativeQueryMetadata> namedNativeQueries) {
        this.m_namedNativeQueries = namedNativeQueries;
    }

    public void setNamedQueries(List<NamedQueryMetadata> namedQueries) {
        this.m_namedQueries = namedQueries;
    }

    public void setNamedStoredProcedureQueries(List<NamedStoredProcedureQueryMetadata> namedStoredProcedureQueries) {
        this.m_namedStoredProcedureQueries = namedStoredProcedureQueries;
    }

    public void setOptimisticLocking(OptimisticLockingMetadata optimisticLocking) {
        this.m_optimisticLocking = optimisticLocking;
    }

    protected void setPostLoad(Method method, EntityListenerMetadata listener) {
        listener.setPostBuildMethod(method);
        listener.setPostCloneMethod(method);
        listener.setPostRefreshMethod(method);
    }

    public void setPostLoad(String postLoad) {
        this.m_postLoad = postLoad;
    }

    protected void setPostPersist(Method method, EntityListenerMetadata listener) {
        listener.setPostInsertMethod(method);
    }

    public void setPostPersist(String postPersist) {
        this.m_postPersist = postPersist;
    }

    protected void setPostRemove(Method method, EntityListenerMetadata listener) {
        listener.setPostDeleteMethod(method);
    }

    public void setPostRemove(String postRemove) {
        this.m_postRemove = postRemove;
    }

    protected void setPostUpdate(Method method, EntityListenerMetadata listener) {
        listener.setPostUpdateMethod(method);
    }

    public void setPostUpdate(String postUpdate) {
        this.m_postUpdate = postUpdate;
    }

    protected void setPrePersist(Method method, EntityListenerMetadata listener) {
        listener.setPrePersistMethod(method);
    }

    public void setPrePersist(String prePersist) {
        this.m_prePersist = prePersist;
    }

    protected void setPreRemove(Method method, EntityListenerMetadata listener) {
        listener.setPreRemoveMethod(method);
    }

    public void setPreRemove(String preRemove) {
        this.m_preRemove = preRemove;
    }

    protected void setPreUpdate(Method method, EntityListenerMetadata listener) {
        listener.setPreUpdateWithChangesMethod(method);
    }

    public void setPreUpdate(String preUpdate) {
        this.m_preUpdate = preUpdate;
    }

    public void setReadOnly(Boolean readOnly) {
        this.m_readOnly = readOnly;
    }

    public void setSecondaryTables(List<SecondaryTableMetadata> secondaryTables) {
        this.m_secondaryTables = secondaryTables;
    }

    public void setSqlResultSetMappings(List<SQLResultSetMappingMetadata> sqlResultSetMappings) {
        this.m_sqlResultSetMappings = sqlResultSetMappings;
    }

    public void setTable(TableMetadata table) {
        this.m_table = table;
    }

    protected void validateOptimisticLocking() {
        if (this.getDescriptor().usesVersionColumnOptimisticLocking() && !this.getDescriptor().usesOptimisticLocking()) {
            throw ValidationException.optimisticLockingVersionElementNotSpecified(this.getJavaClass());
        }
    }

    protected void validatePrimaryKey() {
        if (this.getDescriptor().hasCompositePrimaryKey()) {
            if (this.getDescriptor().pkClassWasNotValidated()) {
                throw ValidationException.invalidCompositePKSpecification(this.getJavaClass(), this.getDescriptor().getPKClassName());
            }
        } else if (!this.getDescriptor().hasPrimaryKeyFields() && !this.getDescriptor().isInheritanceSubclass()) {
            throw ValidationException.noPrimaryKeyAnnotationsFound(this.getJavaClass());
        }
    }
}

