/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.metadata.accessors;

import java.lang.annotation.Annotation;
import javax.persistence.FetchType;
import org.eclipse.persistence.annotations.BasicCollection;
import org.eclipse.persistence.annotations.CollectionTable;
import org.eclipse.persistence.annotations.PrivateOwned;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.internal.helper.DatabaseField;
import org.eclipse.persistence.internal.jpa.metadata.MetadataHelper;
import org.eclipse.persistence.internal.jpa.metadata.accessors.ClassAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.DirectAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataAccessibleObject;
import org.eclipse.persistence.internal.jpa.metadata.columns.ColumnMetadata;
import org.eclipse.persistence.internal.jpa.metadata.columns.PrimaryKeyJoinColumnMetadata;
import org.eclipse.persistence.internal.jpa.metadata.columns.PrimaryKeyJoinColumnsMetadata;
import org.eclipse.persistence.internal.jpa.metadata.tables.CollectionTableMetadata;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.mappings.DirectCollectionMapping;
import org.eclipse.persistence.mappings.converters.Converter;

public class BasicCollectionAccessor
extends DirectAccessor {
    private boolean m_privateOwned;
    private ColumnMetadata m_valueColumn;
    private CollectionTableMetadata m_collectionTable;
    private Enum m_joinFetch;

    public BasicCollectionAccessor() {
    }

    public BasicCollectionAccessor(MetadataAccessibleObject accessibleObject, ClassAccessor classAccessor) {
        super(accessibleObject, classAccessor);
        Object basicCollection = this.getAnnotation(BasicCollection.class);
        if (basicCollection != null) {
            this.m_valueColumn = new ColumnMetadata((Annotation)this.invokeMethod("valueColumn", basicCollection), this.getAttributeName());
            this.setFetch((Enum)this.invokeMethod("fetch", basicCollection));
        }
    }

    protected CollectionTableMetadata getCollectionTable() {
        return this.m_collectionTable;
    }

    protected ColumnMetadata getColumn(String loggingCtx) {
        return this.m_valueColumn == null ? new ColumnMetadata(this.getAttributeName()) : this.m_valueColumn;
    }

    protected String getDefaultCollectionTableName() {
        if (this.m_valueColumn != null && this.m_valueColumn.getTable() != null && !this.m_valueColumn.getTable().equals("")) {
            return this.m_valueColumn.getTable();
        }
        return this.getUpperCaseShortJavaClassName() + "_" + this.getUpperCaseAttributeName();
    }

    public FetchType getDefaultFetchType() {
        return FetchType.LAZY;
    }

    public Enum getJoinFetch() {
        return this.m_joinFetch;
    }

    public String getPrivateOwned() {
        return null;
    }

    public Class getReferenceClass() {
        Class cls = this.getReferenceClassFromGeneric();
        return cls == null ? Void.TYPE : cls;
    }

    public ColumnMetadata getValueColumn() {
        return this.m_valueColumn;
    }

    protected boolean hasPrivateOwned() {
        return this.m_privateOwned || this.isAnnotationPresent(PrivateOwned.class);
    }

    public void init(MetadataAccessibleObject accessibleObject, ClassAccessor accessor) {
        super.init(accessibleObject, accessor);
        if (this.m_valueColumn != null) {
            this.m_valueColumn.setAttributeName(this.getAttributeName());
        }
    }

    public boolean isBasicCollection() {
        return true;
    }

    public boolean isPrivateOwned() {
        return this.m_privateOwned;
    }

    public void process() {
        if (!MetadataHelper.isValidBasicCollectionType(this.getRawClass())) {
            throw ValidationException.invalidTypeForBasicCollectionAttribute(this.getAttributeName(), this.getRawClass(), this.getJavaClass());
        }
        DirectCollectionMapping mapping = new DirectCollectionMapping();
        this.process(mapping);
        this.setIndirectionPolicy(mapping, null, this.usesIndirection());
        mapping.setDirectField(this.getDatabaseField(mapping.getReferenceTable(), "metadata_default_value_column"));
        this.processMappingConverter(mapping);
    }

    protected void process(DirectCollectionMapping mapping) {
        mapping.setAttributeName(this.getAttributeName());
        this.setAccessorMethods(mapping);
        mapping.setIsPrivateOwned(this.hasPrivateOwned());
        mapping.setJoinFetch(this.getMappingJoinFetchType(this.m_joinFetch));
        this.processCollectionTable(mapping);
        this.processReturnInsertAndUpdate();
        this.getDescriptor().addMapping(mapping);
    }

    protected void processCollectionTable(DirectCollectionMapping mapping) {
        CollectionTableMetadata collectionTable = this.m_collectionTable == null ? new CollectionTableMetadata((Annotation)this.getAnnotation(CollectionTable.class), this.getAnnotatedElementName()) : this.m_collectionTable;
        this.processTable(collectionTable, this.getDefaultCollectionTableName());
        mapping.setReferenceTable(collectionTable.getDatabaseTable());
        for (PrimaryKeyJoinColumnMetadata primaryKeyJoinColumn : this.processPrimaryKeyJoinColumns(new PrimaryKeyJoinColumnsMetadata(collectionTable.getPrimaryKeyJoinColumns()))) {
            DatabaseField pkField = primaryKeyJoinColumn.getPrimaryKeyField();
            pkField.setName(this.getName(pkField, this.getDescriptor().getPrimaryKeyFieldName(), "metadata_default_pk_column"));
            pkField.setTable(this.getDescriptor().getPrimaryTable());
            DatabaseField fkField = primaryKeyJoinColumn.getForeignKeyField();
            fkField.setName(this.getName(fkField, this.getDescriptor().getPrimaryKeyFieldName(), "metadata_default_fk_column"));
            fkField.setTable(collectionTable.getDatabaseTable());
            mapping.addReferenceKeyField(fkField, pkField);
        }
    }

    protected void setCollectionTable(CollectionTableMetadata collectionTable) {
        this.m_collectionTable = collectionTable;
    }

    public void setConverter(DatabaseMapping mapping, Converter converter) {
        ((DirectCollectionMapping)mapping).setValueConverter(converter);
    }

    public void setConverterClassName(DatabaseMapping mapping, String converterClassName) {
        ((DirectCollectionMapping)mapping).setValueConverterClassName(converterClassName);
    }

    public void setFieldClassification(DatabaseMapping mapping, Class classification) {
        ((DirectCollectionMapping)mapping).setDirectFieldClassification(classification);
    }

    public void setJoinFetch(Enum joinFetch) {
        this.m_joinFetch = joinFetch;
    }

    public void setPrivateOwned(String ignore) {
        this.m_privateOwned = true;
    }

    public void setValueColumn(ColumnMetadata valueColumn) {
        this.m_valueColumn = valueColumn;
    }
}

