/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.metadata.accessors;

import java.lang.annotation.Annotation;
import java.sql.Blob;
import javax.persistence.Basic;
import javax.persistence.Column;
import javax.persistence.FetchType;
import org.eclipse.persistence.annotations.Mutable;
import org.eclipse.persistence.annotations.ReturnInsert;
import org.eclipse.persistence.internal.helper.DatabaseField;
import org.eclipse.persistence.internal.jpa.metadata.MetadataHelper;
import org.eclipse.persistence.internal.jpa.metadata.accessors.ClassAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.DirectAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataAccessibleObject;
import org.eclipse.persistence.internal.jpa.metadata.columns.ColumnMetadata;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.mappings.DirectToFieldMapping;
import org.eclipse.persistence.mappings.converters.Converter;

public class BasicAccessor
extends DirectAccessor {
    private Boolean m_mutable;
    private ColumnMetadata m_column;
    private DatabaseField m_field;

    public BasicAccessor() {
    }

    public BasicAccessor(MetadataAccessibleObject accessibleObject, ClassAccessor classAccessor) {
        super(accessibleObject, classAccessor);
        Object basic = this.getAnnotation(Basic.class);
        if (basic != null) {
            this.setFetch((Enum)this.invokeMethod("fetch", basic));
            this.setOptional((Boolean)this.invokeMethod("optional", basic));
        }
    }

    public ColumnMetadata getColumn() {
        return this.m_column;
    }

    protected ColumnMetadata getColumn(String loggingCtx) {
        if (this.m_column == null) {
            return new ColumnMetadata((Annotation)this.getAnnotation(Column.class), this.getAttributeName());
        }
        return this.m_column;
    }

    public FetchType getDefaultFetchType() {
        return FetchType.EAGER;
    }

    protected DatabaseField getField() {
        return this.m_field;
    }

    public Boolean getMutable() {
        return this.m_mutable;
    }

    public void init(MetadataAccessibleObject accessibleObject, ClassAccessor accessor) {
        super.init(accessibleObject, accessor);
        if (this.m_column != null) {
            this.m_column.setAttributeName(this.getAttributeName());
        }
    }

    public void process() {
        this.m_field = this.getDatabaseField(this.getDescriptor().getPrimaryTable(), "metadata_default_column");
        this.processReturnInsert(this.m_field);
        this.processReturnUpdate(this.m_field);
        if (this.getDescriptor().hasMappingForAttributeName(this.getAttributeName())) {
            this.getLogger().logWarningMessage("metadata_warning_ignore_mapping", this);
        } else {
            this.processDirectToFieldMapping(this.m_field);
        }
    }

    protected void processDirectToFieldMapping(DatabaseField field) {
        DirectToFieldMapping mapping = new DirectToFieldMapping();
        mapping.setField(field);
        mapping.setIsReadOnly(field.isReadOnly());
        mapping.setAttributeName(this.getAttributeName());
        mapping.setIsOptional(this.isOptional());
        mapping.setIsLazy(this.usesIndirection());
        this.setAccessorMethods(mapping);
        this.processMappingConverter(mapping);
        this.processMutable(mapping);
        this.getDescriptor().addMapping(mapping);
    }

    protected void processEnumerated(DatabaseMapping mapping) {
        if (MetadataHelper.isCollectionClass(this.getReferenceClass()) || MetadataHelper.isMapClass(this.getReferenceClass())) {
            this.processSerialized(mapping);
        } else {
            super.processEnumerated(mapping);
        }
    }

    protected void processLob(DatabaseMapping mapping) {
        if (MetadataHelper.isCollectionClass(this.getReferenceClass()) || MetadataHelper.isMapClass(this.getReferenceClass())) {
            this.setFieldClassification(mapping, Blob.class);
            this.processSerialized(mapping);
        } else {
            super.processLob(mapping);
        }
    }

    public void processMutable(DatabaseMapping mapping) {
        if (this.m_mutable == null) {
            Object mutable = this.getAnnotation(Mutable.class);
            if (mutable != null) {
                ((DirectToFieldMapping)mapping).setIsMutable((Boolean)this.invokeMethod("value", mutable));
            }
        } else {
            ((DirectToFieldMapping)mapping).setIsMutable(this.m_mutable);
        }
    }

    protected void processReturnInsert(DatabaseField field) {
        Object returnInsert = this.getAnnotation(ReturnInsert.class);
        if (returnInsert != null) {
            this.processReturnInsert(field, (Boolean)this.invokeMethod("returnOnly", returnInsert));
        }
    }

    protected void processReturnInsert(DatabaseField field, boolean returnOnly) {
        if (returnOnly) {
            this.getDescriptor().addFieldForInsertReturnOnly(field);
        } else {
            this.getDescriptor().addFieldForInsert(field);
        }
    }

    protected void processReturnUpdate(DatabaseField field) {
        if (this.hasReturnUpdate()) {
            this.getDescriptor().addFieldForUpdate(field);
        }
    }

    public void setColumn(ColumnMetadata column) {
        this.m_column = column;
    }

    public void setConverter(DatabaseMapping mapping, Converter converter) {
        ((DirectToFieldMapping)mapping).setConverter(converter);
    }

    public void setConverterClassName(DatabaseMapping mapping, String converterClassName) {
        ((DirectToFieldMapping)mapping).setConverterClassName(converterClassName);
    }

    public void setFieldClassification(DatabaseMapping mapping, Class classification) {
        ((DirectToFieldMapping)mapping).setFieldClassification(classification);
    }

    public void setMutable(Boolean mutable) {
        this.m_mutable = mutable;
    }
}

