/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa;

import java.util.Map;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import org.eclipse.persistence.internal.jpa.EntityManagerImpl;
import org.eclipse.persistence.internal.jpa.EntityManagerSetupImpl;
import org.eclipse.persistence.internal.localization.ExceptionLocalization;
import org.eclipse.persistence.sessions.server.ServerSession;

public class EntityManagerFactoryImpl
implements EntityManagerFactory {
    protected ServerSession serverSession;
    protected EntityManagerSetupImpl setupImpl;
    protected boolean isOpen = true;
    protected Map properties;

    public EntityManagerFactoryImpl(ServerSession serverSession) {
        this.serverSession = serverSession;
    }

    public EntityManagerFactoryImpl(EntityManagerSetupImpl setupImpl, Map properties) {
        this.setupImpl = setupImpl;
        this.properties = properties;
    }

    public synchronized ServerSession getServerSession() {
        if (this.serverSession == null) {
            ClassLoader realLoader = this.setupImpl.getPersistenceUnitInfo().getClassLoader();
            this.serverSession = this.setupImpl.deploy(realLoader, this.properties);
        }
        return this.serverSession;
    }

    public synchronized void close() {
        this.verifyOpen();
        this.isOpen = false;
        this.setupImpl.undeploy();
    }

    public boolean isOpen() {
        return this.isOpen;
    }

    public EntityManager createEntityManager() {
        return this.createEntityManagerImpl(false);
    }

    public EntityManager createEntityManager(Map properties) {
        return this.createEntityManagerImpl(properties, false);
    }

    protected EntityManagerImpl createEntityManagerImpl(boolean extended) {
        return this.createEntityManagerImpl(null, extended);
    }

    protected synchronized EntityManagerImpl createEntityManagerImpl(Map properties, boolean extended) {
        this.verifyOpen();
        if (!this.getServerSession().isConnected()) {
            this.getServerSession().login();
        }
        return this.createEntityManagerImplInternal(properties, extended);
    }

    protected EntityManagerImpl createEntityManagerImplInternal(Map properties, boolean extended) {
        return new EntityManagerImpl(this, properties, false, extended);
    }

    protected void verifyOpen() {
        if (!this.isOpen) {
            throw new IllegalStateException(ExceptionLocalization.buildMessage("operation_on_closed_entity_manager_factory"));
        }
    }

    protected void finalize() throws Throwable {
        if (this.isOpen()) {
            this.close();
        }
    }

    public Object getProperty(String name) {
        if (name == null) {
            return null;
        }
        return this.getServerSession().getProperty(name);
    }
}

