/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.util.Iterator;
import java.util.Vector;
import org.eclipse.persistence.descriptors.CMPPolicy;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.exceptions.DescriptorException;
import org.eclipse.persistence.internal.descriptors.ObjectBuilder;
import org.eclipse.persistence.internal.helper.ConversionManager;
import org.eclipse.persistence.internal.helper.DatabaseField;
import org.eclipse.persistence.internal.jpa.metadata.MetadataHelper;
import org.eclipse.persistence.internal.localization.ExceptionLocalization;
import org.eclipse.persistence.internal.security.PrivilegedAccessHelper;
import org.eclipse.persistence.internal.security.PrivilegedClassForName;
import org.eclipse.persistence.internal.security.PrivilegedGetField;
import org.eclipse.persistence.internal.security.PrivilegedGetMethod;
import org.eclipse.persistence.internal.security.PrivilegedGetValueFromField;
import org.eclipse.persistence.internal.security.PrivilegedMethodInvoker;
import org.eclipse.persistence.internal.security.PrivilegedSetValueInField;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.mappings.foundation.AbstractDirectMapping;

public class CMP3Policy
extends CMPPolicy {
    protected CMPPolicy.KeyElementAccessor[] keyClassFields;
    protected String pkClassName;
    protected Class pkClass;

    public void convertClassNamesToClasses(ClassLoader classLoader) {
        if (this.getPKClassName() != null) {
            try {
                Class pkClass = null;
                if (PrivilegedAccessHelper.shouldUsePrivilegedAccess()) {
                    try {
                        pkClass = (Class)AccessController.doPrivileged(new PrivilegedClassForName(this.getPKClassName(), true, classLoader));
                    }
                    catch (PrivilegedActionException exception) {
                        throw new IllegalArgumentException(ExceptionLocalization.buildMessage("pk_class_not_found", new Object[]{this.pkClassName}), exception.getException());
                    }
                } else {
                    pkClass = PrivilegedAccessHelper.getClassForName(this.getPKClassName(), true, classLoader);
                }
                this.setPKClass(pkClass);
            }
            catch (ClassNotFoundException exc) {
                throw new IllegalArgumentException(ExceptionLocalization.buildMessage("pk_class_not_found", new Object[]{this.pkClassName}), exc);
            }
        }
    }

    public boolean isCMP3Policy() {
        return true;
    }

    public void setPrimaryKeyClassName(String pkClassName) {
        this.pkClassName = pkClassName;
    }

    public Class getPKClass() {
        if (this.pkClass == null && this.getPKClassName() == null) {
            this.initializePrimaryKeyFields(null);
        }
        return this.pkClass;
    }

    public void setPKClass(Class pkClass) {
        this.pkClass = pkClass;
    }

    public String getPKClassName() {
        return this.pkClassName;
    }

    public Object getPKClassInstance() {
        try {
            return this.getPKClass().newInstance();
        }
        catch (Exception ex) {
            return null;
        }
    }

    public Vector createPkVectorFromKey(Object key, AbstractSession session) {
        CMPPolicy.KeyElementAccessor[] pkElementArray = this.getKeyClassFields(key.getClass());
        Vector<Object> pkVector = new Vector<Object>(pkElementArray.length);
        for (int index = 0; index < pkElementArray.length; ++index) {
            DatabaseMapping mapping = this.getDescriptor().getObjectBuilder().getMappingForAttributeName(pkElementArray[index].getAttributeName());
            if (mapping == null) {
                mapping = this.getDescriptor().getObjectBuilder().getMappingForField(pkElementArray[index].getDatabaseField());
            }
            while (mapping.isAggregateObjectMapping()) {
                if ((mapping = mapping.getReferenceDescriptor().getObjectBuilder().getMappingForAttributeName(pkElementArray[index].getAttributeName())) != null) continue;
                mapping = this.getDescriptor().getObjectBuilder().getMappingForField(pkElementArray[index].getDatabaseField());
            }
            Object fieldValue = null;
            fieldValue = mapping.isDirectToFieldMapping() ? ((AbstractDirectMapping)mapping).getFieldValue(pkElementArray[index].getValue(key), session) : pkElementArray[index].getValue(key);
            pkVector.add(fieldValue);
        }
        return pkVector;
    }

    protected Object createBeanUsingKey(Object key, AbstractSession session) {
        try {
            Object bean = this.getDescriptor().getInstantiationPolicy().buildNewInstance();
            CMPPolicy.KeyElementAccessor[] keyElements = this.getKeyClassFields(key.getClass());
            for (int index = 0; index < keyElements.length; ++index) {
                Object toWriteInto = bean;
                Object keyFieldValue = keyElements[index].getValue(key);
                DatabaseField field = keyElements[index].getDatabaseField();
                DatabaseMapping mapping = this.getDescriptor().getObjectBuilder().getMappingForAttributeName(keyElements[index].getAttributeName());
                if (mapping == null) {
                    mapping = this.getDescriptor().getObjectBuilder().getMappingForField(field);
                }
                while (mapping.isAggregateObjectMapping()) {
                    Object aggregate = mapping.getRealAttributeValueFromObject(toWriteInto, session);
                    if (aggregate == null) {
                        aggregate = mapping.getReferenceDescriptor().getJavaClass().newInstance();
                        mapping.setRealAttributeValueInObject(toWriteInto, aggregate);
                    }
                    if ((mapping = mapping.getReferenceDescriptor().getObjectBuilder().getMappingForAttributeName(keyElements[index].getAttributeName())) == null) {
                        mapping = this.getDescriptor().getObjectBuilder().getMappingForField(field);
                    }
                    toWriteInto = aggregate;
                }
                mapping.setRealAttributeValueInObject(toWriteInto, keyFieldValue);
            }
            return bean;
        }
        catch (Exception e) {
            throw DescriptorException.errorUsingPrimaryKey(key, this.getDescriptor(), e);
        }
    }

    protected CMPPolicy.KeyElementAccessor[] initializePrimaryKeyFields(Class keyClass) {
        CMPPolicy.KeyElementAccessor[] pkAttributes = null;
        ClassDescriptor descriptor = this.getDescriptor();
        pkAttributes = new CMPPolicy.KeyElementAccessor[descriptor.getObjectBuilder().getPrimaryKeyMappings().size()];
        Iterator<DatabaseField> attributesIter = descriptor.getPrimaryKeyFields().iterator();
        int i = 0;
        while (attributesIter.hasNext()) {
            DatabaseField field = attributesIter.next();
            Vector<DatabaseMapping> allMappings = descriptor.getObjectBuilder().getReadOnlyMappingsForField(field);
            if (allMappings == null) {
                allMappings = new Vector(1);
            }
            allMappings.add(descriptor.getObjectBuilder().getMappingForField(field));
            NoSuchMethodException elementIsFound = null;
            for (int index = allMappings.size() - 1; index >= 0; --index) {
                block22: {
                    DatabaseMapping mapping = allMappings.get(index);
                    if (mapping.isForeignReferenceMapping()) continue;
                    if (mapping.isAggregateMapping()) {
                        DatabaseMapping writableMapping;
                        ObjectBuilder builder = mapping.getReferenceDescriptor().getObjectBuilder();
                        Vector<DatabaseMapping> aggregateMappings = builder.getReadOnlyMappingsForField(field);
                        if (aggregateMappings != null && !aggregateMappings.isEmpty()) {
                            allMappings.addAll(aggregateMappings);
                        }
                        if ((writableMapping = builder.getMappingForField(field)) != null) {
                            allMappings.add(writableMapping);
                        }
                        allMappings.remove(mapping);
                        index = allMappings.size();
                        continue;
                    }
                    String fieldName = mapping.getAttributeName();
                    if (keyClass == null) {
                        pkAttributes[i] = new CMPPolicy.KeyIsElementAccessor(mapping.getAttributeName(), field);
                        this.setPKClass(ConversionManager.getObjectClass(mapping.getAttributeClassification()));
                        elementIsFound = null;
                    } else {
                        try {
                            Field keyField = null;
                            if (PrivilegedAccessHelper.shouldUsePrivilegedAccess()) {
                                try {
                                    keyField = (Field)AccessController.doPrivileged(new PrivilegedGetField(keyClass, fieldName, true));
                                }
                                catch (PrivilegedActionException exception) {
                                    throw (NoSuchFieldException)exception.getException();
                                }
                            } else {
                                keyField = PrivilegedAccessHelper.getField(keyClass, fieldName, true);
                            }
                            pkAttributes[i] = new FieldAccessor(keyField, fieldName, field);
                            elementIsFound = null;
                        }
                        catch (NoSuchFieldException ex) {
                            StringBuffer buffer = new StringBuffer();
                            buffer.append("get");
                            buffer.append(fieldName.substring(0, 1).toUpperCase());
                            buffer.append(fieldName.substring(1));
                            try {
                                Method method = null;
                                if (PrivilegedAccessHelper.shouldUsePrivilegedAccess()) {
                                    try {
                                        method = AccessController.doPrivileged(new PrivilegedGetMethod(keyClass, buffer.toString(), new Class[0], true));
                                    }
                                    catch (PrivilegedActionException exception) {
                                        throw (NoSuchMethodException)exception.getException();
                                    }
                                } else {
                                    method = PrivilegedAccessHelper.getMethod(keyClass, buffer.toString(), new Class[0], true);
                                }
                                pkAttributes[i] = new PropertyAccessor(method, fieldName, field);
                                elementIsFound = null;
                            }
                            catch (NoSuchMethodException exs) {
                                if (descriptor.getObjectBuilder().getPrimaryKeyMappings().size() == 1) {
                                    pkAttributes[i] = new CMPPolicy.KeyIsElementAccessor(mapping.getAttributeName(), field);
                                    this.setPKClass(ConversionManager.getObjectClass(mapping.getAttributeClassification()));
                                    elementIsFound = null;
                                    break block22;
                                }
                                elementIsFound = exs;
                            }
                        }
                    }
                }
                if (elementIsFound == null) break;
            }
            if (elementIsFound != null) {
                throw DescriptorException.errorUsingPrimaryKey(keyClass, this.getDescriptor(), elementIsFound);
            }
            ++i;
        }
        return pkAttributes;
    }

    protected CMPPolicy.KeyElementAccessor[] getKeyClassFields(Class clazz) {
        if (this.keyClassFields == null) {
            this.keyClassFields = this.initializePrimaryKeyFields(this.pkClass == null ? clazz : this.pkClass);
        }
        return this.keyClassFields;
    }

    private class FieldAccessor
    implements CMPPolicy.KeyElementAccessor {
        protected Field field;
        protected String attributeName;
        protected DatabaseField databaseField;

        public FieldAccessor(Field field, String attributeName, DatabaseField databaseField) {
            this.field = field;
            this.attributeName = attributeName;
            this.databaseField = databaseField;
        }

        public String getAttributeName() {
            return this.attributeName;
        }

        public DatabaseField getDatabaseField() {
            return this.databaseField;
        }

        public Object getValue(Object object) {
            try {
                if (PrivilegedAccessHelper.shouldUsePrivilegedAccess()) {
                    try {
                        return AccessController.doPrivileged(new PrivilegedGetValueFromField(this.field, object));
                    }
                    catch (PrivilegedActionException exception) {
                        throw DescriptorException.errorUsingPrimaryKey(object, CMP3Policy.this.getDescriptor(), exception.getException());
                    }
                }
                return PrivilegedAccessHelper.getValueFromField(this.field, object);
            }
            catch (Exception ex) {
                throw DescriptorException.errorUsingPrimaryKey(object, CMP3Policy.this.getDescriptor(), ex);
            }
        }

        public void setValue(Object object, Object value) {
            block5: {
                try {
                    Field pkField = null;
                    if (PrivilegedAccessHelper.shouldUsePrivilegedAccess()) {
                        try {
                            pkField = (Field)AccessController.doPrivileged(new PrivilegedGetField(object.getClass(), this.field.getName(), true));
                            AccessController.doPrivileged(new PrivilegedSetValueInField(pkField, object, value));
                            break block5;
                        }
                        catch (PrivilegedActionException exception) {
                            throw DescriptorException.errorUsingPrimaryKey(object, CMP3Policy.this.getDescriptor(), exception.getException());
                        }
                    }
                    pkField = PrivilegedAccessHelper.getField(object.getClass(), this.field.getName(), true);
                    PrivilegedAccessHelper.setValueInField(pkField, object, value);
                }
                catch (Exception ex) {
                    throw DescriptorException.errorUsingPrimaryKey(object, CMP3Policy.this.getDescriptor(), ex);
                }
            }
        }
    }

    private class PropertyAccessor
    implements CMPPolicy.KeyElementAccessor {
        protected Method method;
        protected String attributeName;
        protected DatabaseField databaseField;

        public PropertyAccessor(Method method, String attributeName, DatabaseField field) {
            this.method = method;
            this.attributeName = attributeName;
            this.databaseField = field;
        }

        public String getAttributeName() {
            return this.attributeName;
        }

        public DatabaseField getDatabaseField() {
            return this.databaseField;
        }

        public Object getValue(Object object) {
            try {
                if (PrivilegedAccessHelper.shouldUsePrivilegedAccess()) {
                    try {
                        return AccessController.doPrivileged(new PrivilegedMethodInvoker(this.method, object, new Object[0]));
                    }
                    catch (PrivilegedActionException exception) {
                        Exception throwableException = exception.getException();
                        if (throwableException instanceof IllegalAccessException) {
                            throw (IllegalAccessException)throwableException;
                        }
                        throw (InvocationTargetException)throwableException;
                    }
                }
                return PrivilegedAccessHelper.invokeMethod(this.method, object, new Object[0]);
            }
            catch (Exception ex) {
                throw DescriptorException.errorUsingPrimaryKey(object, CMP3Policy.this.getDescriptor(), ex);
            }
        }

        public void setValue(Object object, Object value) {
            block6: {
                try {
                    if (PrivilegedAccessHelper.shouldUsePrivilegedAccess()) {
                        try {
                            AccessController.doPrivileged(new PrivilegedMethodInvoker(MetadataHelper.getSetMethod(this.method, object.getClass()), object, new Object[]{value}));
                            break block6;
                        }
                        catch (PrivilegedActionException exception) {
                            Exception throwableException = exception.getException();
                            if (throwableException instanceof IllegalAccessException) {
                                throw (IllegalAccessException)throwableException;
                            }
                            throw (InvocationTargetException)throwableException;
                        }
                    }
                    PrivilegedAccessHelper.invokeMethod(MetadataHelper.getSetMethod(this.method, object.getClass()), object, new Object[]{value});
                }
                catch (Exception ex) {
                    throw DescriptorException.errorUsingPrimaryKey(object, CMP3Policy.this.getDescriptor(), ex);
                }
            }
        }
    }
}

