/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.identitymaps;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Vector;
import org.eclipse.persistence.internal.helper.ClassConstants;
import org.eclipse.persistence.internal.helper.ConcurrencyManager;
import org.eclipse.persistence.internal.helper.Helper;
import org.eclipse.persistence.internal.identitymaps.IdentityMap;
import org.eclipse.persistence.sessions.Record;

public class CacheKey
implements Serializable,
Cloneable {
    protected Vector key;
    protected int hash;
    protected Object object;
    protected IdentityMap mapOwner;
    protected Object writeLockValue;
    protected Object wrapper;
    protected ConcurrencyManager mutex;
    protected Record record;
    protected long lastUpdatedQueryId;
    protected int invalidationState = 0;
    public static final int CHECK_INVALIDATION_POLICY = 0;
    public static final int CACHE_KEY_INVALID = -1;
    protected long readTime = 0L;

    public CacheKey(Vector primaryKey) {
        this.key = primaryKey;
        this.hash = this.computeHash(primaryKey);
    }

    public CacheKey(Vector primaryKey, Object object, Object lockValue) {
        this.key = primaryKey;
        this.hash = this.computeHash(primaryKey);
        this.writeLockValue = lockValue;
        if (object != null) {
            this.setObject(object);
        }
    }

    public CacheKey(Vector primaryKey, Object object, Object lockValue, long readTime) {
        this(primaryKey, object, lockValue);
        this.readTime = readTime;
    }

    public void acquire() {
        this.getMutex().acquire(false);
    }

    public void acquire(boolean forMerge) {
        this.getMutex().acquire(forMerge);
    }

    public boolean acquireNoWait() {
        return this.getMutex().acquireNoWait(false);
    }

    public boolean acquireIfUnownedNoWait() {
        return this.getMutex().acquireIfUnownedNoWait(false);
    }

    public boolean acquireNoWait(boolean forMerge) {
        return this.getMutex().acquireNoWait(forMerge);
    }

    public void acquireDeferredLock() {
        this.getMutex().acquireDeferredLock();
    }

    public void checkReadLock() {
        this.getMutex().checkReadLock();
    }

    public void checkDeferredLock() {
        this.getMutex().checkDeferredLock();
    }

    public void acquireReadLock() {
        this.getMutex().acquireReadLock();
    }

    public boolean acquireReadLockNoWait() {
        return this.getMutex().acquireReadLockNoWait();
    }

    public Object clone() {
        Object object = null;
        try {
            object = super.clone();
        }
        catch (Exception exception) {
            throw new InternalError(exception.toString());
        }
        return object;
    }

    protected int computeHash(Vector primaryKey) {
        int computedHashValue = 0;
        int size = primaryKey.size();
        for (int index = 0; index < size; ++index) {
            Object value = primaryKey.get(index);
            if (value == null) continue;
            if (value.getClass().isArray()) {
                computedHashValue ^= this.computeArrayHashCode(value);
                continue;
            }
            computedHashValue ^= value.hashCode();
        }
        return computedHashValue;
    }

    private int computeArrayHashCode(Object obj) {
        if (obj.getClass() == ClassConstants.APBYTE) {
            return Arrays.hashCode((byte[])obj);
        }
        if (obj.getClass() == ClassConstants.APCHAR) {
            return Arrays.hashCode((char[])obj);
        }
        return Arrays.hashCode((Object[])obj);
    }

    public boolean equals(Object object) {
        try {
            return this.equals((CacheKey)object);
        }
        catch (ClassCastException incorrectType) {
            return false;
        }
    }

    public boolean equals(CacheKey key) {
        if (this == key) {
            return true;
        }
        int size = this.key.size();
        if (size == key.key.size()) {
            for (int index = 0; index < size; ++index) {
                Object myValue = this.key.get(index);
                Object comparisionValue = key.key.get(index);
                if (!(myValue == null ? comparisionValue != null : (myValue.getClass().isArray() ? (myValue.getClass() == ClassConstants.APBYTE && comparisionValue.getClass() == ClassConstants.APBYTE ? !Helper.compareByteArrays((byte[])myValue, (byte[])comparisionValue) : (myValue.getClass() == ClassConstants.APCHAR && comparisionValue.getClass() == ClassConstants.APCHAR ? !Helper.compareCharArrays((char[])myValue, (char[])comparisionValue) : !Helper.compareArrays((Object[])myValue, (Object[])comparisionValue))) : !myValue.equals(comparisionValue)))) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public long getLastUpdatedQueryId() {
        return this.lastUpdatedQueryId;
    }

    public Vector getKey() {
        return this.key;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ConcurrencyManager getMutex() {
        if (this.mutex == null) {
            CacheKey cacheKey = this;
            synchronized (cacheKey) {
                if (this.mutex == null) {
                    this.mutex = new ConcurrencyManager(this);
                }
            }
        }
        return this.mutex;
    }

    public Object getObject() {
        return this.object;
    }

    public IdentityMap getOwningMap() {
        return this.mapOwner;
    }

    public long getReadTime() {
        return this.readTime;
    }

    public Record getRecord() {
        return this.record;
    }

    public Object getWrapper() {
        return this.wrapper;
    }

    public Object getWriteLockValue() {
        return this.writeLockValue;
    }

    public int hashCode() {
        return this.hash;
    }

    public boolean isAcquired() {
        return this.getMutex().isAcquired();
    }

    public int getInvalidationState() {
        return this.invalidationState;
    }

    public void release() {
        this.getMutex().release();
    }

    public void releaseDeferredLock() {
        this.getMutex().releaseDeferredLock();
    }

    public void releaseReadLock() {
        this.getMutex().releaseReadLock();
    }

    public void setInvalidationState(int invalidationState) {
        this.invalidationState = invalidationState;
    }

    public void setLastUpdatedQueryId(long id) {
        this.lastUpdatedQueryId = id;
    }

    public void setKey(Vector key) {
        this.key = key;
        this.hash = this.computeHash(key);
    }

    public void setMutex(ConcurrencyManager mutex) {
        this.mutex = mutex;
    }

    public void setObject(Object object) {
        this.object = object;
    }

    public void setOwningMap(IdentityMap map) {
        this.mapOwner = map;
    }

    public void setReadTime(long readTime) {
        this.readTime = readTime;
        this.invalidationState = 0;
    }

    public void setRecord(Record newRecord) {
        this.record = newRecord;
    }

    public void setWrapper(Object wrapper) {
        this.wrapper = wrapper;
    }

    public void setWriteLockValue(Object writeLockValue) {
        this.writeLockValue = writeLockValue;
    }

    public String toString() {
        int hashCode = 0;
        if (this.getObject() != null) {
            hashCode = this.getObject().hashCode();
        }
        return "[" + this.getKey() + ": " + hashCode + ": " + this.getWriteLockValue() + ": " + this.getReadTime() + ": " + this.getObject() + "]";
    }

    public void updateAccess() {
    }
}

