/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.expressions;

import java.io.IOException;
import java.io.Writer;
import java.util.Collection;
import java.util.Iterator;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.expressions.Expression;
import org.eclipse.persistence.internal.databaseaccess.DatabasePlatform;
import org.eclipse.persistence.internal.expressions.ConstantExpression;
import org.eclipse.persistence.internal.expressions.FieldExpression;
import org.eclipse.persistence.internal.expressions.ParameterExpression;
import org.eclipse.persistence.internal.expressions.QueryKeyExpression;
import org.eclipse.persistence.internal.helper.DatabaseField;
import org.eclipse.persistence.internal.sessions.AbstractRecord;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.queries.SQLCall;

public class ExpressionSQLPrinter {
    protected AbstractSession session;
    protected SQLCall call;
    protected AbstractRecord translationRow;
    protected boolean shouldPrintQualifiedNames;
    protected Writer writer;
    protected boolean requiresDistinct;
    protected boolean isFirstElementPrinted;

    public ExpressionSQLPrinter(AbstractSession session, AbstractRecord translationRow, SQLCall call, boolean printQualifiedNames) {
        this.session = session;
        this.translationRow = translationRow;
        this.call = call;
        this.shouldPrintQualifiedNames = printQualifiedNames;
        this.requiresDistinct = false;
        this.isFirstElementPrinted = false;
    }

    protected SQLCall getCall() {
        return this.call;
    }

    public DatabasePlatform getPlatform() {
        return this.session.getPlatform();
    }

    protected AbstractSession getSession() {
        return this.session;
    }

    protected AbstractRecord getTranslationRow() {
        return this.translationRow;
    }

    public Writer getWriter() {
        return this.writer;
    }

    public boolean isFirstElementPrinted() {
        return this.isFirstElementPrinted;
    }

    public void printExpression(Expression expression) {
        this.translateExpression(expression);
    }

    public void printField(DatabaseField field) {
        if (field == null) {
            return;
        }
        try {
            if (this.shouldPrintQualifiedNames()) {
                this.getWriter().write(field.getQualifiedName());
            } else {
                this.getWriter().write(field.getName());
            }
        }
        catch (IOException exception) {
            throw ValidationException.fileError(exception);
        }
    }

    public void printParameter(ParameterExpression expression) {
        try {
            this.getCall().appendTranslationParameter(this.getWriter(), expression, this.getPlatform());
        }
        catch (IOException exception) {
            throw ValidationException.fileError(exception);
        }
    }

    public void printParameter(DatabaseField field) {
        this.getCall().appendTranslation(this.getWriter(), field);
    }

    public void printPrimitive(Object value) {
        if (value instanceof Collection) {
            this.printValuelist((Collection)value);
            return;
        }
        this.session.getPlatform().appendLiteralToCall(this.getCall(), this.getWriter(), value);
    }

    public void printNull(ConstantExpression nullValueExpression) {
        if (this.session.getPlatform().shouldBindLiterals()) {
            DatabaseField field = null;
            Expression localBase = nullValueExpression.getLocalBase();
            if (localBase.isFieldExpression()) {
                field = ((FieldExpression)localBase).getField();
            } else if (localBase.isQueryKeyExpression()) {
                field = ((QueryKeyExpression)localBase).getField();
            }
            this.session.getPlatform().appendLiteralToCall(this.getCall(), this.getWriter(), field);
        } else {
            this.session.getPlatform().appendLiteralToCall(this.getCall(), this.getWriter(), null);
        }
    }

    public void printString(String value) {
        try {
            this.getWriter().write(value);
        }
        catch (IOException exception) {
            throw ValidationException.fileError(exception);
        }
    }

    public void printValuelist(Collection values) {
        try {
            this.getWriter().write("(");
            Iterator valuesEnum = values.iterator();
            while (valuesEnum.hasNext()) {
                Object value = valuesEnum.next();
                this.session.getPlatform().appendLiteralToCall(this.getCall(), this.getWriter(), value);
                if (!valuesEnum.hasNext()) continue;
                this.getWriter().write(", ");
            }
            this.getWriter().write(")");
        }
        catch (IOException exception) {
            throw ValidationException.fileError(exception);
        }
    }

    public void printList(Collection values) {
        try {
            this.getWriter().write("(");
            Iterator valuesEnum = values.iterator();
            while (valuesEnum.hasNext()) {
                Object value = valuesEnum.next();
                if (value instanceof Expression) {
                    ((Expression)value).printSQL(this);
                } else {
                    this.session.getPlatform().appendLiteralToCall(this.getCall(), this.getWriter(), value);
                }
                if (!valuesEnum.hasNext()) continue;
                this.getWriter().write(", ");
            }
            this.getWriter().write(")");
        }
        catch (IOException exception) {
            throw ValidationException.fileError(exception);
        }
    }

    public boolean requiresDistinct() {
        return this.requiresDistinct;
    }

    protected void setCall(SQLCall call) {
        this.call = call;
    }

    public void setIsFirstElementPrinted(boolean isFirstElementPrinted) {
        this.isFirstElementPrinted = isFirstElementPrinted;
    }

    public void setRequiresDistinct(boolean requiresDistinct) {
        this.requiresDistinct = requiresDistinct;
    }

    protected void setSession(AbstractSession theSession) {
        this.session = theSession;
    }

    protected void setShouldPrintQualifiedNames(boolean shouldPrintQualifiedNames) {
        this.shouldPrintQualifiedNames = shouldPrintQualifiedNames;
    }

    protected void setTranslationRow(AbstractRecord theRow) {
        this.translationRow = theRow;
    }

    public void setWriter(Writer writer) {
        this.writer = writer;
    }

    public boolean shouldPrintParameterValues() {
        return this.getTranslationRow() != null;
    }

    protected boolean shouldPrintQualifiedNames() {
        return this.shouldPrintQualifiedNames;
    }

    protected void translateExpression(Expression theExpression) {
        theExpression.printSQL(this);
    }
}

