/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.descriptors;

import java.io.Serializable;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.descriptors.DescriptorEvent;
import org.eclipse.persistence.descriptors.FetchGroupManager;
import org.eclipse.persistence.descriptors.changetracking.ObjectChangePolicy;
import org.eclipse.persistence.exceptions.ConcurrencyException;
import org.eclipse.persistence.exceptions.DatabaseException;
import org.eclipse.persistence.exceptions.DescriptorException;
import org.eclipse.persistence.exceptions.QueryException;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.expressions.Expression;
import org.eclipse.persistence.expressions.ExpressionBuilder;
import org.eclipse.persistence.internal.databaseaccess.DatabaseAccessor;
import org.eclipse.persistence.internal.databaseaccess.DatabasePlatform;
import org.eclipse.persistence.internal.databaseaccess.Platform;
import org.eclipse.persistence.internal.descriptors.DescriptorIterator;
import org.eclipse.persistence.internal.descriptors.OptimisticLockingPolicy;
import org.eclipse.persistence.internal.descriptors.PersistenceEntity;
import org.eclipse.persistence.internal.expressions.QueryKeyExpression;
import org.eclipse.persistence.internal.expressions.SQLSelectStatement;
import org.eclipse.persistence.internal.helper.DatabaseField;
import org.eclipse.persistence.internal.helper.DatabaseTable;
import org.eclipse.persistence.internal.helper.DeferredLockManager;
import org.eclipse.persistence.internal.helper.Helper;
import org.eclipse.persistence.internal.helper.NonSynchronizedVector;
import org.eclipse.persistence.internal.identitymaps.CacheKey;
import org.eclipse.persistence.internal.indirection.ProxyIndirectionPolicy;
import org.eclipse.persistence.internal.queries.JoinedAttributeManager;
import org.eclipse.persistence.internal.sessions.AbstractRecord;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.internal.sessions.AggregateObjectChangeSet;
import org.eclipse.persistence.internal.sessions.ChangeRecord;
import org.eclipse.persistence.internal.sessions.MergeManager;
import org.eclipse.persistence.internal.sessions.ObjectChangeSet;
import org.eclipse.persistence.internal.sessions.UnitOfWorkChangeSet;
import org.eclipse.persistence.internal.sessions.UnitOfWorkImpl;
import org.eclipse.persistence.mappings.AggregateMapping;
import org.eclipse.persistence.mappings.AggregateObjectMapping;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.mappings.ForeignReferenceMapping;
import org.eclipse.persistence.mappings.foundation.AbstractDirectMapping;
import org.eclipse.persistence.mappings.foundation.AbstractTransformationMapping;
import org.eclipse.persistence.mappings.querykeys.DirectQueryKey;
import org.eclipse.persistence.mappings.querykeys.QueryKey;
import org.eclipse.persistence.queries.DataReadQuery;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.ObjectBuildingQuery;
import org.eclipse.persistence.queries.ObjectLevelModifyQuery;
import org.eclipse.persistence.queries.ObjectLevelReadQuery;
import org.eclipse.persistence.queries.QueryByExamplePolicy;
import org.eclipse.persistence.queries.ReadAllQuery;
import org.eclipse.persistence.queries.ReadObjectQuery;
import org.eclipse.persistence.queries.WriteObjectQuery;
import org.eclipse.persistence.sessions.DatabaseRecord;
import org.eclipse.persistence.sessions.ObjectCopyingPolicy;
import org.eclipse.persistence.sessions.remote.RemoteSession;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ObjectBuilder
implements Cloneable,
Serializable {
    protected ClassDescriptor descriptor;
    protected Map<String, DatabaseMapping> mappingsByAttribute;
    protected Map<DatabaseField, DatabaseMapping> mappingsByField = new HashMap<DatabaseField, DatabaseMapping>(20);
    protected Map<DatabaseField, Vector<DatabaseMapping>> readOnlyMappingsByField = new HashMap<DatabaseField, Vector<DatabaseMapping>>(20);
    protected Map fieldsMap;
    protected Map primaryKeyFieldsBySecondaryField;
    protected Vector<DatabaseMapping> primaryKeyMappings;
    protected Vector<Class> primaryKeyClassifications;
    protected transient Vector<DatabaseMapping> nonPrimaryKeyMappings;
    protected transient Expression primaryKeyExpression;
    protected Vector<DatabaseMapping> joinedAttributes = null;
    protected List<DatabaseMapping> cloningMappings;

    public ObjectBuilder(ClassDescriptor descriptor) {
        this.mappingsByAttribute = new HashMap<String, DatabaseMapping>(20);
        this.fieldsMap = new HashMap(20);
        this.primaryKeyMappings = NonSynchronizedVector.newInstance(5);
        this.nonPrimaryKeyMappings = NonSynchronizedVector.newInstance(10);
        this.cloningMappings = new ArrayList<DatabaseMapping>(10);
        this.descriptor = descriptor;
    }

    public AbstractRecord createRecord() {
        return new DatabaseRecord();
    }

    public AbstractRecord createRecord(int size) {
        return new DatabaseRecord(size);
    }

    public void addPrimaryKeyForNonDefaultTable(AbstractRecord databaseRow) {
        this.addPrimaryKeyForNonDefaultTable(databaseRow, null, null);
    }

    public void addPrimaryKeyForNonDefaultTable(AbstractRecord databaseRow, Object object, AbstractSession session) {
        if (!this.getDescriptor().hasMultipleTables()) {
            return;
        }
        Enumeration<DatabaseTable> tablesEnum = this.getDescriptor().getTables().elements();
        tablesEnum.nextElement();
        while (tablesEnum.hasMoreElements()) {
            DatabaseTable table = tablesEnum.nextElement();
            Map<DatabaseField, DatabaseField> keyMapping = this.getDescriptor().getAdditionalTablePrimaryKeyFields().get(table);
            if (keyMapping == null) continue;
            Iterator<DatabaseField> primaryKeyFieldEnum = keyMapping.keySet().iterator();
            Iterator<DatabaseField> secondaryKeyFieldEnum = keyMapping.values().iterator();
            while (primaryKeyFieldEnum.hasNext()) {
                DatabaseField primaryKeyField = primaryKeyFieldEnum.next();
                DatabaseField secondaryKeyField = secondaryKeyFieldEnum.next();
                Object primaryValue = databaseRow.get(primaryKeyField);
                if (primaryValue == null && !databaseRow.containsKey(primaryKeyField)) {
                    if (object != null) {
                        DatabaseMapping mapping = this.getMappingForField(secondaryKeyField);
                        if (mapping == null) {
                            throw DescriptorException.missingMappingForField(secondaryKeyField, this.getDescriptor());
                        }
                        mapping.writeFromObjectIntoRow(object, databaseRow, session);
                    }
                    databaseRow.put(primaryKeyField, databaseRow.get(secondaryKeyField));
                    continue;
                }
                databaseRow.put(secondaryKeyField, primaryValue);
            }
        }
    }

    public void clearPrimaryKey(Object object) {
        if (object instanceof PersistenceEntity) {
            ((PersistenceEntity)object)._persistence_setPKVector(null);
            ((PersistenceEntity)object)._persistence_setCacheKey(null);
        }
    }

    public void assignReturnRow(Object object, AbstractSession writeSession, AbstractRecord row) throws DatabaseException {
        writeSession.log(1, "query", "assign_return_row", row);
        ReadObjectQuery query = new ReadObjectQuery();
        query.setSession(writeSession);
        HashSet handledMappings = null;
        int size = row.size();
        if (size > 1) {
            handledMappings = new HashSet(size);
        }
        Vector fields = row.getFields();
        for (int index = 0; index < size; ++index) {
            DatabaseField field = (DatabaseField)fields.get(index);
            this.assignReturnValueForField(object, query, row, field, handledMappings);
        }
    }

    public void assignReturnValueForField(Object object, ReadObjectQuery query, AbstractRecord row, DatabaseField field, Collection handledMappings) {
        Vector<DatabaseMapping> mappingVector;
        DatabaseMapping mapping = this.getMappingForField(field);
        if (mapping != null) {
            this.assignReturnValueToMapping(object, query, row, field, mapping, handledMappings);
        }
        if ((mappingVector = this.getReadOnlyMappingsForField(field)) != null) {
            int size = mappingVector.size();
            for (int index = 0; index < size; ++index) {
                mapping = mappingVector.get(index);
                this.assignReturnValueToMapping(object, query, row, field, mapping, handledMappings);
            }
        }
    }

    protected void assignReturnValueToMapping(Object object, ReadObjectQuery query, AbstractRecord row, DatabaseField field, DatabaseMapping mapping, Collection handledMappings) {
        if (handledMappings != null && handledMappings.contains(mapping)) {
            return;
        }
        if (mapping.isDirectToFieldMapping()) {
            mapping.readFromRowIntoObject(row, null, object, query);
        } else if (mapping.isAggregateObjectMapping()) {
            ((AggregateObjectMapping)mapping).readFromReturnRowIntoObject(row, object, query, handledMappings);
        } else if (mapping.isTransformationMapping()) {
            ((AbstractTransformationMapping)mapping).readFromReturnRowIntoObject(row, object, query, handledMappings);
        } else {
            query.getSession().log(1, "query", "field_for_unsupported_mapping_returned", field, this.getDescriptor());
        }
    }

    public Object assignSequenceNumber(Object object, AbstractSession writeSession) throws DatabaseException {
        DatabaseField sequenceNumberField = this.getDescriptor().getSequenceNumberField();
        Object existingValue = this.getBaseValueForField(sequenceNumberField, object);
        if (existingValue != null && !writeSession.getSequencing().shouldOverrideExistingValue(object.getClass(), existingValue)) {
            return null;
        }
        Object sequenceValue = writeSession.getSequencing().getNextValue(object.getClass());
        writeSession.log(1, "sequencing", "assign_sequence", sequenceValue, object);
        if (sequenceValue == null) {
            return null;
        }
        AbstractRecord tempRow = this.createRecord(1);
        tempRow.put(sequenceNumberField, sequenceValue);
        ReadObjectQuery query = new ReadObjectQuery();
        query.setSession(writeSession);
        DatabaseMapping mapping = this.getBaseMappingForField(sequenceNumberField);
        Object sequenceIntoObject = this.getParentObjectForField(sequenceNumberField, object);
        Object convertedSequenceValue = mapping.readFromRowIntoObject(tempRow, null, sequenceIntoObject, query);
        this.clearPrimaryKey(object);
        return convertedSequenceValue;
    }

    public void buildAttributesIntoObject(Object domainObject, AbstractRecord databaseRow, ObjectBuildingQuery query, JoinedAttributeManager joinManager, boolean forRefresh) throws DatabaseException {
        AbstractSession executionSession = query.getSession().getExecutionSession(query);
        Vector<DatabaseMapping> mappings = this.getDescriptor().getMappings();
        boolean readAllMappings = query.shouldReadAllMappings();
        int size = mappings.size();
        for (int index = 0; index < size; ++index) {
            DatabaseMapping mapping = mappings.get(index);
            if (!readAllMappings && !query.shouldReadMapping(mapping)) continue;
            mapping.readFromRowIntoObject(databaseRow, joinManager, domainObject, query, executionSession);
        }
        if (this.getDescriptor().getEventManager().hasAnyEventListeners()) {
            DescriptorEvent event = new DescriptorEvent(domainObject);
            event.setQuery(query);
            event.setSession(query.getSession());
            event.setRecord(databaseRow);
            if (forRefresh) {
                event.setEventCode(9);
            } else {
                event.setEventCode(8);
            }
            this.getDescriptor().getEventManager().executeEvent(event);
        }
    }

    public Object buildBackupClone(Object clone, UnitOfWorkImpl unitOfWork) {
        ClassDescriptor descriptor = this.getDescriptor();
        Object backup = descriptor.getCopyPolicy().buildClone(clone, unitOfWork);
        List mappings = this.getCloningMappings();
        int size = mappings.size();
        if (descriptor.hasFetchGroupManager() && descriptor.getFetchGroupManager().isPartialObject(clone)) {
            FetchGroupManager fetchGroupManager = descriptor.getFetchGroupManager();
            for (int index = 0; index < size; ++index) {
                DatabaseMapping mapping = (DatabaseMapping)mappings.get(index);
                if (!fetchGroupManager.isAttributeFetched(clone, mapping.getAttributeName())) continue;
                mapping.buildBackupClone(clone, backup, unitOfWork);
            }
        } else {
            for (int index = 0; index < size; ++index) {
                ((DatabaseMapping)mappings.get(index)).buildBackupClone(clone, backup, unitOfWork);
            }
        }
        return backup;
    }

    public Expression buildDeleteExpression(DatabaseTable table, AbstractRecord row) {
        if (this.getDescriptor().usesOptimisticLocking() && this.getDescriptor().getTables().firstElement().equals(table)) {
            return this.getDescriptor().getOptimisticLockingPolicy().buildDeleteExpression(table, this.primaryKeyExpression, row);
        }
        return this.buildPrimaryKeyExpression(table);
    }

    public Expression buildExpressionFromExample(Object queryObject, QueryByExamplePolicy policy, Expression expressionBuilder, Map processedObjects, AbstractSession session) {
        if (processedObjects.containsKey(queryObject)) {
            return null;
        }
        processedObjects.put(queryObject, queryObject);
        Expression expression = null;
        Vector<DatabaseMapping> mappings = this.getDescriptor().getMappings();
        for (int index = 0; index < mappings.size(); ++index) {
            DatabaseMapping mapping = mappings.get(index);
            expression = expression == null ? mapping.buildExpression(queryObject, policy, expressionBuilder, processedObjects, session) : expression.and(mapping.buildExpression(queryObject, policy, expressionBuilder, processedObjects, session));
        }
        return expression;
    }

    public Object buildNewInstance() {
        return this.getDescriptor().getInstantiationPolicy().buildNewInstance();
    }

    public Object buildObject(ObjectLevelReadQuery query, AbstractRecord databaseRow) throws DatabaseException, QueryException {
        JoinedAttributeManager joinManager = null;
        if (query.hasJoining()) {
            joinManager = query.getJoinedAttributeManager();
        }
        return this.buildObject(query, databaseRow, joinManager);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object buildObject(ObjectBuildingQuery query, AbstractRecord databaseRow, JoinedAttributeManager joinManager) throws DatabaseException, QueryException {
        AbstractSession session = query.getSession();
        session.startOperationProfile("object building", query, Integer.MAX_VALUE);
        Vector primaryKey = this.extractPrimaryKeyFromRow(databaseRow, session);
        if (primaryKey == null && !query.hasPartialAttributeExpressions() && !this.getDescriptor().isAggregateCollectionDescriptor()) {
            session.endOperationProfile("object building", query, Integer.MAX_VALUE);
            if (query.shouldBuildNullForNullPk()) {
                return null;
            }
            throw QueryException.nullPrimaryKeyInBuildingObject(query, databaseRow);
        }
        ClassDescriptor concreteDescriptor = this.getDescriptor();
        if (concreteDescriptor.hasInheritance() && concreteDescriptor.getInheritancePolicy().shouldReadSubclasses()) {
            Class classValue = concreteDescriptor.getInheritancePolicy().classFromRow(databaseRow, session);
            if ((concreteDescriptor = session.getDescriptor(classValue)) == null && query.hasPartialAttributeExpressions()) {
                concreteDescriptor = this.getDescriptor();
            }
            if (concreteDescriptor == null) {
                session.endOperationProfile("object building", query, Integer.MAX_VALUE);
                throw QueryException.noDescriptorForClassFromInheritancePolicy(query, classValue);
            }
        }
        Object domainObject = null;
        try {
            if (session.isUnitOfWork()) {
                domainObject = this.buildObjectInUnitOfWork(query, joinManager, databaseRow, (UnitOfWorkImpl)session, primaryKey, concreteDescriptor);
            } else {
                domainObject = this.buildObject(query, databaseRow, session, primaryKey, concreteDescriptor, joinManager);
                if (query.shouldCacheQueryResults()) {
                    query.cacheResult(domainObject);
                }
                if (query.shouldUseWrapperPolicy()) {
                    domainObject = concreteDescriptor.getObjectBuilder().wrapObject(domainObject, session);
                }
            }
        }
        finally {
            session.endOperationProfile("object building", query, Integer.MAX_VALUE);
        }
        return domainObject;
    }

    protected Object buildObjectInUnitOfWork(ObjectBuildingQuery query, JoinedAttributeManager joinManager, AbstractRecord databaseRow, UnitOfWorkImpl unitOfWork, Vector primaryKey, ClassDescriptor concreteDescriptor) throws DatabaseException, QueryException {
        if (!concreteDescriptor.shouldUseSessionCacheInUnitOfWorkEarlyTransaction() && (unitOfWork.getCommitManager().isActive() || unitOfWork.wasTransactionBegunPrematurely() || concreteDescriptor.shouldIsolateObjectsInUnitOfWork()) && !unitOfWork.isClassReadOnly(concreteDescriptor.getJavaClass(), concreteDescriptor)) {
            return concreteDescriptor.getObjectBuilder().buildWorkingCopyCloneFromRow(query, joinManager, databaseRow, unitOfWork, primaryKey);
        }
        return this.buildWorkingCopyCloneNormally(query, databaseRow, unitOfWork, primaryKey, concreteDescriptor, joinManager);
    }

    protected Object buildWorkingCopyCloneNormally(ObjectBuildingQuery query, AbstractRecord databaseRow, UnitOfWorkImpl unitOfWork, Vector primaryKey, ClassDescriptor concreteDescriptor, JoinedAttributeManager joinManager) throws DatabaseException, QueryException {
        AbstractSession session = unitOfWork.getParentIdentityMapSession(query);
        Object original = null;
        Object clone = null;
        query.setSession(session);
        original = session.isUnitOfWork() ? this.buildObjectInUnitOfWork(query, joinManager, databaseRow, (UnitOfWorkImpl)session, primaryKey, concreteDescriptor) : this.buildObject(query, databaseRow, session, primaryKey, concreteDescriptor, joinManager);
        if (query.shouldCacheQueryResults()) {
            query.cacheResult(original);
        }
        query.setSession(unitOfWork);
        clone = unitOfWork.shouldCascadeCloneToJoinedRelationship() ? query.registerIndividualResult(original, unitOfWork, joinManager) : query.registerIndividualResult(original, unitOfWork, null);
        return clone;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object buildObject(ObjectBuildingQuery query, AbstractRecord databaseRow, AbstractSession session, Vector primaryKey, ClassDescriptor concreteDescriptor, JoinedAttributeManager joinManager) throws DatabaseException, QueryException {
        Object domainObject = null;
        CacheKey cacheKey = null;
        try {
            if (query.shouldMaintainCache()) {
                if (DeferredLockManager.SHOULD_USE_DEFERRED_LOCKS && (concreteDescriptor.shouldAcquireCascadedLocks() || joinManager != null)) {
                    int counter;
                    cacheKey = session.getIdentityMapAccessorInstance().acquireDeferredLock(primaryKey, concreteDescriptor.getJavaClass(), concreteDescriptor);
                    domainObject = cacheKey.getObject();
                    for (counter = 0; domainObject == null && counter < 1000 && cacheKey.getMutex().getActiveThread() != Thread.currentThread(); ++counter) {
                        cacheKey.releaseDeferredLock();
                        try {
                            Thread.sleep(10L);
                        }
                        catch (InterruptedException exception) {
                            // empty catch block
                        }
                        cacheKey = session.getIdentityMapAccessorInstance().acquireDeferredLock(primaryKey, concreteDescriptor.getJavaClass(), concreteDescriptor);
                        domainObject = cacheKey.getObject();
                    }
                    if (counter == 1000) {
                        throw ConcurrencyException.maxTriesLockOnBuildObjectExceded(cacheKey.getMutex().getActiveThread(), Thread.currentThread());
                    }
                } else {
                    cacheKey = session.getIdentityMapAccessorInstance().acquireLock(primaryKey, concreteDescriptor.getJavaClass(), concreteDescriptor);
                    domainObject = cacheKey.getObject();
                }
            }
            if (domainObject == null) {
                domainObject = query.isReadObjectQuery() && ((ReadObjectQuery)query).shouldLoadResultIntoSelectionObject() ? ((ReadObjectQuery)query).getSelectionObject() : concreteDescriptor.getObjectBuilder().buildNewInstance();
                if (query.shouldMaintainCache()) {
                    cacheKey.setObject(domainObject);
                    this.copyQueryInfoToCacheKey(cacheKey, query, databaseRow, session, concreteDescriptor);
                }
                concreteDescriptor.getObjectBuilder().buildAttributesIntoObject(domainObject, databaseRow, query, joinManager, false);
                if (query.shouldMaintainCache() && query.getFetchGroup() != null && concreteDescriptor.hasFetchGroupManager()) {
                    concreteDescriptor.getFetchGroupManager().setObjectFetchGroup(domainObject, query.getFetchGroup(), session);
                }
            } else {
                if (query.isReadObjectQuery() && ((ReadObjectQuery)query).shouldLoadResultIntoSelectionObject()) {
                    this.copyInto(domainObject, ((ReadObjectQuery)query).getSelectionObject());
                    domainObject = ((ReadObjectQuery)query).getSelectionObject();
                }
                boolean isInvalidated = concreteDescriptor.getCacheInvalidationPolicy().isInvalidated(cacheKey, query.getExecutionTime());
                if (cacheKey.getMutex().getActiveThread() == Thread.currentThread() && (query.shouldRefreshIdentityMapResult() || concreteDescriptor.shouldAlwaysRefreshCache() || isInvalidated) && cacheKey.getLastUpdatedQueryId() != query.getQueryId() && !cacheKey.getMutex().isLockedByMergeManager()) {
                    if (concreteDescriptor.hasFetchGroupManager() && concreteDescriptor.getFetchGroupManager().isPartialObject(domainObject)) {
                        this.revertFetchGroupData(domainObject, concreteDescriptor, cacheKey, query, joinManager, databaseRow, session);
                    } else {
                        boolean refreshRequired = true;
                        if (concreteDescriptor.usesOptimisticLocking()) {
                            OptimisticLockingPolicy policy = concreteDescriptor.getOptimisticLockingPolicy();
                            Object cacheValue = policy.getValueToPutInCache(databaseRow, session);
                            if (concreteDescriptor.shouldOnlyRefreshCacheIfNewerVersion() && !(refreshRequired = policy.isNewerVersion(databaseRow, domainObject, primaryKey, session))) {
                                cacheKey.setReadTime(query.getExecutionTime());
                            }
                            if (refreshRequired) {
                                cacheKey.setWriteLockValue(cacheValue);
                            }
                        }
                        if (refreshRequired) {
                            cacheKey.setLastUpdatedQueryId(query.getQueryId());
                            concreteDescriptor.getObjectBuilder().buildAttributesIntoObject(domainObject, databaseRow, query, joinManager, true);
                            cacheKey.setReadTime(query.getExecutionTime());
                        }
                    }
                } else if (concreteDescriptor.hasFetchGroupManager() && concreteDescriptor.getFetchGroupManager().isPartialObject(domainObject) && !concreteDescriptor.getFetchGroupManager().isObjectValidForFetchGroup(domainObject, query.getFetchGroup())) {
                    concreteDescriptor.getFetchGroupManager().unionFetchGroupIntoObject(domainObject, query.getFetchGroup(), session);
                    concreteDescriptor.getObjectBuilder().buildAttributesIntoObject(domainObject, databaseRow, query, joinManager, false);
                } else if (joinManager != null && joinManager.hasJoinedAttributeExpressions()) {
                    List<Expression> joinExpressions = joinManager.getJoinedAttributeExpressions();
                    int size = joinExpressions.size();
                    for (int index = 0; index < size; ++index) {
                        QueryKeyExpression queryKeyExpression = (QueryKeyExpression)joinExpressions.get(index);
                        if (!queryKeyExpression.getBaseExpression().isExpressionBuilder()) continue;
                        DatabaseMapping mapping = this.getMappingForAttributeName(queryKeyExpression.getName());
                        if (mapping == null) {
                            throw ValidationException.missingMappingForAttribute(concreteDescriptor, queryKeyExpression.getName(), this.toString());
                        }
                        Object attributeValue = mapping.getAttributeValueFromObject(domainObject);
                        if (attributeValue == null || !mapping.isForeignReferenceMapping() || !((ForeignReferenceMapping)mapping).usesIndirection() || ((ForeignReferenceMapping)mapping).getIndirectionPolicy().objectIsInstantiated(attributeValue)) continue;
                        mapping.readFromRowIntoObject(databaseRow, joinManager, domainObject, query, query.getExecutionSession());
                    }
                } else if (query.isReadAllQuery() && ((ReadAllQuery)query).hasBatchReadAttributes()) {
                    Vector batchExpressions = ((ReadAllQuery)query).getBatchReadAttributeExpressions();
                    int size = batchExpressions.size();
                    for (int index = 0; index < size; ++index) {
                        QueryKeyExpression queryKeyExpression = (QueryKeyExpression)batchExpressions.get(index);
                        if (!queryKeyExpression.getBaseExpression().isExpressionBuilder()) continue;
                        DatabaseMapping mapping = this.getMappingForAttributeName(queryKeyExpression.getName());
                        if (mapping == null) {
                            throw ValidationException.missingMappingForAttribute(concreteDescriptor, queryKeyExpression.getName(), this.toString());
                        }
                        Object attributeValue = mapping.getAttributeValueFromObject(domainObject);
                        if (attributeValue == null || !mapping.isForeignReferenceMapping() || !((ForeignReferenceMapping)mapping).usesIndirection() || ((ForeignReferenceMapping)mapping).getIndirectionPolicy().objectIsInstantiated(attributeValue)) continue;
                        mapping.readFromRowIntoObject(databaseRow, joinManager, domainObject, query, query.getExecutionSession());
                    }
                }
            }
        }
        finally {
            if (query.shouldMaintainCache() && cacheKey != null) {
                if (cacheKey.getObject() != null) {
                    cacheKey.updateAccess();
                }
                if (DeferredLockManager.SHOULD_USE_DEFERRED_LOCKS && (concreteDescriptor.shouldAcquireCascadedLocks() || joinManager != null)) {
                    cacheKey.releaseDeferredLock();
                } else {
                    cacheKey.release();
                }
            }
        }
        if (domainObject instanceof PersistenceEntity) {
            ((PersistenceEntity)domainObject)._persistence_setCacheKey(cacheKey);
            ((PersistenceEntity)domainObject)._persistence_setPKVector(primaryKey);
        }
        return domainObject;
    }

    private void revertFetchGroupData(Object domainObject, ClassDescriptor concreteDescriptor, CacheKey cacheKey, ObjectBuildingQuery query, JoinedAttributeManager joinManager, AbstractRecord databaseRow, AbstractSession session) {
        concreteDescriptor.getFetchGroupManager().reset(domainObject);
        concreteDescriptor.getObjectBuilder().buildAttributesIntoObject(domainObject, databaseRow, query, joinManager, false);
        concreteDescriptor.getFetchGroupManager().setObjectFetchGroup(domainObject, query.getFetchGroup(), session);
        concreteDescriptor.getFetchGroupManager().setRefreshOnFetchGroupToObject(domainObject, query.shouldRefreshIdentityMapResult() || concreteDescriptor.shouldAlwaysRefreshCache());
        cacheKey.setLastUpdatedQueryId(query.getQueryId());
        if (concreteDescriptor.usesOptimisticLocking()) {
            OptimisticLockingPolicy policy = concreteDescriptor.getOptimisticLockingPolicy();
            cacheKey.setWriteLockValue(policy.getValueToPutInCache(databaseRow, session));
        }
        cacheKey.setReadTime(query.getExecutionTime());
        cacheKey.setInvalidationState(0);
    }

    public Object buildObjectsInto(ReadAllQuery query, Vector databaseRows, Object domainObjects) throws DatabaseException {
        AbstractSession session = query.getSession();
        int size = databaseRows.size();
        JoinedAttributeManager joinManager = null;
        if (query.hasJoining()) {
            joinManager = query.getJoinedAttributeManager();
        }
        for (int index = 0; index < size; ++index) {
            AbstractRecord databaseRow = (AbstractRecord)databaseRows.get(index);
            if (databaseRow == null) continue;
            Object domainObject = this.buildObject(query, databaseRow, joinManager);
            query.getContainerPolicy().addInto(domainObject, domainObjects, session);
        }
        return domainObjects;
    }

    public Expression buildPrimaryKeyExpression(DatabaseTable table) throws DescriptorException {
        if (this.getDescriptor().getTables().firstElement().equals(table)) {
            return this.getPrimaryKeyExpression();
        }
        Map<DatabaseField, DatabaseField> keyMapping = this.getDescriptor().getAdditionalTablePrimaryKeyFields().get(table);
        if (keyMapping == null) {
            throw DescriptorException.multipleTablePrimaryKeyNotSpecified(this.getDescriptor());
        }
        ExpressionBuilder builder = new ExpressionBuilder();
        Expression expression = null;
        for (DatabaseField field : keyMapping.values()) {
            expression = builder.getField(field).equal(builder.getParameter(field)).and(expression);
        }
        return expression;
    }

    public Expression buildPrimaryKeyExpressionFromKeys(Vector primaryKeyValues, AbstractSession session) {
        Expression expression = null;
        ExpressionBuilder builder = new ExpressionBuilder();
        List<DatabaseField> primaryKeyFields = this.getDescriptor().getPrimaryKeyFields();
        for (int index = 0; index < primaryKeyFields.size(); ++index) {
            Object value = primaryKeyValues.get(index);
            DatabaseField field = primaryKeyFields.get(index);
            if (value == null) continue;
            Expression subExpression = ((Expression)builder).getField(field).equal(value);
            expression = subExpression.and(expression);
        }
        return expression;
    }

    public Expression buildPrimaryKeyExpressionFromObject(Object domainObject, AbstractSession session) {
        return this.buildPrimaryKeyExpressionFromKeys(this.extractPrimaryKeyFromObject(domainObject, session), session);
    }

    public AbstractRecord buildRow(Object object, AbstractSession session) {
        return this.buildRow(this.createRecord(), object, session);
    }

    public AbstractRecord buildRow(AbstractRecord databaseRow, Object object, AbstractSession session) {
        Vector<DatabaseMapping> mappings = this.getDescriptor().getMappings();
        int mappingsSize = mappings.size();
        for (int index = 0; index < mappingsSize; ++index) {
            DatabaseMapping mapping = mappings.get(index);
            mapping.writeFromObjectIntoRow(object, databaseRow, session);
        }
        if (this.getDescriptor().hasInheritance()) {
            this.getDescriptor().getInheritancePolicy().addClassIndicatorFieldToRow(databaseRow);
        }
        if (!this.getDescriptor().isAggregateDescriptor()) {
            this.addPrimaryKeyForNonDefaultTable(databaseRow);
        }
        return databaseRow;
    }

    public AbstractRecord buildRowForShallowInsert(Object object, AbstractSession session) {
        return this.buildRowForShallowInsert(this.createRecord(), object, session);
    }

    public AbstractRecord buildRowForShallowInsert(AbstractRecord databaseRow, Object object, AbstractSession session) {
        Vector<DatabaseMapping> mappings = this.getDescriptor().getMappings();
        int mappingsSize = mappings.size();
        for (int index = 0; index < mappingsSize; ++index) {
            DatabaseMapping mapping = mappings.get(index);
            mapping.writeFromObjectIntoRowForShallowInsert(object, databaseRow, session);
        }
        if (this.getDescriptor().hasInheritance()) {
            this.getDescriptor().getInheritancePolicy().addClassIndicatorFieldToRow(databaseRow);
        }
        if (!this.getDescriptor().isAggregateDescriptor()) {
            this.addPrimaryKeyForNonDefaultTable(databaseRow);
        }
        return databaseRow;
    }

    public AbstractRecord buildRowWithChangeSet(ObjectChangeSet objectChangeSet, AbstractSession session) {
        return this.buildRowWithChangeSet(this.createRecord(), objectChangeSet, session);
    }

    public AbstractRecord buildRowWithChangeSet(AbstractRecord databaseRow, ObjectChangeSet objectChangeSet, AbstractSession session) {
        Enumeration changeRecords = objectChangeSet.getChanges().elements();
        while (changeRecords.hasMoreElements()) {
            ChangeRecord changeRecord = (ChangeRecord)changeRecords.nextElement();
            DatabaseMapping mapping = changeRecord.getMapping();
            mapping.writeFromObjectIntoRowWithChangeRecord(changeRecord, databaseRow, session);
        }
        if (this.getDescriptor().hasInheritance()) {
            this.getDescriptor().getInheritancePolicy().addClassIndicatorFieldToRow(databaseRow);
        }
        return databaseRow;
    }

    public AbstractRecord buildRowForShallowInsertWithChangeSet(ObjectChangeSet objectChangeSet, AbstractSession session) {
        return this.buildRowForShallowInsertWithChangeSet(this.createRecord(), objectChangeSet, session);
    }

    public AbstractRecord buildRowForShallowInsertWithChangeSet(AbstractRecord databaseRow, ObjectChangeSet objectChangeSet, AbstractSession session) {
        for (ChangeRecord changeRecord : objectChangeSet.getChanges()) {
            DatabaseMapping mapping = changeRecord.getMapping();
            mapping.writeFromObjectIntoRowForShallowInsertWithChangeRecord(changeRecord, databaseRow, session);
        }
        if (this.getDescriptor().hasInheritance()) {
            this.getDescriptor().getInheritancePolicy().addClassIndicatorFieldToRow(databaseRow);
        }
        if (!this.getDescriptor().isAggregateDescriptor()) {
            this.addPrimaryKeyForNonDefaultTable(databaseRow);
        }
        return databaseRow;
    }

    public AbstractRecord buildRowForTranslation(Object object, AbstractSession session) {
        AbstractRecord databaseRow = this.createRecord();
        for (DatabaseMapping mapping : this.getPrimaryKeyMappings()) {
            if (mapping == null) continue;
            mapping.writeFromObjectIntoRow(object, databaseRow, session);
        }
        this.addPrimaryKeyForNonDefaultTable(databaseRow, object, session);
        return databaseRow;
    }

    public AbstractRecord buildRowForUpdate(WriteObjectQuery query) {
        AbstractRecord databaseRow = this.createRecord();
        for (DatabaseMapping mapping : this.getNonPrimaryKeyMappings()) {
            mapping.writeFromObjectIntoRowForUpdate(query, databaseRow);
        }
        if (this.getDescriptor().hasInheritance() && this.getDescriptor().isAggregateDescriptor() && query.getObject() != null) {
            if (query.getBackupClone() == null) {
                this.getDescriptor().getInheritancePolicy().addClassIndicatorFieldToRow(databaseRow);
            } else if (!query.getObject().getClass().equals(query.getBackupClone().getClass())) {
                this.getDescriptor().getInheritancePolicy().addClassIndicatorFieldToRow(databaseRow);
            }
        }
        return databaseRow;
    }

    public AbstractRecord buildRowForUpdateWithChangeSet(WriteObjectQuery query) {
        AbstractRecord databaseRow = this.createRecord();
        AbstractSession session = query.getSession();
        Vector changes = query.getObjectChangeSet().getChanges();
        int size = changes.size();
        for (int index = 0; index < size; ++index) {
            ChangeRecord changeRecord = (ChangeRecord)changes.get(index);
            DatabaseMapping mapping = changeRecord.getMapping();
            mapping.writeFromObjectIntoRowWithChangeRecord(changeRecord, databaseRow, session);
        }
        return databaseRow;
    }

    public AbstractRecord buildRowForWhereClause(ObjectLevelModifyQuery query) {
        AbstractRecord databaseRow = this.createRecord();
        for (DatabaseMapping mapping : this.getDescriptor().getMappings()) {
            mapping.writeFromObjectIntoRowForWhereClause(query, databaseRow);
        }
        if (!this.getDescriptor().isAggregateDescriptor()) {
            this.addPrimaryKeyForNonDefaultTable(databaseRow);
        }
        return databaseRow;
    }

    public AbstractRecord buildRowFromPrimaryKeyValues(Vector key, AbstractSession session) {
        AbstractRecord databaseRow = this.createRecord(key.size());
        int keySize = key.size();
        for (int index = 0; index < keySize; ++index) {
            DatabaseField field = this.getDescriptor().getPrimaryKeyFields().get(index);
            Object value = key.elementAt(index);
            value = session.getPlatform(this.getDescriptor().getJavaClass()).getConversionManager().convertObject(value, field.getType());
            databaseRow.put(field, value);
        }
        return databaseRow;
    }

    public AbstractRecord buildTemplateInsertRow(AbstractSession session) {
        AbstractRecord databaseRow = this.createRecord();
        this.buildTemplateInsertRow(session, databaseRow);
        return databaseRow;
    }

    public void buildTemplateInsertRow(AbstractSession session, AbstractRecord databaseRow) {
        for (DatabaseMapping mapping : this.getDescriptor().getMappings()) {
            mapping.writeInsertFieldsIntoRow(databaseRow, session);
        }
        if (this.getDescriptor().hasInheritance()) {
            this.getDescriptor().getInheritancePolicy().addClassIndicatorFieldToInsertRow(databaseRow);
        }
        if (!this.getDescriptor().isAggregateDescriptor()) {
            this.addPrimaryKeyForNonDefaultTable(databaseRow);
        }
        if (this.getDescriptor().usesOptimisticLocking()) {
            this.getDescriptor().getOptimisticLockingPolicy().addLockFieldsToUpdateRow(databaseRow, session);
        }
        if (this.getDescriptor().usesSequenceNumbers() && session.getSequencing().shouldAcquireValueAfterInsert(this.getDescriptor().getJavaClass())) {
            databaseRow.remove(this.getDescriptor().getSequenceNumberField());
        }
        if (this.getDescriptor().hasReturningPolicy()) {
            this.getDescriptor().getReturningPolicy().trimModifyRowForInsert(databaseRow);
        }
    }

    public AbstractRecord buildTemplateUpdateRow(AbstractSession session) {
        AbstractRecord databaseRow = this.createRecord();
        for (DatabaseMapping mapping : this.getNonPrimaryKeyMappings()) {
            mapping.writeUpdateFieldsIntoRow(databaseRow, session);
        }
        if (this.getDescriptor().usesOptimisticLocking()) {
            this.getDescriptor().getOptimisticLockingPolicy().addLockFieldsToUpdateRow(databaseRow, session);
        }
        return databaseRow;
    }

    public Expression buildUpdateExpression(DatabaseTable table, AbstractRecord transactionRow, AbstractRecord modifyRow) {
        Expression primaryKeyExpression = this.buildPrimaryKeyExpression(table);
        if (this.getDescriptor().usesOptimisticLocking()) {
            return this.getDescriptor().getOptimisticLockingPolicy().buildUpdateExpression(table, primaryKeyExpression, transactionRow, modifyRow);
        }
        return primaryKeyExpression;
    }

    public void buildPrimaryKeyAttributesIntoObject(Object original, AbstractRecord databaseRow, ObjectBuildingQuery query) throws DatabaseException, QueryException {
        AbstractSession executionSession = query.getSession().getExecutionSession(query);
        Vector<DatabaseMapping> mappings = this.getPrimaryKeyMappings();
        int mappingsSize = mappings.size();
        for (int i = 0; i < mappingsSize; ++i) {
            DatabaseMapping mapping = mappings.get(i);
            mapping.buildShallowOriginalFromRow(databaseRow, original, null, query, executionSession);
        }
    }

    public void buildAttributesIntoShallowObject(Object original, AbstractRecord databaseRow, ObjectBuildingQuery query) throws DatabaseException, QueryException {
        AbstractSession executionSession = query.getSession().getExecutionSession(query);
        Vector<DatabaseMapping> pkMappings = this.getPrimaryKeyMappings();
        int mappingsSize = pkMappings.size();
        for (int i = 0; i < mappingsSize; ++i) {
            DatabaseMapping mapping = pkMappings.get(i);
            if (mapping.isDirectToFieldMapping()) continue;
            mapping.buildShallowOriginalFromRow(databaseRow, original, null, query, executionSession);
        }
        Vector<DatabaseMapping> mappings = this.getDescriptor().getMappings();
        mappingsSize = mappings.size();
        for (int i = 0; i < mappingsSize; ++i) {
            DatabaseMapping mapping = mappings.get(i);
            if (!mapping.isDirectToFieldMapping()) continue;
            mapping.buildShallowOriginalFromRow(databaseRow, original, null, query, executionSession);
        }
    }

    public void buildAttributesIntoWorkingCopyClone(Object clone, ObjectBuildingQuery query, JoinedAttributeManager joinManager, AbstractRecord databaseRow, UnitOfWorkImpl unitOfWork, boolean forRefresh) throws DatabaseException, QueryException {
        boolean readAllMappings = query.shouldReadAllMappings();
        Vector<DatabaseMapping> mappings = this.descriptor.getMappings();
        int size = mappings.size();
        for (int index = 0; index < size; ++index) {
            DatabaseMapping mapping = mappings.get(index);
            if (!readAllMappings && !query.shouldReadMapping(mapping)) continue;
            mapping.buildCloneFromRow(databaseRow, joinManager, clone, query, unitOfWork, unitOfWork);
        }
        if (this.descriptor.hasCMPPolicy()) {
            this.descriptor.getCMPPolicy().invokeEJBLoad(clone, unitOfWork);
        }
        if (this.descriptor.getEventManager().hasAnyEventListeners()) {
            DescriptorEvent event = new DescriptorEvent(clone);
            event.setQuery(query);
            event.setSession(unitOfWork);
            event.setRecord(databaseRow);
            if (forRefresh) {
                event.setEventCode(9);
            } else {
                event.setEventCode(8);
            }
            this.descriptor.getEventManager().executeEvent(event);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object buildWorkingCopyCloneFromRow(ObjectBuildingQuery query, JoinedAttributeManager joinManager, AbstractRecord databaseRow, UnitOfWorkImpl unitOfWork, Vector primaryKey) throws DatabaseException, QueryException {
        AbstractSession session = unitOfWork.getParentIdentityMapSession(query);
        ClassDescriptor descriptor = this.getDescriptor();
        CacheKey unitOfWorkCacheKey = unitOfWork.getIdentityMapAccessorInstance().getIdentityMapManager().acquireLock(primaryKey, descriptor.getJavaClass(), false, descriptor);
        Object workingClone = unitOfWorkCacheKey.getObject();
        try {
            Object originalCacheKey;
            boolean isARefresh;
            boolean wasAClone = workingClone != null;
            boolean bl = isARefresh = query.shouldRefreshIdentityMapResult() || query.isLockQuery() && (!wasAClone || !query.isClonePessimisticLocked(workingClone, unitOfWork));
            if (wasAClone && descriptor.hasFetchGroupManager() && descriptor.getFetchGroupManager().isPartialObject(workingClone) && !descriptor.getFetchGroupManager().isObjectValidForFetchGroup(workingClone, query.getFetchGroup())) {
                isARefresh = true;
            }
            if (wasAClone && !isARefresh) {
                Object object = workingClone;
                return object;
            }
            boolean wasAnOriginal = false;
            boolean isIsolated = descriptor.shouldIsolateObjectsInUnitOfWork() || descriptor.shouldIsolateObjectsInUnitOfWorkEarlyTransaction() && unitOfWork.wasTransactionBegunPrematurely();
            Object original = null;
            if (!(isARefresh || isIsolated || unitOfWork.shouldReadFromDB() || (originalCacheKey = session.getIdentityMapAccessorInstance().getCacheKeyForObject(primaryKey, descriptor.getJavaClass(), descriptor)) == null)) {
                original = ((CacheKey)originalCacheKey).getObject();
                wasAnOriginal = original != null;
                boolean bl2 = isARefresh = wasAnOriginal && (descriptor.shouldAlwaysRefreshCache() || descriptor.getCacheInvalidationPolicy().isInvalidated((CacheKey)originalCacheKey, query.getExecutionTime()));
                if (wasAnOriginal && !isARefresh) {
                    Object object = unitOfWork.cloneAndRegisterObject(original, (CacheKey)originalCacheKey, unitOfWorkCacheKey, descriptor);
                    return object;
                }
            }
            if (!wasAClone) {
                if (wasAnOriginal) {
                    workingClone = this.instantiateWorkingCopyClone(original, unitOfWork);
                    unitOfWork.getCloneToOriginals().put(workingClone, original);
                } else {
                    workingClone = this.instantiateWorkingCopyCloneFromRow(databaseRow, query, primaryKey, unitOfWork);
                }
                unitOfWorkCacheKey.setObject(workingClone);
                unitOfWork.getCloneMapping().put(workingClone, workingClone);
            }
            if (wasAClone && unitOfWorkCacheKey.getLastUpdatedQueryId() >= query.getQueryId()) {
                originalCacheKey = workingClone;
                return originalCacheKey;
            }
            this.copyQueryInfoToCacheKey(unitOfWorkCacheKey, query, databaseRow, unitOfWork, descriptor);
            ObjectChangePolicy policy = descriptor.getObjectChangePolicy();
            if (!wasAClone) {
                policy.setChangeListener(workingClone, unitOfWork, descriptor);
            }
            policy.dissableEventProcessing(workingClone);
            if (isARefresh && this.descriptor.hasFetchGroupManager()) {
                this.descriptor.getFetchGroupManager().setObjectFetchGroup(workingClone, query.getFetchGroup(), unitOfWork);
            }
            this.buildAttributesIntoWorkingCopyClone(workingClone, query, joinManager, databaseRow, unitOfWork, wasAClone);
            if (!isARefresh && this.descriptor.hasFetchGroupManager()) {
                this.descriptor.getFetchGroupManager().setObjectFetchGroup(workingClone, query.getFetchGroup(), unitOfWork);
            }
            Object backupClone = policy.buildBackupClone(workingClone, this, unitOfWork);
            if (wasAClone) {
                policy.clearChanges(workingClone, unitOfWork, descriptor);
            }
            policy.enableEventProcessing(workingClone);
            unitOfWork.getCloneMapping().put(workingClone, backupClone);
            query.recordCloneForPessimisticLocking(workingClone, unitOfWork);
            if (workingClone instanceof PersistenceEntity) {
                ((PersistenceEntity)workingClone)._persistence_setPKVector(primaryKey);
            }
        }
        finally {
            unitOfWorkCacheKey.release();
        }
        return workingClone;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object buildWorkingCopyCloneFromResultSet(ObjectBuildingQuery query, JoinedAttributeManager joinManager, ResultSet resultSet, UnitOfWorkImpl unitOfWork, DatabaseAccessor accessor, ResultSetMetaData metaData, DatabasePlatform platform) throws DatabaseException, QueryException {
        ClassDescriptor descriptor = this.getDescriptor();
        Object primaryKeyObject = this.getPrimaryKeyMappings().get(0).valueFromResultSet(resultSet, query, unitOfWork, accessor, metaData, 1, platform);
        Vector<Object> primaryKey = new Vector<Object>(1);
        primaryKey.add(primaryKeyObject);
        CacheKey unitOfWorkCacheKey = unitOfWork.getIdentityMapAccessorInstance().getIdentityMapManager().acquireLock(primaryKey, descriptor.getJavaClass(), false, descriptor);
        Object workingClone = unitOfWorkCacheKey.getObject();
        try {
            if (workingClone != null) {
                Object object = workingClone;
                return object;
            }
            workingClone = descriptor.getCopyPolicy().buildWorkingCopyCloneFromPrimaryKeyObject(primaryKeyObject, query, unitOfWork);
            unitOfWorkCacheKey.setObject(workingClone);
            unitOfWork.getCloneMapping().put(workingClone, workingClone);
            ObjectChangePolicy policy = descriptor.getObjectChangePolicy();
            policy.setChangeListener(workingClone, unitOfWork, descriptor);
            Vector<DatabaseMapping> mappings = descriptor.getMappings();
            int size = mappings.size();
            for (int index = 0; index < size; ++index) {
                DatabaseMapping mapping = (DatabaseMapping)mappings.get(index);
                mapping.readFromResultSetIntoObject(resultSet, workingClone, query, unitOfWork, accessor, metaData, index + 1, platform);
            }
            query.recordCloneForPessimisticLocking(workingClone, unitOfWork);
            if (workingClone instanceof PersistenceEntity) {
                ((PersistenceEntity)workingClone)._persistence_setPKVector(primaryKey);
            }
        }
        finally {
            unitOfWorkCacheKey.release();
        }
        return workingClone;
    }

    public Object clone() {
        ObjectBuilder objectBuilder = null;
        try {
            objectBuilder = (ObjectBuilder)super.clone();
        }
        catch (CloneNotSupportedException exception) {
            throw new InternalError(exception.toString());
        }
        objectBuilder.setMappingsByAttribute(new HashMap<String, DatabaseMapping>(this.getMappingsByAttribute()));
        objectBuilder.setMappingsByField(new HashMap<DatabaseField, DatabaseMapping>(this.getMappingsByField()));
        objectBuilder.setFieldsMap(new HashMap(this.getFieldsMap()));
        objectBuilder.setReadOnlyMappingsByField(new HashMap<DatabaseField, Vector<DatabaseMapping>>(this.getReadOnlyMappingsByField()));
        objectBuilder.setPrimaryKeyMappings((Vector)this.getPrimaryKeyMappings().clone());
        objectBuilder.setNonPrimaryKeyMappings((Vector)this.getNonPrimaryKeyMappings().clone());
        return objectBuilder;
    }

    public void cascadePerformRemove(Object object, UnitOfWorkImpl uow, Map visitedObjects) {
        Vector<DatabaseMapping> mappings = this.getDescriptor().getMappings();
        for (int index = 0; index < mappings.size(); ++index) {
            DatabaseMapping mapping = (DatabaseMapping)mappings.get(index);
            mapping.cascadePerformRemoveIfRequired(object, uow, visitedObjects);
        }
    }

    public void cascadeDiscoverAndPersistUnregisteredNewObjects(Object object, Map newObjects, Map unregisteredExistingObjects, Map visitedObjects, UnitOfWorkImpl uow) {
        Vector<DatabaseMapping> mappings = this.getDescriptor().getMappings();
        for (int index = 0; index < mappings.size(); ++index) {
            DatabaseMapping mapping = (DatabaseMapping)mappings.get(index);
            mapping.cascadeDiscoverAndPersistUnregisteredNewObjects(object, newObjects, unregisteredExistingObjects, visitedObjects, uow);
        }
    }

    public void cascadeRegisterNewForCreate(Object object, UnitOfWorkImpl uow, Map visitedObjects) {
        Vector<DatabaseMapping> mappings = this.getDescriptor().getMappings();
        for (int index = 0; index < mappings.size(); ++index) {
            DatabaseMapping mapping = (DatabaseMapping)mappings.get(index);
            mapping.cascadeRegisterNewIfRequired(object, uow, visitedObjects);
        }
    }

    public ObjectChangeSet compareForChange(Object clone, Object backUp, UnitOfWorkChangeSet changeSet, AbstractSession session) {
        return this.descriptor.getObjectChangePolicy().calculateChanges(clone, backUp, changeSet, session, this.getDescriptor(), true);
    }

    public boolean compareObjects(Object firstObject, Object secondObject, AbstractSession session) {
        Vector<DatabaseMapping> mappings = this.getDescriptor().getMappings();
        for (int index = 0; index < mappings.size(); ++index) {
            DatabaseMapping mapping = (DatabaseMapping)mappings.get(index);
            if (mapping.compareObjects(firstObject, secondObject, session)) continue;
            Object firstValue = mapping.getAttributeValueFromObject(firstObject);
            Object secondValue = mapping.getAttributeValueFromObject(secondObject);
            session.log(1, "query", "compare_failed", mapping, firstValue, secondValue);
            return false;
        }
        return true;
    }

    public void copyInto(Object source, Object target, boolean cloneOneToOneValueHolders) {
        Vector<DatabaseMapping> mappings = this.getDescriptor().getMappings();
        for (int index = 0; index < mappings.size(); ++index) {
            DatabaseMapping mapping = (DatabaseMapping)mappings.get(index);
            Object value = null;
            value = cloneOneToOneValueHolders && mapping.isForeignReferenceMapping() ? ((ForeignReferenceMapping)mapping).getAttributeValueWithClonedValueHolders(source) : mapping.getAttributeValueFromObject(source);
            mapping.setAttributeValueInObject(target, value);
        }
    }

    public void copyInto(Object source, Object target) {
        this.copyInto(source, target, false);
    }

    public Object copyObject(Object original, ObjectCopyingPolicy policy) {
        Object copy = policy.getCopies().get(original);
        if (copy != null) {
            return copy;
        }
        copy = this.instantiateClone(original, policy.getSession());
        policy.getCopies().put(original, copy);
        List mappings = this.getCloningMappings();
        for (int index = 0; index < mappings.size(); ++index) {
            ((DatabaseMapping)mappings.get(index)).buildCopy(copy, original, policy);
        }
        if (policy.shouldResetPrimaryKey() && !this.getDescriptor().isAggregateDescriptor() && !this.getDescriptor().isAggregateCollectionDescriptor()) {
            boolean hasOneToOne = false;
            Enumeration<DatabaseMapping> keyMappingsEnum = this.getPrimaryKeyMappings().elements();
            while (keyMappingsEnum.hasMoreElements()) {
                if (!keyMappingsEnum.nextElement().isOneToOneMapping()) continue;
                hasOneToOne = true;
            }
            if (!hasOneToOne) {
                keyMappingsEnum = this.getPrimaryKeyMappings().elements();
                while (keyMappingsEnum.hasMoreElements()) {
                    DatabaseMapping mapping = keyMappingsEnum.nextElement();
                    if (mapping.isDirectToFieldMapping()) {
                        Object nullValue = ((AbstractDirectMapping)mapping).getAttributeValue(null, policy.getSession());
                        mapping.setAttributeValueInObject(copy, nullValue);
                        continue;
                    }
                    if (!mapping.isTransformationMapping()) continue;
                    mapping.setAttributeValueInObject(copy, null);
                }
            }
        }
        if (this.getDescriptor().getEventManager().hasAnyEventListeners()) {
            DescriptorEvent event = new DescriptorEvent(copy);
            event.setSession(policy.getSession());
            event.setOriginalObject(original);
            event.setEventCode(10);
            this.getDescriptor().getEventManager().executeEvent(event);
        }
        return copy;
    }

    public ObjectChangeSet createObjectChangeSet(Object clone, UnitOfWorkChangeSet uowChangeSet, AbstractSession session) {
        boolean isNew = ((UnitOfWorkImpl)session).isObjectNew(clone);
        return this.createObjectChangeSet(clone, uowChangeSet, isNew, session);
    }

    public ObjectChangeSet createObjectChangeSet(Object clone, UnitOfWorkChangeSet uowChangeSet, boolean isNew, AbstractSession session) {
        return this.createObjectChangeSet(clone, uowChangeSet, isNew, false, session);
    }

    public ObjectChangeSet createObjectChangeSet(Object clone, UnitOfWorkChangeSet uowChangeSet, boolean isNew, boolean assignPrimaryKeyIfExisting, AbstractSession session) {
        Vector primaryKey;
        ObjectChangeSet changes = (ObjectChangeSet)uowChangeSet.getObjectChangeSetForClone(clone);
        if (changes == null) {
            changes = this.getDescriptor().isAggregateDescriptor() ? new AggregateObjectChangeSet(new Vector(0), this.getDescriptor().getJavaClass(), clone, uowChangeSet, isNew) : new ObjectChangeSet(this.extractPrimaryKeyFromObject(clone, session, true), this.getDescriptor().getJavaClass(), clone, uowChangeSet, isNew);
            changes.setIsAggregate(this.getDescriptor().isAggregateDescriptor() || this.getDescriptor().isAggregateCollectionDescriptor());
            uowChangeSet.addObjectChangeSetForIdentity(changes, clone);
        } else if (assignPrimaryKeyIfExisting && !changes.isAggregate() && (primaryKey = this.extractPrimaryKeyFromObject(clone, session, true)) != null) {
            changes.setCacheKey(new CacheKey(primaryKey));
        }
        return changes;
    }

    public void createPrimaryKeyExpression(AbstractSession session) {
        Expression expression = null;
        ExpressionBuilder builder = new ExpressionBuilder();
        List<DatabaseField> primaryKeyFields = this.getDescriptor().getPrimaryKeyFields();
        for (int index = 0; index < primaryKeyFields.size(); ++index) {
            DatabaseField primaryKeyField = primaryKeyFields.get(index);
            Expression subExp1 = ((Expression)builder).getField(primaryKeyField);
            Expression subExp2 = builder.getParameter(primaryKeyField);
            Expression subExpression = subExp1.equal(subExp2);
            expression = expression == null ? subExpression : expression.and(subExpression);
        }
        this.setPrimaryKeyExpression(expression);
    }

    public Vector extractPrimaryKeyFromExpression(boolean requiresExactMatch, Expression expression, AbstractRecord translationRow, AbstractSession session) {
        AbstractRecord primaryKeyRow = this.createRecord(this.getPrimaryKeyMappings().size());
        expression.getBuilder().setSession(session.getRootSession(null));
        boolean isValid = expression.extractPrimaryKeyValues(requiresExactMatch, this.getDescriptor(), primaryKeyRow, translationRow);
        if (requiresExactMatch && !isValid) {
            return null;
        }
        if (primaryKeyRow.size() != this.getDescriptor().getPrimaryKeyFields().size()) {
            return null;
        }
        return this.extractPrimaryKeyFromRow(primaryKeyRow, session);
    }

    public Vector extractPrimaryKeyFromObject(Object domainObject, AbstractSession session) {
        return this.extractPrimaryKeyFromObject(domainObject, session, false);
    }

    public Vector extractPrimaryKeyFromObject(Object domainObject, AbstractSession session, boolean shouldReturnNullIfNull) {
        Vector key;
        boolean isPersistenceEntity = domainObject instanceof PersistenceEntity;
        if (isPersistenceEntity && (key = ((PersistenceEntity)domainObject)._persistence_getPKVector()) != null) {
            return key;
        }
        ClassDescriptor descriptor = this.getDescriptor();
        boolean isNull = false;
        if (descriptor.hasInheritance() && domainObject.getClass() != descriptor.getJavaClass() && !domainObject.getClass().getSuperclass().equals(descriptor.getJavaClass())) {
            return session.getDescriptor(domainObject).getObjectBuilder().extractPrimaryKeyFromObject(domainObject, session, shouldReturnNullIfNull);
        }
        List<DatabaseField> primaryKeyFields = descriptor.getPrimaryKeyFields();
        NonSynchronizedVector primaryKeyValues = new NonSynchronizedVector(primaryKeyFields.size());
        Vector<DatabaseMapping> mappings = this.getPrimaryKeyMappings();
        int size = mappings.size();
        if (descriptor.hasSimplePrimaryKey()) {
            for (int index = 0; index < size; ++index) {
                AbstractDirectMapping mapping = (AbstractDirectMapping)mappings.get(index);
                Object keyValue = mapping.valueFromObject(domainObject, primaryKeyFields.get(index), session);
                if (keyValue == null) {
                    if (shouldReturnNullIfNull) {
                        return null;
                    }
                    isNull = true;
                }
                ((Vector)primaryKeyValues).add(keyValue);
            }
        } else {
            AbstractRecord databaseRow = this.createRecord(size);
            for (int index = 0; index < size; ++index) {
                DatabaseMapping mapping = (DatabaseMapping)mappings.get(index);
                if (mapping == null) continue;
                mapping.writeFromObjectIntoRow(domainObject, databaseRow, session);
            }
            Vector<Class> primaryKeyClassifications = this.getPrimaryKeyClassifications();
            Platform platform = session.getPlatform(domainObject.getClass());
            for (int index = 0; index < size; ++index) {
                Class classification = (Class)primaryKeyClassifications.get(index);
                Object value = databaseRow.get(primaryKeyFields.get(index));
                if (value == null) {
                    if (shouldReturnNullIfNull) {
                        return null;
                    }
                    isNull = true;
                }
                ((Vector)primaryKeyValues).add(platform.convertObject(value, classification));
            }
        }
        if (isPersistenceEntity && !isNull) {
            ((PersistenceEntity)domainObject)._persistence_setPKVector(primaryKeyValues);
        }
        return primaryKeyValues;
    }

    public Vector extractPrimaryKeyFromRow(AbstractRecord databaseRow, AbstractSession session) {
        List<DatabaseField> primaryKeyFields = this.getDescriptor().getPrimaryKeyFields();
        Vector<Class> primaryKeyClassifications = this.getPrimaryKeyClassifications();
        int size = primaryKeyFields.size();
        NonSynchronizedVector primaryKeyValues = new NonSynchronizedVector(size);
        for (int index = 0; index < size; ++index) {
            DatabaseField field = primaryKeyFields.get(index);
            Class classification = primaryKeyClassifications.get(index);
            Object value = databaseRow.get(field);
            if (value != null) {
                if (value.getClass() != classification) {
                    value = session.getPlatform(this.getDescriptor().getJavaClass()).convertObject(value, classification);
                }
            } else {
                return null;
            }
            ((Vector)primaryKeyValues).addElement(value);
        }
        return primaryKeyValues;
    }

    public AbstractRecord extractPrimaryKeyRowFromExpression(Expression expression, AbstractRecord translationRow, AbstractSession session) {
        AbstractRecord primaryKeyRow = this.createRecord(this.getPrimaryKeyMappings().size());
        expression.getBuilder().setSession(session.getRootSession(null));
        boolean isValid = expression.extractPrimaryKeyValues(true, this.getDescriptor(), primaryKeyRow, translationRow);
        if (!isValid) {
            return null;
        }
        if (primaryKeyRow.size() != this.getDescriptor().getPrimaryKeyFields().size()) {
            return null;
        }
        return primaryKeyRow;
    }

    public AbstractRecord extractPrimaryKeyRowFromObject(Object domainObject, AbstractSession session) {
        AbstractRecord databaseRow = this.createRecord(this.getPrimaryKeyMappings().size());
        for (int index = 0; index < this.getPrimaryKeyMappings().size(); ++index) {
            this.getPrimaryKeyMappings().get(index).writeFromObjectIntoRow(domainObject, databaseRow, session);
        }
        if (this.getDescriptor().hasSimplePrimaryKey()) {
            return databaseRow;
        }
        AbstractRecord primaryKeyRow = this.createRecord(this.getPrimaryKeyMappings().size());
        List<DatabaseField> primaryKeyFields = this.getDescriptor().getPrimaryKeyFields();
        for (int index = 0; index < primaryKeyFields.size(); ++index) {
            Class classification = this.getPrimaryKeyClassifications().get(index);
            DatabaseField field = primaryKeyFields.get(index);
            Object value = databaseRow.get(field);
            primaryKeyRow.put(field, session.getPlatform(domainObject.getClass()).convertObject(value, classification));
        }
        return primaryKeyRow;
    }

    public Object extractValueFromObjectForField(Object domainObject, DatabaseField field, AbstractSession session) throws DescriptorException {
        ClassDescriptor descriptor = null;
        if (this.getDescriptor().hasInheritance() && domainObject.getClass() != this.getDescriptor().getJavaClass() && (descriptor = session.getDescriptor(domainObject)).getJavaClass() != this.getDescriptor().getJavaClass()) {
            return descriptor.getObjectBuilder().extractValueFromObjectForField(domainObject, field, session);
        }
        DatabaseMapping mapping = this.getMappingForField(field);
        if (mapping == null) {
            throw DescriptorException.missingMappingForField(field, this.getDescriptor());
        }
        return mapping.valueFromObject(domainObject, field, session);
    }

    public void fixObjectReferences(Object object, Map objectDescriptors, Map processedObjects, ObjectLevelReadQuery query, RemoteSession session) {
        Vector<DatabaseMapping> mappings = this.getDescriptor().getMappings();
        for (int index = 0; index < mappings.size(); ++index) {
            mappings.get(index).fixObjectReferences(object, objectDescriptors, processedObjects, query, session);
        }
    }

    public DatabaseMapping getBaseMappingForField(DatabaseField databaseField) {
        DatabaseMapping mapping = this.getMappingForField(databaseField);
        while (mapping.isAggregateObjectMapping()) {
            mapping = ((AggregateObjectMapping)mapping).getReferenceDescriptor().getObjectBuilder().getMappingForField(databaseField);
        }
        return mapping;
    }

    public Object getBaseValueForField(DatabaseField databaseField, Object domainObject) {
        Object valueIntoObject = domainObject;
        DatabaseMapping mapping = this.getMappingForField(databaseField);
        while (mapping.isAggregateObjectMapping()) {
            valueIntoObject = mapping.getAttributeValueFromObject(valueIntoObject);
            mapping = ((AggregateMapping)mapping).getReferenceDescriptor().getObjectBuilder().getMappingForField(databaseField);
        }
        return mapping.getAttributeValueFromObject(valueIntoObject);
    }

    public ClassDescriptor getDescriptor() {
        return this.descriptor;
    }

    public Class getFieldClassification(DatabaseField fieldToClassify) throws DescriptorException {
        DatabaseMapping mapping = this.getMappingForField(fieldToClassify);
        if (mapping == null) {
            return null;
        }
        return mapping.getFieldClassification(fieldToClassify);
    }

    public DatabaseField getFieldForQueryKeyName(String name) {
        QueryKey key = this.getDescriptor().getQueryKeyNamed(name);
        if (key == null) {
            DatabaseMapping mapping = this.getMappingForAttributeName(name);
            if (mapping == null) {
                return null;
            }
            if (mapping.getFields().isEmpty()) {
                return null;
            }
            return mapping.getFields().get(0);
        }
        if (key.isDirectQueryKey()) {
            return ((DirectQueryKey)key).getField();
        }
        return null;
    }

    public Map getFieldsMap() {
        return this.fieldsMap;
    }

    protected void setFieldsMap(Map fieldsMap) {
        this.fieldsMap = fieldsMap;
    }

    public List getCloningMappings() {
        return this.cloningMappings;
    }

    public Vector<DatabaseMapping> getJoinedAttributes() {
        return this.joinedAttributes;
    }

    public boolean hasJoinedAttributes() {
        return this.joinedAttributes != null;
    }

    public DatabaseMapping getMappingForAttributeName(String name) {
        return this.getMappingsByAttribute().get(name);
    }

    public DatabaseMapping getMappingForField(DatabaseField field) {
        return this.getMappingsByField().get(field);
    }

    public Vector<DatabaseMapping> getReadOnlyMappingsForField(DatabaseField field) {
        return this.getReadOnlyMappingsByField().get(field);
    }

    protected Map<String, DatabaseMapping> getMappingsByAttribute() {
        return this.mappingsByAttribute;
    }

    public Map<DatabaseField, DatabaseMapping> getMappingsByField() {
        return this.mappingsByField;
    }

    public Map<DatabaseField, Vector<DatabaseMapping>> getReadOnlyMappingsByField() {
        return this.readOnlyMappingsByField;
    }

    protected Vector<DatabaseMapping> getNonPrimaryKeyMappings() {
        return this.nonPrimaryKeyMappings;
    }

    public Object getParentObjectForField(DatabaseField databaseField, Object domainObject) {
        Object valueIntoObject = domainObject;
        DatabaseMapping mapping = this.getMappingForField(databaseField);
        while (mapping.isAggregateObjectMapping()) {
            valueIntoObject = mapping.getAttributeValueFromObject(valueIntoObject);
            mapping = ((AggregateMapping)mapping).getReferenceDescriptor().getObjectBuilder().getMappingForField(databaseField);
        }
        return valueIntoObject;
    }

    public Vector<Class> getPrimaryKeyClassifications() {
        if (this.primaryKeyClassifications == null) {
            List<DatabaseField> primaryKeyFields = this.getDescriptor().getPrimaryKeyFields();
            NonSynchronizedVector classifications = NonSynchronizedVector.newInstance(primaryKeyFields.size());
            for (int index = 0; index < primaryKeyFields.size(); ++index) {
                DatabaseMapping mapping = this.getPrimaryKeyMappings().get(index);
                DatabaseField field = primaryKeyFields.get(index);
                if (mapping != null) {
                    ((Vector)classifications).add(Helper.getObjectClass(mapping.getFieldClassification(field)));
                } else {
                    ((Vector)classifications).add(null);
                }
                this.primaryKeyClassifications = classifications;
            }
        }
        return this.primaryKeyClassifications;
    }

    public Expression getPrimaryKeyExpression() {
        return this.primaryKeyExpression;
    }

    public Vector<DatabaseMapping> getPrimaryKeyMappings() {
        return this.primaryKeyMappings;
    }

    public DatabaseField getTargetFieldForQueryKeyName(String queryKeyName) {
        DatabaseMapping mapping = this.getMappingForAttributeName(queryKeyName);
        if (mapping != null && mapping.isDirectToFieldMapping()) {
            return ((AbstractDirectMapping)mapping).getField();
        }
        QueryKey queryKey = this.getDescriptor().getQueryKeyNamed(queryKeyName);
        if (queryKey != null && queryKey.isDirectQueryKey()) {
            return ((DirectQueryKey)queryKey).getField();
        }
        return null;
    }

    public void initialize(AbstractSession session) throws DescriptorException {
        this.getMappingsByField().clear();
        this.getReadOnlyMappingsByField().clear();
        this.getMappingsByAttribute().clear();
        this.getCloningMappings().clear();
        Enumeration<DatabaseMapping> mappings = this.getDescriptor().getMappings().elements();
        while (mappings.hasMoreElements()) {
            DatabaseMapping mapping = mappings.nextElement();
            if (!mapping.isWriteOnly()) {
                this.getMappingsByAttribute().put(mapping.getAttributeName(), mapping);
            }
            if (mapping.isCloningRequired()) {
                this.getCloningMappings().add(mapping);
            }
            for (DatabaseField field : mapping.getFields()) {
                if (mapping.isReadOnly()) {
                    NonSynchronizedVector mappingVector = this.getReadOnlyMappingsByField().get(field);
                    if (mappingVector == null) {
                        mappingVector = NonSynchronizedVector.newInstance();
                        this.getReadOnlyMappingsByField().put(field, mappingVector);
                    }
                    ((Vector)mappingVector).add(mapping);
                    continue;
                }
                if (mapping.isAggregateObjectMapping()) {
                    ObjectBuilder aggregateObjectBuilder = ((AggregateObjectMapping)mapping).getReferenceDescriptor().getObjectBuilder();
                    DatabaseMapping aggregatedFieldMapping = aggregateObjectBuilder.getMappingForField(field);
                    if (aggregatedFieldMapping == null) {
                        NonSynchronizedVector mappingVector = this.getReadOnlyMappingsByField().get(field);
                        if (mappingVector == null) {
                            mappingVector = NonSynchronizedVector.newInstance();
                            this.getReadOnlyMappingsByField().put(field, mappingVector);
                        }
                        ((Vector)mappingVector).add(mapping);
                        continue;
                    }
                    this.getMappingsByField().put(field, mapping);
                    continue;
                }
                if (this.getMappingsByField().containsKey(field)) {
                    session.getIntegrityChecker().handleError(DescriptorException.multipleWriteMappingsForField(field.toString(), mapping));
                    continue;
                }
                this.getMappingsByField().put(field, mapping);
            }
        }
        this.initializePrimaryKey(session);
        this.initializeJoinedAttributes();
    }

    public void initializeJoinedAttributes() {
        NonSynchronizedVector joinedAttributes = null;
        Vector<DatabaseMapping> mappings = this.getDescriptor().getMappings();
        for (int i = 0; i < mappings.size(); ++i) {
            DatabaseMapping mapping = mappings.get(i);
            if (!mapping.isForeignReferenceMapping() || !((ForeignReferenceMapping)mapping).isJoinFetched()) continue;
            if (joinedAttributes == null) {
                joinedAttributes = NonSynchronizedVector.newInstance();
            }
            ((Vector)joinedAttributes).add(mapping);
        }
        this.joinedAttributes = joinedAttributes;
    }

    protected void copyQueryInfoToCacheKey(CacheKey cacheKey, ObjectBuildingQuery query, AbstractRecord databaseRow, AbstractSession session, ClassDescriptor concreteDescriptor) {
        cacheKey.setLastUpdatedQueryId(query.getQueryId());
        if (concreteDescriptor.usesOptimisticLocking()) {
            OptimisticLockingPolicy policy = concreteDescriptor.getOptimisticLockingPolicy();
            Object cacheValue = policy.getValueToPutInCache(databaseRow, session);
            cacheKey.setWriteLockValue(cacheValue);
        }
        cacheKey.setReadTime(query.getExecutionTime());
    }

    public void initializePrimaryKey(AbstractSession session) throws DescriptorException {
        DatabaseMapping mapping;
        this.createPrimaryKeyExpression(session);
        List<DatabaseField> primaryKeyfields = this.getDescriptor().getPrimaryKeyFields();
        this.getPrimaryKeyMappings().clear();
        this.getNonPrimaryKeyMappings().clear();
        for (DatabaseField field : this.getMappingsByField().keySet()) {
            if (primaryKeyfields.contains(field)) continue;
            DatabaseMapping mapping2 = this.getMappingForField(field);
            if (this.getNonPrimaryKeyMappings().contains(mapping2)) continue;
            this.getNonPrimaryKeyMappings().addElement(mapping2);
        }
        List<DatabaseField> primaryKeyFields = this.getDescriptor().getPrimaryKeyFields();
        for (int index = 0; index < primaryKeyFields.size(); ++index) {
            DatabaseField primaryKeyField = primaryKeyFields.get(index);
            mapping = this.getMappingForField(primaryKeyField);
            if (mapping == null && !this.getDescriptor().isAggregateDescriptor() && !this.getDescriptor().isAggregateCollectionDescriptor()) {
                throw DescriptorException.noMappingForPrimaryKey(primaryKeyField, this.getDescriptor());
            }
            this.getPrimaryKeyMappings().addElement(mapping);
            if (mapping != null) {
                mapping.setIsPrimaryKeyMapping(true);
            }
            if (!this.getDescriptor().hasMultipleTables() || mapping == null) continue;
            for (Map<DatabaseField, DatabaseField> keyMapping : this.getDescriptor().getAdditionalTablePrimaryKeyFields().values()) {
                DatabaseField secondaryField = keyMapping.get(primaryKeyField);
                if (secondaryField == null) continue;
                this.getMappingsByField().put(secondaryField, mapping);
                if (!mapping.isAggregateObjectMapping()) continue;
                ((AggregateObjectMapping)mapping).addPrimaryKeyJoinField(primaryKeyField, secondaryField);
            }
        }
        boolean hasSimplePrimaryKey = true;
        for (int index = 0; index < this.getPrimaryKeyMappings().size(); ++index) {
            mapping = this.getPrimaryKeyMappings().get(index);
            if (mapping != null && mapping.isDirectToFieldMapping()) continue;
            hasSimplePrimaryKey = false;
            break;
        }
        this.getDescriptor().setHasSimplePrimaryKey(hasSimplePrimaryKey);
    }

    public Object instantiateClone(Object domainObject, AbstractSession session) {
        return this.getDescriptor().getCopyPolicy().buildClone(domainObject, session);
    }

    public Object instantiateWorkingCopyClone(Object domainObject, AbstractSession session) {
        return this.getDescriptor().getCopyPolicy().buildWorkingCopyClone(domainObject, session);
    }

    public Object instantiateWorkingCopyCloneFromRow(AbstractRecord row, ObjectBuildingQuery query, Vector primaryKey, UnitOfWorkImpl unitOfWork) {
        return this.getDescriptor().getCopyPolicy().buildWorkingCopyCloneFromRow(row, query, primaryKey, unitOfWork);
    }

    public boolean isPrimaryKeyMapping(DatabaseMapping mapping) {
        return this.getPrimaryKeyMappings().contains(mapping);
    }

    public void iterate(DescriptorIterator iterator) {
        Vector<DatabaseMapping> mappings = this.getDescriptor().getMappings();
        int mappingsSize = mappings.size();
        for (int index = 0; index < mappingsSize; ++index) {
            mappings.get(index).iterate(iterator);
        }
    }

    public void mergeChangesIntoObject(Object target, ObjectChangeSet changeSet, Object source, MergeManager mergeManager) {
        Enumeration changes = changeSet.getChanges().elements();
        while (changes.hasMoreElements()) {
            ChangeRecord record = (ChangeRecord)changes.nextElement();
            DatabaseMapping mapping = this.getMappingForAttributeName(record.getAttribute());
            mapping.mergeChangesIntoObject(target, record, source, mergeManager);
        }
        if (this.getDescriptor().getEventManager().hasAnyEventListeners()) {
            DescriptorEvent event = new DescriptorEvent(target);
            event.setSession(mergeManager.getSession());
            event.setOriginalObject(source);
            event.setChangeSet(changeSet);
            event.setEventCode(11);
            this.getDescriptor().getEventManager().executeEvent(event);
        }
    }

    public void mergeIntoObject(Object target, boolean isUnInitialized, Object source, MergeManager mergeManager) {
        this.mergeIntoObject(target, isUnInitialized, source, mergeManager, false);
    }

    public void mergeIntoObject(Object target, boolean isUnInitialized, Object source, MergeManager mergeManager, boolean cascadeOnly) {
        Vector<DatabaseMapping> mappings = this.getDescriptor().getMappings();
        for (int index = 0; index < mappings.size(); ++index) {
            DatabaseMapping mapping = mappings.get(index);
            if (cascadeOnly && !mapping.isForeignReferenceMapping()) continue;
            mapping.mergeIntoObject(target, isUnInitialized, source, mergeManager);
        }
        if (this.getDescriptor().getEventManager().hasAnyEventListeners()) {
            DescriptorEvent event = new DescriptorEvent(target);
            event.setSession(mergeManager.getSession());
            event.setOriginalObject(source);
            event.setEventCode(11);
            this.getDescriptor().getEventManager().executeEvent(event);
        }
    }

    public void populateAttributesForClone(Object original, Object clone, UnitOfWorkImpl unitOfWork) {
        List mappings = this.getCloningMappings();
        int size = mappings.size();
        if (this.descriptor.hasFetchGroupManager() && this.descriptor.getFetchGroupManager().isPartialObject(original)) {
            FetchGroupManager fetchGroupManager = this.descriptor.getFetchGroupManager();
            for (int index = 0; index < size; ++index) {
                DatabaseMapping mapping = (DatabaseMapping)mappings.get(index);
                if (!fetchGroupManager.isAttributeFetched(original, mapping.getAttributeName())) continue;
                mapping.buildClone(original, clone, unitOfWork);
            }
        } else {
            for (int index = 0; index < size; ++index) {
                ((DatabaseMapping)mappings.get(index)).buildClone(original, clone, unitOfWork);
            }
        }
        if (this.descriptor.hasCMPPolicy()) {
            this.descriptor.getCMPPolicy().invokeEJBLoad(clone, unitOfWork);
        }
        if (this.descriptor.getEventManager().hasAnyEventListeners()) {
            DescriptorEvent event = new DescriptorEvent(clone);
            event.setSession(unitOfWork);
            event.setOriginalObject(original);
            event.setEventCode(10);
            this.descriptor.getEventManager().executeEvent(event);
        }
    }

    public void rehashFieldDependancies(AbstractSession session) {
        this.setMappingsByField(Helper.rehashMap(this.getMappingsByField()));
        this.setReadOnlyMappingsByField(Helper.rehashMap(this.getReadOnlyMappingsByField()));
        this.setFieldsMap(Helper.rehashMap(this.getFieldsMap()));
        this.setPrimaryKeyMappings(NonSynchronizedVector.newInstance(2));
        this.setNonPrimaryKeyMappings(NonSynchronizedVector.newInstance(2));
        this.initializePrimaryKey(session);
    }

    public void setDescriptor(ClassDescriptor aDescriptor) {
        this.descriptor = aDescriptor;
    }

    protected void setMappingsByAttribute(Map<String, DatabaseMapping> theAttributeMappings) {
        this.mappingsByAttribute = theAttributeMappings;
    }

    public void setMappingsByField(Map<DatabaseField, DatabaseMapping> theFieldMappings) {
        this.mappingsByField = theFieldMappings;
    }

    public void setReadOnlyMappingsByField(Map<DatabaseField, Vector<DatabaseMapping>> theReadOnlyFieldMappings) {
        this.readOnlyMappingsByField = theReadOnlyFieldMappings;
    }

    protected void setNonPrimaryKeyMappings(Vector<DatabaseMapping> theNonPrimaryKeyMappings) {
        this.nonPrimaryKeyMappings = theNonPrimaryKeyMappings;
    }

    protected void setPrimaryKeyClassifications(Vector<Class> primaryKeyClassifications) {
        this.primaryKeyClassifications = primaryKeyClassifications;
    }

    public void setPrimaryKeyExpression(Expression criteria) {
        this.primaryKeyExpression = criteria;
    }

    protected void setPrimaryKeyMappings(Vector<DatabaseMapping> thePrimaryKeyMappings) {
        this.primaryKeyMappings = thePrimaryKeyMappings;
    }

    public String toString() {
        return Helper.getShortClassName(this.getClass()) + "(" + this.getDescriptor().toString() + ")";
    }

    public Object unwrapObject(Object proxy, AbstractSession session) {
        ClassDescriptor descriptor;
        if (proxy == null) {
            return null;
        }
        if (!this.descriptor.hasWrapperPolicy() || this.descriptor.getJavaClass() == proxy.getClass() || !this.descriptor.getWrapperPolicy().isWrapped(proxy)) {
            if (session.getProject().hasProxyIndirection()) {
                return ProxyIndirectionPolicy.getValueFromProxy(proxy);
            }
            return proxy;
        }
        if (this.descriptor.hasInheritance() && this.descriptor.getInheritancePolicy().hasChildren() && (descriptor = session.getDescriptor(proxy)) != this.descriptor) {
            return descriptor.getObjectBuilder().unwrapObject(proxy, session);
        }
        return this.descriptor.getWrapperPolicy().unwrapObject(proxy, session);
    }

    public void validate(AbstractSession session) throws DescriptorException {
        if (this.getDescriptor().usesSequenceNumbers() && this.getMappingForField(this.getDescriptor().getSequenceNumberField()) == null) {
            throw DescriptorException.mappingForSequenceNumberField(this.getDescriptor());
        }
    }

    public boolean verifyDelete(Object object, AbstractSession session) {
        AbstractRecord translationRow = this.buildRowForTranslation(object, session);
        if (this.getDescriptor().getQueryManager().getReadObjectQuery() != null && this.getDescriptor().getQueryManager().getReadObjectQuery().isCallQuery()) {
            Object result = session.readObject(object);
            if (result != null) {
                return false;
            }
        } else {
            Enumeration<DatabaseTable> tables = this.getDescriptor().getTables().elements();
            while (tables.hasMoreElements()) {
                DatabaseTable table = tables.nextElement();
                SQLSelectStatement sqlStatement = new SQLSelectStatement();
                sqlStatement.addTable(table);
                if (table == this.getDescriptor().getTables().firstElement()) {
                    sqlStatement.setWhereClause((Expression)this.getPrimaryKeyExpression().clone());
                } else {
                    sqlStatement.setWhereClause(this.buildPrimaryKeyExpression(table));
                }
                DatabaseField all = new DatabaseField("*");
                all.setTable(table);
                sqlStatement.addField(all);
                sqlStatement.normalize(session, null);
                DataReadQuery dataReadQuery = new DataReadQuery();
                dataReadQuery.setSQLStatement(sqlStatement);
                dataReadQuery.setSessionName(this.getDescriptor().getSessionName());
                Vector queryResults = (Vector)session.executeQuery((DatabaseQuery)dataReadQuery, translationRow);
                if (queryResults.isEmpty()) continue;
                return false;
            }
        }
        Enumeration<DatabaseMapping> mappings = this.getDescriptor().getMappings().elements();
        while (mappings.hasMoreElements()) {
            DatabaseMapping mapping = mappings.nextElement();
            if (mapping.verifyDelete(object, session)) continue;
            return false;
        }
        return true;
    }

    public Object wrapObject(Object implementation, AbstractSession session) {
        ClassDescriptor descriptor;
        if (implementation == null) {
            return null;
        }
        if (!this.descriptor.hasWrapperPolicy() || this.descriptor.getWrapperPolicy().isWrapped(implementation)) {
            return implementation;
        }
        if (this.descriptor.hasInheritance() && this.descriptor.getInheritancePolicy().hasChildren() && implementation.getClass() != this.descriptor.getJavaClass() && (descriptor = session.getDescriptor(implementation)) != this.descriptor) {
            return descriptor.getObjectBuilder().wrapObject(implementation, session);
        }
        return this.descriptor.getWrapperPolicy().wrapObject(implementation, session);
    }
}

