/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.descriptors;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.exceptions.DescriptorException;
import org.eclipse.persistence.exceptions.QueryException;
import org.eclipse.persistence.internal.helper.ClassConstants;
import org.eclipse.persistence.internal.helper.DatabaseField;
import org.eclipse.persistence.internal.helper.Helper;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.internal.sessions.UnitOfWorkImpl;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.queries.FetchGroup;
import org.eclipse.persistence.queries.FetchGroupTracker;
import org.eclipse.persistence.queries.ObjectLevelReadQuery;
import org.eclipse.persistence.queries.ReadObjectQuery;

public class FetchGroupManager
implements Cloneable {
    private Map fetchGroups = null;
    private FetchGroup defaultFetchGroup;
    private ClassDescriptor descriptor;

    public static void loadUnfetchedObject(Object object) {
        ReadObjectQuery query = new ReadObjectQuery(object);
        query.setShouldUseDefaultFetchGroup(false);
        ((FetchGroupTracker)object)._persistence_getSession().executeQuery(query);
    }

    public void addFetchGroup(FetchGroup group) {
        this.getFetchGroups().put(group.getName(), group);
    }

    public Map getFetchGroups() {
        if (this.fetchGroups == null) {
            this.fetchGroups = new HashMap(2);
        }
        return this.fetchGroups;
    }

    public FetchGroup getDefaultFetchGroup() {
        return this.defaultFetchGroup;
    }

    public FetchGroup getFetchGroup(String groupName) {
        return (FetchGroup)this.getFetchGroups().get(groupName);
    }

    public void setDefaultFetchGroup(FetchGroup newDefaultFetchGroup) {
        this.defaultFetchGroup = newDefaultFetchGroup;
    }

    public boolean isPartialObject(Object domainObject) {
        if (domainObject != null) {
            FetchGroup fetchGroupInCache = ((FetchGroupTracker)domainObject)._persistence_getFetchGroup();
            return fetchGroupInCache != null;
        }
        return false;
    }

    public boolean isObjectValidForFetchGroup(Object object, FetchGroup fetchGroup) {
        FetchGroup groupInObject = ((FetchGroupTracker)object)._persistence_getFetchGroup();
        return groupInObject == null || groupInObject.isSupersetOf(fetchGroup);
    }

    public boolean shouldWriteInto(Object cachedObject, Object clone) {
        if (this.isPartialObject(clone)) {
            FetchGroup fetchGroupInSrc = ((FetchGroupTracker)cachedObject)._persistence_getFetchGroup();
            FetchGroup fetchGroupInTarg = ((FetchGroupTracker)clone)._persistence_getFetchGroup();
            return fetchGroupInTarg != null && !fetchGroupInTarg.isSupersetOf(fetchGroupInSrc) || ((FetchGroupTracker)cachedObject)._persistence_shouldRefreshFetchGroup();
        }
        return false;
    }

    public void writePartialIntoClones(Object partialObject, Object workingClone, UnitOfWorkImpl uow) {
        FetchGroup fetchGroupInClone = ((FetchGroupTracker)workingClone)._persistence_getFetchGroup();
        FetchGroup fetchGroupInObject = ((FetchGroupTracker)partialObject)._persistence_getFetchGroup();
        Object backupClone = uow.getBackupClone(workingClone);
        FetchGroup union = this.unionFetchGroups(fetchGroupInObject, fetchGroupInClone);
        this.setObjectFetchGroup(workingClone, union, uow);
        if (workingClone != backupClone) {
            this.setObjectFetchGroup(backupClone, union, uow);
        }
        if (((FetchGroupTracker)partialObject)._persistence_shouldRefreshFetchGroup()) {
            this.refreshFetchGroupIntoClones(partialObject, workingClone, backupClone, fetchGroupInObject, fetchGroupInClone, uow);
        } else {
            this.revertDataIntoUnfetchedAttributesOfClones(partialObject, workingClone, backupClone, fetchGroupInObject, fetchGroupInClone, uow);
        }
    }

    private void refreshFetchGroupIntoClones(Object cachedObject, Object workingClone, Object backupClone, FetchGroup fetchGroupInObject, FetchGroup fetchGroupInClone, UnitOfWorkImpl uow) {
        Vector<DatabaseMapping> mappings = this.descriptor.getMappings();
        boolean isObjectPartial = fetchGroupInObject != null;
        Set fetchedAttributes = isObjectPartial ? fetchGroupInObject.getAttributes() : null;
        int size = mappings.size();
        for (int index = 0; index < size; ++index) {
            DatabaseMapping mapping = mappings.get(index);
            if (isObjectPartial && (fetchedAttributes == null || !fetchedAttributes.contains(mapping.getAttributeName()))) continue;
            mapping.buildClone(cachedObject, workingClone, uow);
            if (workingClone == backupClone) continue;
            mapping.buildClone(workingClone, backupClone, uow);
        }
    }

    private void revertDataIntoUnfetchedAttributesOfClones(Object cachedObject, Object workingClone, Object backupClone, FetchGroup fetchGroupInObject, FetchGroup fetchGroupInClone, UnitOfWorkImpl uow) {
        Vector<DatabaseMapping> mappings = this.descriptor.getMappings();
        Set fetchedAttributesClone = fetchGroupInClone.getAttributes();
        Set fetchedAttributesCached = null;
        if (fetchGroupInObject != null) {
            fetchedAttributesCached = fetchGroupInObject.getAttributes();
        }
        int size = mappings.size();
        for (int index = 0; index < size; ++index) {
            DatabaseMapping mapping = mappings.get(index);
            String attributeName = mapping.getAttributeName();
            if (fetchedAttributesCached != null && !fetchedAttributesCached.contains(attributeName) || fetchedAttributesClone.contains(attributeName)) continue;
            mapping.buildClone(cachedObject, workingClone, uow);
            if (workingClone == backupClone) continue;
            mapping.buildClone(workingClone, backupClone, uow);
        }
    }

    public void copyFetchGroupInto(Object source, Object target, AbstractSession session) {
        if (this.isPartialObject(source)) {
            this.setObjectFetchGroup(target, ((FetchGroupTracker)source)._persistence_getFetchGroup(), session);
        }
    }

    public void unionFetchGroupIntoObject(Object source, FetchGroup newFetchGroup, AbstractSession session) {
        this.setObjectFetchGroup(source, this.unionFetchGroups(((FetchGroupTracker)source)._persistence_getFetchGroup(), newFetchGroup), session);
    }

    public FetchGroup unionFetchGroups(FetchGroup first, FetchGroup second) {
        if (first == null || second == null) {
            return null;
        }
        if (first.isSupersetOf(second)) {
            return first;
        }
        if (second.isSupersetOf(first)) {
            return second;
        }
        StringBuffer unionGroupName = new StringBuffer(first.getName());
        unionGroupName.append("_");
        unionGroupName.append(second.getName());
        FetchGroup unionFetchGroup = new FetchGroup(unionGroupName.toString());
        unionFetchGroup.addAttributes(first.getAttributes());
        unionFetchGroup.addAttributes(second.getAttributes());
        return unionFetchGroup;
    }

    public void reset(Object source) {
        ((FetchGroupTracker)source)._persistence_resetFetchGroup();
    }

    public void setObjectFetchGroup(Object source, FetchGroup fetchGroup, AbstractSession session) {
        FetchGroupTracker tracker = (FetchGroupTracker)source;
        tracker._persistence_setFetchGroup(fetchGroup);
        tracker._persistence_setSession(session);
    }

    public void setRefreshOnFetchGroupToObject(Object source, boolean shouldRefreshOnFetchgroup) {
        ((FetchGroupTracker)source)._persistence_setShouldRefreshFetchGroup(shouldRefreshOnFetchgroup);
    }

    public boolean isAttributeFetched(Object object, String attributeName) {
        FetchGroup fetchgroup = ((FetchGroupTracker)object)._persistence_getFetchGroup();
        return fetchgroup == null || fetchgroup.containsAttribute(attributeName);
    }

    public ClassDescriptor getDescriptor() {
        return this.descriptor;
    }

    public ClassDescriptor getClassDescriptor() {
        return this.getDescriptor();
    }

    public void setDescriptor(ClassDescriptor descriptor) {
        this.descriptor = descriptor;
    }

    public void prepareQueryWithFetchGroup(ObjectLevelReadQuery query) {
        DatabaseMapping lockMapping;
        DatabaseField lockField;
        query.initializeFetchGroup();
        if (!query.hasFetchGroup()) {
            return;
        }
        if (query.isReportQuery()) {
            throw QueryException.fetchGroupNotSupportOnReportQuery();
        }
        if (query.hasPartialAttributeExpressions()) {
            throw QueryException.fetchGroupNotSupportOnPartialAttributeReading();
        }
        for (DatabaseMapping mapping : this.getDescriptor().getObjectBuilder().getPrimaryKeyMappings()) {
            query.getFetchGroup().addAttribute(mapping.getAttributeName());
        }
        if (query.shouldMaintainCache() && this.getDescriptor().usesOptimisticLocking() && (lockField = this.getDescriptor().getOptimisticLockingPolicy().getWriteLockField()) != null && (lockMapping = this.getDescriptor().getObjectBuilder().getMappingForField(lockField)) != null) {
            query.getFetchGroup().addAttribute(lockMapping.getAttributeName());
        }
    }

    public void initialize(AbstractSession session) throws DescriptorException {
        if (!Helper.classImplementsInterface(this.getDescriptor().getJavaClass(), ClassConstants.FetchGroupTracker_class)) {
            session.getIntegrityChecker().handleError(DescriptorException.needToImplementFetchGroupTracker(this.getDescriptor().getJavaClass(), this.getDescriptor()));
        }
        if (this.getDefaultFetchGroup() == null) {
            FetchGroup fetchGroup = new FetchGroup();
            boolean hasLazy = false;
            for (DatabaseMapping mapping : this.getDescriptor().getMappings()) {
                if (!mapping.isLazy()) {
                    fetchGroup.addAttribute(mapping.getAttributeName());
                    continue;
                }
                hasLazy = true;
            }
            if (hasLazy) {
                this.setDefaultFetchGroup(fetchGroup);
            }
        }
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (Exception exception) {
            throw new InternalError(exception.toString());
        }
    }
}

