/*******************************************************************************
 * Copyright (c) 1998, 2008 Oracle. All rights reserved.
 * This program and the accompanying materials are made available under the 
 * terms of the Eclipse Public License v1.0 and Eclipse Distribution License v. 1.0 
 * which accompanies this distribution. 
 * The Eclipse Public License is available at http://www.eclipse.org/legal/epl-v10.html
 * and the Eclipse Distribution License is available at 
 * http://www.eclipse.org/org/documents/edl-v10.php.
 *
 * Contributors:
 *     Oracle - initial API and implementation from Oracle TopLink
 ******************************************************************************/  
package org.eclipse.persistence.internal.localization.i18n;

import java.util.ListResourceBundle;
 
/**
 * English ResourceBundle for LoggingLocalization messages.
 *
 * @author Shannon Chen
 * @since TOPLink/Java 5.0
 *
 * Internal change on 2006/04/24: 
 *
 * Message id is added for iAS 11 logging compliance.
 * Every message added into this file needs the message id entry as well.
 * 
 */
public class LoggingLocalizationResource extends ListResourceBundle {
    static final Object[][] contents = {
        { "topLink_version", "EclipseLink, version: {0}" },
        { "application_server_name_and_version", "Server: {0}" },
        { "login_successful", "{0} login successful" },
        { "logout_successful", "{0} logout successful" },     

        { "connected_user_database_driver", "Connected: {0}{6}User: {1}{6}Database: {2}  Version: {3}{6}Driver: {4}  Version: {5}" },
        { "connected_user_database", "Connected: {3}{4}User: {0}{3}{4}Database: {1}  Version: {2}" },
        { "JDBC_driver_does_not_support_meta_data", "Connected: unknown (JDBC Driver does not support meta data.)" },
        { "connecting", "connecting({0})" },
        { "disconnect", "disconnect" },
        { "reconnecting", "reconnecting({0})" },
        { "connected_sdk", "Connected: SDK" },
        
        { "no_session_found", "Could not find the session with the name [{0}] in the session.xml file [{1}]" },

        { "identitymap_for", "{0}{1} for: {2}" },
        { "includes", "(includes: " },
        { "key_object_null", "{0}Key: {1}{2}Object: null" },
        { "key_identity_hash_code_object", "{0}Key: {1}{2}Identity Hash Code: {3}{2}Object: {4}" },
        { "elements", "{0}{1} elements" },
        { "unitofwork_identity_hashcode", "{0}UnitOfWork identity hashcode: {1}" },
        { "deleted_objects", "Deleted Objects:" },
        { "deleting_object", "The remove operation has been performed on: {0}"},
        { "register_new_for_persist", "PERSIST operation called on: {0}." },
        { "all_registered_clones", "All Registered Clones:" },
        { "new_objects", "New Objects:" },        

        { "failed_to_propogate_to", "CacheSynchronization : Failed to propagate to {0}.  {1}" },
        { "exception_thrown_when_attempting_to_shutdown_cache_synch", "Exception thrown when attempting to shutdown cache synch: {0}" },
        { "corrupted_session_announcement", "SessionID: {0}  Discovery manager received corrupted session announcement - ignoring." },
        { "exception_thrown_when_attempting_to_close_listening_topic_connection", "Exception thrown when attempting to close listening topic connection: {0}" },
        { "retreived_unknown_message_type", "Retreived unknown message type: {0} from topic: {1}; ignoring" },
        { "retreived_null_message", "Retreived null message from topic: {0}; ignoring" },
        { "received_unexpected_message_type", "Received unexpected message type: {0} from topic: {1}; ignoring" },
        { "problem_adding_remote_connection", "Problem adding remote connection: {0}" },        

        { "error_in_codegen", "Error during generation of concrete bean class." },
        { "error_during_PersistenceManager_setup_for_bean", "Error during PersistenceManager setup for bean: {0}" },
        { "error_in_create", "Error in create." },
        { "error_executing_ejbHome", "Error executing ejbHome: {0}" },
        { "error_in_remove", "Error in remove." },
        { "table_existed_during_creation", "Table creation failed. If it already exists, it must be dropped first. This can be done manually or by setting the db-table-gen attribute in orion-ejb-jar.xml." },
        { "an_error_occured_trying_to_undeploy_bean", "An error occurred trying to undeploy bean (after deployment failure): {0}" },
        { "an_error_occured_executing_findByPrimaryKey", "An error occurred executing findByPrimaryKey: {0}" },
        { "an_error_occured_preparing_bean", "An error occurred preparing bean for invocation: {0}" },
        { "an_error_executing_finder", "An error occurred executing finder: {0}" },
        { "an_error_executing_ejbSelect", "An error occurred executing ejbSelect: {0}" },
        { "ejbSelect2", "EjbSelect: {0}" },
        { "error_getting_transaction_status", "Error getting transaction status.  {0}" },
        { "removeEJB_return", "removeEJB return: {0}" },
        { "multiple_ds_not_supported", "EclipseLink CMP does not support multiple datasources, and will only use one of them named ({0}), which is specified in the orion-ejb-jar.xml, and being associated with an entity bean defined last in the corresponding ejb-jar.xml." },
        { "failed_to_find_mbean_server", "Failed to find MBean Server: {0}" },
        { "problem_while_registering", "Problem while registering: {0}" },
        { "objectchangepolicy_turned_off", "Change tracking turned off for: {0}" },
        { "External_transaction_controller_not_defined_by_server_platform", "The DatabaseSession has an external transaction controller defined " + "by something other than the ServerPlatform. EclipseLink will permit the " + "override of the external transaction controller, but we recommend " + "you consider the alternative of subclassing " + "org.eclipse.persistence.platform.server.ServerPlatformBase " + "and override getExternalTransactionControllerClass()." },        

        { "extra_cmp_field", "There is an abstract getter and/or setter defined on the [{0}] " + "abstract bean class but the corresponding cmp field [{1}] " + "is not declared in the ejb-jar.xml." },
        { "extra_ejb_select", "There is an abstract ejbSelect defined on the [{0}] " + "abstract bean class but the corresponding ejbSelect [{1}{2}] " + "entry is not declared in the ejb-jar.xml." },
        { "extra_finder", "There is a finder defined on the [{0}] " + "home interface(s) but the corresponding finder [{1}{2}] " + "entry is not declared in the ejb-jar.xml." },
        { "cmp_and_cmr_field", "The ejb-jar.xml entry for [{0}] contains both a <cmp-field> and <cmr-field> entry for the attribute [{1}].  The <cmp-field> entry will be ignored." },        

        { "toplink_cmp_bean_name_xml_deprecated", "Support for toplink-cmp-bean_name.xml is deprecated." + "Please refer to the documentation for the use of toplink-ejb-jar.xml" },        

        { "drop_connection_on_error", "Warning: Dropping remote command connection to {0} on error {1}" },
        { "received_corrupt_announcement", "Warning: Discovery manager could not process service announcement due to {0} - ignoring announcement" },
        { "missing_converter", "Warning: Cannot convert command {0} due to missing CommandConverter - ignoring command" },
        { "failed_command_propagation", "Error: Failed trying to propagate command to {0} due to {1}" },
        { "exception_thrown_when_attempting_to_close_connection", "Warning: exception thrown when attempting to close connection" },
        { "error_executing_remote_command", "{0} command failed due to: {1}" },
        { "problem_adding_connection", "Could not add remote connection from {0} due to error: {1}" },
        { "problem_reconnect_to_jms", "Could not reconnect to JMS Topic name {0} due to error: {1}" },        

        { "toplink_severe", "[EPS Severe]: " },
        { "toplink_warning", "[EPS Warning]: " },
        { "toplink_info", "[EPS Info]: " },
        { "toplink_config", "[EPS Config]: " },
        { "toplink_fine", "[EPS Fine]: " },
        { "toplink_finer", "[EPS Finer]: " },
        { "toplink_finest", "[EPS Finest]: " },
        { "toplink", "[EPS]: " },
        { "an_error_occured_initializing_dms_listener", "Exception thrown when initializing DMS embedded listener and the SPY Servlet" },       

        { "input_minimum_arguments", "The command line input arguments must at least include -s, -a or -x, and -o." },
        { "src_pm_name_first_argument", "You must specify the source PM name at the first input argument as either: -sOc4j-native or -sWeblogic." },
        { "oc4j_native_migration_start", "OC4J-Native CMP -> OC4J EclipseLink CMP Migration STARTS......" },
        { "validate_ejb_jar", "Validating ejb-jar.xml starts, it may take some times..."},
        { "weblogic_native_migration_start", "WebLogic-Native CMP -> OC4J EclipseLink CMP Migration STARTS......" },
        { "must_define_migration_output_dir", "You must define an output directory for the migration tool" },
        { "migration_output_dir_not_valid", "The output directory ({0}) you defined is not valid" },
        { "migration_input_dir_not_valid", "The input directory ({0}) you defined is not valid" },
        { "input_and_output_dir_be_different", "You must define an output directory different from the input directory." },
        { "input_archive_format_not_supported", "Migration utility supports .ear and .jar and input archive format. The input file format as ({0}) is not supported." },
        { "archive_not_found_in_input", "The archive file ({0}) is not existed under input directory ({1})." },
        { "input_not_both_archive_and_xml", "You use either -e to specify the archive file name, or -x to signal that descriptor files under the input directory will be migrated, but not both." },
        { "input_at_least_either_archive_or_xml", "You use either -e to specify the migarted archive file name, or -x to signal that descriptor xml files under the input directory will be migrated, and you must specify and only specify one of them." },
        { "ejb_jar_xml_not_found_in_input", "The ejb-jar.xml is not present under input directory ({0})." },
        { "orion_ejb_jar_xml_not_found_in_input", "orion-ejb-jar.xml is not existed under input directory ({0}) you specified." },
        { "weblogic_ejb_jar_xml_not_found_in_input", "weblogic-ejb-jar.xml is not existed under input directory ({0}) you specified." },
        { "toplink_ejb_jar_xml_found_in_input", "The toplink-ejb-jar.xml is under input directory ({0}). You have to remove the toplink descriptor away from the input directory to process the migration." },
        { "migration_successful", "Migration Successful!" },
        { "migration_failed", "Migration Failed." },
        { "mw_project_generated_and_under", "The migrated EclipseLink Workbench project files are under ({0})." },
        { "log_file_under_output_dir", "There is a log file called ({0}) under output directory ({1})." },
        { "parse_ejb_jar_with_validation_fails", "Parsing ejb-jar.xml with validation fails with error ({0}). The migration tool will parse the xml file without validation."},
        { "jar_entry_not_migratable", "The jar entry ({0}) in the input EAR file ({1}) is not migratable." },
        { "jar_entry_has_been_migrated", "The native cmp descriptor file in the jar entry ({0}) from the input EAR file ({1}) has been migrated." },
        { "no_jar_entry_migratable_in_ear", "None of the jar entry in the input EAR file ({0}) is migratable." },
        { "invalid_command_line_argument", "The command line argument ({0}) is invalid" },
        { "persistence_unit_ignores_statments_cache_setting", "The statement cache cannot be enabled because no connection pool is configured." },
        { "column_size_not_migrated", "DB column size ({0}) is not migrated. See migration doc for details." },
        { "associate_using_third_table_not_migrated", "Oc4j native CMP feature -DassociateUsingThirdTable=true to map 1:m using a relation table is not migrated. You must re-map cmr field ({1}) of the entity ({0}) as one-to-many mapping through Mapping Workbench after the migration process." },
        { "delay_updates_until_commit_not_supported", "Oc4j native CMP feature 'delay-updates-until-commit' on entity({0}) is not directly supported in EclipseLink CMP. See migration doc for details." },
        { "do_select_before_insert_not_supported", "Oc4j native CMP feature 'do-select-before-insert' on entity({0}) is not directly supported in EclipseLink CMP. See migration doc for details." },
        { "no_exclusive_write_access_not_supported", "Oc4j native CMP feature 'no-exclusive-write-access' on entity({0}) is not directly supported in EclipseLink CMP. See migration doc for details." },
        { "force_update_not_supported", "Oc4j native CMP feature 'force-update' on entity({0}) is not directly supported in EclipseLink CMP. See migration doc for details." },
        { "isolation_level_not_supported", "Oc4j native CMP setting 'isolation-level' on entity({0}) is not directly supported in EclipseLink CMP. See migration doc for details." },
        { "force_update_not_supported", "Oc4j native CMP feature 'primarykey-lazy-loading' on entity({0}) is not directly supported in EclipseLink CMP. See migration doc for details." },
        { "max_instance_not_supported", "Oc4j native CMP setting 'max-instance' on entity({0}) is not directly supported in EclipseLink CMP. See migration doc for details." },
        { "max_tx_retries_not_supported", "Oc4j native CMP setting 'max-tx-retries' on entity({0}) is not directly supported in EclipseLink CMP. See migration doc for details." },
        { "min_instance_not_supported", "Oc4j native CMP setting 'min-instance' on entity({0}) is not directly supported in EclipseLink CMP. See migration doc for details."},
        { "update_all_fields_not_supported", "Oc4j native CMP feature 'update-all-fields' on entity({0}) is not directly supported in EclipseLink CMP. See migration doc for details." },
        { "validity_timeout_not_supported", "Oc4j native CMP setting 'validity-timeout' on entity({0}) is not directly supported in EclipseLink CMP. See migration doc for details." },
        { "call_timeout_not_migrated", "The call-timeout value={1} is defined in entity {0} in orion-ejb-jar.xml" + " but no persistent mappings defined in the descriptor file, therefore no migration will occur. " + " If you use EclipseLink default mapping later to generate the EclipseLink mapping descriptor, be aware that the call-timeout " + " setting will be lost as EclipseLink default mapping has no access to native descriptor file. " + " You then need to reset the call timeout mamually or through EclipseLink Mapping Workbench after default mapping generation." },
        { "optimistic_locking_not_supported", "Oc4j native CMP setting locking-mode='optimistic' on entity({0}) is not directly supported in EclipseLink CMP. See migration doc for details." },
        { "old_pessimistic_locking_not_supported", "Oc4j native CMP setting 'old-pessimistic-locking' on entity({0}) is not directly supported in EclipseLink CMP. See migration doc for details." },
        { "locking_mode_not_valid", "Locking mode({1}) on entity({0} in orion-ejb-jar.xml is not well defined and therefore not migrated." },
        { "verifiy_columns_read_locking_not_supported", "Optimistic setting 'Read' on 'verifiy-columns' in entity ({0}) is not directly supported in EclipseLink CMP. See migration doc for details." },
        { "verifiy_rows_read_locking_not_supported", "Optimistic setting 'Read' on 'verifiy-rows' in entity ({0}) is not directly supported in EclipseLink CMP. See migration doc for details.." },
        { "one_to_one_join_outer_migrated", "The one-to-one outer join defined for cmr field ({0}) of entity bean ({1}) is not directly supported in EclipseLink CMP. See migration doc for details." },
        { "bacth_update_not_supported", "The Batch update setting batch-size with value ({0}) defined on entity bean ({1}) is not directly supported in EclipseLink CMP. See migration doc for details." },
        { "data_sync_on_ejb_create_not_supported", "The data syncronization setting data-synchronization-option='ejbCreate' defined on entity bean ({0}) is not directly supported in EclipseLink CMP. See migration doc for details." },
        { "weblogic_ql_not_supported", "WebLogic-QL({0}) of the method({1} of the entity({2}) is not migrated as EclipseLink does not support WebLogic QL language." },
        { "input_orione_ejb_jar_augmented", "Input orion-ejb-jar.xml file has been augmented to specify EclipseLink as OC4J's Persistent Manager" },
        { "template_orion_ejb_jar_created", "A templated orion-ejb-jar.xml file has been created" },
        { "create_default_dbms_tables_not_supported", "WLS native CMP setting 'create-default-dbms-tables' is not directly supported in EclipseLink CMP. See migration doc for details." },
        { "default_dbms_tables_ddl_not_supported", "WLS native CMP setting 'default-dbms-tables-ddl' is not directly supported in EclipseLink CMP. See migration doc for details." },
        { "enable_batch_operations_as_true_not_supported", "WLS native CMP setting 'enable-batch-operations-as-true' is not directly supported in EclipseLink CMP. See migration doc for details." },
        { "validate_db_schema_with_not_supported", "WLS native CMP setting 'validate-db-schema-with' is not directly supported in EclipseLink CMP. See migration doc for details." },
        { "automatic_key_generation_not_supported", "WLS native CMP setting 'automatic-key-generation' on entity({0}) is not directly supported in EclipseLink CMP. See migration doc for details." },
        { "check_exist_on_method_as_true_not_supported", "WLS native CMP setting 'check-exists-on-method-as-true' on entity({0}) is not directly supported in EclipseLink CMP. See migration doc for details." },
        { "delay_database_insert_until_ejb_create_not_supported", "WLS native CMP setting 'delay-database-insert-until-ejbCreate' on entity({0}) is not directly supported in EclipseLink CMP. See migration doc for details." },
        { "delay_database_insert_until_ejb_post_create_not_supported", "WLS native CMP setting 'delay-database-insert-until-ejbPostCreate' on entity({0}) is not directly supported in EclipseLink CMP. See migration doc for details." },
        { "field_group_not_supported", "WLS native CMP setting 'field-group' on entity({0}) is not directly supported in EclipseLink CMP. See migration doc for details." },
        { "relationship_cacheing_not_supported", "WLS native CMP setting 'relationship-caching' on entity({0}) is not directly supported in EclipseLink CMP. See migration doc for details." },
        { "weblogic_query_not_supported", "WLS native CMP setting 'weblogic-query' on entity({0}) is not directly supported in EclipseLink CMP. See migration doc for details." },
        { "sequence_cachekey_improper_format", "WLS native CMP setting 'key-cache-size' on entity ({0}) is ill-formatted with value ({1})" },
        { "dir_cleaned_for_mw_files", "Files and sub-directories under directory {0} have been deleted in order to create a clean directory for the new generated EclipseLink Mapping Workbench project files" },
        { "mapping_not_supported_by_mw", "The EclipseLink mapping {0} is not supported by the mapping workbench" },
        { "toplink_ejb_jar_in_jar", "toplink-ejb-jar.xml is included in jar({0}) file, no migration therefore will be performed for this jar." },
        { "jta_cannot_be_disabled_in_cmp", "When using Container Managed Persistence (CMP), JTA cannot be disabled. EclipseLink will act as if JTA is enabled." },
        { "descriptor_named_query_cannot_be_added", "Cannot add a descriptor named query whose name conflict with an existing query. Query To Be Added: [{0}] is named: [{1}] with arguments [{2}]." },

        { "metadata_default_alias", "The alias name for the entity class [{0}] is being defaulted to: {1}." },
        { "metadata_default_map_key_attribute_name", "The map key attribute name for the mapping element [{0}] is being defaulted to: {1}." },
        { "metadata_default_table_name", "The table name for entity [{0}] is being defaulted to: {1}." },
        { "metadata_default_table_schema", "The table schema for entity [{0}] is being defaulted to: {1}." },
        { "metadata_default_table_catalog", "The table catalog for entity [{0}] is being defaulted to: {1}." },
        { "metadata_default_table_generator_name", "The table generator name defined within [{0}] is being defaulted to: {1}." },
        { "metadata_default_table_generator_schema", "The table generator schema defined within [{0}] is being defaulted to: {1}." },
        { "metadata_default_table_generator_catalog", "The table generator catalog defined within [{0}] is being defaulted to: {1}." },
        { "metadata_default_join_table_name", "The join table name for the many to many mapping [{0}] is being defaulted to: {1}." },
        { "metadata_default_join_schema", "The join table schema for the many to many mapping [{0}] is being defaulted to: {1}." },
        { "metadata_default_join_catalog", "The join table catalog for the many to many mapping [{0}] is being defaulted to: {1}." },
        { "metadata_default_secondary_table_name", "The secondary table name for the entity [{0}] is being defaulted to: {1}." },
        { "metadata_default_secondary_schema", "The secondary table name for the entity [{0}] is being defaulted to: {1}." },
        { "metadata_default_secondary_catalog", "The secondary table name for the entity [{0}] is being defaulted to: {1}." },
        { "metadata_default_collection_table_name", "The collection table name for the basic collection/map mapping [{0}] is being defaulted to: {1}." },
        { "metadata_default_collection_schema", "The collection table name for the basic collection/map mapping [{0}] is being defaulted to: {1}." },
        { "metadata_default_collection_catalog", "The collection table name for the basic collection/map mapping [{0}] is being defaulted to: {1}." },
        { "metadata_default_converter_data_type", "The data type for the converter named [{2}] used with the element [{1}] in the entity [{0}] is being defaulted to [{3}]." },
        { "metadata_default_converter_object_type", "The object type for the converter named [{2}] used with the element [{1}] in the entity [{0}] is being defaulted to [{3}]." },
        { "metadata_default_column", "The column name for element [{0}] is being defaulted to: {1}." },
        { "metadata_default_key_column", "The key column name for the basic map mapping element [{0}] is being defaulted to: {1}." },
        { "metadata_default_value_column", "The value column name for the basic collection/map mapping element mapping element [{0}] is being defaulted to: {1}." },
        { "metadata_default_pk_column", "The primary key column name for the mapping element [{0}] is being defaulted to: {1}." },
        { "metadata_default_fk_column", "The foreign key column name for the mapping element [{0}] is being defaulted to: {1}." },
        { "metadata_default_source_pk_column", "The source primary key column name for the many to many mapping [{0}] is being defaulted to: {1}." },
        { "metadata_default_source_fk_column", "The source foreign key column name for the many to many mapping [{0}] is being defaulted to: {1}." },
        { "metadata_default_target_pk_column", "The target primary key column name for the many to many mapping [{0}] is being defaulted to: {1}." },
        { "metadata_default_target_fk_column", "The target foreign key column name for the many to many mapping [{0}] is being defaulted to: {1}." },
        { "metadata_default_discriminator_column", "The discriminator column name for the root inheritance class [{0}] is being defaulted to: {1}." },
        { "metadata_default_inheritance_pk_column", "The primary key column name for the inheritance class [{0}] is being defaulted to: {1}." },
        { "metadata_default_inheritance_fk_column", "The foreign key column name for the inheritance class [{0}] is being defaulted to: {1}." },
        { "metadata_default_secondary_table_pk_column", "The secondary table primary key column name for element [{0}] is being defaulted to: {1}." },
        { "metadata_default_secondary_table_fk_column", "The secondary table foreign key column name for element [{0}] is being defaulted to: {1}." },
        { "metadata_default_one_to_one_mapping", "Element [{0}] is being defaulted to a one to one mapping." },
        { "metadata_default_one_to_many_mapping", "Element [{0}] is being defaulted to a one to many mapping." },
        { "metadata_default_one_to_one_reference_class", "The target entity (reference) class for the one to one mapping element [{0}] is being defaulted to: {1}." },
        { "metadata_default_one_to_many_reference_class", "The target entity (reference) class for the one to many mapping element [{0}] is being defaulted to: {1}." },
        { "metadata_default_many_to_one_reference_class", "The target entity (reference) class for the many to one mapping element [{0}] is being defaulted to: {1}." },
        { "metadata_default_many_to_many_reference_class", "The target entity (reference) class for the many to many mapping element [{0}] is being defaulted to: {1}." },
        
        { "metadata_warning_ignore_mapping", "A mapping for the element [{1}] is already defined on the descriptor for the entity [{0}]. Ignoring the mapping annotation." },
        { "metadata_warning_ignore_lob", "Ignoring lob specification on element [{1}] within entity class [{0}] since a @Convert is specified." },
        { "metadata_warning_ignore_temporal", "Ignoring temporal specification on element [{1}] within entity class [{0}] since a @Convert is specified." },
        { "metadata_warning_ignore_serialized", "Ignoring default serialization on element [{1}] within entity class [{0}] since a @Convert is specified." },
        { "metadata_warning_ignore_enumerated", "Ignoring enumerated specification on element [{1}] within entity class [{0}] since a @Convert is specified." },
        { "metadata_warning_ignore_version_locking", "Optimistic locking metadata is already defined on the descriptor for the entity [{0}]. Ignoring version specification on element [{1}]." },
        { "metadata_warning_ignore_mapped_superclass_optimistic_locking", "Optimistic locking metadata is already defined on the descriptor for the entity [{0}]. Ignoring the optimistic locking specification on the mapped superclass [{1}] for this entity." },
        { "metadata_warning_ignore_mapped_superclass_cache", "Ignoring the cache metadata on the mapped superclass [{1}] for the entity class [{0}] since it has its own cache metadata defined." },
        { "metadata_warning_ignore_inheritance_subclass_cache", "Ignoring the cache metadata on the inheritance subclass [{0}]. Cache metadata should only be specified on the root of the inheritance hierarchy and can not be overidden in an inheritance subclass." },
        { "metadata_warning_ignore_mapped_superclass_change_tracking", "Ignoring the change tracking metadata on the mapped superclass [{1}] for the entity class [{0}] since it has its own change tracking metadata defined." },
        { "metadata_warning_ignore_mapped_superclass_customizer", "Ignoring the customizer on the mapped superclass [{1}] for the entity class [{0}] since it has its own customizer defined." },
        { "metadata_warning_ignore_mapped_superclass_read_only", "Ignoring the read only settting the mapped superclass [{1}] for the entity class [{0}] since it has its own read only setting." },
        { "metadata_warning_ignore_inheritance_subclass_read_only", "Ignoring the read only setting on the inheritance subclass [{0}]. A read only setting should only be specified on the root of the inheritance hierarchy and can not be overridden in an inheritance subclass." },
        
        { "annotation_warning_ignore_annotation", "The annotation [{0}] on the element [{1}] is being ignored because of an XML metadata-complete setting of true for this class." },
        { "annotation_warning_ignore_association_override", "Ignoring the @AssociationOverride named [{0}] defined on the class [{2}] for the entity [{1}] since an association override with the same name was defined in XML." },
        { "annotation_warning_ignore_association_override_on_mapped_superclass", "Ignoring the @AssociationOverride named [{0}] defined on the mapped superclass [{1}] for the entity [{2}] since an association override with the same name was previously discovered for that entity (either on the entity itself or another mapped-superclass)." },
        { "annotation_warning_ignore_attribute_override", "Ignoring the @AttributeOverride named [{0}] defined on the class [{2}] for the entity [{1}] since an attribute override with the same name was defined in XML." },
        { "annotation_warning_ignore_attribute_override_on_mapped_superclass", "Ignoring the @AttributeOverride named [{0}] defined on the mapped superclass [{1}] for the entity [{2}] since an attribute override override with the same name was previously discovered for that entity (either on the entity itself or another mapped-superclass)." },
        { "annotation_warning_ignore_id_class", "Ignoring the @IdClass annotation on the entity [{0}] since an id-class was defined in XML." },
        { "annotation_warning_ignore_read_only", "A @ReadOnly was applied to the inheritance subclass [{0]]. A @ReadOnly should only be specified on the root of the inheritance hierarchy." },
        { "annotation_warning_ignore_converter", "Ignoring the converter named [{0}] defined on the class [{1}] since a converter with the same name was defined in the mapping file [{2}]" },
        { "annotation_warning_ignore_struct_converter", "Ignoring the @StructConverter named [{0}] defined on the class [{1}] since a struct converter with the same name was defined in the mapping file [{2}]" },
        { "annotation_warning_ignore_named_native_query", "Ignoring the @NamedNativeQuery named [{0}] defined on the class [{1}] since a named native query with the same name was defined in the mapping file [{2}]" },
        { "annotation_warning_ignore_named_query", "Ignoring the @NamedQuery named [{0}] defined on the class [{1}] since a named query with the same name was defined in the mapping file [{2}]" },
        { "annotation_warning_ignore_named_stored_procedure_query", "Ignoring the @NamedStoredProcedureQuery named [{0}] defined on the class [{1}] since a named stored procedure query with the same name was defined in the mapping file [{2}]" },
        { "annotation_warning_ignore_table", "Ignoring the @Table annotation on the entity [{0}] since a table metadata was defined in XML." },
        { "annotation_warning_ignore_secondary_table", "Ignoring the @SecondaryTable(s) annotation on the entity [{0}] since secondary table metadata was defined in XML." },
        { "annotation_warning_ignore_customizer", "A customizer is already defined on the descriptor for the entity [{0}]. Ignoring @Customizer on the mapped superclass [{1}] for this descriptor." },
        { "annotation_warning_ignore_private_owned", "Ignoring @PrivateOwned on element [{1}] within entity class [{0}]. A @PrivateOwned can only be used with a @BasicCollection, @BasicMap, @OneToOne and @OneToMany." },
        { "annotation_warning_ignore_return_insert", "Ignoring the @ReturnInsert on the element [{0}]. A @ReturnInsert is only supported with a basic mapping." },
        { "annotation_warning_ignore_return_update", "Ignoring the @ReturnUpdate on the element [{0}]. A @ReturnUpdate is only supported with a basic mapping." },
        { "annotation_warning_ignore_change_tracking", "A change tracking policy is already defined on the descriptor for the entity [{0}]. Ignoring @ChangeTracking on the mapped superclass [{1}] for this descriptor." },
        { "annotation_warning_ignore_optimistic_locking", "An optimistic-locking element has been defined for the entity [{0}] in the mapping file [{1}]. Ignoring the @OptimisticLocking defined on this entity." },
        
        { "weaver_null_project", "Weaver session'''s project cannot be null"},
        { "weaver_disable_by_system_property", "Weaving disabled by system property {0}"},		
        { "weaver_not_overwriting", "Weaver is not overwriting class {0} because it has not been set to overwrite."},
        { "weaver_could_not_write", "Weaver encountered an exception while trying to write class {0} to the file system.  The exception was: {1}"},
        
        { "weaver_class_not_in_project", "Weaver found a class that is not part of the project: {0}."},
        { "weaver_processing_class", "Weaver processing class: {0}."},
        { "cannot_weave_changetracking", "Class {0} could not weaved for change tracking as not supported by its mappings."},

        { "field_type_set_to_java_lang_string", "The default table generator could not locate or convert a java type ({1}) into a database type for database field ({0}). The generator uses 'java.lang.String' as default java type for the field." },
        { "relational_descriptor_support_only", "The default table generator currently only supports generating default table schema from a relational project."},
        { "default_tables_already_existed", "The table ({0}) is already in the database, and won't be created."},

        { "config_factory", "Config factory: ({0}) = ({1})"},
        { "class_list_created_by", "Class list created by ({0}).({1})() method."},
        { "jar_file_url_exception", "Exception while parsing persistence.xml.  Jar file location could not be found: {0}"},
        { "cannot_unwrap_connection", "Cannot unwrap the oracle connection wrapped by the application server because of the following exception.  {0}"},
        { "error_loading_xml_file", "Exception while loading ORM xml file: {0}: {1}"},
        // B5112171: XML AnyObject and AnyCollection throw NPE on null document root element
        { "exception_loading_entity_class", "An exception while trying to initialize persistence.  {1} occurred while trying to load entity class: {0}."},
        { "marshal_warning_null_document_root_element", "{0}: The undefined document root element of a referenced object [{1}] is ignored during marshalling with an any collection|object mapping." },
    
        { "update_all_query_cannot_use_binding_on_this_platform", "UpdateAllQuery cannot use binding on this database platform. Changed query setting to execute without binding." },

        { "broadcast_exception_thrown_when_attempting_to_close_connection", "Warning: {0}: attempt to close connection caused exception {1}" },
        { "broadcast_connection_already_closed", "Warning: {0}: attempt to close connection which has been already closed. Ignoring." },
        { "broadcast_connection_already_closing", "Warning: {0}: attempt to close connection which is currently closing. Ignoring." },
        { "broadcast_remote_command_is_null", "Warning: {0}: received message {1} containing null instead of RemoteCommand." },
        { "broadcast_remote_command_wrong_type", "Warning: {0}: received message {1} containg an object of type {2} instead of expected type RemoteCommand." },
        { "broadcast_ignored_command_while_closing_connection", "Warning: {0}: ignoring request to publish command while connection is closing." },
        { "broadcast_listening_sleep_on_error", "Warning: {0}: Exception {1} was thrown. The thread will sleep for {2} milliseconds before resuming listening." },
        { "dbPlaformHelper_defaultingPlatform", "Not able to detect platform for vendor name [{0}]. Defaulting to [{1}]. The database dialect used may not match with the database you are using. Please explicitly provide a platform using property 'toplink.platform.class.name'."},
        { "dbPlaformHelper_noMappingFound", "Can not load resource [{0}] that loads mapping from vendor name to database platform. Autodetection of database platform will not work."},
        
        { "sessions_xml_path_where_session_load_from", "The session info is loaded from [{0}]."},
        { "resource_local_persistence_init_info_ignores_jta_data_source", "PersistenceUnitInfo {0} has transactionType RESOURCE_LOCAL and therefore jtaDataSource will be ignored"},
        { "deprecated_property", "property {1} is deprecated, property {0} should be used instead."},
        { "persistence_unit_processor_error_loading_class", "{0}: {1} was thrown on attempt of PersistenceLoadProcessor to load class {2}. The class is ignored."},
        
        { "attempted_to_open_url_as_jar", "{1} was thrown on attempt to open {0} as a jar."},
        { "attempted_to_open_url_as_directory", "{1} was thrown on attempt to open {0} as a directory."},
        { "attempted_to_open_entry_in_url_as_jar", "{2} was thrown on attempt to open {0} as a jar and access entry: {1}."},
        { "attempted_to_open_file_url_as_directory", "{2} was thrown on attempt to open {0} as a directory and access entry: {1}."},
        { "invalid_datasource_property_value", "{1} is not a valid object to be passed in for property {0}.  Valid values are String or instances of javax.sql.DataSource."},
        // class name is preceeded by "class" - we need to hardcode the full package name
        { "sdo_type_generation_modified_function_naming_format_to", "{0}: Generated Type [{1}] java get/set method name changed to [{2}] to follow class naming conventions."},                                            
        { "sdo_type_generation_modified_class_naming_format_to", "{0}: Generated Type [{1}] java class name changed to [{2}] to follow class naming conventions."},                                            
        { "sdo_type_generation_warning_class_name_violates_java_spec", "{0}: Generated Type [{1}] conflicts with Java specification naming rules for [{2}] and should be renamed."},                                           
        { "sdo_type_generation_warning_class_name_violates_sdo_spec", "{0}: Generated Type [{1}] conflicts with SDO specification naming rules for [{2}] and should be renamed."},                                            
        
        { "sdo_classgenerator_exception", "{2} A [{0}] Exception occurred - message is [{1}]"},
        { "query_has_both_join_attributes_and_partial_attributes", "{0} named {1} has both join attributes and partial attributes. These two technologies were not designed to work together, result may be unpredictible."},
        { "sdo_missing_schemaLocation", "Referenced schema with uri {0} could not be processed because no schemaLocation attribute was specified."},
        { "sdo_invalid_schemaLocation", "Could not create schemaLocation [{0}] for import with uri [{1}]."},
        { "sdo_error_processing_referenced_schema", "An {0} occurred processing referenced schema with uri {1} with schemaLocation {2}."},
        { "ox_turn_global_logging_off", " {0} Turning global session logging off."},
        { "ox_lowering_global_logging_from_default_info_to_warning", " {0} Lowering global logging from default INFO to WARNING level."},        
        { "ox_turn_session_logging_off", " {0} Turning session logging off."},
        { "ox_lowering_session_logging_from_default_info_to_warning", " {0} Lowering session logging from default INFO to WARNING level."},
        
        { "cannot_get_server_name_and_version", "Cannot get server name and version because of the following exception.  {0}"},
        { "communication_failure_attempting_query_retry", "Communication failure detected when attempting to perform read query outside of a transaction. Attempting to retry query."},
        { "communication_failure_attempting_begintransaction_retry", "Communication failure detected when attempting to create transaction on database.  Attempting to retry begin transaction."},

        
        
        
        
        // newly added for message id
        // The corresponding key mapping for a key:message mapping above is added below only if I18N is required - or was missed
        {"oracle.core.ojdl.logging.MessageIdSuffixResourceBundle" ,"oracle.core.ojdl.logging.MessageIdSuffixResourceBundle"},  
        {"topLink_version.MSGID" ,"TOP-50001"}, 
        {"application_server_name_and_version.MSGID" ,"TOP-50002"}, 
        {"login_successful.MSGID" ,"TOP-50003"}, 
        {"logout_successful.MSGID" ,"TOP-50004"},         
        
        {"connected_user_database_driver.MSGID" ,"TOP-50005"}, 
        {"connected_user_database.MSGID" ,"TOP-50006"}, 
        {"JDBC_driver_does_not_support_meta_data.MSGID" ,"TOP-50007"}, 
        {"connecting.MSGID" ,"TOP-50008"}, 
        {"disconnect.MSGID" ,"TOP-50009"}, 
        {"reconnecting.MSGID" ,"TOP-50010"}, 
        {"connected_sdk.MSGID" ,"TOP-50011"}, 
        
        {"no_session_found.MSGID" ,"TOP-50012"}, 
        
        {"identitymap_for.MSGID" ,"TOP-50013"}, 
        {"includes.MSGID" ,"TOP-50014"}, 
        {"key_object_null.MSGID" ,"TOP-50015"}, 
        {"key_identity_hash_code_object.MSGID" ,"TOP-50016"}, 
        {"elements.MSGID" ,"TOP-50017"}, 
        {"unitofwork_identity_hashcode.MSGID" ,"TOP-50018"}, 
        {"deleted_objects.MSGID" ,"TOP-50019"}, 
        {"deleting_object.MSGID" ,"TOP-50020"}, 
        {"register_new_for_persist.MSGID" ,"TOP-50021"}, 
        {"all_registered_clones.MSGID" ,"TOP-50022"}, 
        {"new_objects.MSGID" ,"TOP-50023"},         
        
        {"failed_to_propogate_to.MSGID" ,"TOP-50024"}, 
        {"exception_thrown_when_attempting_to_shutdown_cache_synch.MSGID" ,"TOP-50025"}, 
        {"corrupted_session_announcement.MSGID" ,"TOP-50026"}, 
        {"exception_thrown_when_attempting_to_close_listening_topic_connection.MSGID" ,"TOP-50027"}, 
        {"retreived_unknown_message_type.MSGID" ,"TOP-50028"}, 
        {"retreived_null_message.MSGID" ,"TOP-50029"}, 
        {"received_unexpected_message_type.MSGID" ,"TOP-50030"}, 
        {"problem_adding_remote_connection.MSGID" ,"TOP-50031"},         
        
        {"error_in_codegen.MSGID" ,"TOP-50032"}, 
        {"error_during_PersistenceManager_setup_for_bean.MSGID" ,"TOP-50033"}, 
        {"error_in_create.MSGID" ,"TOP-50034"}, 
        {"error_executing_ejbHome.MSGID" ,"TOP-50035"}, 
        {"error_in_remove.MSGID" ,"TOP-50036"}, 
        {"table_existed_during_creation.MSGID" ,"TOP-50037"}, 
        {"an_error_occured_trying_to_undeploy_bean.MSGID" ,"TOP-50038"}, 
        {"an_error_occured_executing_findByPrimaryKey.MSGID" ,"TOP-50039"}, 
        {"an_error_occured_preparing_bean.MSGID" ,"TOP-50040"}, 
        {"an_error_executing_finder.MSGID" ,"TOP-50041"}, 
        {"an_error_executing_ejbSelect.MSGID" ,"TOP-50042"}, 
        {"ejbSelect2.MSGID" ,"TOP-50043"}, 
        {"error_getting_transaction_status.MSGID" ,"TOP-50044"}, 
        {"removeEJB_return.MSGID" ,"TOP-50045"}, 
        {"multiple_ds_not_supported.MSGID" ,"TOP-50046"}, 
        {"failed_to_find_mbean_server.MSGID" ,"TOP-50047"}, 
        {"problem_while_registering.MSGID" ,"TOP-50048"}, 
        {"objectchangepolicy_turned_off.MSGID" ,"TOP-50049"}, 
        {"External_transaction_controller_not_defined_by_server_platform.MSGID" ,"TOP-50050"},         
        
        {"extra_cmp_field.MSGID" ,"TOP-50051"}, 
        {"extra_ejb_select.MSGID" ,"TOP-50052"}, 
        {"extra_finder.MSGID" ,"TOP-50053"}, 
        {"cmp_and_cmr_field.MSGID" ,"TOP-50054"},         
        
        {"toplink_cmp_bean_name_xml_deprecated.MSGID" ,"TOP-50055"}, 
                
        {"drop_connection_on_error.MSGID" ,"TOP-50056"}, 
        {"received_corrupt_announcement.MSGID" ,"TOP-50057"}, 
        {"missing_converter.MSGID" ,"TOP-50058"}, 
        {"failed_command_propagation.MSGID" ,"TOP-50059"}, 
        {"exception_thrown_when_attempting_to_close_connection.MSGID" ,"TOP-50060"}, 
        {"error_executing_remote_command.MSGID" ,"TOP-50061"}, 
        {"problem_adding_connection.MSGID" ,"TOP-50062"}, 
        {"problem_reconnect_to_jms.MSGID" ,"TOP-50063"},         
        
        {"toplink_severe.MSGID" ,"TOP-50064"}, 
        {"toplink_warning.MSGID" ,"TOP-50065"}, 
        {"toplink_info.MSGID" ,"TOP-50066"}, 
        {"toplink_config.MSGID" ,"TOP-50067"}, 
        {"toplink_fine.MSGID" ,"TOP-50068"}, 
        {"toplink_finer.MSGID" ,"TOP-50069"}, 
        {"toplink_finest.MSGID" ,"TOP-50070"}, 
        {"toplink.MSGID" ,"TOP-50071"}, 
        {"an_error_occured_initializing_dms_listener.MSGID" ,"TOP-50072"},         
        
        {"input_minimum_arguments.MSGID" ,"TOP-50073"}, 
        {"src_pm_name_first_argument.MSGID" ,"TOP-50074"}, 
        {"oc4j_native_migration_start.MSGID" ,"TOP-50075"}, 
        {"validate_ejb_jar.MSGID" ,"TOP-50076"}, 
        {"weblogic_native_migration_start.MSGID" ,"TOP-50077"}, 
        {"must_define_migration_output_dir.MSGID" ,"TOP-50078"}, 
        {"migration_output_dir_not_valid.MSGID" ,"TOP-50079"}, 
        {"migration_input_dir_not_valid.MSGID" ,"TOP-50080"}, 
        {"input_and_output_dir_be_different.MSGID" ,"TOP-50081"}, 
        {"input_archive_format_not_supported.MSGID" ,"TOP-50082"}, 
        {"archive_not_found_in_input.MSGID" ,"TOP-50083"}, 
        {"input_not_both_archive_and_xml.MSGID" ,"TOP-50084"}, 
        {"input_at_least_either_archive_or_xml.MSGID" ,"TOP-50085"}, 
        {"ejb_jar_xml_not_found_in_input.MSGID" ,"TOP-50086"}, 
        {"orion_ejb_jar_xml_not_found_in_input.MSGID" ,"TOP-50087"}, 
        {"weblogic_ejb_jar_xml_not_found_in_input.MSGID" ,"TOP-50088"}, 
        {"toplink_ejb_jar_xml_found_in_input.MSGID" ,"TOP-50089"}, 
        {"migration_successful.MSGID" ,"TOP-50090"}, 
        {"migration_failed.MSGID" ,"TOP-50091"}, 
        {"mw_project_generated_and_under.MSGID" ,"TOP-50092"}, 
        {"log_file_under_output_dir.MSGID" ,"TOP-50093"}, 
        {"parse_ejb_jar_with_validation_fails.MSGID" ,"TOP-50094"}, 
        {"jar_entry_not_migratable.MSGID" ,"TOP-50095"}, 
        {"jar_entry_has_been_migrated.MSGID" ,"TOP-50096"}, 
        {"no_jar_entry_migratable_in_ear.MSGID" ,"TOP-50097"}, 
        {"invalid_command_line_argument.MSGID" ,"TOP-50098"}, 
        {"column_size_not_migrated.MSGID" ,"TOP-50099"}, 
        {"associate_using_third_table_not_migrated.MSGID" ,"TOP-50100"}, 
        {"delay_updates_until_commit_not_supported.MSGID" ,"TOP-50101"}, 
        {"do_select_before_insert_not_supported.MSGID" ,"TOP-50102"}, 
        {"no_exclusive_write_access_not_supported.MSGID" ,"TOP-50103"}, 
        {"force_update_not_supported.MSGID" ,"TOP-50104"}, 
        {"isolation_level_not_supported.MSGID" ,"TOP-50105"}, 
        {"force_update_not_supported.MSGID" ,"TOP-50106"}, 
        {"max_instance_not_supported.MSGID" ,"TOP-50107"}, 
        {"max_tx_retries_not_supported.MSGID" ,"TOP-50108"}, 
        {"min_instance_not_supported.MSGID" ,"TOP-50109"}, 
        {"update_all_fields_not_supported.MSGID" ,"TOP-50110"}, 
        {"validity_timeout_not_supported.MSGID" ,"TOP-50111"}, 
        {"call_timeout_not_migrated.MSGID" ,"TOP-50112"}, 
        {"optimistic_locking_not_supported.MSGID" ,"TOP-50113"}, 
        {"old_pessimistic_locking_not_supported.MSGID" ,"TOP-50114"}, 
        {"locking_mode_not_valid.MSGID" ,"TOP-50115"}, 
        {"verifiy_columns_read_locking_not_supported.MSGID" ,"TOP-50116"}, 
        {"verifiy_rows_read_locking_not_supported.MSGID" ,"TOP-50117"}, 
        {"one_to_one_join_outer_migrated.MSGID" ,"TOP-50118"}, 
        {"bacth_update_not_supported.MSGID" ,"TOP-50119"}, 
        {"data_sync_on_ejb_create_not_supported.MSGID" ,"TOP-50120"}, 
        {"weblogic_ql_not_supported.MSGID" ,"TOP-50121"}, 
        {"input_orione_ejb_jar_augmented.MSGID" ,"TOP-50122"}, 
        {"template_orion_ejb_jar_created.MSGID" ,"TOP-50123"}, 
        {"create_default_dbms_tables_not_supported.MSGID" ,"TOP-50124"}, 
        {"default_dbms_tables_ddl_not_supported.MSGID" ,"TOP-50125"}, 
        {"enable_batch_operations_as_true_not_supported.MSGID" ,"TOP-50126"}, 
        {"validate_db_schema_with_not_supported.MSGID" ,"TOP-50127"}, 
        {"automatic_key_generation_not_supported.MSGID" ,"TOP-50128"}, 
        {"check_exist_on_method_as_true_not_supported.MSGID" ,"TOP-50129"}, 
        {"delay_database_insert_until_ejb_create_not_supported.MSGID" ,"TOP-50130"}, 
        {"delay_database_insert_until_ejb_post_create_not_supported.MSGID" ,"TOP-50131"}, 
        {"field_group_not_supported.MSGID" ,"TOP-50132"}, 
        {"relationship_cacheing_not_supported.MSGID" ,"TOP-50133"}, 
        {"weblogic_query_not_supported.MSGID" ,"TOP-50134"}, 
        {"sequence_cachekey_improper_format.MSGID" ,"TOP-50135"}, 
        {"dir_cleaned_for_mw_files.MSGID" ,"TOP-50136"}, 
        {"mapping_not_supported_by_mw.MSGID" ,"TOP-50137"}, 
        {"toplink_ejb_jar_in_jar.MSGID" ,"TOP-50138"}, 
        {"migration_tool_usage.MSGID" ,"TOP-50139"}, 
        {"migration_tool_usage_exmaple.MSGID" ,"TOP-50140"}, 
        {"jta_cannot_be_disabled_in_cmp.MSGID" ,"TOP-50141"}, 
        
        {"annotation_default_alias.MSGID" ,"TOP-50142"}, 
        {"annotation_default_one_to_one_mapping.MSGID" ,"TOP-50143"}, 
        {"annotation_default_one_to_many_mapping.MSGID" ,"TOP-50144"}, 
        {"annotation_default_column.MSGID" ,"TOP-50145"}, 
        {"annotation_default_pk_column.MSGID" ,"TOP-50146"}, 
        {"annotation_default_fk_column.MSGID" ,"TOP-50147"}, 
        {"annotation_default_table_name.MSGID" ,"TOP-50148"}, 
        {"annotation_default_source_pk_column.MSGID" ,"TOP-50149"}, 
        {"annotation_default_source_fk_column.MSGID" ,"TOP-50150"}, 
        {"annotation_default_target_pk_column.MSGID" ,"TOP-50151"}, 
        {"annotation_default_target_fk_column.MSGID" ,"TOP-50152"}, 
        {"annotation_default_inheritance_pk_column.MSGID" ,"TOP-50153"}, 
        {"annotation_default_inheritance_fk_column.MSGID" ,"TOP-50154"}, 
        {"annotation_default_association_table_name.MSGID" ,"TOP-50155"}, 
        {"annotation_default_secondary_table_pk_column.MSGID" ,"TOP-50156"}, 
        {"annotation_default_secondary_table_fk_column.MSGID" ,"TOP-50157"}, 
        {"annotation_default_one_to_one_reference_class.MSGID" ,"TOP-50158"}, 
        {"annotation_default_one_to_many_reference_class.MSGID" ,"TOP-50159"}, 
        {"annotation_default_many_to_one_reference_class.MSGID" ,"TOP-50160"}, 
        {"annotation_default_many_to_many_reference_class.MSGID" ,"TOP-50161"}, 
        
        {"annotation_warning_ignore_mapping.MSGID" ,"TOP-50162"}, 
        {"annotation_warning_ignore_primary_key.MSGID" ,"TOP-50163"}, 
        {"annotation_warning_ignore_embedded_id.MSGID" ,"TOP-50164"}, 
        {"annotation_warning_ignore_id_class.MSGID" ,"TOP-50165"}, 
        {"annotation_warning_ignore_version_locking.MSGID" ,"TOP-50166"}, 
        {"annotation_warning_ignore_table.MSGID" ,"TOP-50167"}, 
        {"annotation_warning_ignore_secondary_table.MSGID" ,"TOP-50168"}, 
        {"annotation_warning_ignore_inheritance.MSGID" ,"TOP-50169"}, 
        {"annotation_warning_ignore_get_method.MSGID" ,"TOP-50170"}, 
        {"annotation_warning_ignore_query.MSGID" ,"TOP-50171"}, 
        
        {"weaver_null_project.MSGID" ,"TOP-50172"}, 
        {"weaver_disable_by_system_property.MSGID" ,"TOP-50173"}, 
        {"weaver_valueholders_disabled_missing_field.MSGID" ,"TOP-50174"}, 
        {"weaver_change_tracking_disabled_missing_field.MSGID" ,"TOP-50175"}, 
        {"weaver_change_tracking_disabled_not_supported.MSGID" ,"TOP-50176"}, 
        
        {"field_type_set_to_java_lang_string.MSGID" ,"TOP-50177"}, 
        {"relational_descriptor_support_only.MSGID" ,"TOP-50178"}, 
        {"default_tables_already_existed.MSGID" ,"TOP-50179"}, 
        
        {"config_factory.MSGID" ,"TOP-50180"}, 
        {"class_list_created_by.MSGID" ,"TOP-50181"}, 

        {"cannot_unwrap_connection.MSGID" ,"TOP-50182"},
        {"marshal_warning_null_document_root_element.MSGID", "TOP-50183" },

        { "broadcast_exception_thrown_when_attempting_to_close_connection.MSGID", "TOP-50184" },
        { "broadcast_connection_already_closed.MSGID", "TOP-50185" },
        { "broadcast_connection_already_closing.MSGID", "TOP-50186" },
        { "broadcast_remote_command_is_null.MSGID", "TOP-50187" },
        { "broadcast_remote_command_wrong_type.MSGID", "TOP-50188" },
        { "broadcast_ignored_command_while_closing_connection.MSGID", "TOP-50189"},
        { "broadcast_listening_sleep_on_error.MSGID", "TOP-50190"},
        { "sdo_type_generation_modified_function_naming_format_to.MSGID", "TOP-50191"},                                            
        { "sdo_type_generation_modified_class_naming_format_to.MSGID", "TOP-50192"},                                            
        { "sdo_type_generation_warning_class_name_violates_java_spec.MSGID", "TOP-50193"},                                           
        { "sdo_type_generation_warning_class_name_violates_sdo_spec.MSGID", "TOP-50194"},                                            
        
        { "sdo_classgenerator_exception.MSGID", "TOP-50195"},
        { "query_has_both_join_attributes_and_partial_attributes.MSGID", "TOP-50196"},        
        { "sdo_missing_schemaLocation.MSGID", "TOP-50197"},
        { "sdo_error_processing_referenced_schema.MSGID", "TOP-50198"},
        { "ox_turn_global_logging_off.MSGID", "TOP-50199"},
        { "ox_lowering_global_logging_from_default_info_to_warning.MSGID", "TOP-50200"},
        { "ox_turn_session_logging_off.MSGID", "TOP-50201"},
        { "ox_lowering_session_logging_from_default_info_to_warning.MSGID", "TOP-50202"},
        { "communication_failure_attempting_query_retry.MSGID", "TOP-50203"},
        { "communication_failure_attempting_begintransaction_retry.MSGID","TOP-50204"}
    }; 
     
    /**
     * Return the lookup table.
     */
    protected Object[][] getContents() {
        return contents;
    }
}
