/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.packager.deb;

import com.google.common.io.BaseEncoding;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.List;
import java.util.Map;
import java.util.zip.GZIPInputStream;
import org.apache.commons.compress.archivers.ar.ArArchiveEntry;
import org.apache.commons.compress.archivers.ar.ArArchiveInputStream;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveInputStream;
import org.eclipse.packager.deb.ControlFileParser;
import org.eclipse.packager.deb.ControlFileWriter;
import org.eclipse.packager.deb.FieldFormatter;
import org.eclipse.packager.deb.ParserException;
import org.eclipse.packager.deb.internal.BinarySectionPackagesFile;

public final class Packages {
    private static final MessageDigest MD5;

    private Packages() {
    }

    public static Map<String, String> parseControlFile(File packageFile) throws IOException, ParserException {
        try (ArArchiveInputStream in = new ArArchiveInputStream((InputStream)new FileInputStream(packageFile));){
            ArArchiveEntry ar;
            while ((ar = in.getNextEntry()) != null) {
                if (!ar.getName().equals("control.tar.gz")) continue;
                try (TarArchiveInputStream inputStream = new TarArchiveInputStream((InputStream)new GZIPInputStream((InputStream)in));){
                    TarArchiveEntry te;
                    while ((te = inputStream.getNextEntry()) != null) {
                        String name = te.getName();
                        if (name.startsWith("./")) {
                            name = name.substring(2);
                        }
                        if (!name.equals("control")) continue;
                        Map<String, String> map = Packages.parseControlFile((InputStream)inputStream);
                        return map;
                    }
                }
            }
        }
        return null;
    }

    public static Map<String, String> parseControlFile(InputStream inputStream) throws IOException, ParserException {
        return ControlFileParser.parse(inputStream);
    }

    public static List<Map<String, String>> parseStatusFile(InputStream inputStream) throws IOException, ParserException {
        return ControlFileParser.parseMulti(inputStream);
    }

    public static void writeBinaryPackageValues(PrintWriter writer, Map<String, String> values) throws IOException {
        new ControlFileWriter(writer, BinarySectionPackagesFile.FORMATTERS).writeEntries(values);
    }

    public static String makeDescriptionMd5(String string) {
        if (string == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        try {
            FieldFormatter.MULTI.appendValue(string, sb);
            sb.append('\n');
        }
        catch (IOException iOException) {
            // empty catch block
        }
        String result = sb.toString();
        byte[] data = MD5.digest(result.getBytes(StandardCharsets.UTF_8));
        return BaseEncoding.base16().encode(data).toLowerCase();
    }

    static {
        try {
            MD5 = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
    }
}

