/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.packager.deb.build;

import com.google.common.io.Files;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.eclipse.packager.deb.build.ContentProvider;

public class TextFileContentProvider
implements ContentProvider {
    private final byte[] data;

    public TextFileContentProvider(File file) throws FileNotFoundException, IOException {
        if (file != null) {
            String data = Files.asCharSource((File)file, (Charset)StandardCharsets.UTF_8).read();
            if (TextFileContentProvider.needFix()) {
                data = TextFileContentProvider.fix(data);
            }
            this.data = data.getBytes(StandardCharsets.UTF_8);
        } else {
            this.data = null;
        }
    }

    private static boolean needFix() {
        return !"\n".equals(System.lineSeparator());
    }

    private static String fix(String data) {
        return data.replace("\r\n", "\n");
    }

    @Override
    public long getSize() {
        return this.data == null ? 0L : (long)this.data.length;
    }

    @Override
    public InputStream createInputStream() throws IOException {
        if (this.data != null) {
            return new ByteArrayInputStream(this.data);
        }
        return null;
    }

    @Override
    public boolean hasContent() {
        return this.data != null;
    }
}

