/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.packager.deb.build;

import com.google.common.io.ByteStreams;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringWriter;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.security.MessageDigest;
import java.time.Instant;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.function.Supplier;
import java.util.zip.GZIPOutputStream;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.ar.ArArchiveEntry;
import org.apache.commons.compress.archivers.ar.ArArchiveOutputStream;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveOutputStream;
import org.bouncycastle.util.encoders.Hex;
import org.eclipse.packager.deb.ControlFileWriter;
import org.eclipse.packager.deb.build.BinaryPackageBuilder;
import org.eclipse.packager.deb.build.ContentProvider;
import org.eclipse.packager.deb.build.EntryInformation;
import org.eclipse.packager.deb.build.FileContentProvider;
import org.eclipse.packager.deb.build.StaticContentProvider;
import org.eclipse.packager.deb.control.BinaryPackageControlFile;
import org.eclipse.packager.deb.internal.ChecksumInputStream;

public class DebianPackageWriter
implements AutoCloseable,
BinaryPackageBuilder {
    public static final Charset CHARSET = Charset.forName("UTF-8");
    private static final int AR_ARCHIVE_DEFAULT_MODE = 33188;
    private final ArArchiveOutputStream ar;
    private final byte[] binaryHeader = "2.0\n".getBytes();
    private final Supplier<Instant> timestampSupplier;
    private final File dataTemp;
    private final TarArchiveOutputStream dataStream;
    private final BinaryPackageControlFile packageControlFile;
    private long installedSize = 0L;
    private final Map<String, String> checkSums = new TreeMap<String, String>();
    private final Set<String> confFiles = new TreeSet<String>();
    private final Set<String> paths = new HashSet<String>();
    private ContentProvider preinstScript;
    private ContentProvider postinstScript;
    private ContentProvider prermScript;
    private ContentProvider postrmScript;

    public DebianPackageWriter(OutputStream stream, BinaryPackageControlFile packageControlFile) throws IOException {
        this(stream, packageControlFile, Instant::now);
    }

    public DebianPackageWriter(OutputStream stream, BinaryPackageControlFile packageControlFile, Supplier<Instant> timestampSupplier) throws IOException {
        Objects.requireNonNull(timestampSupplier);
        this.timestampSupplier = timestampSupplier;
        this.packageControlFile = packageControlFile;
        BinaryPackageControlFile.validate(packageControlFile);
        this.ar = new ArArchiveOutputStream(stream);
        this.ar.putArchiveEntry((ArchiveEntry)new ArArchiveEntry("debian-binary", (long)this.binaryHeader.length, 0, 0, 33188, timestampSupplier.get().getEpochSecond()));
        this.ar.write(this.binaryHeader);
        this.ar.closeArchiveEntry();
        this.dataTemp = File.createTempFile("data", null);
        this.dataStream = new TarArchiveOutputStream((OutputStream)new GZIPOutputStream(new FileOutputStream(this.dataTemp)));
        this.dataStream.setLongFileMode(2);
    }

    public void addFile(File file, String fileName, EntryInformation entryInformation) throws IOException {
        this.addFile(new FileContentProvider(file), fileName, entryInformation, Optional.of(() -> file == null || !file.canRead() ? null : Instant.ofEpochMilli(file.lastModified())));
    }

    public void addFile(File file, String fileName, EntryInformation entryInformation, Optional<Supplier<Instant>> timestampSupplier) throws IOException {
        this.addFile(new FileContentProvider(file), fileName, entryInformation, timestampSupplier);
    }

    public void addFile(byte[] content, String fileName, EntryInformation entryInformation) throws IOException {
        this.addFile(new StaticContentProvider(content), fileName, entryInformation);
    }

    public void addFile(byte[] content, String fileName, EntryInformation entryInformation, Optional<Supplier<Instant>> timestampSupplier) throws IOException {
        this.addFile(new StaticContentProvider(content), fileName, entryInformation, timestampSupplier);
    }

    public void addFile(String content, String fileName, EntryInformation entryInformation) throws IOException {
        this.addFile(new StaticContentProvider(content), fileName, entryInformation);
    }

    public void addFile(String content, String fileName, EntryInformation entryInformation, Optional<Supplier<Instant>> timestampSupplier) throws IOException {
        this.addFile(new StaticContentProvider(content), fileName, entryInformation, timestampSupplier);
    }

    @Override
    public void addFile(ContentProvider contentProvider, String fileName, EntryInformation entryInformation, Optional<Supplier<Instant>> timestampSupplier) throws IOException {
        Objects.requireNonNull(timestampSupplier);
        if (entryInformation == null) {
            entryInformation = EntryInformation.DEFAULT_FILE;
        }
        try {
            fileName = this.cleanupPath(fileName);
            if (entryInformation.isConfigurationFile()) {
                this.confFiles.add(fileName.substring(1));
            }
            TarArchiveEntry entry = new TarArchiveEntry(fileName);
            entry.setSize(contentProvider.getSize());
            DebianPackageWriter.applyInfo(entry, entryInformation);
            DebianPackageWriter.applyTimestamp(entry, timestampSupplier);
            this.checkCreateParents(fileName, timestampSupplier);
            this.dataStream.putArchiveEntry((ArchiveEntry)entry);
            HashMap<String, byte[]> results = new HashMap<String, byte[]>();
            try (ChecksumInputStream in = new ChecksumInputStream(contentProvider.createInputStream(), results, MessageDigest.getInstance("MD5"));){
                this.installedSize += ByteStreams.copy((InputStream)in, (OutputStream)this.dataStream);
            }
            this.dataStream.closeArchiveEntry();
            this.recordChecksum(fileName, (byte[])results.get("MD5"));
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    private String cleanupPath(String fileName) {
        if (fileName == null) {
            return null;
        }
        fileName = fileName.replace("\\", "/");
        if ((fileName = fileName.replace("/+", "/")).startsWith("./")) {
            return fileName;
        }
        if (fileName.startsWith("/")) {
            return "." + fileName;
        }
        return "./" + fileName;
    }

    @Override
    public void addDirectory(String directory, EntryInformation entryInformation, Optional<Supplier<Instant>> timestampSupplier) throws IOException {
        if (!(directory = this.cleanupPath(directory)).endsWith("/")) {
            directory = directory + Character.toString('/');
        }
        this.checkCreateParents(directory, timestampSupplier);
        this.internalAddDirectory(directory, entryInformation, timestampSupplier);
    }

    protected void internalAddDirectory(String path, EntryInformation entryInformation, Optional<Supplier<Instant>> timestampSupplier) throws IOException {
        TarArchiveEntry entry = new TarArchiveEntry(path);
        DebianPackageWriter.applyInfo(entry, entryInformation);
        DebianPackageWriter.applyTimestamp(entry, timestampSupplier);
        this.dataStream.putArchiveEntry((ArchiveEntry)entry);
        this.dataStream.closeArchiveEntry();
        this.paths.add(path);
    }

    private static void applyTimestamp(TarArchiveEntry entry, Optional<Supplier<Instant>> timestampSupplier) {
        timestampSupplier.map(Supplier::get).map(Instant::toEpochMilli).ifPresent(arg_0 -> ((TarArchiveEntry)entry).setModTime(arg_0));
    }

    private static void applyInfo(TarArchiveEntry entry, EntryInformation entryInformation) {
        if (entryInformation == null) {
            return;
        }
        if (entryInformation.getUser() != null) {
            entry.setUserName(entryInformation.getUser());
        }
        if (entryInformation.getGroup() != null) {
            entry.setGroupName(entryInformation.getGroup());
        }
        entry.setMode(entryInformation.getMode());
    }

    private void checkCreateParents(String fileName, Optional<Supplier<Instant>> timestampSupplier) throws IOException {
        String[] toks = fileName.split("/+");
        String current = "";
        for (int i = 0; i < toks.length - 1; ++i) {
            if (toks[i].isEmpty() || this.paths.contains(current = current + toks[i] + "/")) continue;
            this.internalAddDirectory(current, EntryInformation.DEFAULT_DIRECTORY, timestampSupplier);
        }
    }

    private void recordChecksum(String fileName, byte[] bs) {
        this.checkSums.put(fileName, Hex.toHexString((byte[])bs));
    }

    @Override
    public void close() throws IOException {
        try {
            try {
                this.buildAndAddControlFile(this.timestampSupplier);
                this.dataStream.close();
                this.addArFile(this.dataTemp, "data.tar.gz", this.timestampSupplier);
            }
            finally {
                this.ar.close();
            }
        }
        finally {
            this.dataTemp.delete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void buildAndAddControlFile(Supplier<Instant> timestampSupplier) throws IOException, FileNotFoundException {
        File controlFile = File.createTempFile("control", null);
        try {
            try (GZIPOutputStream gout = new GZIPOutputStream(new FileOutputStream(controlFile));
                 TarArchiveOutputStream tout = new TarArchiveOutputStream((OutputStream)gout);){
                tout.setLongFileMode(2);
                this.addControlContent(tout, "control", this.createControlContent(), -1, timestampSupplier);
                this.addControlContent(tout, "md5sums", this.createChecksumContent(), -1, timestampSupplier);
                this.addControlContent(tout, "conffiles", this.createConfFilesContent(), -1, timestampSupplier);
                this.addControlContent(tout, "preinst", this.preinstScript, EntryInformation.DEFAULT_FILE_EXEC.getMode(), timestampSupplier);
                this.addControlContent(tout, "prerm", this.prermScript, EntryInformation.DEFAULT_FILE_EXEC.getMode(), timestampSupplier);
                this.addControlContent(tout, "postinst", this.postinstScript, EntryInformation.DEFAULT_FILE_EXEC.getMode(), timestampSupplier);
                this.addControlContent(tout, "postrm", this.postrmScript, EntryInformation.DEFAULT_FILE_EXEC.getMode(), timestampSupplier);
            }
            this.addArFile(controlFile, "control.tar.gz", timestampSupplier);
        }
        finally {
            controlFile.delete();
        }
    }

    private void addControlContent(TarArchiveOutputStream out, String name, ContentProvider content, int mode, Supplier<Instant> timestampSupplier) throws IOException {
        if (content == null || !content.hasContent()) {
            return;
        }
        TarArchiveEntry entry = new TarArchiveEntry(name);
        if (mode >= 0) {
            entry.setMode(mode);
        }
        entry.setUserName("root");
        entry.setGroupName("root");
        entry.setSize(content.getSize());
        entry.setModTime(timestampSupplier.get().toEpochMilli());
        out.putArchiveEntry((ArchiveEntry)entry);
        try (InputStream stream = content.createInputStream();){
            ByteStreams.copy((InputStream)stream, (OutputStream)out);
        }
        out.closeArchiveEntry();
    }

    protected ContentProvider createControlContent() throws IOException {
        this.packageControlFile.set("Installed-Size", Long.toString(this.installedSize));
        StringWriter sw = new StringWriter();
        ControlFileWriter writer = new ControlFileWriter(sw, BinaryPackageControlFile.FORMATTERS);
        writer.writeEntries(this.packageControlFile.getValues());
        sw.close();
        return new StaticContentProvider(sw.toString());
    }

    protected ContentProvider createChecksumContent() throws IOException {
        if (this.checkSums.isEmpty()) {
            return ContentProvider.NULL_CONTENT;
        }
        StringWriter sw = new StringWriter();
        for (Map.Entry<String, String> entry : this.checkSums.entrySet()) {
            String filename = entry.getKey().substring(2);
            sw.append(entry.getValue());
            sw.append("  ");
            sw.append(filename);
            sw.append('\n');
        }
        sw.close();
        return new StaticContentProvider(sw.toString());
    }

    protected ContentProvider createConfFilesContent() throws IOException {
        if (this.confFiles.isEmpty()) {
            return ContentProvider.NULL_CONTENT;
        }
        StringWriter sw = new StringWriter();
        for (String confFile : this.confFiles) {
            sw.append(confFile).append('\n');
        }
        sw.close();
        return new StaticContentProvider(sw.toString());
    }

    private void addArFile(File file, String entryName, Supplier<Instant> timestampSupplier) throws IOException {
        ArArchiveEntry entry = new ArArchiveEntry(entryName, file.length(), 0, 0, 33188, timestampSupplier.get().getEpochSecond());
        this.ar.putArchiveEntry((ArchiveEntry)entry);
        Files.copy(file.toPath(), (OutputStream)this.ar);
        this.ar.closeArchiveEntry();
    }

    public void setPostinstScript(ContentProvider postinstScript) {
        this.postinstScript = postinstScript;
    }

    public void setPostrmScript(ContentProvider postrmScript) {
        this.postrmScript = postrmScript;
    }

    public void setPreinstScript(ContentProvider preinstScript) {
        this.preinstScript = preinstScript;
    }

    public void setPrermScript(ContentProvider prermScript) {
        this.prermScript = prermScript;
    }
}

