/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.packager.deb;

import com.google.common.io.BaseEncoding;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.List;
import java.util.Map;
import java.util.zip.GZIPInputStream;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.ar.ArArchiveInputStream;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveInputStream;
import org.eclipse.packager.deb.ControlFileParser;
import org.eclipse.packager.deb.ControlFileWriter;
import org.eclipse.packager.deb.FieldFormatter;
import org.eclipse.packager.deb.ParserException;
import org.eclipse.packager.deb.internal.BinarySectionPackagesFile;

public final class Packages {
    private static final MessageDigest MD5;

    private Packages() {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Map<String, String> parseControlFile(File packageFile) throws IOException, ParserException {
        try (ArArchiveInputStream in = new ArArchiveInputStream((InputStream)new FileInputStream(packageFile));){
            ArchiveEntry ar;
            block23: while ((ar = in.getNextEntry()) != null) {
                if (!ar.getName().equals("control.tar.gz")) continue;
                TarArchiveInputStream inputStream = new TarArchiveInputStream((InputStream)new GZIPInputStream((InputStream)in));
                Throwable throwable = null;
                try {
                    String name;
                    do {
                        TarArchiveEntry te;
                        if ((te = inputStream.getNextTarEntry()) == null) continue block23;
                        name = te.getName();
                        if (!name.startsWith("./")) continue;
                        name = name.substring(2);
                    } while (!name.equals("control"));
                    Map<String, String> map = Packages.parseControlFile((InputStream)inputStream);
                    return map;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (inputStream == null) continue;
                    if (throwable != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    inputStream.close();
                }
            }
            return null;
        }
    }

    public static Map<String, String> parseControlFile(InputStream inputStream) throws IOException, ParserException {
        return ControlFileParser.parse(inputStream);
    }

    public static List<Map<String, String>> parseStatusFile(InputStream inputStream) throws IOException, ParserException {
        return ControlFileParser.parseMulti(inputStream);
    }

    public static void writeBinaryPackageValues(PrintWriter writer, Map<String, String> values) throws IOException {
        new ControlFileWriter(writer, BinarySectionPackagesFile.FORMATTERS).writeEntries(values);
    }

    public static String makeDescriptionMd5(String string) {
        if (string == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        try {
            FieldFormatter.MULTI.appendValue(string, sb);
            sb.append('\n');
        }
        catch (IOException iOException) {
            // empty catch block
        }
        String result = sb.toString();
        byte[] data = MD5.digest(result.getBytes(StandardCharsets.UTF_8));
        return BaseEncoding.base16().encode(data).toLowerCase();
    }

    static {
        try {
            MD5 = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
    }
}

