/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.wsdl.ui.internal.text;

import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.wsdl.Definition;
import org.eclipse.wst.wsdl.internal.impl.DefinitionImpl;
import org.eclipse.wst.wsdl.internal.impl.WSDLElementImpl;
import org.eclipse.wst.wsdl.internal.impl.XSDSchemaExtensibilityElementImpl;
import org.eclipse.wst.wsdl.ui.internal.util.WSDLEditorUtil;
import org.eclipse.wst.xsd.ui.internal.util.ModelReconcileAdapter;
import org.eclipse.xsd.XSDConcreteComponent;
import org.eclipse.xsd.impl.XSDSchemaImpl;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

class WSDLModelReconcileAdapter
extends ModelReconcileAdapter {
    protected Definition definition;

    public WSDLModelReconcileAdapter(Document document, Definition definition) {
        super(document);
        this.definition = definition;
    }

    private Element getDefinitionElement(Document document) {
        Element definitionElement = null;
        Node node = document.getFirstChild();
        while (node != null) {
            if (node.getNodeType() == 1) {
                Element element = (Element)node;
                if (WSDLEditorUtil.getInstance().getWSDLType(element) == 1) {
                    definitionElement = element;
                    break;
                }
            }
            node = node.getNextSibling();
        }
        return definitionElement;
    }

    protected void handleNodeChanged(Node node) {
        if (node instanceof Element) {
            this.reconcileModelObjectForElement((Element)node);
        } else if (node instanceof Document) {
            Document document = (Document)node;
            Element definitionElement = this.getDefinitionElement(document);
            if (definitionElement != null && definitionElement != this.definition.getElement()) {
                if (definitionElement.getLocalName().equals("definitions")) {
                    this.definition.setElement(definitionElement);
                }
            } else if (definitionElement != null) {
                ((DefinitionImpl)this.definition).elementChanged(definitionElement);
            } else if (definitionElement == null) {
                ((DefinitionImpl)this.definition).removeAll();
                this.definition.getNamespaces().clear();
                this.definition.setQName(null);
                this.definition.setTargetNamespace(null);
                this.definition.setDocument(document);
            }
        }
    }

    private void reconcileModelObjectForElement(Element element) {
        Object modelObject = WSDLEditorUtil.getInstance().findModelObjectForElement(this.definition, element);
        if (modelObject != null) {
            if (modelObject instanceof XSDSchemaExtensibilityElementImpl) {
                XSDSchemaExtensibilityElementImpl ee = (XSDSchemaExtensibilityElementImpl)modelObject;
                ((XSDSchemaImpl)ee.getSchema()).elementChanged(element);
                ee.elementChanged(element);
            } else if (modelObject instanceof WSDLElementImpl) {
                ((WSDLElementImpl)modelObject).elementChanged(element);
            } else if (modelObject instanceof XSDConcreteComponent) {
                ((XSDConcreteComponent)modelObject).elementChanged(element);
            }
        }
    }

    protected void reconcileModelObjectForElement(Element element, int eventType, Object feature, Object oldValue, Object newValue, int index) {
        this.reconcileModelObjectForElement(element);
    }

    public void modelDirtyStateChanged(IStructuredModel model, boolean isDirty) {
        if (!isDirty) {
            ((DefinitionImpl)this.definition).reconcileReferences(true);
        }
    }
}

