/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.server.ui.internal.view.servers;

import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;

public class ServerViewerComparator
extends ViewerComparator {
    public static final int MAX_DEPTH = 3;
    public static final int ASCENDING = 1;
    public static final int DESCENDING = -1;
    protected ITableLabelProvider labelProvider;
    protected int[] priorities = new int[1];
    protected int[] directions = new int[]{1};

    public ServerViewerComparator(ITableLabelProvider labelProvider) {
        this.labelProvider = labelProvider;
    }

    public void setTopPriority(int priority) {
        if (this.priorities[0] == priority) {
            return;
        }
        int len = this.priorities.length + 1;
        if (len > 3) {
            len = 3;
        }
        int[] temp = new int[len];
        System.arraycopy(this.priorities, 0, temp, 1, len - 1);
        temp[0] = priority;
        this.priorities = temp;
        temp = new int[len];
        System.arraycopy(this.directions, 0, temp, 1, len - 1);
        temp[0] = 1;
        this.directions = temp;
    }

    public int getTopPriority() {
        return this.priorities[0];
    }

    public void setTopPriorityDirection(int direction) {
        if (direction == 1 || direction == -1) {
            this.directions[0] = direction;
        }
    }

    public int getTopPriorityDirection() {
        return this.directions[0];
    }

    public void reverseTopPriority() {
        this.directions[0] = this.directions[0] * -1;
    }

    public int compare(Viewer viewer, Object e1, Object e2, int a) {
        String s2;
        int col = this.priorities[a];
        String s1 = this.labelProvider.getColumnText(e1, col);
        int s = s1.compareToIgnoreCase(s2 = this.labelProvider.getColumnText(e2, col)) * this.directions[a];
        if (s == 0) {
            if (a == this.priorities.length - 1) {
                return 0;
            }
            return this.compare(viewer, e1, e2, a + 1);
        }
        return s;
    }

    public int compare(Viewer viewer, Object e1, Object e2) {
        return this.compare(viewer, e1, e2, 0);
    }
}

