/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.server.ui.internal.extension;

import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.update.core.ICategory;
import org.eclipse.update.core.IFeature;
import org.eclipse.update.core.ISite;
import org.eclipse.update.core.ISiteFeatureReference;
import org.eclipse.wst.server.core.internal.IMemento;
import org.eclipse.wst.server.core.internal.InstallableRuntime;
import org.eclipse.wst.server.ui.internal.ProgressUtil;

public class ExtensionSite {
    private IMemento memento;
    private List featureList;

    public ExtensionSite(IMemento memento) {
        this.memento = memento;
    }

    public String getUrl() {
        return this.memento.getString("url");
    }

    protected static boolean hasCategory(ISiteFeatureReference ref, String category) {
        ICategory[] cat = ref.getCategories();
        if (cat == null) {
            return false;
        }
        int size = cat.length;
        int i = 0;
        while (i < size) {
            if (category.equals(cat[i].getName())) {
                return true;
            }
            ++i;
        }
        return false;
    }

    protected static boolean matches(String a, String b) {
        if (a == null || "*".equals(a)) {
            return true;
        }
        if (b == null) {
            return false;
        }
        StringTokenizer st = new StringTokenizer(a, ",");
        while (st.hasMoreTokens()) {
            String c = st.nextToken().trim();
            if (!b.equals(c)) continue;
            return true;
        }
        return false;
    }

    public synchronized List getFeatures(String category, IProgressMonitor monitor) throws CoreException {
        if (this.featureList != null) {
            return this.featureList;
        }
        String fromSite = this.getUrl();
        ArrayList<IFeature> list = new ArrayList<IFeature>();
        if (fromSite == null) {
            return list;
        }
        monitor.beginTask("Searching " + fromSite, 100);
        ISite site = InstallableRuntime.getSite((String)fromSite, (IProgressMonitor)ProgressUtil.getSubMonitorFor(monitor, 5));
        if (site == null) {
            return list;
        }
        ISiteFeatureReference[] featureRefs = site.getFeatureReferences();
        int i = 0;
        while (i < featureRefs.length) {
            IFeature feature2;
            if (ExtensionSite.hasCategory(featureRefs[i], category) && ExtensionSite.matches(featureRefs[i].getOS(), Platform.getOS()) && ExtensionSite.matches(featureRefs[i].getOSArch(), Platform.getOSArch()) && ExtensionSite.matches(featureRefs[i].getWS(), Platform.getWS()) && (feature2 = featureRefs[i].getFeature(ProgressUtil.getSubMonitorFor(monitor, 5))) != null) {
                list.add(feature2);
            }
            ++i;
        }
        monitor.done();
        this.featureList = list;
        return this.featureList;
    }

    public String toString() {
        return "ExtensionSite[" + this.getUrl() + "]";
    }
}

