/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.server.http.ui.internal;

import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.eclipse.wst.server.http.ui.internal.Trace;
import org.osgi.framework.BundleContext;

public class HttpUIPlugin
extends AbstractUIPlugin {
    public static final String PLUGIN_ID = "org.eclipse.wst.server.http.ui";
    private Map imageDescriptors = new HashMap();
    private static URL ICON_BASE_URL;
    private static final String URL_WIZBAN = "wizban/";
    public static final String IMG_WIZ_SERVER = "wizServer";
    private static HttpUIPlugin plugin;

    public HttpUIPlugin() {
        plugin = this;
    }

    public static HttpUIPlugin getInstance() {
        return plugin;
    }

    protected ImageRegistry createImageRegistry() {
        ImageRegistry registry = new ImageRegistry();
        this.registerImage(registry, IMG_WIZ_SERVER, "wizban/server_wiz.gif");
        return registry;
    }

    public static Image getImage(String key) {
        return HttpUIPlugin.getInstance().getImageRegistry().get(key);
    }

    public static ImageDescriptor getImageDescriptor(String key) {
        try {
            HttpUIPlugin.getInstance().getImageRegistry();
            return (ImageDescriptor)HttpUIPlugin.getInstance().imageDescriptors.get(key);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public void stop(BundleContext context) throws Exception {
        plugin = null;
        super.stop(context);
    }

    private void registerImage(ImageRegistry registry, String key, String partialURL) {
        if (ICON_BASE_URL == null) {
            String pathSuffix = "icons/";
            ICON_BASE_URL = plugin.getBundle().getEntry(pathSuffix);
        }
        try {
            ImageDescriptor id = ImageDescriptor.createFromURL((URL)new URL(ICON_BASE_URL, partialURL));
            registry.put(key, id);
            this.imageDescriptors.put(key, id);
        }
        catch (Exception e) {
            Trace.trace(Trace.WARNING, "Error registering image", e);
        }
    }
}

