/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.common.project.facet.ui.internal;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.eclipse.draw2d.AbsoluteBendpoint;
import org.eclipse.draw2d.AbstractBorder;
import org.eclipse.draw2d.AbstractLayout;
import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.ChopboxAnchor;
import org.eclipse.draw2d.CompoundBorder;
import org.eclipse.draw2d.ConnectionAnchor;
import org.eclipse.draw2d.Ellipse;
import org.eclipse.draw2d.EllipseAnchor;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.LightweightSystem;
import org.eclipse.draw2d.LineBorder;
import org.eclipse.draw2d.MarginBorder;
import org.eclipse.draw2d.PolylineConnection;
import org.eclipse.draw2d.StackLayout;
import org.eclipse.draw2d.ToolbarLayout;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.graph.DirectedGraph;
import org.eclipse.draw2d.graph.DirectedGraphLayout;
import org.eclipse.draw2d.graph.Edge;
import org.eclipse.draw2d.graph.Node;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.wst.common.project.facet.core.IConstraint;
import org.eclipse.wst.common.project.facet.core.IGroup;
import org.eclipse.wst.common.project.facet.core.IProjectFacet;
import org.eclipse.wst.common.project.facet.core.IVersionExpr;

public final class ConstraintDisplayDialog
extends Dialog {
    private static final Font BOLD_FONT;
    private final IConstraint constraint;
    private final Point location;
    private int width;
    private int height;

    static {
        FontData sys = Display.getCurrent().getSystemFont().getFontData()[0];
        FontData bold = new FontData(sys.getName(), sys.getHeight(), 1);
        BOLD_FONT = new Font((Device)Display.getCurrent(), bold);
    }

    protected ConstraintDisplayDialog(Shell parentShell, Point location, IConstraint constraint) {
        super(parentShell);
        this.setShellStyle(0x10000 | ConstraintDisplayDialog.getDefaultOrientation());
        this.constraint = constraint;
        this.location = location;
    }

    protected Control createDialogArea(Composite parent) {
        Canvas canvas = new Canvas(parent, 0);
        canvas.setLayoutData((Object)new GridData(4, 4, true, true));
        Color infoBackgroundColor = parent.getDisplay().getSystemColor(29);
        canvas.setBackground(infoBackgroundColor);
        LightweightSystem lws = new LightweightSystem(canvas);
        Figure outer = new Figure();
        outer.setLayoutManager((LayoutManager)new ToolbarLayout());
        lws.setContents((IFigure)outer);
        Figure contents = new Figure();
        contents.setBorder((Border)new MarginBorder(10));
        outer.add((IFigure)contents);
        this.createConstraintGraph((IFigure)contents, null, this.constraint);
        contents.setLayoutManager((LayoutManager)new GraphLayoutManager());
        Label escLabel = new Label(Resources.pressEscToClose);
        escLabel.setLabelAlignment(4);
        escLabel.setBorder((Border)new CompoundBorder((Border)new DividerBorder(2), (Border)new MarginBorder(2)));
        outer.add((IFigure)escLabel);
        Dimension size = outer.getPreferredSize();
        this.width = size.width < 200 ? 200 : size.width;
        this.height = size.height;
        return canvas;
    }

    protected Control createButtonBar(Composite parent) {
        return null;
    }

    protected Point getInitialLocation(Point size) {
        return this.location;
    }

    protected Point getInitialSize() {
        return new Point(this.width, this.height);
    }

    private void createConstraintGraph(IFigure container, PolylineConnection parentCon, IConstraint constraint) {
        if (constraint.getType() == IConstraint.Type.AND || constraint.getType() == IConstraint.Type.OR) {
            if (constraint.getOperands().size() == 1) {
                IConstraint child = (IConstraint)constraint.getOperand(0);
                this.createConstraintGraph(container, parentCon, child);
            } else {
                AndOrConstraintFigure node = new AndOrConstraintFigure(constraint);
                container.add((IFigure)node);
                if (parentCon != null) {
                    parentCon.setTargetAnchor((ConnectionAnchor)new EllipseAnchor((IFigure)node));
                }
                for (Object operand : constraint.getOperands()) {
                    IConstraint child = (IConstraint)operand;
                    PolylineConnection childEdge = new PolylineConnection();
                    container.add((IFigure)childEdge);
                    childEdge.setSourceAnchor((ConnectionAnchor)new EllipseAnchor((IFigure)node));
                    this.createConstraintGraph(container, childEdge, child);
                }
            }
        } else if (constraint.getType() == IConstraint.Type.REQUIRES) {
            RequiresConstraintFigure node = new RequiresConstraintFigure(constraint);
            container.add((IFigure)node);
            if (parentCon != null) {
                parentCon.setTargetAnchor((ConnectionAnchor)new ChopboxAnchor((IFigure)node));
            }
        } else if (constraint.getType() == IConstraint.Type.CONFLICTS) {
            ConflictsConstraintFigure node = new ConflictsConstraintFigure(constraint);
            container.add((IFigure)node);
            if (parentCon != null) {
                parentCon.setTargetAnchor((ConnectionAnchor)new ChopboxAnchor((IFigure)node));
            }
        } else {
            throw new IllegalStateException();
        }
    }

    private static final class AndOrConstraintFigure
    extends Figure {
        public AndOrConstraintFigure(IConstraint constraint) {
            Color background;
            String labelText;
            this.setLayoutManager((LayoutManager)new StackLayout());
            if (constraint.getType() == IConstraint.Type.AND) {
                labelText = Resources.andOperator;
                background = new Color(null, 0, 175, 0);
            } else if (constraint.getType() == IConstraint.Type.OR) {
                labelText = Resources.orOperator;
                background = new Color(null, 255, 128, 0);
            } else {
                throw new IllegalStateException();
            }
            Ellipse circle = new Ellipse();
            circle.setOpaque(true);
            circle.setBackgroundColor(background);
            this.add((IFigure)circle);
            Label label = new Label();
            label.setFont(BOLD_FONT);
            label.setText(labelText);
            this.add((IFigure)label);
        }

        public Dimension getPreferredSize(int wHint, int hHint) {
            return new Dimension(35, 35);
        }
    }

    private static final class ConflictsConstraintFigure
    extends Figure {
        public ConflictsConstraintFigure(IConstraint constraint) {
            this.setLayoutManager((LayoutManager)new ToolbarLayout());
            this.setBorder((Border)new LineBorder(1));
            this.setOpaque(true);
            this.setBackgroundColor(new Color(null, 255, 255, 255));
            Label headerLabel = new Label();
            headerLabel.setFont(BOLD_FONT);
            headerLabel.setBorder((Border)new MarginBorder(2));
            this.add((IFigure)headerLabel);
            StringBuffer bodyLabelText = new StringBuffer();
            Object firstOperand = constraint.getOperand(0);
            if (firstOperand instanceof IGroup) {
                headerLabel.setText(Resources.conflictsWithGroupOperator);
                bodyLabelText.append(((IGroup)firstOperand).getId());
            } else {
                headerLabel.setText(Resources.conflictsWithFacetOperator);
                IProjectFacet f = (IProjectFacet)firstOperand;
                bodyLabelText.append(f.getLabel());
                if (constraint.getOperands().size() == 2) {
                    IVersionExpr vexpr = (IVersionExpr)constraint.getOperand(1);
                    bodyLabelText.append(' ');
                    bodyLabelText.append(vexpr.toDisplayString());
                }
            }
            Label bodyLabel = new Label();
            bodyLabel.setText(bodyLabelText.toString());
            bodyLabel.setBorder((Border)new CompoundBorder((Border)new DividerBorder(1), (Border)new MarginBorder(2)));
            this.add((IFigure)bodyLabel);
        }
    }

    private static final class DashedLineBorder
    extends LineBorder {
        public DashedLineBorder() {
            super(1);
        }

        public void paint(IFigure figure, Graphics graphics, Insets insets) {
            graphics.setLineStyle(2);
            super.paint(figure, graphics, insets);
            graphics.setLineStyle(1);
        }
    }

    private static final class DividerBorder
    extends AbstractBorder {
        private final int lines;
        private final Insets insets;

        public DividerBorder(int lines) {
            this.lines = lines;
            this.insets = new Insets(1 + (this.lines - 1) * 2);
        }

        public Insets getInsets(IFigure figure) {
            return this.insets;
        }

        public void paint(IFigure figure, Graphics graphics, Insets insets) {
            Rectangle paintRectangle = DividerBorder.getPaintRectangle((IFigure)figure, (Insets)insets);
            int xLeft = paintRectangle.getTopLeft().x;
            int xRight = paintRectangle.getTopRight().x;
            int y = paintRectangle.getTopLeft().y;
            int i = 0;
            while (i < this.lines) {
                graphics.drawLine(xLeft, y, xRight, y);
                ++i;
                y += 2;
            }
        }
    }

    private static final class GraphLayoutManager
    extends AbstractLayout {
        private int laidout = 0;

        private GraphLayoutManager() {
        }

        protected Dimension calculatePreferredSize(IFigure container, int wHint, int hHint) {
            container.validate();
            List children = container.getChildren();
            Rectangle result = new Rectangle().setLocation(container.getClientArea().getLocation());
            int i = 0;
            while (i < children.size()) {
                result.union(((IFigure)children.get(i)).getBounds());
                ++i;
            }
            result.resize(container.getInsets().getWidth() + 2, container.getInsets().getHeight() + 2);
            return result.getSize();
        }

        public void layout(IFigure container) {
            if (this.laidout > 5) {
                return;
            }
            DirectedGraph graph = new DirectedGraph();
            HashMap<IFigure, Node> nodes = new HashMap<IFigure, Node>();
            for (Object child : container.getChildren()) {
                IFigure childFigure = (IFigure)child;
                if (childFigure instanceof PolylineConnection) continue;
                Node node = new Node((Object)childFigure);
                Dimension size = childFigure.getPreferredSize();
                node.height = size.height;
                node.width = size.width;
                graph.nodes.add((Object)node);
                nodes.put(childFigure, node);
            }
            for (Object child : container.getChildren()) {
                if (!(child instanceof PolylineConnection)) continue;
                PolylineConnection cn = (PolylineConnection)child;
                IFigure source = cn.getSourceAnchor().getOwner();
                Node sourceNode = (Node)nodes.get(source);
                IFigure target = cn.getTargetAnchor().getOwner();
                Node targetNode = (Node)nodes.get(target);
                Edge edge = new Edge((Object)cn, sourceNode, targetNode);
                graph.edges.add((Object)edge);
            }
            new DirectedGraphLayout().visit(graph);
            for (Object obj : graph.nodes) {
                Node node = (Node)obj;
                IFigure figure = (IFigure)node.data;
                Rectangle bounds = new Rectangle(node.x + 10, node.y - 6, figure.getPreferredSize().width, figure.getPreferredSize().height);
                figure.setBounds(bounds);
            }
            for (Object obj : graph.edges) {
                Edge edge = (Edge)obj;
                PolylineConnection cn = (PolylineConnection)edge.data;
                if (edge.vNodes == null) {
                    cn.setRoutingConstraint((Object)Collections.EMPTY_LIST);
                    continue;
                }
                ArrayList<AbsoluteBendpoint> bends = new ArrayList<AbsoluteBendpoint>();
                for (Object obj2 : edge.vNodes) {
                    Node vn = (Node)obj2;
                    if (edge.isFeedback()) {
                        bends.add(new AbsoluteBendpoint(vn.x, vn.y + vn.height));
                        bends.add(new AbsoluteBendpoint(vn.x, vn.y));
                        continue;
                    }
                    bends.add(new AbsoluteBendpoint(vn.x, vn.y));
                    bends.add(new AbsoluteBendpoint(vn.x, vn.y + vn.height));
                }
                cn.setRoutingConstraint(bends);
            }
            ++this.laidout;
        }
    }

    private static final class RequiresConstraintFigure
    extends Figure {
        public RequiresConstraintFigure(IConstraint constraint) {
            Boolean soft = (Boolean)constraint.getOperand(constraint.getOperands().size() - 1);
            this.setLayoutManager((LayoutManager)new ToolbarLayout());
            this.setBackgroundColor(new Color(null, 255, 255, 255));
            this.setOpaque(true);
            this.setBorder((Border)(soft != false ? new DashedLineBorder() : new LineBorder(1)));
            Label headerLabel = new Label();
            headerLabel.setFont(BOLD_FONT);
            headerLabel.setBorder((Border)new MarginBorder(2));
            this.add((IFigure)headerLabel);
            StringBuffer bodyLabelText = new StringBuffer();
            Object firstOperand = constraint.getOperand(0);
            if (firstOperand instanceof IGroup) {
                IGroup group = (IGroup)firstOperand;
                headerLabel.setText(Resources.requiresGroupMemberOperator);
                bodyLabelText.append(group.toString());
            } else {
                IProjectFacet f = (IProjectFacet)firstOperand;
                IVersionExpr vexpr = (IVersionExpr)constraint.getOperand(1);
                headerLabel.setText(Resources.requiresFacetOperator);
                bodyLabelText.append(f.getLabel());
                if (!vexpr.toString().equals("*")) {
                    bodyLabelText.append(' ');
                    bodyLabelText.append(vexpr.toDisplayString());
                }
            }
            Label bodyLabel = new Label();
            bodyLabel.setText(bodyLabelText.toString());
            bodyLabel.setBorder((Border)new CompoundBorder((Border)new DividerBorder(1), (Border)new MarginBorder(2)));
            this.add((IFigure)bodyLabel);
        }
    }

    private static final class Resources
    extends NLS {
        public static String pressEscToClose;
        public static String andOperator;
        public static String orOperator;
        public static String requiresFacetOperator;
        public static String requiresGroupMemberOperator;
        public static String conflictsWithGroupOperator;
        public static String conflictsWithFacetOperator;

        static {
            Resources.initializeMessages((String)ConstraintDisplayDialog.class.getName(), Resources.class);
        }

        private Resources() {
        }
    }
}

