/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.common.project.facet.ui;

import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.dialogs.WizardNewProjectCreationPage;
import org.eclipse.wst.common.project.facet.core.IFacetedProjectTemplate;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;
import org.eclipse.wst.common.project.facet.ui.ModifyFacetedProjectWizard;

public abstract class FacetedProjectWizard
extends ModifyFacetedProjectWizard
implements INewWizard {
    private final IFacetedProjectTemplate template = this.getTemplate();
    private WizardNewProjectCreationPage firstPage;
    private String projectName;
    private IPath customPath;

    public FacetedProjectWizard() {
        super(null);
        this.setWindowTitle(String.valueOf(Resources.newPrefix) + this.template.getLabel());
        ImageDescriptor defImageDescriptor = this.getDefaultPageImageDescriptor();
        if (defImageDescriptor != null) {
            this.setDefaultPageImageDescriptor(defImageDescriptor);
        }
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
    }

    public void addPages() {
        this.firstPage = new WizardNewProjectCreationPage("first.page");
        this.firstPage.setTitle(this.template.getLabel());
        this.firstPage.setDescription(this.getPageDescription());
        this.addPage((IWizardPage)this.firstPage);
        super.addPages();
        this.facetsSelectionPage.setInitialPreset(this.template.getInitialPreset());
        Set fixed = this.template.getFixedProjectFacets();
        this.facetsSelectionPage.setFixedProjectFacets(fixed);
    }

    public boolean canFinish() {
        return this.firstPage.isPageComplete() && super.canFinish();
    }

    public IWizardPage[] getPages() {
        IWizardPage[] base = super.getPages();
        IWizardPage[] pages = new IWizardPage[base.length + 1];
        pages[0] = this.firstPage;
        System.arraycopy(base, 0, pages, 1, base.length);
        return pages;
    }

    public synchronized boolean performFinish() {
        this.projectName = this.firstPage.getProjectName();
        this.customPath = this.firstPage.useDefaults() ? null : this.firstPage.getLocationPath();
        return super.performFinish();
    }

    protected void performFinish(IProgressMonitor monitor) throws CoreException {
        this.fproj = ProjectFacetsManager.create((String)this.projectName, (IPath)this.customPath, (IProgressMonitor)monitor);
        super.performFinish(monitor);
        Set fixed = this.template.getFixedProjectFacets();
        this.fproj.setFixedProjectFacets(fixed);
    }

    public synchronized String getProjectName() {
        if (this.fproj == null) {
            return this.firstPage.getProjectName();
        }
        return this.fproj.getProject().getName();
    }

    protected abstract IFacetedProjectTemplate getTemplate();

    protected abstract String getPageDescription();

    protected abstract ImageDescriptor getDefaultPageImageDescriptor();

    private static final class Resources
    extends NLS {
        public static String newPrefix;

        static {
            Resources.initializeMessages((String)FacetedProjectWizard.class.getName(), Resources.class);
        }

        private Resources() {
        }
    }
}

