/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.navigator.sorters;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.ui.internal.navigator.NavigatorContentService;
import org.eclipse.ui.internal.navigator.sorters.CommonSorterDescriptor;
import org.eclipse.ui.internal.navigator.sorters.CommonSorterDescriptorManager;
import org.eclipse.ui.internal.navigator.sorters.SkeletonViewerSorter;
import org.eclipse.ui.navigator.INavigatorContentDescriptor;
import org.eclipse.ui.navigator.INavigatorSorterService;

public class NavigatorSorterService
implements INavigatorSorterService {
    private final NavigatorContentService contentService;
    private final Map sorters = new HashMap();

    public NavigatorSorterService(NavigatorContentService aContentService) {
        this.contentService = aContentService;
    }

    public ViewerSorter findSorterForParent(Object aParent) {
        CommonSorterDescriptor[] descriptors = CommonSorterDescriptorManager.getInstance().findApplicableSorters(this.contentService, aParent);
        if (descriptors.length > 0) {
            return this.getSorter(descriptors[0]);
        }
        return SkeletonViewerSorter.INSTANCE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ViewerSorter getSorter(CommonSorterDescriptor descriptor) {
        ViewerSorter sorter = (ViewerSorter)this.sorters.get(descriptor);
        if (sorter != null) {
            return sorter;
        }
        Map map = this.sorters;
        synchronized (map) {
            sorter = (ViewerSorter)this.sorters.get(descriptor);
            if (sorter == null) {
                sorter = descriptor.createSorter();
                this.sorters.put(descriptor, sorter);
            }
        }
        return sorter;
    }

    public ViewerSorter findSorter(INavigatorContentDescriptor source, Object parent, Object lvalue, Object rvalue) {
        CommonSorterDescriptor[] descriptors = CommonSorterDescriptorManager.getInstance().findApplicableSorters(this.contentService, source, parent, lvalue, rvalue);
        if (descriptors.length > 0) {
            return this.getSorter(descriptors[0]);
        }
        return null;
    }
}

