/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.views.markers.internal;

import com.ibm.icu.text.DateFormat;
import java.util.Date;
import java.util.Iterator;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.internal.ide.IDEInternalWorkbenchImages;
import org.eclipse.ui.internal.ide.IDEWorkbenchPlugin;
import org.eclipse.ui.views.markers.internal.MarkerMessages;
import org.eclipse.ui.views.markers.internal.MarkerNode;

public final class Util {
    static String EMPTY_STRING = "";
    static String TWO_LINE_FEED = "\n\n";
    static String LINE_FEED_AND_TAB = "\n\t";
    private static DateFormat format;
    static final MarkerNode[] EMPTY_MARKER_ARRAY;
    static final int SHORT_DELAY = 100;
    static final int LONG_DELAY = 30000;

    static {
        EMPTY_MARKER_ARRAY = new MarkerNode[0];
    }

    public static String getProperty(String property, IMarker marker) {
        if (marker == null || !marker.exists()) {
            return EMPTY_STRING;
        }
        try {
            Object obj = marker.getAttribute(property);
            if (obj != null) {
                return obj.toString();
            }
            return EMPTY_STRING;
        }
        catch (CoreException e) {
            Util.log(e);
            return EMPTY_STRING;
        }
    }

    public static String getCreationTime(long timestamp) {
        if (format == null) {
            format = DateFormat.getDateTimeInstance((int)1, (int)2);
        }
        return format.format(new Date(timestamp));
    }

    public static String getCreationTime(IMarker marker) {
        try {
            return Util.getCreationTime(marker.getCreationTime());
        }
        catch (CoreException e) {
            Util.log(e);
            return EMPTY_STRING;
        }
    }

    public static String getContainerName(IMarker marker) {
        if (!marker.exists()) {
            return EMPTY_STRING;
        }
        try {
            Object pathAttribute = marker.getAttribute("org.eclipse.ui.views.markers.path");
            if (pathAttribute != null) {
                return pathAttribute.toString();
            }
        }
        catch (CoreException exception) {
            Util.log(exception);
        }
        IPath path = marker.getResource().getFullPath();
        int n = path.segmentCount() - 1;
        if (n <= 0) {
            return EMPTY_STRING;
        }
        int len = 0;
        int i = 0;
        while (i < n) {
            len += path.segment(i).length();
            ++i;
        }
        if (n > 1) {
            len += n - 1;
        }
        StringBuffer sb = new StringBuffer(len);
        int i2 = 0;
        while (i2 < n) {
            if (i2 != 0) {
                sb.append('/');
            }
            sb.append(path.segment(i2));
            ++i2;
        }
        return sb.toString();
    }

    public static void log(CoreException exception) {
        IDEWorkbenchPlugin.log(exception.getLocalizedMessage(), exception);
    }

    public static String getResourceName(IMarker marker) {
        if (!marker.exists()) {
            return EMPTY_STRING;
        }
        try {
            Object nameAttribute = marker.getAttribute("org.eclipse.ui.views.markers.name");
            if (nameAttribute != null) {
                return nameAttribute.toString();
            }
        }
        catch (CoreException exception) {
            Util.log(exception);
        }
        return marker.getResource().getName();
    }

    public static boolean isEditable(IMarker marker) {
        if (marker == null) {
            return false;
        }
        try {
            return marker.isSubtypeOf("org.eclipse.core.resources.bookmark") || marker.isSubtypeOf("org.eclipse.core.resources.taskmarker") && marker.getAttribute("userEditable", true);
        }
        catch (CoreException coreException) {
            return false;
        }
    }

    public static IStatus errorStatus(Throwable exception) {
        String message = exception.getLocalizedMessage();
        if (message == null) {
            message = EMPTY_STRING;
        }
        return new Status(4, "org.eclipse.ui.ide", 4, message, exception);
    }

    private Util() {
    }

    public static Image getImage(int severity) {
        if (severity == 2) {
            return Util.getIDEImage("IMG_OBJS_ERROR_PATH");
        }
        if (severity == 1) {
            return Util.getIDEImage("IMG_OBJS_WARNING_PATH");
        }
        if (severity == 0) {
            return Util.getIDEImage("IMG_OBJS_INFO_PATH");
        }
        return null;
    }

    private static Image getIDEImage(String constantName) {
        return JFaceResources.getResources().createImageWithDefault(IDEInternalWorkbenchImages.getImageDescriptor(constantName));
    }

    public static String getShortContainerName(IMarker marker) {
        if (!marker.exists()) {
            return EMPTY_STRING;
        }
        try {
            Object pathAttribute = marker.getAttribute("org.eclipse.ui.views.markers.path");
            if (pathAttribute != null) {
                return pathAttribute.toString();
            }
        }
        catch (CoreException exception) {
            Util.log(exception);
        }
        IResource resource = marker.getResource();
        int type = resource.getType();
        if (type == 4) {
            return resource.getName();
        }
        if (type == 8) {
            return MarkerMessages.Util_WorkspaceRoot;
        }
        String result = marker.getResource().getProjectRelativePath().removeLastSegments(1).toOSString();
        if (result.trim().length() == 0) {
            return MarkerMessages.Util_ProjectRoot;
        }
        return result;
    }

    static boolean isSingleConcreteSelection(IStructuredSelection selection) {
        Object first;
        if (selection != null && selection.size() == 1 && (first = selection.getFirstElement()) instanceof MarkerNode) {
            return ((MarkerNode)first).isConcrete();
        }
        return false;
    }

    public static boolean allConcreteSelection(IStructuredSelection selection) {
        if (selection != null && selection.size() > 0) {
            Iterator nodes = selection.iterator();
            while (nodes.hasNext()) {
                if (((MarkerNode)nodes.next()).isConcrete()) continue;
                return false;
            }
            return true;
        }
        return false;
    }
}

