/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.dialogs;

import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectNatureDescriptor;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.eclipse.ui.dialogs.SelectionStatusDialog;
import org.eclipse.ui.internal.ide.IDEWorkbenchMessages;
import org.eclipse.ui.internal.ide.IDEWorkbenchPlugin;
import org.eclipse.ui.internal.ide.dialogs.CreateLinkedResourceGroup;

public class NewFolderDialog
extends SelectionStatusDialog {
    private Text folderNameField;
    private Button advancedButton;
    private CreateLinkedResourceGroup linkedResourceGroup;
    private IContainer container;
    private boolean firstLinkCheck = true;
    private Composite linkedResourceParent;
    private Composite linkedResourceComposite;
    private int basicShellHeight = -1;

    public NewFolderDialog(Shell parentShell, IContainer container) {
        super(parentShell);
        this.container = container;
        this.setTitle(IDEWorkbenchMessages.NewFolderDialog_title);
        this.setShellStyle(this.getShellStyle() | 0x10);
        this.setStatusLineAboveButtons(true);
    }

    protected void computeResult() {
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)shell, "org.eclipse.ui.ide.new_folder_dialog");
    }

    public void create() {
        super.create();
        this.getButton(0).setEnabled(false);
    }

    protected void createAdvancedControls(Composite parent) {
        Preferences preferences = ResourcesPlugin.getPlugin().getPluginPreferences();
        if (!preferences.getBoolean("description.disableLinking") && this.isValidContainer()) {
            this.linkedResourceParent = new Composite(parent, 0);
            this.linkedResourceParent.setFont(parent.getFont());
            this.linkedResourceParent.setLayoutData((Object)new GridData(768));
            GridLayout layout = new GridLayout();
            layout.marginHeight = 0;
            layout.marginWidth = 0;
            this.linkedResourceParent.setLayout((Layout)layout);
            this.advancedButton = new Button(this.linkedResourceParent, 8);
            this.advancedButton.setFont(this.linkedResourceParent.getFont());
            this.advancedButton.setText(IDEWorkbenchMessages.showAdvanced);
            this.setButtonLayoutData(this.advancedButton);
            GridData data = (GridData)this.advancedButton.getLayoutData();
            data.horizontalAlignment = 1;
            this.advancedButton.setLayoutData((Object)data);
            this.advancedButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    NewFolderDialog.this.handleAdvancedButtonSelect();
                }
            });
        }
        this.linkedResourceGroup = new CreateLinkedResourceGroup(2, new Listener(){

            public void handleEvent(Event e) {
                NewFolderDialog.this.validateLinkedResource();
                NewFolderDialog.this.firstLinkCheck = false;
            }
        }, new CreateLinkedResourceGroup.IStringValue(){

            public void setValue(String string) {
                NewFolderDialog.this.folderNameField.setText(string);
            }

            public String getValue() {
                return NewFolderDialog.this.folderNameField.getText();
            }
        });
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        composite.setLayout((Layout)new GridLayout());
        composite.setLayoutData((Object)new GridData(1808));
        this.createFolderNameGroup(composite);
        this.createAdvancedControls(composite);
        return composite;
    }

    private void createFolderNameGroup(Composite parent) {
        Font font = parent.getFont();
        Composite folderGroup = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        folderGroup.setLayout((Layout)layout);
        folderGroup.setLayoutData((Object)new GridData(768));
        Label folderLabel = new Label(folderGroup, 0);
        folderLabel.setFont(font);
        folderLabel.setText(IDEWorkbenchMessages.NewFolderDialog_nameLabel);
        this.folderNameField = new Text(folderGroup, 2048);
        GridData data = new GridData(768);
        data.widthHint = 200;
        this.folderNameField.setLayoutData((Object)data);
        this.folderNameField.setFont(font);
        this.folderNameField.addListener(24, new Listener(){

            public void handleEvent(Event event) {
                NewFolderDialog.this.validateLinkedResource();
            }
        });
    }

    private IFolder createFolderHandle(String folderName) {
        IWorkspaceRoot workspaceRoot = this.container.getWorkspace().getRoot();
        IPath folderPath = this.container.getFullPath().append(folderName);
        IFolder folderHandle = workspaceRoot.getFolder(folderPath);
        return folderHandle;
    }

    private IFolder createNewFolder(String folderName, final URI linkTarget) {
        final IFolder folderHandle = this.createFolderHandle(folderName);
        WorkspaceModifyOperation operation = new WorkspaceModifyOperation(){

            public void execute(IProgressMonitor monitor) throws CoreException {
                try {
                    monitor.beginTask(IDEWorkbenchMessages.NewFolderDialog_progress, 2000);
                    if (monitor.isCanceled()) {
                        throw new OperationCanceledException();
                    }
                    if (linkTarget == null) {
                        folderHandle.create(false, true, monitor);
                    } else {
                        folderHandle.createLink(linkTarget, 16, monitor);
                    }
                    if (monitor.isCanceled()) {
                        throw new OperationCanceledException();
                    }
                }
                finally {
                    monitor.done();
                }
            }
        };
        try {
            PlatformUI.getWorkbench().getProgressService().busyCursorWhile((IRunnableWithProgress)operation);
        }
        catch (InterruptedException interruptedException) {
            return null;
        }
        catch (InvocationTargetException exception) {
            if (exception.getTargetException() instanceof CoreException) {
                ErrorDialog.openError((Shell)this.getShell(), (String)IDEWorkbenchMessages.NewFolderDialog_errorTitle, null, (IStatus)((CoreException)exception.getTargetException()).getStatus());
            } else {
                IDEWorkbenchPlugin.log(((Object)((Object)this)).getClass(), "createNewFolder", exception.getTargetException());
                MessageDialog.openError((Shell)this.getShell(), (String)IDEWorkbenchMessages.NewFolderDialog_errorTitle, (String)NLS.bind((String)IDEWorkbenchMessages.NewFolderDialog_internalError, (Object)exception.getTargetException().getMessage()));
            }
            return null;
        }
        return folderHandle;
    }

    protected void handleAdvancedButtonSelect() {
        Shell shell = this.getShell();
        Point shellSize = shell.getSize();
        Composite composite = (Composite)this.getDialogArea();
        if (this.linkedResourceComposite != null) {
            this.linkedResourceComposite.dispose();
            this.linkedResourceComposite = null;
            composite.layout();
            shell.setSize(shellSize.x, this.basicShellHeight);
            this.advancedButton.setText(IDEWorkbenchMessages.showAdvanced);
        } else {
            if (this.basicShellHeight == -1) {
                this.basicShellHeight = shell.computeSize((int)-1, (int)-1, (boolean)true).y;
            }
            this.linkedResourceComposite = this.linkedResourceGroup.createContents(this.linkedResourceParent);
            shellSize = shell.computeSize(-1, -1, true);
            shell.setSize(shellSize);
            composite.layout();
            this.advancedButton.setText(IDEWorkbenchMessages.hideAdvanced);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean isValidContainer() {
        if (this.container.getType() != 4 && this.container.getType() != 2) {
            return false;
        }
        try {
            IWorkspace workspace = IDEWorkbenchPlugin.getPluginWorkspace();
            IProject project = this.container.getProject();
            String[] natureIds = project.getDescription().getNatureIds();
            int i = 0;
            while (true) {
                if (i >= natureIds.length) {
                    return true;
                }
                IProjectNatureDescriptor descriptor = workspace.getNatureDescriptor(natureIds[i]);
                if (descriptor != null && !descriptor.isLinkingAllowed()) {
                    return false;
                }
                ++i;
            }
        }
        catch (CoreException coreException) {
            return false;
        }
    }

    protected void updateStatus(IStatus status) {
        if (this.firstLinkCheck && status != null) {
            Status newStatus = new Status(0, status.getPlugin(), status.getCode(), status.getMessage(), status.getException());
            super.updateStatus((IStatus)newStatus);
        } else {
            super.updateStatus(status);
        }
    }

    private void updateStatus(int severity, String message) {
        this.updateStatus((IStatus)new Status(severity, "org.eclipse.ui.ide", severity, message, null));
    }

    private void validateLinkedResource() {
        boolean valid = this.validateFolderName();
        if (valid) {
            IFolder linkHandle = this.createFolderHandle(this.folderNameField.getText());
            IStatus status = this.linkedResourceGroup.validateLinkLocation((IResource)linkHandle);
            if (status.getSeverity() != 4) {
                this.getOkButton().setEnabled(true);
            } else {
                this.getOkButton().setEnabled(false);
            }
            if (!status.isOK()) {
                this.updateStatus(status);
            }
        } else {
            this.getOkButton().setEnabled(false);
        }
    }

    private boolean validateFolderName() {
        String name = this.folderNameField.getText();
        IWorkspace workspace = this.container.getWorkspace();
        IStatus nameStatus = workspace.validateName(name, 2);
        if ("".equals(name)) {
            this.updateStatus(4, IDEWorkbenchMessages.NewFolderDialog_folderNameEmpty);
            return false;
        }
        if (!nameStatus.isOK()) {
            this.updateStatus(nameStatus);
            return false;
        }
        Path path = new Path(name);
        if (this.container.getFolder((IPath)path).exists() || this.container.getFile((IPath)path).exists()) {
            this.updateStatus(4, NLS.bind((String)IDEWorkbenchMessages.NewFolderDialog_alreadyExists, (Object)name));
            return false;
        }
        this.updateStatus(0, "");
        return true;
    }

    protected void okPressed() {
        URI linkTarget = this.linkedResourceGroup.getLinkTargetURI();
        IFolder folder = this.createNewFolder(this.folderNameField.getText(), linkTarget);
        if (folder == null) {
            return;
        }
        this.setSelectionResult(new IFolder[]{folder});
        super.okPressed();
    }
}

