/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.cheatsheets;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.net.URL;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.jface.util.SafeRunnable;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.XMLMemento;
import org.eclipse.ui.internal.cheatsheets.CheatSheetHistory;
import org.eclipse.ui.internal.cheatsheets.Messages;
import org.eclipse.ui.internal.cheatsheets.registry.CheatSheetRegistryReader;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;

public class CheatSheetPlugin
extends AbstractUIPlugin {
    public static final String PLUGIN_ID = "org.eclipse.help.base";
    static CheatSheetPlugin plugin;
    private CheatSheetHistory history = null;
    private DocumentBuilder documentBuilder = null;
    private static final String HISTORY_FILENAME = "history.xml";
    private static final String MEMENTO_TAG_CHEATSHEET = "cheatsheet";
    private static final String MEMENTO_TAG_VERSION = "version";
    private static final String[] VERSION_STRING;
    private static final String MEMENTO_TAG_CHEATSHEET_HISTORY = "cheatsheetHistory";
    public static final IPath ICONS_PATH;
    public static final String T_OBJ = "obj16/";
    public static final String T_ELCL = "elcl16/";
    public static final String T_DLCL = "dlcl16/";
    public static final String T_VIEW = "view16/";

    static {
        VERSION_STRING = new String[]{"0.0", "3.0.0"};
        ICONS_PATH = new Path("$nl$/icons/");
    }

    public static CheatSheetPlugin getPlugin() {
        return plugin;
    }

    public Image getImage(String key) {
        Image image = this.getImageRegistry().get(key);
        return image;
    }

    public CheatSheetHistory getCheatSheetHistory() {
        if (this.history == null) {
            this.history = new CheatSheetHistory(CheatSheetRegistryReader.getInstance());
            this.restoreCheatSheetHistory();
        }
        return this.history;
    }

    private File getCheatSheetStateFile(String filename) {
        IPath path = CheatSheetPlugin.getPlugin().getStateLocation();
        path = path.append(filename);
        return path.toFile();
    }

    public DocumentBuilder getDocumentBuilder() {
        if (this.documentBuilder == null) {
            try {
                this.documentBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            }
            catch (Exception e) {
                Status status = new Status(4, "org.eclipse.ui.cheatsheets", 0, Messages.ERROR_CREATING_DOCUMENT_BUILDER, (Throwable)e);
                CheatSheetPlugin.getPlugin().getLog().log((IStatus)status);
            }
        }
        return this.documentBuilder;
    }

    public static synchronized void logError(String message, Throwable ex) {
        if (message == null) {
            message = "";
        }
        Status errorStatus = new Status(4, PLUGIN_ID, 0, message, ex);
        CheatSheetPlugin.getPlugin().getLog().log((IStatus)errorStatus);
    }

    protected void initializeImageRegistry(ImageRegistry reg) {
        IPath path = ICONS_PATH.append(T_OBJ).append("cheatsheet_obj.gif");
        ImageDescriptor imageDescriptor = CheatSheetPlugin.createImageDescriptor(CheatSheetPlugin.getPlugin().getBundle(), path);
        reg.put("CHEATSHEET_OBJ", imageDescriptor);
        path = ICONS_PATH.append(T_OBJ).append("skip_status.gif");
        imageDescriptor = CheatSheetPlugin.createImageDescriptor(CheatSheetPlugin.getPlugin().getBundle(), path);
        reg.put("CHEATSHEET_ITEM_SKIP", imageDescriptor);
        path = ICONS_PATH.append(T_OBJ).append("complete_status.gif");
        imageDescriptor = CheatSheetPlugin.createImageDescriptor(CheatSheetPlugin.getPlugin().getBundle(), path);
        reg.put("CHEATSHEET_ITEM_COMPLETE", imageDescriptor);
        path = ICONS_PATH.append(T_ELCL).append("linkto_help.gif");
        imageDescriptor = CheatSheetPlugin.createImageDescriptor(CheatSheetPlugin.getPlugin().getBundle(), path);
        reg.put("CHEATSHEET_ITEM_HELP", imageDescriptor);
        path = ICONS_PATH.append(T_ELCL).append("start_cheatsheet.gif");
        imageDescriptor = CheatSheetPlugin.createImageDescriptor(CheatSheetPlugin.getPlugin().getBundle(), path);
        reg.put("CHEATSHEET_START", imageDescriptor);
        path = ICONS_PATH.append(T_ELCL).append("restart_cheatsheet.gif");
        imageDescriptor = CheatSheetPlugin.createImageDescriptor(CheatSheetPlugin.getPlugin().getBundle(), path);
        reg.put("CHEATSHEET_RESTART", imageDescriptor);
        path = ICONS_PATH.append(T_ELCL).append("start_task.gif");
        imageDescriptor = CheatSheetPlugin.createImageDescriptor(CheatSheetPlugin.getPlugin().getBundle(), path);
        reg.put("CHEATSHEET_ITEM_BUTTON_START", imageDescriptor);
        path = ICONS_PATH.append(T_ELCL).append("skip_task.gif");
        imageDescriptor = CheatSheetPlugin.createImageDescriptor(CheatSheetPlugin.getPlugin().getBundle(), path);
        reg.put("CHEATSHEET_ITEM_BUTTON_SKIP", imageDescriptor);
        path = ICONS_PATH.append(T_ELCL).append("complete_task.gif");
        imageDescriptor = CheatSheetPlugin.createImageDescriptor(CheatSheetPlugin.getPlugin().getBundle(), path);
        reg.put("CHEATSHEET_ITEM_BUTTON_COMPLETE", imageDescriptor);
        path = ICONS_PATH.append(T_ELCL).append("restart_task.gif");
        imageDescriptor = CheatSheetPlugin.createImageDescriptor(CheatSheetPlugin.getPlugin().getBundle(), path);
        reg.put("CHEATSHEET_ITEM_BUTTON_RESTART", imageDescriptor);
        path = ICONS_PATH.append(T_ELCL).append("return_to_start.gif");
        imageDescriptor = CheatSheetPlugin.createImageDescriptor(CheatSheetPlugin.getPlugin().getBundle(), path);
        reg.put("CHEATSHEET_RETURN", imageDescriptor);
        path = ICONS_PATH.append(T_OBJ).append("composite_obj.gif");
        imageDescriptor = CheatSheetPlugin.createImageDescriptor(CheatSheetPlugin.getPlugin().getBundle(), path);
        reg.put("COMPOSITE_OBJ", imageDescriptor);
        path = ICONS_PATH.append(T_OBJ).append("information.gif");
        imageDescriptor = CheatSheetPlugin.createImageDescriptor(CheatSheetPlugin.getPlugin().getBundle(), path);
        reg.put("INFORMATION", imageDescriptor);
        path = ICONS_PATH.append(T_OBJ).append("warning.gif");
        imageDescriptor = CheatSheetPlugin.createImageDescriptor(CheatSheetPlugin.getPlugin().getBundle(), path);
        reg.put("WARNING", imageDescriptor);
        path = ICONS_PATH.append(T_ELCL).append("start_ccs_task.gif");
        imageDescriptor = CheatSheetPlugin.createImageDescriptor(CheatSheetPlugin.getPlugin().getBundle(), path);
        reg.put("COMPOSITE_TASK_START", imageDescriptor);
        path = ICONS_PATH.append(T_ELCL).append("skip_ccs_task.gif");
        imageDescriptor = CheatSheetPlugin.createImageDescriptor(CheatSheetPlugin.getPlugin().getBundle(), path);
        reg.put("COMPOSITE_TASK_SKIP", imageDescriptor);
        path = ICONS_PATH.append(T_ELCL).append("review_ccs_task.gif");
        imageDescriptor = CheatSheetPlugin.createImageDescriptor(CheatSheetPlugin.getPlugin().getBundle(), path);
        reg.put("COMPOSITE_TASK_REVIEW", imageDescriptor);
        path = ICONS_PATH.append(T_ELCL).append("goto_ccs_task.gif");
        imageDescriptor = CheatSheetPlugin.createImageDescriptor(CheatSheetPlugin.getPlugin().getBundle(), path);
        reg.put("COMPOSITE_GOTO_TASK", imageDescriptor);
        path = ICONS_PATH.append(T_ELCL).append("restart_all.gif");
        imageDescriptor = CheatSheetPlugin.createImageDescriptor(CheatSheetPlugin.getPlugin().getBundle(), path);
        reg.put("COMPOSITE_RESTART_ALL", imageDescriptor);
        path = ICONS_PATH.append(T_VIEW).append("cheatsheet_view.gif");
        imageDescriptor = CheatSheetPlugin.createImageDescriptor(CheatSheetPlugin.getPlugin().getBundle(), path);
        reg.put("CHEATSHEET_VIEW", imageDescriptor);
    }

    private void restoreCheatSheetHistory() {
        SafeRunner.run((ISafeRunnable)new SafeRunnable(){

            public void run() {
                IMemento childMem;
                XMLMemento memento = CheatSheetPlugin.this.readMemento(CheatSheetPlugin.HISTORY_FILENAME);
                if (memento != null && (childMem = memento.getChild(CheatSheetPlugin.MEMENTO_TAG_CHEATSHEET_HISTORY)) != null) {
                    CheatSheetPlugin.this.history.restoreState(childMem);
                }
            }

            public void handleException(Throwable e) {
                String message = Messages.ERROR_READING_STATE_FILE;
                Status status = new Status(4, "org.eclipse.ui.cheatsheets", 0, message, e);
                CheatSheetPlugin.getPlugin().getLog().log((IStatus)status);
            }
        });
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public XMLMemento readMemento(String filename) {
        XMLMemento memento;
        InputStreamReader reader = null;
        try {
            try {
                File stateFile = this.getCheatSheetStateFile(filename);
                FileInputStream input = new FileInputStream(stateFile);
                reader = new InputStreamReader((InputStream)input, "utf-8");
                memento = XMLMemento.createReadRoot((Reader)reader);
            }
            catch (FileNotFoundException fileNotFoundException) {
                memento = null;
            }
            catch (Exception e) {
                String message = Messages.ERROR_READING_STATE_FILE;
                Status status = new Status(4, "org.eclipse.ui.cheatsheets", 0, message, (Throwable)e);
                CheatSheetPlugin.getPlugin().getLog().log((IStatus)status);
                memento = null;
            }
        }
        catch (Throwable throwable) {
            Object var7_10 = null;
            try {
                if (reader == null) throw throwable;
                reader.close();
                throw throwable;
            }
            catch (IOException e) {
                String message = Messages.ERROR_READING_STATE_FILE;
                Status status = new Status(4, "org.eclipse.ui.cheatsheets", 0, message, (Throwable)e);
                CheatSheetPlugin.getPlugin().getLog().log((IStatus)status);
            }
            throw throwable;
        }
        {
            Object var7_11 = null;
        }
        try {}
        catch (IOException e) {
            String message = Messages.ERROR_READING_STATE_FILE;
            Status status = new Status(4, "org.eclipse.ui.cheatsheets", 0, message, (Throwable)e);
            CheatSheetPlugin.getPlugin().getLog().log((IStatus)status);
            return memento;
        }
        if (reader == null) return memento;
        reader.close();
        return memento;
    }

    private void saveCheatSheetHistory() {
        SafeRunner.run((ISafeRunnable)new SafeRunnable(){

            public void run() {
                XMLMemento memento = XMLMemento.createWriteRoot((String)CheatSheetPlugin.MEMENTO_TAG_CHEATSHEET);
                memento.putString(CheatSheetPlugin.MEMENTO_TAG_VERSION, VERSION_STRING[1]);
                CheatSheetPlugin.this.getCheatSheetHistory().saveState(memento.createChild(CheatSheetPlugin.MEMENTO_TAG_CHEATSHEET_HISTORY));
                IStatus status = CheatSheetPlugin.this.saveMemento(memento, CheatSheetPlugin.HISTORY_FILENAME);
                if (!status.isOK()) {
                    CheatSheetPlugin.getPlugin().getLog().log(status);
                }
            }

            public void handleException(Throwable e) {
                String message = Messages.ERROR_WRITING_STATE_FILE;
                Status status = new Status(4, "org.eclipse.ui.cheatsheets", 0, message, e);
                CheatSheetPlugin.getPlugin().getLog().log((IStatus)status);
            }
        });
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public IStatus saveMemento(XMLMemento memento, String filename) {
        IStatus iStatus;
        File stateFile = this.getCheatSheetStateFile(filename);
        OutputStreamWriter writer = null;
        try {
            try {
                FileOutputStream stream = new FileOutputStream(stateFile);
                writer = new OutputStreamWriter((OutputStream)stream, "utf-8");
                memento.save((Writer)writer);
                iStatus = Status.OK_STATUS;
                Object var8_9 = null;
            }
            catch (IOException e) {
                Status status2;
                stateFile.delete();
                String message = Messages.ERROR_WRITING_STATE_FILE;
                Status status = status2 = new Status(4, "org.eclipse.ui.cheatsheets", 0, message, (Throwable)e);
                Object var8_10 = null;
                try {
                    if (writer == null) return status;
                    writer.close();
                    return status;
                }
                catch (IOException e2) {
                    String message2 = Messages.ERROR_WRITING_STATE_FILE;
                    Status status3 = new Status(4, "org.eclipse.ui.cheatsheets", 0, message2, (Throwable)e2);
                    CheatSheetPlugin.getPlugin().getLog().log((IStatus)status3);
                }
                return status;
            }
        }
        catch (Throwable throwable) {
            Object var8_11 = null;
            try {}
            catch (IOException e2) {
                String message2 = Messages.ERROR_WRITING_STATE_FILE;
                Status status3 = new Status(4, "org.eclipse.ui.cheatsheets", 0, message2, (Throwable)e2);
                CheatSheetPlugin.getPlugin().getLog().log((IStatus)status3);
                throw throwable;
            }
            if (writer == null) throw throwable;
            writer.close();
            throw throwable;
        }
        try {}
        catch (IOException e2) {
            String message2 = Messages.ERROR_WRITING_STATE_FILE;
            Status status3 = new Status(4, "org.eclipse.ui.cheatsheets", 0, message2, (Throwable)e2);
            CheatSheetPlugin.getPlugin().getLog().log((IStatus)status3);
            return iStatus;
        }
        if (writer == null) return iStatus;
        writer.close();
        return iStatus;
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        plugin = this;
    }

    public void stop(BundleContext context) throws Exception {
        super.stop(context);
        if (this.history != null) {
            this.saveCheatSheetHistory();
        }
        CheatSheetRegistryReader.getInstance().stop();
    }

    public static ImageDescriptor createImageDescriptor(Bundle bundle, IPath path) {
        URL url = FileLocator.find((Bundle)bundle, (IPath)path, null);
        if (url != null) {
            return ImageDescriptor.createFromURL((URL)url);
        }
        return null;
    }
}

