/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ui.wizards;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.team.internal.ui.ProjectSetImporter;
import org.eclipse.team.internal.ui.TeamUIMessages;
import org.eclipse.team.internal.ui.TeamUIPlugin;
import org.eclipse.team.internal.ui.wizards.PsfFilenameStore;
import org.eclipse.team.ui.TeamOperation;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.IWorkingSetManager;

public class ImportProjectSetOperation
extends TeamOperation {
    private String psfFile;
    private String workingSetName;

    public ImportProjectSetOperation(IRunnableContext context, String psfFile, String workingSetName) {
        super(context);
        this.psfFile = psfFile;
        this.workingSetName = workingSetName;
    }

    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        PsfFilenameStore.remember(this.psfFile);
        IProject[] newProjects = ProjectSetImporter.importProjectSet(this.psfFile, this.getShell(), monitor);
        if (this.workingSetName != null) {
            this.createWorkingSet(this.workingSetName, newProjects);
        }
    }

    protected boolean canRunAsJob() {
        return true;
    }

    protected String getJobName() {
        return TeamUIMessages.ImportProjectSetMainPage_jobName;
    }

    private void createWorkingSet(String workingSetName, IProject[] projects) {
        IWorkingSetManager manager = TeamUIPlugin.getPlugin().getWorkbench().getWorkingSetManager();
        IWorkingSet oldSet = manager.getWorkingSet(workingSetName);
        if (oldSet == null) {
            IWorkingSet newSet = manager.createWorkingSet(workingSetName, (IAdaptable[])projects);
            manager.addWorkingSet(newSet);
        } else {
            IAdaptable[] tempElements = oldSet.getElements();
            IAdaptable[] adaptedProjects = oldSet.adaptElements((IAdaptable[])projects);
            IAdaptable[] finalElementList = new IAdaptable[tempElements.length + adaptedProjects.length];
            System.arraycopy(tempElements, 0, finalElementList, 0, tempElements.length);
            System.arraycopy(adaptedProjects, 0, finalElementList, tempElements.length, adaptedProjects.length);
            oldSet.setElements(finalElementList);
        }
    }
}

