/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ui.wizards;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Text;
import org.eclipse.team.core.RepositoryProvider;
import org.eclipse.team.internal.ui.TeamUIMessages;
import org.eclipse.team.internal.ui.wizards.PsfFilenameStore;
import org.eclipse.team.internal.ui.wizards.TeamWizardPage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.model.BaseWorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;

public class ExportProjectSetMainPage
extends TeamWizardPage {
    Combo fileCombo;
    protected Text workspaceText;
    protected String file = "";
    protected IFile workspaceFile;
    Button browseButton;
    List selectedProjects = new ArrayList();
    CheckboxTableViewer tableViewer;
    Table table;
    private boolean saveToFileSystem;
    private Button fileRadio;
    private Button workspaceRadio;

    public ExportProjectSetMainPage(String pageName, String title, ImageDescriptor titleImage) {
        super(pageName, title, titleImage);
        this.setDescription(TeamUIMessages.ExportProjectSetMainPage_description);
    }

    public void createControl(Composite parent) {
        Composite composite = this.createComposite(parent, 1);
        this.initializeDialogUnits((Control)composite);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)composite, "org.eclipse.team.ui.export_project_set_page_context");
        this.createLabel(composite, TeamUIMessages.ExportProjectSetMainPage_Select_the_projects_to_include_in_the_project_set__2);
        this.table = new Table(composite, 2848);
        this.tableViewer = new CheckboxTableViewer(this.table);
        this.table.setLayout((Layout)new TableLayout());
        GridData data = new GridData(1808);
        data.heightHint = 300;
        this.table.setLayoutData((Object)data);
        this.tableViewer.setContentProvider((IContentProvider)new ProjectContentProvider());
        this.tableViewer.setLabelProvider((IBaseLabelProvider)new WorkbenchLabelProvider());
        this.tableViewer.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                IProject project = (IProject)event.getElement();
                if (event.getChecked()) {
                    ExportProjectSetMainPage.this.selectedProjects.add(project);
                } else {
                    ExportProjectSetMainPage.this.selectedProjects.remove(project);
                }
                ExportProjectSetMainPage.this.updateEnablement();
            }
        });
        Composite buttonComposite = new Composite(composite, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginWidth = 0;
        buttonComposite.setLayout((Layout)layout);
        data = new GridData(4, 4, true, false);
        buttonComposite.setLayoutData((Object)data);
        Button selectAll = new Button(buttonComposite, 8);
        data = new GridData();
        data.verticalAlignment = 1;
        data.horizontalAlignment = 3;
        int widthHint = this.convertHorizontalDLUsToPixels(61);
        data.widthHint = Math.max(widthHint, selectAll.computeSize((int)-1, (int)-1, (boolean)true).x);
        selectAll.setLayoutData((Object)data);
        selectAll.setText(TeamUIMessages.ExportProjectSetMainPage_SelectAll);
        selectAll.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                ExportProjectSetMainPage.this.tableViewer.setAllChecked(true);
                ExportProjectSetMainPage.this.selectedProjects.removeAll(ExportProjectSetMainPage.this.selectedProjects);
                Object[] checked = ExportProjectSetMainPage.this.tableViewer.getCheckedElements();
                int i = 0;
                while (i < checked.length) {
                    ExportProjectSetMainPage.this.selectedProjects.add(checked[i]);
                    ++i;
                }
                ExportProjectSetMainPage.this.updateEnablement();
            }
        });
        Button deselectAll = new Button(buttonComposite, 8);
        data = new GridData();
        data.verticalAlignment = 1;
        data.horizontalAlignment = 3;
        widthHint = this.convertHorizontalDLUsToPixels(61);
        data.widthHint = Math.max(widthHint, deselectAll.computeSize((int)-1, (int)-1, (boolean)true).x);
        deselectAll.setLayoutData((Object)data);
        deselectAll.setText(TeamUIMessages.ExportProjectSetMainPage_DeselectAll);
        deselectAll.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                ExportProjectSetMainPage.this.tableViewer.setAllChecked(false);
                ExportProjectSetMainPage.this.selectedProjects.removeAll(ExportProjectSetMainPage.this.selectedProjects);
                ExportProjectSetMainPage.this.updateEnablement();
            }
        });
        Group locationGroup = new Group(composite, 0);
        layout = new GridLayout();
        locationGroup.setLayout((Layout)layout);
        data = new GridData(768);
        locationGroup.setLayoutData((Object)data);
        locationGroup.setText(TeamUIMessages.ExportProjectSetMainPage_Project_Set_File_Name__3);
        this.createExportToFile((Composite)locationGroup);
        this.createExportToWorkspace((Composite)locationGroup);
        this.saveToFileSystem = true;
        this.initializeProjects();
        this.setControl((Control)composite);
        this.updateEnablement();
        Dialog.applyDialogFont((Control)parent);
    }

    private void createExportToFile(Composite composite) {
        this.fileRadio = new Button(composite, 16);
        this.fileRadio.setText(TeamUIMessages.ExportProjectSetMainPage_FileButton);
        this.fileRadio.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                ExportProjectSetMainPage.this.saveToFileSystem = true;
                ExportProjectSetMainPage.this.updateEnablement();
            }
        });
        Composite inner = new Composite(composite, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginWidth = 0;
        inner.setLayout((Layout)layout);
        GridData data = new GridData(4, 4, true, false);
        inner.setLayoutData((Object)data);
        this.fileCombo = this.createDropDownCombo(inner);
        this.file = PsfFilenameStore.getSuggestedDefault();
        this.fileCombo.setItems(PsfFilenameStore.getHistory());
        this.fileCombo.setText(this.file);
        this.fileCombo.addListener(24, new Listener(){

            public void handleEvent(Event event) {
                ExportProjectSetMainPage.this.file = ExportProjectSetMainPage.this.fileCombo.getText();
                ExportProjectSetMainPage.this.updateEnablement();
            }
        });
        this.browseButton = new Button(inner, 8);
        this.browseButton.setText(TeamUIMessages.ExportProjectSetMainPage_Browse_4);
        data = new GridData();
        data.horizontalAlignment = 4;
        int widthHint = this.convertHorizontalDLUsToPixels(61);
        data.widthHint = Math.max(widthHint, this.browseButton.computeSize((int)-1, (int)-1, (boolean)true).x);
        this.browseButton.setLayoutData((Object)data);
        this.browseButton.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                int separator;
                if (!ExportProjectSetMainPage.this.isSaveToFileSystem()) {
                    ExportProjectSetMainPage.this.saveToFileSystem = true;
                }
                FileDialog d = new FileDialog(ExportProjectSetMainPage.this.getShell(), 8192);
                d.setFilterExtensions(new String[]{"*.psf"});
                d.setFilterNames(new String[]{TeamUIMessages.ExportProjectSetMainPage_Project_Set_Files_3});
                d.setFileName(TeamUIMessages.ExportProjectSetMainPage_default);
                String fileName = ExportProjectSetMainPage.this.getFileName();
                if (fileName != null && (separator = fileName.lastIndexOf(System.getProperty("file.separator").charAt(0))) != -1) {
                    fileName = fileName.substring(0, separator);
                }
                d.setFilterPath(fileName);
                String f = d.open();
                if (f != null) {
                    ExportProjectSetMainPage.this.fileCombo.setText(f);
                    ExportProjectSetMainPage.this.file = f;
                }
            }
        });
    }

    private void createExportToWorkspace(Composite composite) {
        this.workspaceRadio = new Button(composite, 16);
        this.workspaceRadio.setText(TeamUIMessages.ExportProjectSetMainPage_WorkspaceButton);
        this.workspaceRadio.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                ExportProjectSetMainPage.this.saveToFileSystem = false;
                ExportProjectSetMainPage.this.updateEnablement();
            }
        });
        Composite nameGroup = new Composite(composite, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginWidth = 0;
        nameGroup.setLayout((Layout)layout);
        GridData data = new GridData(4, 4, true, false);
        nameGroup.setLayoutData((Object)data);
        this.workspaceText = this.createTextField(nameGroup);
        this.workspaceText.setEditable(false);
        this.workspaceText.addListener(24, new Listener(){

            public void handleEvent(Event event) {
                ExportProjectSetMainPage.this.file = ExportProjectSetMainPage.this.workspaceFile.getLocation().toString();
                ExportProjectSetMainPage.this.updateEnablement();
            }
        });
        Button wsBrowseButton = new Button(nameGroup, 8);
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        int widthHint = this.convertHorizontalDLUsToPixels(61);
        gd.widthHint = Math.max(widthHint, wsBrowseButton.computeSize((int)-1, (int)-1, (boolean)true).x);
        wsBrowseButton.setLayoutData((Object)gd);
        wsBrowseButton.setText(TeamUIMessages.ExportProjectSetMainPage_Browse);
        wsBrowseButton.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                if (ExportProjectSetMainPage.this.isSaveToFileSystem()) {
                    ExportProjectSetMainPage.this.saveToFileSystem = false;
                }
                WorkspaceDialog d = new WorkspaceDialog(ExportProjectSetMainPage.this.getShell());
                d.open();
            }
        });
    }

    private void initializeProjects() {
        ArrayList<IProject> projectList = new ArrayList<IProject>();
        IProject[] workspaceProjects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        int i = 0;
        while (i < workspaceProjects.length) {
            if (RepositoryProvider.getProvider((IProject)workspaceProjects[i]) != null) {
                projectList.add(workspaceProjects[i]);
            }
            ++i;
        }
        this.tableViewer.setInput((Object)projectList.toArray(new IProject[projectList.size()]));
        if (this.selectedProjects != null) {
            this.tableViewer.setCheckedElements((Object[])this.selectedProjects.toArray(new IProject[this.selectedProjects.size()]));
        }
    }

    private void updateEnablement() {
        boolean complete;
        this.fileRadio.setSelection(this.saveToFileSystem);
        this.workspaceRadio.setSelection(!this.saveToFileSystem);
        if (this.selectedProjects.size() == 0) {
            this.setMessage(null);
            complete = false;
        } else if (this.file.length() == 0) {
            this.setMessage(null);
            complete = false;
        } else {
            File f = new File(this.file);
            if (f.isDirectory()) {
                this.setMessage(TeamUIMessages.ExportProjectSetMainPage_You_have_specified_a_folder_5, 3);
                complete = false;
            } else {
                complete = this.isSaveToFileSystem() || this.workspaceFile != null;
            }
        }
        if (complete) {
            this.setMessage(null);
        }
        this.setPageComplete(complete);
    }

    public String getFileName() {
        return this.file;
    }

    public void setFileName(String file) {
        if (file != null) {
            this.file = file;
        }
    }

    public IProject[] getSelectedProjects() {
        return this.selectedProjects.toArray(new IProject[this.selectedProjects.size()]);
    }

    public void setSelectedProjects(IProject[] selectedProjects) {
        this.selectedProjects.addAll(Arrays.asList(selectedProjects));
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            this.fileCombo.setFocus();
        }
    }

    public boolean isSaveToFileSystem() {
        return this.saveToFileSystem;
    }

    public void refreshWorkspaceFile(IProgressMonitor monitor) throws CoreException {
        if (this.workspaceFile != null) {
            this.workspaceFile.refreshLocal(1, monitor);
        }
    }

    class LocationPageContentProvider
    extends BaseWorkbenchContentProvider {
        boolean showClosedProjects = false;

        LocationPageContentProvider() {
        }

        public Object[] getChildren(Object element) {
            if (element instanceof IWorkspace) {
                Object[] allProjects = ((IWorkspace)element).getRoot().getProjects();
                if (this.showClosedProjects) {
                    return allProjects;
                }
                ArrayList<Object> accessibleProjects = new ArrayList<Object>();
                int i = 0;
                while (i < allProjects.length) {
                    if (allProjects[i].isOpen()) {
                        accessibleProjects.add(allProjects[i]);
                    }
                    ++i;
                }
                return accessibleProjects.toArray();
            }
            return super.getChildren(element);
        }
    }

    class ProjectContentProvider
    extends WorkbenchContentProvider {
        ProjectContentProvider() {
        }

        public Object[] getElements(Object element) {
            if (element instanceof IProject[]) {
                return (IProject[])element;
            }
            return null;
        }
    }

    class WorkspaceDialog
    extends TitleAreaDialog {
        protected TreeViewer wsTreeViewer;
        protected Text wsFilenameText;
        protected IContainer wsContainer;
        protected Image dlgTitleImage;

        public WorkspaceDialog(Shell shell) {
            super(shell);
        }

        protected Control createContents(Composite parent) {
            Control control = super.createContents(parent);
            this.setTitle(TeamUIMessages.ExportProjectSetMainPage_WorkspaceDialogTitle);
            this.setMessage(TeamUIMessages.ExportProjectSetMainPage_WorkspaceDialogTitleMessage);
            return control;
        }

        protected Control createDialogArea(Composite parent) {
            Composite composite = (Composite)super.createDialogArea(parent);
            GridLayout layout = new GridLayout();
            layout.numColumns = 1;
            composite.setLayout((Layout)layout);
            GridData data = new GridData(4, 4, true, false);
            composite.setLayoutData((Object)data);
            this.getShell().setText(TeamUIMessages.ExportProjectSetMainPage_WorkspaceDialogMessage);
            this.wsTreeViewer = new TreeViewer(composite, 2048);
            GridData gd = new GridData(4, 4, true, true);
            gd.widthHint = 550;
            gd.heightHint = 250;
            this.wsTreeViewer.getTree().setLayoutData((Object)gd);
            this.wsTreeViewer.setContentProvider((IContentProvider)new LocationPageContentProvider());
            this.wsTreeViewer.setLabelProvider((IBaseLabelProvider)new WorkbenchLabelProvider());
            this.wsTreeViewer.setInput((Object)ResourcesPlugin.getWorkspace());
            Composite group = new Composite(composite, 0);
            layout = new GridLayout(2, false);
            layout.marginWidth = 0;
            group.setLayout((Layout)layout);
            group.setLayoutData((Object)new GridData(4, 4, true, false));
            Label label = new Label(group, 0);
            label.setLayoutData((Object)new GridData());
            label.setText(TeamUIMessages.ExportProjectSetMainPage_WorkspaceDialogFilename);
            this.wsFilenameText = new Text(group, 2048);
            this.wsFilenameText.setLayoutData((Object)new GridData(4, 128, true, false));
            this.wsFilenameText.setText("projectSet.psf");
            this.setupListeners();
            return parent;
        }

        protected void okPressed() {
            String patchName = this.wsFilenameText.getText();
            if (patchName.equals("")) {
                this.setErrorMessage(TeamUIMessages.ExportProjectSetMainPage_WorkspaceDialogErrorNoFilename);
                return;
            }
            if (!ResourcesPlugin.getWorkspace().validateName(patchName, 1).isOK()) {
                this.wsFilenameText.setText("");
                this.setErrorMessage(TeamUIMessages.ExportProjectSetMainPage_WorkspaceDialogErrorFilenameSegments);
                return;
            }
            if (this.wsContainer == null) {
                this.getSelectedContainer();
            }
            ExportProjectSetMainPage.this.workspaceFile = this.wsContainer.getFile((IPath)new Path(this.wsFilenameText.getText()));
            if (ExportProjectSetMainPage.this.workspaceFile != null) {
                ExportProjectSetMainPage.this.workspaceText.setText(ExportProjectSetMainPage.this.workspaceFile.getFullPath().toString());
            }
            super.okPressed();
        }

        private void getSelectedContainer() {
            Object obj = ((IStructuredSelection)this.wsTreeViewer.getSelection()).getFirstElement();
            if (obj instanceof IContainer) {
                this.wsContainer = (IContainer)obj;
            } else if (obj instanceof IFile) {
                this.wsContainer = ((IFile)obj).getParent();
            }
        }

        protected void cancelPressed() {
            this.getSelectedContainer();
            super.cancelPressed();
        }

        public boolean close() {
            return super.close();
        }

        void setupListeners() {
            this.wsTreeViewer.addSelectionChangedListener(new ISelectionChangedListener(this){
                final /* synthetic */ WorkspaceDialog this$1;
                {
                    this.this$1 = workspaceDialog;
                }

                public void selectionChanged(SelectionChangedEvent event) {
                    IStructuredSelection s = (IStructuredSelection)event.getSelection();
                    Object obj = s.getFirstElement();
                    if (obj instanceof IContainer) {
                        this.this$1.wsContainer = (IContainer)obj;
                    } else if (obj instanceof IFile) {
                        IFile tempFile = (IFile)obj;
                        this.this$1.wsContainer = tempFile.getParent();
                        this.this$1.wsFilenameText.setText(tempFile.getName());
                    }
                }
            });
            this.wsTreeViewer.addDoubleClickListener(new IDoubleClickListener(this){
                final /* synthetic */ WorkspaceDialog this$1;
                {
                    this.this$1 = workspaceDialog;
                }

                public void doubleClick(DoubleClickEvent event) {
                    ISelection s = event.getSelection();
                    if (s instanceof IStructuredSelection) {
                        Object item = ((IStructuredSelection)s).getFirstElement();
                        if (this.this$1.wsTreeViewer.getExpandedState(item)) {
                            this.this$1.wsTreeViewer.collapseToLevel(item, 1);
                        } else {
                            this.this$1.wsTreeViewer.expandToLevel(item, 1);
                        }
                    }
                }
            });
            this.wsFilenameText.addModifyListener(new ModifyListener(this){
                final /* synthetic */ WorkspaceDialog this$1;
                {
                    this.this$1 = workspaceDialog;
                }

                public void modifyText(ModifyEvent e) {
                    this.this$1.setErrorMessage(null);
                }
            });
        }
    }
}

