/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ui.synchronize;

import org.eclipse.compare.ITypedElement;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.team.core.TeamException;
import org.eclipse.team.core.variants.IResourceVariant;
import org.eclipse.team.internal.ui.StorageTypedElement;

public class RemoteResourceTypedElement
extends StorageTypedElement {
    private IResourceVariant remote;

    public RemoteResourceTypedElement(IResourceVariant remote, String encoding) {
        super(encoding);
        Assert.isNotNull((Object)remote);
        this.remote = remote;
    }

    public String getName() {
        return this.remote.getName();
    }

    public String getContentIdentifier() {
        return this.remote.getContentIdentifier();
    }

    public String getType() {
        if (this.remote.isContainer()) {
            return "FOLDER";
        }
        return super.getType();
    }

    public boolean isEditable() {
        return false;
    }

    public ITypedElement replace(ITypedElement child, ITypedElement other) {
        return null;
    }

    protected IStorage getElementStorage(IProgressMonitor monitor) throws TeamException {
        return this.remote.getStorage(monitor);
    }

    public void update(IResourceVariant variant) {
        Assert.isNotNull((Object)variant);
        this.discardBuffer();
        this.remote = variant;
        this.fireContentChanged();
    }
}

