/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ui.synchronize;

import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.team.internal.ui.TeamUIMessages;
import org.eclipse.team.internal.ui.TeamUIPlugin;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.IWorkingSetManager;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.ContainerCheckedTreeViewer;
import org.eclipse.ui.dialogs.IWorkingSetSelectionDialog;

public abstract class GlobalRefreshElementSelectionPage
extends WizardPage {
    private boolean scopeCheckingElement = false;
    private Button participantScope;
    private Button selectedResourcesScope;
    private Button workingSetScope;
    private ContainerCheckedTreeViewer fViewer;
    private Text workingSetLabel;
    private IWorkingSet[] workingSets;
    private IDialogSettings settings;
    private static final String STORE_SECTION = "SynchronizeResourceSelectionDialog";
    private static final String STORE_WORKING_SETS = "SynchronizeResourceSelectionDialog.STORE_WORKING_SETS";

    protected GlobalRefreshElementSelectionPage(String pageName) {
        super(pageName);
        IDialogSettings s = TeamUIPlugin.getPlugin().getDialogSettings();
        this.settings = s.getSection(STORE_SECTION);
        if (this.settings == null) {
            this.settings = s.addNewSection(STORE_SECTION);
        }
    }

    public void createControl(Composite parent2) {
        Composite top = new Composite(parent2, 0);
        top.setLayout((Layout)new GridLayout());
        this.initializeDialogUnits((Control)top);
        GridData data = new GridData(1808);
        data.widthHint = 50;
        top.setLayoutData((Object)data);
        this.setControl((Control)top);
        PlatformUI.getWorkbench().getHelpSystem().setHelp(this.getControl(), "org.eclipse.team.ui.sync_resource_selection_page_context");
        Label l = new Label(top, 0);
        l.setText(TeamUIMessages.GlobalRefreshResourceSelectionPage_5);
        this.fViewer = this.createViewer(top);
        Composite selectGroup = new Composite(top, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        selectGroup.setLayout((Layout)layout);
        data = new GridData(768);
        selectGroup.setLayoutData((Object)data);
        Button selectAll = new Button(selectGroup, 0);
        selectAll.setText(TeamUIMessages.GlobalRefreshResourceSelectionPage_12);
        selectAll.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                GlobalRefreshElementSelectionPage.this.participantScope.setSelection(true);
                GlobalRefreshElementSelectionPage.this.selectedResourcesScope.setSelection(false);
                GlobalRefreshElementSelectionPage.this.workingSetScope.setSelection(false);
                GlobalRefreshElementSelectionPage.this.updateParticipantScope();
                GlobalRefreshElementSelectionPage.this.scopeCheckingElement = true;
                GlobalRefreshElementSelectionPage.this.updateOKStatus();
                GlobalRefreshElementSelectionPage.this.scopeCheckingElement = false;
            }
        });
        this.setButtonLayoutData(selectAll);
        Button deSelectAll = new Button(selectGroup, 0);
        deSelectAll.setText(TeamUIMessages.GlobalRefreshResourceSelectionPage_13);
        deSelectAll.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                GlobalRefreshElementSelectionPage.this.fViewer.setCheckedElements(new Object[0]);
                GlobalRefreshElementSelectionPage.this.updateOKStatus();
            }
        });
        this.setButtonLayoutData(deSelectAll);
        Group scopeGroup = new Group(top, 0);
        scopeGroup.setText(TeamUIMessages.GlobalRefreshResourceSelectionPage_6);
        layout = new GridLayout();
        layout.numColumns = 3;
        layout.makeColumnsEqualWidth = false;
        scopeGroup.setLayout((Layout)layout);
        data = new GridData(768);
        data.widthHint = 50;
        scopeGroup.setLayoutData((Object)data);
        this.participantScope = new Button((Composite)scopeGroup, 16);
        this.participantScope.setText(TeamUIMessages.GlobalRefreshResourceSelectionPage_7);
        this.participantScope.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                GlobalRefreshElementSelectionPage.this.updateParticipantScope();
            }
        });
        this.selectedResourcesScope = new Button((Composite)scopeGroup, 16);
        this.selectedResourcesScope.setText(TeamUIMessages.GlobalRefreshResourceSelectionPage_8);
        this.selectedResourcesScope.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                GlobalRefreshElementSelectionPage.this.updateSelectedResourcesScope();
            }
        });
        data = new GridData();
        data.horizontalSpan = 2;
        this.selectedResourcesScope.setLayoutData((Object)data);
        this.workingSetScope = new Button((Composite)scopeGroup, 16);
        this.workingSetScope.setText(TeamUIMessages.GlobalRefreshResourceSelectionPage_10);
        this.workingSetScope.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (GlobalRefreshElementSelectionPage.this.isWorkingSetSelected()) {
                    GlobalRefreshElementSelectionPage.this.updateWorkingSetScope();
                }
            }
        });
        this.workingSetLabel = new Text((Composite)scopeGroup, 2048);
        this.workingSetLabel.setEditable(false);
        data = new GridData(768);
        this.workingSetLabel.setLayoutData((Object)data);
        Button selectWorkingSetButton = new Button((Composite)scopeGroup, 0);
        selectWorkingSetButton.setText(TeamUIMessages.GlobalRefreshResourceSelectionPage_11);
        selectWorkingSetButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                GlobalRefreshElementSelectionPage.this.selectWorkingSetAction();
            }
        });
        data = new GridData(128);
        selectWorkingSetButton.setLayoutData((Object)data);
        Dialog.applyDialogFont((Control)selectWorkingSetButton);
        this.initializeScopingHint();
        Dialog.applyDialogFont((Control)top);
    }

    protected abstract ContainerCheckedTreeViewer createViewer(Composite var1);

    protected void updateOKStatus() {
        if (this.fViewer != null) {
            if (!this.scopeCheckingElement && !this.selectedResourcesScope.getSelection()) {
                this.selectedResourcesScope.setSelection(true);
                this.participantScope.setSelection(false);
                this.workingSetScope.setSelection(false);
                this.updateSelectedResourcesScope();
            }
            this.setPageComplete(this.areAnyElementsChecked());
        } else {
            this.setPageComplete(false);
        }
    }

    private boolean areAnyElementsChecked() {
        TreeItem[] item = this.fViewer.getTree().getItems();
        int i = 0;
        while (i < item.length) {
            TreeItem child = item[i];
            if (child.getChecked() || child.getGrayed()) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public Object[] getRootElement() {
        TreeItem[] item = this.fViewer.getTree().getItems();
        ArrayList checked = new ArrayList();
        int i = 0;
        while (i < item.length) {
            TreeItem child = item[i];
            this.collectCheckedItems(child, checked);
            ++i;
        }
        return checked.toArray(new Object[checked.size()]);
    }

    protected void initializeScopingHint() {
        String working_sets = this.settings.get(STORE_WORKING_SETS);
        if (working_sets == null) {
            this.participantScope.setSelection(true);
            this.updateParticipantScope();
        } else {
            StringTokenizer st = new StringTokenizer(working_sets, " ,");
            ArrayList<IWorkingSet> ws = new ArrayList<IWorkingSet>();
            while (st.hasMoreTokens()) {
                IWorkingSetManager workingSetManager;
                IWorkingSet workingSet;
                String workingSetName = st.nextToken();
                if (workingSetName == null || workingSetName.equals("") || (workingSet = (workingSetManager = PlatformUI.getWorkbench().getWorkingSetManager()).getWorkingSet(workingSetName)) == null) continue;
                ws.add(workingSet);
            }
            if (!ws.isEmpty()) {
                this.workingSets = ws.toArray(new IWorkingSet[ws.size()]);
                this.updateWorkingSetScope();
                this.updateWorkingSetLabel();
                this.participantScope.setSelection(false);
                this.selectedResourcesScope.setSelection(false);
                this.workingSetScope.setSelection(true);
            }
        }
    }

    public void dispose() {
        if (this.workingSets != null && this.isWorkingSetSelected()) {
            String concatsWorkingSets = this.makeWorkingSetLabel();
            this.settings.put(STORE_WORKING_SETS, concatsWorkingSets);
        } else {
            this.settings.put(STORE_WORKING_SETS, null);
        }
    }

    private void updateParticipantScope() {
        if (this.isWorkspaceSelected()) {
            this.scopeCheckingElement = true;
            this.checkAll();
            this.setPageComplete(this.getRootElement().length > 0);
            this.scopeCheckingElement = false;
        }
    }

    protected abstract void checkAll();

    private void updateSelectedResourcesScope() {
        this.setPageComplete(this.getRootElement().length > 0);
    }

    private void selectWorkingSetAction() {
        IWorkingSetManager manager = PlatformUI.getWorkbench().getWorkingSetManager();
        IWorkingSetSelectionDialog dialog = manager.createWorkingSetSelectionDialog(this.getShell(), true);
        dialog.open();
        IWorkingSet[] sets = dialog.getSelection();
        if (sets == null) {
            return;
        }
        this.workingSets = sets;
        this.updateWorkingSetScope();
        this.updateWorkingSetLabel();
        this.participantScope.setSelection(false);
        this.selectedResourcesScope.setSelection(false);
        this.workingSetScope.setSelection(true);
    }

    private void updateWorkingSetScope() {
        if (this.workingSets != null) {
            this.scopeCheckingElement = true;
            this.checkWorkingSetElements();
            this.scopeCheckingElement = false;
            this.setPageComplete(true);
        } else {
            this.scopeCheckingElement = true;
            this.fViewer.setCheckedElements(new Object[0]);
            this.scopeCheckingElement = false;
            this.setPageComplete(false);
        }
    }

    protected abstract void checkWorkingSetElements();

    private void collectCheckedItems(TreeItem item, List checked) {
        if (item.getChecked() && !item.getGrayed()) {
            checked.add(item.getData());
        } else if (item.getGrayed()) {
            TreeItem[] children = item.getItems();
            int i = 0;
            while (i < children.length) {
                TreeItem child = children[i];
                this.collectCheckedItems(child, checked);
                ++i;
            }
        }
    }

    private void updateWorkingSetLabel() {
        if (this.workingSets == null) {
            this.workingSetLabel.setText(TeamUIMessages.StatisticsPanel_noWorkingSet);
        } else {
            this.workingSetLabel.setText(this.makeWorkingSetLabel());
        }
    }

    private String makeWorkingSetLabel() {
        StringBuffer buffer = new StringBuffer();
        int i = 0;
        while (i < this.workingSets.length) {
            IWorkingSet set = this.workingSets[i];
            if (i != 0) {
                buffer.append(" ,");
            }
            buffer.append(set.getName());
            ++i;
        }
        return buffer.toString();
    }

    protected boolean isWorkspaceSelected() {
        return this.participantScope.getSelection();
    }

    protected boolean isWorkingSetSelected() {
        return this.workingSetScope.getSelection();
    }

    public IWorkingSet[] getWorkingSets() {
        return this.workingSets;
    }

    public ContainerCheckedTreeViewer getViewer() {
        return this.fViewer;
    }
}

