/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ui.mapping;

import java.util.ArrayList;
import java.util.HashSet;
import org.eclipse.core.resources.mapping.IModelProviderDescriptor;
import org.eclipse.core.resources.mapping.ModelProvider;
import org.eclipse.core.resources.mapping.ResourceTraversal;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.team.core.diff.FastDiffFilter;
import org.eclipse.team.core.diff.IDiffChangeEvent;
import org.eclipse.team.core.diff.IDiffChangeListener;
import org.eclipse.team.core.diff.IDiffTree;
import org.eclipse.team.core.mapping.ISynchronizationContext;
import org.eclipse.team.core.mapping.ISynchronizationScope;
import org.eclipse.team.internal.core.subscribers.SubscriberDiffTreeEventHandler;
import org.eclipse.team.internal.ui.TeamUIMessages;
import org.eclipse.team.internal.ui.TeamUIPlugin;
import org.eclipse.team.internal.ui.Utils;
import org.eclipse.team.internal.ui.mapping.CommonViewerAdvisor;
import org.eclipse.team.internal.ui.mapping.IEmptyTreeListener;
import org.eclipse.team.internal.ui.registry.TeamContentProviderDescriptor;
import org.eclipse.team.internal.ui.registry.TeamContentProviderManager;
import org.eclipse.team.internal.ui.synchronize.AbstractSynchronizePage;
import org.eclipse.team.internal.ui.synchronize.ForwardingChangesSection;
import org.eclipse.team.internal.ui.synchronize.SynchronizePageConfiguration;
import org.eclipse.team.ui.TeamUI;
import org.eclipse.team.ui.mapping.ISynchronizationCompareAdapter;
import org.eclipse.team.ui.mapping.ITeamContentProviderDescriptor;
import org.eclipse.team.ui.synchronize.ISynchronizePageConfiguration;
import org.eclipse.team.ui.synchronize.ModelOperation;
import org.eclipse.team.ui.synchronize.ModelSynchronizeParticipant;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.Hyperlink;

public class DiffTreeChangesSection
extends ForwardingChangesSection
implements IDiffChangeListener,
IPropertyChangeListener,
IEmptyTreeListener {
    private ISynchronizationContext context;
    private IStatus[] errors;
    private boolean showingError;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public DiffTreeChangesSection(Composite parent, AbstractSynchronizePage page, ISynchronizePageConfiguration configuration) {
        super(parent, page, configuration);
        this.context = (ISynchronizationContext)configuration.getProperty("org.eclipse.team.ui.synchronizationContext");
        this.context.getDiffTree().addDiffChangeListener((IDiffChangeListener)this);
        this.getConfiguration().addPropertyChangeListener(this);
        Platform.getJobManager().addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

            public void running(IJobChangeEvent event) {
                if (this.isJobOfInterest(event.getJob()) && DiffTreeChangesSection.this.context.getDiffTree().isEmpty()) {
                    DiffTreeChangesSection.this.calculateDescription();
                }
            }

            private boolean isJobOfInterest(Job job) {
                if (job.belongsTo((Object)DiffTreeChangesSection.this.getConfiguration().getParticipant())) {
                    return true;
                }
                SubscriberDiffTreeEventHandler handler = DiffTreeChangesSection.this.getHandler();
                return handler != null && handler.getEventHandlerJob() == job;
            }

            public void done(IJobChangeEvent event) {
                if (this.isJobOfInterest(event.getJob()) && DiffTreeChangesSection.this.context.getDiffTree().isEmpty()) {
                    DiffTreeChangesSection.this.calculateDescription();
                }
            }
        });
    }

    public void dispose() {
        this.context.getDiffTree().removeDiffChangeListener((IDiffChangeListener)this);
        this.getConfiguration().removePropertyChangeListener(this);
        super.dispose();
    }

    protected int getChangesCount() {
        return this.context.getDiffTree().size();
    }

    protected long getChangesInMode(int candidateMode) {
        long numChanges;
        long numConflicts = this.context.getDiffTree().countFor(768, 768);
        switch (candidateMode) {
            case 8: {
                numChanges = numConflicts;
                break;
            }
            case 2: {
                numChanges = numConflicts + this.context.getDiffTree().countFor(256, 768);
                break;
            }
            case 1: {
                numChanges = numConflicts + this.context.getDiffTree().countFor(512, 768);
                break;
            }
            case 4: {
                numChanges = numConflicts + this.context.getDiffTree().countFor(512, 768) + this.context.getDiffTree().countFor(256, 768);
                break;
            }
            default: {
                numChanges = 0L;
            }
        }
        return numChanges;
    }

    protected boolean hasChangesInMode(String id, ISynchronizationCompareAdapter adapter, int candidateMode) {
        switch (candidateMode) {
            case 8: {
                return this.hasChangesFor(id, adapter, this.context, new int[]{768}, 768);
            }
            case 2: {
                return this.hasChangesFor(id, adapter, this.context, new int[]{768, 256}, 768);
            }
            case 1: {
                return this.hasChangesFor(id, adapter, this.context, new int[]{768, 512}, 768);
            }
            case 4: {
                return this.hasChangesFor(id, adapter, this.context, new int[]{768, 512, 256}, 768);
            }
        }
        return false;
    }

    private boolean hasChangesFor(String id, ISynchronizationCompareAdapter adapter, ISynchronizationContext context, int[] states, int mask) {
        ITraversalFactory factory;
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.team.internal.ui.mapping.DiffTreeChangesSection$ITraversalFactory");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        ResourceTraversal[] traversals = (factory = (ITraversalFactory)Utils.getAdapter(adapter, clazz)) == null ? context.getScope().getTraversals(id) : factory.getTraversals(context.getScope());
        return context.getDiffTree().hasMatchingDiffs(traversals, FastDiffFilter.getStateFilter((int[])states, (int)mask));
    }

    protected long getVisibleChangesCount() {
        ISynchronizePageConfiguration configuration = this.getConfiguration();
        if (configuration.getComparisonType() == "two-way") {
            return this.context.getDiffTree().size();
        }
        int currentMode = configuration.getMode();
        String id = (String)configuration.getProperty("org.eclipse.team.ui.activeModelProvider");
        if (id != null && !id.equals("org.eclipse.team.ui.activeModelProvider")) {
            try {
                IModelProviderDescriptor desc = ModelProvider.getModelProviderDescriptor((String)id);
                ISynchronizationCompareAdapter adapter = Utils.getCompareAdapter(desc.getModelProvider());
                if (adapter != null) {
                    return this.hasChangesInMode(desc.getId(), adapter, this.getConfiguration().getMode()) ? -1 : 0;
                }
            }
            catch (CoreException e) {
                TeamUIPlugin.log(e);
            }
            return this.isViewerEmpty() ? 0 : -1;
        }
        return this.getChangesInMode(currentMode);
    }

    protected int getCandidateMode() {
        long incomingChanges;
        SynchronizePageConfiguration configuration = (SynchronizePageConfiguration)this.getConfiguration();
        long outgoingChanges = this.context.getDiffTree().countFor(256, 768);
        if (outgoingChanges > 0L) {
            if (configuration.isModeSupported(2)) {
                return 2;
            }
            if (configuration.isModeSupported(4)) {
                return 4;
            }
        }
        if ((incomingChanges = this.context.getDiffTree().countFor(512, 768)) > 0L) {
            if (configuration.isModeSupported(1)) {
                return 1;
            }
            if (configuration.isModeSupported(4)) {
                return 4;
            }
        }
        return configuration.getMode();
    }

    public void diffsChanged(IDiffChangeEvent event, IProgressMonitor monitor) {
        IStatus[] errors = event.getErrors();
        if (errors.length > 0) {
            this.errors = errors;
        }
        this.calculateDescription();
    }

    public void propertyChanged(IDiffTree tree, int property, IPath[] paths) {
    }

    public void propertyChange(PropertyChangeEvent event) {
        if (event.getProperty().equals("org.eclipse.team.ui.P_SYNCVIEWPAGE_MODE") || event.getProperty().equals("org.eclipse.team.ui.activeModelProvider")) {
            this.calculateDescription();
        }
    }

    protected Composite getEmptyChangesComposite(Composite parent) {
        if (this.context.getDiffTree().isEmpty()) {
            SubscriberDiffTreeEventHandler handler = this.getHandler();
            if (handler != null && handler.getState() == 1) {
                return this.getInitializationPane(parent);
            }
            if (this.isRefreshRunning() || handler != null && handler.getEventHandlerJob().getState() != 0) {
                return this.getInitializingMessagePane(parent);
            }
        } else {
            ISynchronizePageConfiguration configuration = this.getConfiguration();
            String id = (String)configuration.getProperty("org.eclipse.team.ui.activeModelProvider");
            if (id == null) {
                id = "org.eclipse.team.ui.activeModelProvider";
            }
            if (id.equals("org.eclipse.team.ui.activeModelProvider")) {
                if (this.getChangesInMode(this.getConfiguration().getMode()) > 0L && this.isAtLeastOneProviderDisabled()) {
                    return this.createEnableParticipantModelProvidersPane(parent);
                }
            } else {
                ModelProvider[] providers = this.findModelsWithChangesInMode(this.getConfiguration().getMode());
                ModelProvider currentProvider = null;
                int i = 0;
                while (i < providers.length) {
                    ModelProvider provider = providers[i];
                    if (this.isEnabled(provider)) {
                        if (provider.getDescriptor().getId().equals(id)) {
                            currentProvider = provider;
                        } else {
                            return this.getPointerToModel(parent, provider, id);
                        }
                    }
                    ++i;
                }
                if (currentProvider != null || providers.length > 0) {
                    return this.createEnableParticipantModelProvidersPane(parent);
                }
            }
        }
        return super.getEmptyChangesComposite(parent);
    }

    private boolean isAtLeastOneProviderDisabled() {
        ModelProvider[] providers = this.findModelsWithChangesInMode(this.getConfiguration().getMode());
        int i = 0;
        while (i < providers.length) {
            ModelProvider provider = providers[i];
            if (!this.isEnabled(provider)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private ModelProvider[] findModelsWithChangesInMode(int mode) {
        ModelProvider[] providers = this.context.getScope().getModelProviders();
        providers = ModelOperation.sortByExtension(providers);
        ArrayList<ModelProvider> result = new ArrayList<ModelProvider>();
        int i = 0;
        while (i < providers.length) {
            boolean hasChanges;
            ModelProvider provider = providers[i];
            ISynchronizationCompareAdapter adapter = Utils.getCompareAdapter(provider);
            if (adapter != null && (hasChanges = this.hasChangesInMode(provider.getId(), adapter, this.getConfiguration().getMode()))) {
                result.add(provider);
            }
            ++i;
        }
        return result.toArray(new ModelProvider[result.size()]);
    }

    private boolean isEnabled(ModelProvider provider) {
        ITeamContentProviderDescriptor desc = TeamUI.getTeamContentProviderManager().getDescriptor(provider.getId());
        return desc != null && desc.isEnabled();
    }

    private Composite createEnableParticipantModelProvidersPane(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setBackground(this.getBackgroundColor());
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        composite.setLayout((Layout)layout);
        GridData data = new GridData(1808);
        data.grabExcessVerticalSpace = true;
        composite.setLayoutData((Object)data);
        int changesCount = this.getChangesCount();
        String message = changesCount == 1 ? TeamUIMessages.DiffTreeChangesSection_8 : NLS.bind((String)TeamUIMessages.DiffTreeChangesSection_9, (Object)new Integer(changesCount));
        final ITeamContentProviderDescriptor[] descriptors = this.getEnabledContentDescriptors();
        message = descriptors.length == 0 ? NLS.bind((String)TeamUIMessages.DiffTreeChangesSection_10, (Object)message) : NLS.bind((String)TeamUIMessages.DiffTreeChangesSection_11, (Object)message);
        this.createDescriptionLabel(composite, message);
        Label warning = new Label(composite, 0);
        warning.setImage(TeamUIPlugin.getPlugin().getImage("ovr/warning_co.gif"));
        Hyperlink link = this.getForms().createHyperlink(composite, TeamUIMessages.DiffTreeChangesSection_12, 64);
        link.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                ModelSynchronizeParticipant participant = (ModelSynchronizeParticipant)DiffTreeChangesSection.this.getConfiguration().getParticipant();
                ModelProvider[] providers = participant.getEnabledModelProviders();
                int i = 0;
                while (i < providers.length) {
                    ModelProvider provider = providers[i];
                    ITeamContentProviderDescriptor desc = TeamUI.getTeamContentProviderManager().getDescriptor(provider.getId());
                    if (desc != null && !desc.isEnabled()) {
                        ((TeamContentProviderDescriptor)desc).setEnabled(true);
                    }
                    ++i;
                }
                ((TeamContentProviderManager)TeamUI.getTeamContentProviderManager()).enablementChanged(descriptors, DiffTreeChangesSection.this.getEnabledContentDescriptors());
                DiffTreeChangesSection.this.getConfiguration().setProperty("org.eclipse.team.ui.activeModelProvider", "org.eclipse.team.ui.activeModelProvider");
            }
        });
        this.getForms().getHyperlinkGroup().add(link);
        return composite;
    }

    private ITeamContentProviderDescriptor[] getEnabledContentDescriptors() {
        ModelSynchronizeParticipant participant = (ModelSynchronizeParticipant)this.getConfiguration().getParticipant();
        ModelProvider[] providers = participant.getEnabledModelProviders();
        HashSet<ITeamContentProviderDescriptor> result = new HashSet<ITeamContentProviderDescriptor>();
        int i = 0;
        while (i < providers.length) {
            ModelProvider provider = providers[i];
            ITeamContentProviderDescriptor desc = TeamUI.getTeamContentProviderManager().getDescriptor(provider.getId());
            if (desc != null && desc.isEnabled()) {
                result.add(desc);
            }
            ++i;
        }
        return result.toArray(new ITeamContentProviderDescriptor[result.size()]);
    }

    private Composite getInitializationPane(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setBackground(this.getBackgroundColor());
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        composite.setLayout((Layout)layout);
        GridData data = new GridData(1808);
        data.grabExcessVerticalSpace = true;
        composite.setLayoutData((Object)data);
        this.createDescriptionLabel(composite, NLS.bind((String)TeamUIMessages.DiffTreeChangesSection_3, (Object[])new String[]{Utils.shortenText(100, this.getConfiguration().getParticipant().getName())}));
        Hyperlink link = this.getForms().createHyperlink(composite, TeamUIMessages.DiffTreeChangesSection_4, 64);
        link.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                DiffTreeChangesSection.this.getHandler().initializeIfNeeded();
            }
        });
        this.getForms().getHyperlinkGroup().add(link);
        link = this.getForms().createHyperlink(composite, TeamUIMessages.DiffTreeChangesSection_5, 64);
        link.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                DiffTreeChangesSection.this.getConfiguration().getParticipant().run(DiffTreeChangesSection.this.getConfiguration().getSite().getPart());
            }
        });
        this.getForms().getHyperlinkGroup().add(link);
        return composite;
    }

    private Composite getInitializingMessagePane(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setBackground(this.getBackgroundColor());
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        composite.setLayout((Layout)layout);
        GridData data = new GridData(1808);
        data.grabExcessVerticalSpace = true;
        composite.setLayoutData((Object)data);
        if (this.isRefreshRunning()) {
            this.createDescriptionLabel(composite, NLS.bind((String)TeamUIMessages.DiffTreeChangesSection_6, (Object[])new String[]{Utils.shortenText(100, this.getConfiguration().getParticipant().getName())}));
        } else {
            this.createDescriptionLabel(composite, NLS.bind((String)TeamUIMessages.DiffTreeChangesSection_7, (Object[])new String[]{Utils.shortenText(100, this.getConfiguration().getParticipant().getName())}));
        }
        return composite;
    }

    private boolean isRefreshRunning() {
        return Platform.getJobManager().find((Object)this.getConfiguration().getParticipant()).length > 0;
    }

    private SubscriberDiffTreeEventHandler getHandler() {
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.eclipse.team.internal.core.subscribers.SubscriberDiffTreeEventHandler");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return (SubscriberDiffTreeEventHandler)Utils.getAdapter(this.context, clazz);
    }

    private Composite getPointerToModel(Composite parent, final ModelProvider provider, String oldId) {
        Composite composite = new Composite(parent, 0);
        composite.setBackground(this.getBackgroundColor());
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        composite.setLayout((Layout)layout);
        GridData data = new GridData(1808);
        data.grabExcessVerticalSpace = true;
        composite.setLayoutData((Object)data);
        IModelProviderDescriptor oldDesc = ModelProvider.getModelProviderDescriptor((String)oldId);
        String modeToString = Utils.modeToString(this.getConfiguration().getMode());
        String message = NLS.bind((String)TeamUIMessages.DiffTreeChangesSection_0, (Object[])new String[]{provider.getDescriptor().getLabel(), modeToString});
        message = NLS.bind((String)TeamUIMessages.DiffTreeChangesSection_1, (Object[])new String[]{modeToString, oldDesc.getLabel(), message});
        this.createDescriptionLabel(composite, message);
        Label warning = new Label(composite, 0);
        warning.setImage(TeamUIPlugin.getPlugin().getImage("ovr/warning_co.gif"));
        Hyperlink link = this.getForms().createHyperlink(composite, NLS.bind((String)TeamUIMessages.DiffTreeChangesSection_2, (Object[])new String[]{provider.getDescriptor().getLabel()}), 64);
        link.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                DiffTreeChangesSection.this.getConfiguration().setProperty("org.eclipse.team.ui.activeModelProvider", provider.getDescriptor().getId());
            }
        });
        this.getForms().getHyperlinkGroup().add(link);
        new Label(composite, 0);
        Hyperlink link2 = this.getForms().createHyperlink(composite, TeamUIMessages.DiffTreeChangesSection_13, 64);
        link2.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                DiffTreeChangesSection.this.getConfiguration().setProperty("org.eclipse.team.ui.activeModelProvider", "org.eclipse.team.ui.activeModelProvider");
            }
        });
        this.getForms().getHyperlinkGroup().add(link2);
        return composite;
    }

    public void treeEmpty(TreeViewer viewer) {
        this.handleEmptyViewer();
    }

    private void handleEmptyViewer() {
        TeamUIPlugin.getStandardDisplay().asyncExec(new Runnable(){

            public void run() {
                if (!DiffTreeChangesSection.this.getContainer().isDisposed()) {
                    DiffTreeChangesSection.this.updatePage(DiffTreeChangesSection.this.getEmptyChangesComposite((Composite)DiffTreeChangesSection.this.getContainer()));
                }
            }
        });
    }

    protected void calculateDescription() {
        if (this.errors != null && this.errors.length > 0) {
            if (!this.showingError) {
                TeamUIPlugin.getStandardDisplay().asyncExec(new Runnable(){

                    public void run() {
                        DiffTreeChangesSection.this.updatePage(DiffTreeChangesSection.this.getErrorComposite((Composite)DiffTreeChangesSection.this.getContainer()));
                        DiffTreeChangesSection.this.showingError = true;
                    }
                });
            }
            return;
        }
        this.showingError = false;
        if (this.isViewerEmpty()) {
            this.handleEmptyViewer();
        } else {
            super.calculateDescription();
        }
    }

    private boolean isViewerEmpty() {
        Viewer v = this.getPage().getViewer();
        if (v instanceof CommonViewerAdvisor.NavigableCommonViewer) {
            CommonViewerAdvisor.NavigableCommonViewer cv = (CommonViewerAdvisor.NavigableCommonViewer)v;
            return cv.isEmpty();
        }
        return false;
    }

    public void notEmpty(TreeViewer viewer) {
        this.calculateDescription();
    }

    private Composite getErrorComposite(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setBackground(this.getBackgroundColor());
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        composite.setLayout((Layout)layout);
        GridData data = new GridData(1808);
        data.grabExcessVerticalSpace = true;
        composite.setLayoutData((Object)data);
        this.createDescriptionLabel(composite, NLS.bind((String)TeamUIMessages.ChangesSection_10, (Object[])new String[]{Utils.shortenText(100, this.getConfiguration().getParticipant().getName())}));
        Hyperlink link = this.getForms().createHyperlink(composite, TeamUIMessages.ChangesSection_8, 64);
        link.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                DiffTreeChangesSection.this.showErrors();
            }
        });
        this.getForms().getHyperlinkGroup().add(link);
        link = this.getForms().createHyperlink(composite, TeamUIMessages.ChangesSection_9, 64);
        link.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                DiffTreeChangesSection.this.errors = null;
                DiffTreeChangesSection.this.calculateDescription();
                SubscriberDiffTreeEventHandler handler = DiffTreeChangesSection.this.getHandler();
                if (handler != null) {
                    handler.initializeIfNeeded();
                } else {
                    DiffTreeChangesSection.this.getConfiguration().getParticipant().run(DiffTreeChangesSection.this.getConfiguration().getSite().getPart());
                }
            }
        });
        this.getForms().getHyperlinkGroup().add(link);
        return composite;
    }

    void showErrors() {
        if (this.errors != null) {
            IStatus[] status = this.errors;
            String title = TeamUIMessages.ChangesSection_11;
            if (status.length == 1) {
                ErrorDialog.openError((Shell)this.getShell(), (String)title, (String)status[0].getMessage(), (IStatus)status[0]);
            } else {
                MultiStatus multi = new MultiStatus("org.eclipse.team.ui", 0, status, TeamUIMessages.ChangesSection_12, null);
                ErrorDialog.openError((Shell)this.getShell(), (String)title, null, (IStatus)multi);
            }
        }
    }

    public static interface ITraversalFactory {
        public ResourceTraversal[] getTraversals(ISynchronizationScope var1);
    }
}

