/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.runtime.registry;

import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionDelta;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IRegistryChangeEvent;
import org.eclipse.core.runtime.IRegistryChangeListener;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.pde.internal.runtime.PDERuntimeMessages;
import org.eclipse.pde.internal.runtime.PDERuntimePlugin;
import org.eclipse.pde.internal.runtime.PDERuntimePluginImages;
import org.eclipse.pde.internal.runtime.registry.IBundleFolder;
import org.eclipse.pde.internal.runtime.registry.PluginObjectAdapter;
import org.eclipse.pde.internal.runtime.registry.RegistryBrowserContentProvider;
import org.eclipse.pde.internal.runtime.registry.RegistryBrowserLabelProvider;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.XMLMemento;
import org.eclipse.ui.part.DrillDownAdapter;
import org.eclipse.ui.part.ViewPart;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.BundleListener;

public class RegistryBrowser
extends ViewPart
implements BundleListener,
IRegistryChangeListener {
    public static final String SHOW_RUNNING_PLUGINS = "RegistryView.showRunning.label";
    private TreeViewer fTreeViewer;
    private IMemento fMemento;
    private Action fRefreshAction;
    private Action fShowPluginsAction;
    private Action fCollapseAllAction;
    private Action fRemoveAction;
    private Action fAddAction;
    private DrillDownAdapter drillDownAdapter;

    public void init(IViewSite site, IMemento memento) throws PartInitException {
        super.init(site, memento);
        this.fMemento = memento == null ? XMLMemento.createWriteRoot((String)"REGISTRYVIEW") : memento;
        this.initializeMemento();
    }

    private void initializeMemento() {
        if (this.fMemento.getString(SHOW_RUNNING_PLUGINS) == null) {
            this.fMemento.putString(SHOW_RUNNING_PLUGINS, "false");
        }
    }

    public void dispose() {
        Platform.getExtensionRegistry().removeRegistryChangeListener((IRegistryChangeListener)this);
        PDERuntimePlugin.getDefault().getBundleContext().removeBundleListener((BundleListener)this);
        super.dispose();
    }

    public void createPartControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(1808));
        this.makeActions();
        this.createTreeViewer(composite);
        this.fillToolBar();
        this.fTreeViewer.refresh();
        this.setContentDescription(((RegistryBrowserContentProvider)this.fTreeViewer.getContentProvider()).getTitleSummary());
        Platform.getExtensionRegistry().addRegistryChangeListener((IRegistryChangeListener)this);
        PDERuntimePlugin.getDefault().getBundleContext().addBundleListener((BundleListener)this);
    }

    private void createTreeViewer(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(1808));
        Tree tree = new Tree(composite, 0x800002);
        GridData gd = new GridData(1808);
        tree.setLayoutData((Object)gd);
        this.fTreeViewer = new TreeViewer(tree);
        boolean showRunning = this.fMemento.getString(SHOW_RUNNING_PLUGINS).equals("true");
        this.fTreeViewer.setContentProvider((IContentProvider)new RegistryBrowserContentProvider(this.fTreeViewer, showRunning));
        this.fTreeViewer.setLabelProvider((IBaseLabelProvider)new RegistryBrowserLabelProvider(this.fTreeViewer));
        this.fTreeViewer.setUseHashlookup(true);
        this.fTreeViewer.setSorter(new ViewerSorter(){

            public int compare(Viewer viewer, Object e1, Object e2) {
                if (e1 instanceof PluginObjectAdapter) {
                    e1 = ((PluginObjectAdapter)((Object)e1)).getObject();
                }
                if (e2 instanceof PluginObjectAdapter) {
                    e2 = ((PluginObjectAdapter)((Object)e2)).getObject();
                }
                if (e1 instanceof IBundleFolder && e2 instanceof IBundleFolder) {
                    return ((IBundleFolder)e1).getFolderId() - ((IBundleFolder)e2).getFolderId();
                }
                if (e1 instanceof Bundle && e2 instanceof Bundle) {
                    e1 = ((Bundle)e1).getSymbolicName();
                    e2 = ((Bundle)e2).getSymbolicName();
                }
                return super.compare(viewer, e1, e2);
            }
        });
        Bundle[] bundles = PDERuntimePlugin.getDefault().getBundleContext().getBundles();
        this.fTreeViewer.setInput((Object)new PluginObjectAdapter(bundles));
        PlatformUI.getWorkbench().getHelpSystem().setHelp(this.fTreeViewer.getControl(), "org.eclipse.pde.doc.user.registry_view");
        this.getViewSite().setSelectionProvider((ISelectionProvider)this.fTreeViewer);
        MenuManager popupMenuManager = new MenuManager();
        IMenuListener listener = new IMenuListener(){

            public void menuAboutToShow(IMenuManager mng) {
                RegistryBrowser.this.fillContextMenu(mng);
            }
        };
        popupMenuManager.setRemoveAllWhenShown(true);
        popupMenuManager.addMenuListener(listener);
        Menu menu = popupMenuManager.createContextMenu((Control)tree);
        tree.setMenu(menu);
    }

    private void fillToolBar() {
        this.drillDownAdapter = new RegistryDrillDownAdapter(this.fTreeViewer);
        IActionBars bars = this.getViewSite().getActionBars();
        IToolBarManager mng = bars.getToolBarManager();
        this.drillDownAdapter.addNavigationActions(mng);
        mng.add((IAction)this.fRefreshAction);
        mng.add((IContributionItem)new Separator());
        mng.add((IAction)this.fCollapseAllAction);
        IMenuManager mgr = bars.getMenuManager();
        mgr.add((IContributionItem)new Separator());
        mgr.add((IAction)this.fShowPluginsAction);
    }

    public void fillContextMenu(IMenuManager manager) {
        manager.add((IAction)this.fRefreshAction);
        Tree tree = this.getUndisposedTree();
        manager.add((IContributionItem)new Separator());
        this.drillDownAdapter.addNavigationActions(manager);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.fShowPluginsAction);
    }

    public TreeViewer getTreeViewer() {
        return this.fTreeViewer;
    }

    public void saveState(IMemento memento) {
        if (memento == null || this.fMemento == null || this.fTreeViewer == null) {
            return;
        }
        boolean showRunning = ((RegistryBrowserContentProvider)this.fTreeViewer.getContentProvider()).isShowRunning();
        if (showRunning) {
            this.fMemento.putString(SHOW_RUNNING_PLUGINS, Boolean.toString(true));
        } else {
            this.fMemento.putString(SHOW_RUNNING_PLUGINS, Boolean.toString(false));
        }
        memento.putMemento(this.fMemento);
    }

    public void setFocus() {
        this.fTreeViewer.getTree().setFocus();
    }

    public void bundleChanged(BundleEvent event) {
        Tree tree = this.getUndisposedTree();
        if (tree == null) {
            return;
        }
        final RegistryBrowserContentProvider provider = (RegistryBrowserContentProvider)this.fTreeViewer.getContentProvider();
        final Bundle eventBundle = Platform.getBundle((String)event.getBundle().getSymbolicName());
        if (eventBundle == null) {
            return;
        }
        final PluginObjectAdapter adapter = new PluginObjectAdapter(eventBundle);
        tree.getDisplay().asyncExec(new Runnable(){

            public void run() {
                Tree tree = RegistryBrowser.this.getUndisposedTree();
                if (tree == null) {
                    return;
                }
                TreeItem[] items = RegistryBrowser.this.fTreeViewer.getTree().getItems();
                if (items != null) {
                    int i = 0;
                    while (i < items.length) {
                        Bundle bundle;
                        Object object = items[i].getData();
                        if (object instanceof PluginObjectAdapter) {
                            object = ((PluginObjectAdapter)((Object)object)).getObject();
                        }
                        if (object != null && object instanceof Bundle && (bundle = (Bundle)object).equals(eventBundle)) {
                            RegistryBrowser.this.fTreeViewer.update(items[i].getData(), null);
                            RegistryBrowser.this.updateTitle();
                            return;
                        }
                        ++i;
                    }
                }
                if (provider.isShowRunning() && eventBundle.getState() != 32) {
                    return;
                }
                RegistryBrowser.this.fTreeViewer.add(RegistryBrowser.this.fTreeViewer.getInput(), (Object)adapter);
                RegistryBrowser.this.updateTitle();
            }
        });
    }

    public void registryChanged(IRegistryChangeEvent event) {
        Tree tree = this.getUndisposedTree();
        if (tree == null) {
            return;
        }
        final IExtensionDelta[] deltas = event.getExtensionDeltas();
        tree.getDisplay().syncExec(new Runnable(){

            public void run() {
                if (RegistryBrowser.this.getUndisposedTree() == null) {
                    return;
                }
                int i = 0;
                while (i < deltas.length) {
                    RegistryBrowser.this.handleDelta(deltas[i]);
                    ++i;
                }
            }
        });
    }

    private void handleDelta(IExtensionDelta delta) {
        IExtension ext = delta.getExtension();
        IExtensionPoint extPoint = delta.getExtensionPoint();
        if (delta.getKind() == 1) {
            this.addToTree(ext);
            this.addToTree(extPoint);
        } else if (delta.getKind() == 2) {
            this.removeFromTree(ext);
            this.removeFromTree(extPoint);
        }
    }

    private void addToTree(Object object) {
        String namespace = this.getNamespaceIdentifier(object);
        if (namespace == null) {
            return;
        }
        TreeItem[] bundles = this.fTreeViewer.getTree().getItems();
        int i = 0;
        while (i < bundles.length) {
            Object data = bundles[i].getData();
            Object adapted = null;
            if (data instanceof PluginObjectAdapter) {
                adapted = ((PluginObjectAdapter)((Object)data)).getObject();
            }
            if (adapted instanceof Bundle && ((Bundle)adapted).getSymbolicName().equals(namespace)) {
                this.fTreeViewer.refresh(data);
                return;
            }
            ++i;
        }
    }

    private String getNamespaceIdentifier(Object object) {
        if (object instanceof IExtensionPoint) {
            return ((IExtensionPoint)object).getNamespaceIdentifier();
        }
        if (object instanceof IExtension) {
            return ((IExtension)object).getContributor().getName();
        }
        return null;
    }

    private boolean correctFolder(IBundleFolder folder, Object child) {
        if (folder == null) {
            return false;
        }
        if (child instanceof IExtensionPoint) {
            return folder.getFolderId() == 2;
        }
        if (child instanceof IExtension) {
            return folder.getFolderId() == 1;
        }
        return false;
    }

    private void removeFromTree(Object object) {
        String namespace = this.getNamespaceIdentifier(object);
        if (namespace == null) {
            return;
        }
        TreeItem[] bundles = this.fTreeViewer.getTree().getItems();
        int i = 0;
        while (i < bundles.length) {
            Object data = bundles[i].getData();
            Object adapted = null;
            if (data instanceof PluginObjectAdapter) {
                adapted = ((PluginObjectAdapter)((Object)data)).getObject();
            }
            if (adapted instanceof Bundle && ((Bundle)adapted).getSymbolicName().equals(namespace)) {
                bundles[i].getItems();
                this.fTreeViewer.refresh(data);
                return;
            }
            ++i;
        }
    }

    public void makeActions() {
        this.fRefreshAction = new Action("refresh"){

            public void run() {
                BusyIndicator.showWhile((Display)RegistryBrowser.this.fTreeViewer.getTree().getDisplay(), (Runnable)new Runnable(this){
                    final /* synthetic */ 5 this$1;
                    {
                        this.this$1 = var1_1;
                    }

                    public void run() {
                        RegistryBrowser.access$2(5.access$0(this.this$1)).refresh();
                    }
                });
            }

            static /* synthetic */ RegistryBrowser access$0(5 var0) {
                return var0.RegistryBrowser.this;
            }
        };
        this.fRefreshAction.setText(PDERuntimeMessages.RegistryView_refresh_label);
        this.fRefreshAction.setToolTipText(PDERuntimeMessages.RegistryView_refresh_tooltip);
        this.fRefreshAction.setImageDescriptor(PDERuntimePluginImages.DESC_REFRESH);
        this.fRefreshAction.setDisabledImageDescriptor(PDERuntimePluginImages.DESC_REFRESH_DISABLED);
        this.fShowPluginsAction = new Action(PDERuntimeMessages.RegistryView_showRunning_label){

            public void run() {
                RegistryBrowserContentProvider cp = (RegistryBrowserContentProvider)RegistryBrowser.this.fTreeViewer.getContentProvider();
                cp.setShowRunning(RegistryBrowser.this.fShowPluginsAction.isChecked());
                RegistryBrowser.this.fTreeViewer.refresh();
                RegistryBrowser.this.updateTitle();
            }
        };
        this.fShowPluginsAction.setChecked(this.fMemento.getString(SHOW_RUNNING_PLUGINS).equals("true"));
        this.fRemoveAction = new Action("Remove"){

            public void run() {
            }
        };
        this.fAddAction = new Action("Add..."){

            public void run() {
            }
        };
        this.fCollapseAllAction = new Action("collapseAll"){

            public void run() {
                RegistryBrowser.this.fTreeViewer.collapseAll();
            }
        };
        this.fCollapseAllAction.setText(PDERuntimeMessages.RegistryView_collapseAll_label);
        this.fCollapseAllAction.setImageDescriptor(PDERuntimePluginImages.DESC_COLLAPSE_ALL);
        this.fCollapseAllAction.setToolTipText(PDERuntimeMessages.RegistryView_collapseAll_tooltip);
    }

    public void updateTitle() {
        if (this.fTreeViewer == null || this.fTreeViewer.getContentProvider() == null) {
            return;
        }
        this.setContentDescription(((RegistryBrowserContentProvider)this.fTreeViewer.getContentProvider()).getTitleSummary());
    }

    private Tree getUndisposedTree() {
        if (this.fTreeViewer == null || this.fTreeViewer.getTree() == null || this.fTreeViewer.getTree().isDisposed()) {
            return null;
        }
        return this.fTreeViewer.getTree();
    }

    class RegistryDrillDownAdapter
    extends DrillDownAdapter {
        public RegistryDrillDownAdapter(TreeViewer tree) {
            super(tree);
        }

        public void goInto() {
            super.goInto();
            RegistryBrowser.this.fShowPluginsAction.setEnabled(!this.canGoHome());
        }

        public void goBack() {
            super.goBack();
            RegistryBrowser.this.fShowPluginsAction.setEnabled(!this.canGoHome());
        }

        public void goHome() {
            super.goHome();
            RegistryBrowser.this.fShowPluginsAction.setEnabled(!this.canGoHome());
        }

        public void goInto(Object newInput) {
            super.goInto(newInput);
            RegistryBrowser.this.fShowPluginsAction.setEnabled(!this.canGoHome());
        }
    }
}

