/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.baseadaptor;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Writer;
import java.net.URL;
import java.net.URLConnection;
import java.util.Properties;
import org.eclipse.core.runtime.adaptor.LocationManager;
import org.eclipse.osgi.baseadaptor.BaseData;
import org.eclipse.osgi.baseadaptor.HookRegistry;
import org.eclipse.osgi.baseadaptor.bundlefile.BundleFile;
import org.eclipse.osgi.baseadaptor.hooks.AdaptorHook;
import org.eclipse.osgi.baseadaptor.hooks.ClassLoadingHook;
import org.eclipse.osgi.baseadaptor.hooks.StorageHook;
import org.eclipse.osgi.framework.adaptor.BundleData;
import org.eclipse.osgi.framework.adaptor.BundleOperation;
import org.eclipse.osgi.framework.adaptor.BundleWatcher;
import org.eclipse.osgi.framework.adaptor.EventPublisher;
import org.eclipse.osgi.framework.adaptor.FrameworkAdaptor;
import org.eclipse.osgi.framework.adaptor.PermissionStorage;
import org.eclipse.osgi.framework.debug.Debug;
import org.eclipse.osgi.framework.internal.core.FrameworkProperties;
import org.eclipse.osgi.framework.log.FrameworkLog;
import org.eclipse.osgi.framework.log.FrameworkLogEntry;
import org.eclipse.osgi.internal.baseadaptor.AdaptorMsg;
import org.eclipse.osgi.internal.baseadaptor.BaseStorage;
import org.eclipse.osgi.internal.baseadaptor.BaseStorageHook;
import org.eclipse.osgi.internal.baseadaptor.SystemBundleData;
import org.eclipse.osgi.service.resolver.PlatformAdmin;
import org.eclipse.osgi.service.resolver.State;
import org.eclipse.osgi.util.NLS;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.framework.FrameworkEvent;

public class BaseAdaptor
implements FrameworkAdaptor {
    private static final String PROP_PARENT_CLASSLOADER = "osgi.parentClassloader";
    private static final String PARENT_CLASSLOADER_APP = "app";
    private static final String PARENT_CLASSLOADER_EXT = "ext";
    private static final String PARENT_CLASSLOADER_BOOT = "boot";
    private static final String PARENT_CLASSLOADER_FWK = "fwk";
    private static ClassLoader bundleClassLoaderParent;
    private EventPublisher eventPublisher;
    private boolean stopping;
    private HookRegistry hookRegistry;
    private FrameworkLog log;
    private BundleContext context;
    private BaseStorage storage;
    private BundleWatcher bundleWatcher;

    static {
        ClassLoader appCL;
        String type = FrameworkProperties.getProperty(PROP_PARENT_CLASSLOADER, PARENT_CLASSLOADER_BOOT);
        if (PARENT_CLASSLOADER_FWK.equalsIgnoreCase(type)) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.osgi.framework.adaptor.FrameworkAdaptor");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            bundleClassLoaderParent = clazz.getClassLoader();
        } else if (PARENT_CLASSLOADER_APP.equalsIgnoreCase(type)) {
            bundleClassLoaderParent = ClassLoader.getSystemClassLoader();
        } else if (PARENT_CLASSLOADER_EXT.equalsIgnoreCase(type) && (appCL = ClassLoader.getSystemClassLoader()) != null) {
            bundleClassLoaderParent = appCL.getParent();
        }
        if (bundleClassLoaderParent == null) {
            Class<?> clazz;
            try {
                clazz = Class.forName("java.lang.Object");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            bundleClassLoaderParent = new ClassLoader(clazz.getClassLoader()){};
        }
    }

    public BaseAdaptor(String[] args) {
        if (LocationManager.getConfigurationLocation() == null) {
            LocationManager.initializeLocations();
        }
        this.hookRegistry = new HookRegistry(this);
        FrameworkLogEntry[] errors = this.hookRegistry.initialize();
        if (errors.length > 0) {
            int i = 0;
            while (i < errors.length) {
                this.getFrameworkLog().log(errors[i]);
                ++i;
            }
        }
        this.storage = this.getStorage();
    }

    public void initialize(EventPublisher publisher) {
        this.eventPublisher = publisher;
        AdaptorHook[] adaptorHooks = this.getHookRegistry().getAdaptorHooks();
        int i = 0;
        while (i < adaptorHooks.length) {
            adaptorHooks[i].initialize(this);
            ++i;
        }
    }

    public void initializeStorage() throws IOException {
        this.storage.initialize(this);
    }

    public void compactStorage() throws IOException {
        this.storage.compact();
    }

    public Properties getProperties() {
        Properties props;
        block13: {
            props = new Properties();
            String resource = FrameworkProperties.getProperty("osgi.framework.properties", "osgi.properties");
            try {
                InputStream in = null;
                File file = new File(resource);
                if (file.exists()) {
                    in = new FileInputStream(file);
                }
                if (in == null) {
                    in = this.getClass().getResourceAsStream(resource);
                }
                if (in != null) {
                    try {
                        props.load(new BufferedInputStream(in));
                    }
                    catch (Throwable throwable) {
                        try {
                            in.close();
                        }
                        catch (IOException iOException) {}
                        throw throwable;
                    }
                    try {
                        in.close();
                    }
                    catch (IOException iOException) {}
                    break block13;
                }
                if (Debug.DEBUG_GENERAL) {
                    Debug.println("Skipping osgi.properties: " + resource);
                }
            }
            catch (IOException e) {
                if (!Debug.DEBUG_GENERAL) break block13;
                Debug.println("Unable to load osgi.properties: " + e.getMessage());
            }
        }
        this.storage.addProperties(props);
        AdaptorHook[] adaptorHooks = this.getHookRegistry().getAdaptorHooks();
        int i = 0;
        while (i < adaptorHooks.length) {
            adaptorHooks[i].addProperties(props);
            ++i;
        }
        return props;
    }

    public BundleData[] getInstalledBundles() {
        return this.storage.getInstalledBundles();
    }

    public URLConnection mapLocationToURLConnection(String location) throws BundleException {
        try {
            URLConnection result = null;
            AdaptorHook[] adaptorHooks = this.getHookRegistry().getAdaptorHooks();
            int i = 0;
            while (i < adaptorHooks.length) {
                result = adaptorHooks[i].mapLocationToURLConnection(location);
                if (result != null) {
                    return result;
                }
                ++i;
            }
            return new URL(location).openConnection();
        }
        catch (IOException e) {
            throw new BundleException(NLS.bind(AdaptorMsg.ADAPTOR_URL_CREATE_EXCEPTION, location), e);
        }
    }

    public BundleOperation installBundle(String location, URLConnection source) {
        return this.storage.installBundle(location, source);
    }

    public BundleOperation updateBundle(BundleData bundledata, URLConnection source) {
        return this.storage.updateBundle((BaseData)bundledata, source);
    }

    public BundleOperation uninstallBundle(BundleData bundledata) {
        return this.storage.uninstallBundle((BaseData)bundledata);
    }

    public long getTotalFreeSpace() throws IOException {
        return this.storage.getFreeSpace();
    }

    public PermissionStorage getPermissionStorage() throws IOException {
        return this.storage.getPermissionStorage();
    }

    public void frameworkStart(BundleContext fwContext) throws BundleException {
        this.context = fwContext;
        this.stopping = false;
        this.storage.frameworkStart(fwContext);
        AdaptorHook[] adaptorHooks = this.getHookRegistry().getAdaptorHooks();
        int i = 0;
        while (i < adaptorHooks.length) {
            adaptorHooks[i].frameworkStart(fwContext);
            ++i;
        }
    }

    public void frameworkStop(BundleContext fwContext) throws BundleException {
        AdaptorHook[] adaptorHooks = this.getHookRegistry().getAdaptorHooks();
        int i = 0;
        while (i < adaptorHooks.length) {
            adaptorHooks[i].frameworkStop(fwContext);
            ++i;
        }
        this.storage.frameworkStop(fwContext);
    }

    public void frameworkStopping(BundleContext fwContext) {
        this.stopping = true;
        this.storage.frameworkStopping(fwContext);
        AdaptorHook[] adaptorHooks = this.getHookRegistry().getAdaptorHooks();
        int i = 0;
        while (i < adaptorHooks.length) {
            adaptorHooks[i].frameworkStopping(fwContext);
            ++i;
        }
    }

    public int getInitialBundleStartLevel() {
        return this.storage.getInitialBundleStartLevel();
    }

    public void setInitialBundleStartLevel(int value) {
        this.storage.setInitialBundleStartLevel(value);
    }

    public FrameworkLog getFrameworkLog() {
        if (this.log != null) {
            return this.log;
        }
        AdaptorHook[] adaptorHooks = this.getHookRegistry().getAdaptorHooks();
        int i = 0;
        while (i < adaptorHooks.length) {
            this.log = adaptorHooks[i].createFrameworkLog();
            if (this.log != null) {
                return this.log;
            }
            ++i;
        }
        this.log = new FrameworkLog(){

            public void log(FrameworkEvent frameworkEvent) {
                this.log(new FrameworkLogEntry(frameworkEvent.getBundle().getSymbolicName() == null ? frameworkEvent.getBundle().getLocation() : frameworkEvent.getBundle().getSymbolicName(), 4, 0, "FrameworkEvent.ERROR", 0, frameworkEvent.getThrowable(), null));
            }

            public void log(FrameworkLogEntry logEntry) {
                System.err.print(String.valueOf(logEntry.getEntry()) + " ");
                System.err.println(logEntry.getMessage());
                if (logEntry.getThrowable() != null) {
                    logEntry.getThrowable().printStackTrace(System.err);
                }
            }

            public void setWriter(Writer newWriter, boolean append) {
            }

            public void setFile(File newFile, boolean append) throws IOException {
            }

            public File getFile() {
                return null;
            }

            public void setConsoleLog(boolean consoleLog) {
            }

            public void close() {
            }
        };
        return this.log;
    }

    public BundleData createSystemBundleData() throws BundleException {
        return new SystemBundleData(this);
    }

    public BundleWatcher getBundleWatcher() {
        if (this.bundleWatcher != null) {
            return this.bundleWatcher;
        }
        final BundleWatcher[] watchers = this.hookRegistry.getWatchers();
        if (watchers.length == 0) {
            return null;
        }
        this.bundleWatcher = new BundleWatcher(){

            public void watchBundle(Bundle bundle, int type) {
                int i = 0;
                while (i < watchers.length) {
                    watchers[i].watchBundle(bundle, type);
                    ++i;
                }
            }
        };
        return this.bundleWatcher;
    }

    public PlatformAdmin getPlatformAdmin() {
        return this.storage.getStateManager();
    }

    public State getState() {
        return this.storage.getStateManager().getSystemState();
    }

    public ClassLoader getBundleClassLoaderParent() {
        ClassLoader result = null;
        ClassLoadingHook[] cpManagerHooks = this.getHookRegistry().getClassLoadingHooks();
        int i = 0;
        while (i < cpManagerHooks.length) {
            result = cpManagerHooks[i].getBundleClassLoaderParent();
            if (result != null) {
                return result;
            }
            ++i;
        }
        return bundleClassLoaderParent;
    }

    public void handleRuntimeError(Throwable error) {
        AdaptorHook[] adaptorHooks = this.getHookRegistry().getAdaptorHooks();
        int i = 0;
        while (i < adaptorHooks.length) {
            adaptorHooks[i].handleRuntimeError(error);
            ++i;
        }
    }

    public boolean isStopping() {
        return this.stopping;
    }

    public EventPublisher getEventPublisher() {
        return this.eventPublisher;
    }

    public HookRegistry getHookRegistry() {
        return this.hookRegistry;
    }

    public BundleContext getContext() {
        return this.context;
    }

    public BundleFile createBundleFile(Object content, BaseData data) throws IOException {
        return this.storage.createBundleFile(content, data);
    }

    public boolean isReadOnly() {
        return this.storage.isReadOnly();
    }

    protected BaseStorage getStorage() {
        if (this.storage != null) {
            return this.storage;
        }
        StorageHook[] hooks = this.hookRegistry.getStorageHooks();
        int i = 0;
        while (i < hooks.length && this.storage == null) {
            if (hooks[i] instanceof BaseStorageHook) {
                this.storage = ((BaseStorageHook)hooks[i]).getStorage();
            }
            ++i;
        }
        return this.storage;
    }
}

