/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.framework.internal.core;

import java.io.File;
import java.io.InputStream;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.internal.adaptor.ContextFinder;
import org.eclipse.osgi.event.BatchBundleListener;
import org.eclipse.osgi.framework.debug.Debug;
import org.eclipse.osgi.framework.eventmgr.CopyOnWriteIdentityMap;
import org.eclipse.osgi.framework.eventmgr.EventDispatcher;
import org.eclipse.osgi.framework.internal.core.AbstractBundle;
import org.eclipse.osgi.framework.internal.core.BundleHost;
import org.eclipse.osgi.framework.internal.core.FilterImpl;
import org.eclipse.osgi.framework.internal.core.Framework;
import org.eclipse.osgi.framework.internal.core.Msg;
import org.eclipse.osgi.internal.profile.Profile;
import org.eclipse.osgi.internal.serviceregistry.ServiceReferenceImpl;
import org.eclipse.osgi.internal.serviceregistry.ServiceRegistry;
import org.eclipse.osgi.util.NLS;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.BundleException;
import org.osgi.framework.BundleListener;
import org.osgi.framework.Filter;
import org.osgi.framework.FrameworkEvent;
import org.osgi.framework.FrameworkListener;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceEvent;
import org.osgi.framework.ServiceListener;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.framework.SynchronousBundleListener;

public class BundleContextImpl
implements BundleContext,
EventDispatcher {
    private volatile boolean valid;
    final BundleHost bundle;
    final Framework framework;
    private HashMap servicesInUse;
    protected Map bundleEvent;
    protected Map bundleEventSync;
    protected Map frameworkEvent;
    protected BundleActivator activator;
    private final Object contextLock = new Object();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected BundleContextImpl(BundleHost bundle) {
        this.bundle = bundle;
        this.valid = true;
        this.framework = bundle.framework;
        this.bundleEvent = null;
        this.bundleEventSync = null;
        this.frameworkEvent = null;
        Object object = this.contextLock;
        synchronized (object) {
            this.servicesInUse = null;
        }
        this.activator = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void close() {
        this.valid = false;
        ServiceRegistry registry = this.framework.getServiceRegistry();
        registry.removeAllServiceListeners(this);
        Object object = this.framework.frameworkEvent;
        synchronized (object) {
            if (this.frameworkEvent != null) {
                this.framework.frameworkEvent.remove(this);
                this.frameworkEvent = null;
            }
        }
        object = this.framework.bundleEvent;
        synchronized (object) {
            if (this.bundleEvent != null) {
                this.framework.bundleEvent.remove(this);
                this.bundleEvent = null;
            }
        }
        object = this.framework.bundleEventSync;
        synchronized (object) {
            if (this.bundleEventSync != null) {
                this.framework.bundleEventSync.remove(this);
                this.bundleEventSync = null;
            }
        }
        registry.unregisterServices(this);
        registry.releaseServicesInUse(this);
        object = this.contextLock;
        synchronized (object) {
            this.servicesInUse = null;
        }
    }

    public String getProperty(String key) {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPropertyAccess(key);
        }
        return this.framework.getProperty(key);
    }

    public Bundle getBundle() {
        this.checkValid();
        return this.getBundleImpl();
    }

    public AbstractBundle getBundleImpl() {
        return this.bundle;
    }

    public Bundle installBundle(String location) throws BundleException {
        this.checkValid();
        return this.framework.installBundle(location);
    }

    public Bundle installBundle(String location, InputStream in) throws BundleException {
        this.checkValid();
        return this.framework.installBundle(location, in);
    }

    public Bundle getBundle(long id) {
        return this.framework.getBundle(id);
    }

    public AbstractBundle getBundleByLocation(String location) {
        return this.framework.getBundleByLocation(location);
    }

    public Bundle[] getBundles() {
        return this.framework.getAllBundles();
    }

    public void addServiceListener(ServiceListener listener, String filter) throws InvalidSyntaxException {
        this.checkValid();
        if (listener == null) {
            throw new IllegalArgumentException();
        }
        this.framework.getServiceRegistry().addServiceListener(this, listener, filter);
    }

    public void addServiceListener(ServiceListener listener) {
        block2: {
            try {
                this.addServiceListener(listener, null);
            }
            catch (InvalidSyntaxException e) {
                if (!Debug.DEBUG_GENERAL) break block2;
                Debug.println("InvalidSyntaxException w/ null filter" + e.getMessage());
                Debug.printStackTrace(e);
            }
        }
    }

    public void removeServiceListener(ServiceListener listener) {
        this.checkValid();
        if (listener == null) {
            throw new IllegalArgumentException();
        }
        this.framework.getServiceRegistry().removeServiceListener(this, listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addBundleListener(BundleListener listener) {
        Map map;
        this.checkValid();
        if (listener == null) {
            throw new IllegalArgumentException();
        }
        if (Debug.DEBUG_EVENTS) {
            String listenerName = String.valueOf(listener.getClass().getName()) + "@" + Integer.toHexString(System.identityHashCode(listener));
            Debug.println("addBundleListener[" + this.bundle + "](" + listenerName + ")");
        }
        if (listener instanceof SynchronousBundleListener) {
            this.framework.checkAdminPermission(this.getBundle(), "listener");
            map = this.framework.bundleEventSync;
            synchronized (map) {
                this.checkValid();
                if (this.bundleEventSync == null) {
                    this.bundleEventSync = new CopyOnWriteIdentityMap();
                    this.framework.bundleEventSync.put(this, this);
                }
                this.bundleEventSync.put(listener, listener);
            }
        }
        map = this.framework.bundleEvent;
        synchronized (map) {
            this.checkValid();
            if (this.bundleEvent == null) {
                this.bundleEvent = new CopyOnWriteIdentityMap();
                this.framework.bundleEvent.put(this, this);
            }
            this.bundleEvent.put(listener, listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeBundleListener(BundleListener listener) {
        Map map;
        this.checkValid();
        if (listener == null) {
            throw new IllegalArgumentException();
        }
        if (Debug.DEBUG_EVENTS) {
            String listenerName = String.valueOf(listener.getClass().getName()) + "@" + Integer.toHexString(System.identityHashCode(listener));
            Debug.println("removeBundleListener[" + this.bundle + "](" + listenerName + ")");
        }
        if (listener instanceof SynchronousBundleListener) {
            this.framework.checkAdminPermission(this.getBundle(), "listener");
            map = this.framework.bundleEventSync;
            synchronized (map) {
                if (this.bundleEventSync != null) {
                    this.bundleEventSync.remove(listener);
                }
            }
        }
        map = this.framework.bundleEvent;
        synchronized (map) {
            if (this.bundleEvent != null) {
                this.bundleEvent.remove(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addFrameworkListener(FrameworkListener listener) {
        this.checkValid();
        if (listener == null) {
            throw new IllegalArgumentException();
        }
        if (Debug.DEBUG_EVENTS) {
            String listenerName = String.valueOf(listener.getClass().getName()) + "@" + Integer.toHexString(System.identityHashCode(listener));
            Debug.println("addFrameworkListener[" + this.bundle + "](" + listenerName + ")");
        }
        Map map = this.framework.frameworkEvent;
        synchronized (map) {
            this.checkValid();
            if (this.frameworkEvent == null) {
                this.frameworkEvent = new CopyOnWriteIdentityMap();
                this.framework.frameworkEvent.put(this, this);
            }
            this.frameworkEvent.put(listener, listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeFrameworkListener(FrameworkListener listener) {
        this.checkValid();
        if (listener == null) {
            throw new IllegalArgumentException();
        }
        if (Debug.DEBUG_EVENTS) {
            String listenerName = String.valueOf(listener.getClass().getName()) + "@" + Integer.toHexString(System.identityHashCode(listener));
            Debug.println("removeFrameworkListener[" + this.bundle + "](" + listenerName + ")");
        }
        Map map = this.framework.frameworkEvent;
        synchronized (map) {
            if (this.frameworkEvent != null) {
                this.frameworkEvent.remove(listener);
            }
        }
    }

    public ServiceRegistration registerService(String[] clazzes, Object service, Dictionary properties) {
        this.checkValid();
        return this.framework.getServiceRegistry().registerService(this, clazzes, service, properties);
    }

    public ServiceRegistration registerService(String clazz, Object service, Dictionary properties) {
        String[] clazzes = new String[]{clazz};
        return this.registerService(clazzes, service, properties);
    }

    public ServiceReference[] getServiceReferences(String clazz, String filter) throws InvalidSyntaxException {
        this.checkValid();
        return this.framework.getServiceRegistry().getServiceReferences(this, clazz, filter, false);
    }

    public ServiceReference[] getAllServiceReferences(String clazz, String filter) throws InvalidSyntaxException {
        this.checkValid();
        return this.framework.getServiceRegistry().getServiceReferences(this, clazz, filter, true);
    }

    public ServiceReference getServiceReference(String clazz) {
        this.checkValid();
        return this.framework.getServiceRegistry().getServiceReference(this, clazz);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getService(ServiceReference reference) {
        this.checkValid();
        Object object = this.contextLock;
        synchronized (object) {
            if (this.servicesInUse == null) {
                this.servicesInUse = new HashMap(10);
            }
        }
        return this.framework.getServiceRegistry().getService(this, (ServiceReferenceImpl)reference);
    }

    public boolean ungetService(ServiceReference reference) {
        this.checkValid();
        return this.framework.getServiceRegistry().ungetService(this, (ServiceReferenceImpl)reference);
    }

    public File getDataFile(String filename) {
        this.checkValid();
        return this.framework.getDataFile(this.bundle, filename);
    }

    protected void start() throws BundleException {
        this.activator = this.bundle.loadBundleActivator();
        if (this.activator != null) {
            try {
                this.startActivator(this.activator);
            }
            catch (BundleException be) {
                this.activator = null;
                throw be;
            }
        }
    }

    protected void startActivator(final BundleActivator bundleActivator) throws BundleException {
        if (Profile.STARTUP) {
            Profile.logEnter("BundleContextImpl.startActivator()", null);
        }
        try {
            try {
                AccessController.doPrivileged(new PrivilegedExceptionAction(){

                    public Object run() throws Exception {
                        if (bundleActivator != null) {
                            if (Profile.STARTUP) {
                                Profile.logTime("BundleContextImpl.startActivator()", "calling " + BundleContextImpl.this.bundle.getLocation() + " bundle activator");
                            }
                            Object previousTCCL = BundleContextImpl.this.setContextFinder();
                            try {
                                bundleActivator.start(BundleContextImpl.this);
                            }
                            finally {
                                if (previousTCCL != Boolean.FALSE) {
                                    Thread.currentThread().setContextClassLoader((ClassLoader)previousTCCL);
                                }
                            }
                            if (Profile.STARTUP) {
                                Profile.logTime("BundleContextImpl.startActivator()", "returned from " + BundleContextImpl.this.bundle.getLocation() + " bundle activator");
                            }
                        }
                        return null;
                    }
                });
            }
            catch (Throwable t2) {
                Exception t2;
                if (t2 instanceof PrivilegedActionException) {
                    t2 = ((PrivilegedActionException)t2).getException();
                }
                if (Debug.DEBUG_GENERAL) {
                    Debug.printStackTrace(t2);
                }
                String clazz = null;
                clazz = bundleActivator.getClass().getName();
                throw new BundleException(NLS.bind(Msg.BUNDLE_ACTIVATOR_EXCEPTION, new Object[]{clazz, "start", this.bundle.getSymbolicName() == null ? "" + this.bundle.getBundleId() : this.bundle.getSymbolicName()}), 5, t2);
            }
        }
        finally {
            if (Profile.STARTUP) {
                Profile.logExit("BundleContextImpl.startActivator()");
            }
        }
    }

    Object setContextFinder() {
        ContextFinder contextFinder;
        Thread currentThread = Thread.currentThread();
        ClassLoader previousTCCL = currentThread.getContextClassLoader();
        if (previousTCCL != (contextFinder = this.framework.getContextFinder())) {
            currentThread.setContextClassLoader(this.framework.getContextFinder());
            return previousTCCL;
        }
        return Boolean.FALSE;
    }

    protected void stop() throws BundleException {
        try {
            try {
                AccessController.doPrivileged(new PrivilegedExceptionAction(){

                    public Object run() throws Exception {
                        if (BundleContextImpl.this.activator != null) {
                            Object previousTCCL = BundleContextImpl.this.setContextFinder();
                            try {
                                BundleContextImpl.this.activator.stop(BundleContextImpl.this);
                            }
                            finally {
                                if (previousTCCL != Boolean.FALSE) {
                                    Thread.currentThread().setContextClassLoader((ClassLoader)previousTCCL);
                                }
                            }
                        }
                        return null;
                    }
                });
            }
            catch (Throwable t2) {
                Exception t2;
                if (t2 instanceof PrivilegedActionException) {
                    t2 = ((PrivilegedActionException)t2).getException();
                }
                if (Debug.DEBUG_GENERAL) {
                    Debug.printStackTrace(t2);
                }
                String clazz = this.activator == null ? "" : this.activator.getClass().getName();
                throw new BundleException(NLS.bind(Msg.BUNDLE_ACTIVATOR_EXCEPTION, new Object[]{clazz, "stop", this.bundle.getSymbolicName() == null ? "" + this.bundle.getBundleId() : this.bundle.getSymbolicName()}), 5, t2);
            }
        }
        finally {
            this.activator = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map getServicesInUseMap() {
        Object object = this.contextLock;
        synchronized (object) {
            return this.servicesInUse;
        }
    }

    public void dispatchEvent(Object originalListener, Object l, int action, Object object) {
        block23: {
            BundleHost tmpBundle = this.bundle;
            Object previousTCCL = this.setContextFinder();
            try {
                try {
                    if (!this.isValid()) break block23;
                    switch (action) {
                        case 1: 
                        case 2: {
                            BundleListener listener = (BundleListener)l;
                            if (Debug.DEBUG_EVENTS) {
                                String listenerName = String.valueOf(listener.getClass().getName()) + "@" + Integer.toHexString(System.identityHashCode(listener));
                                Debug.println("dispatchBundleEvent[" + tmpBundle + "](" + listenerName + ")");
                            }
                            BundleEvent event = (BundleEvent)object;
                            switch (event.getType()) {
                                case -2147483647: {
                                    if (listener instanceof BatchBundleListener) {
                                        ((BatchBundleListener)listener).batchBegin();
                                        break;
                                    }
                                    break block23;
                                }
                                case -2147483648: {
                                    if (listener instanceof BatchBundleListener) {
                                        ((BatchBundleListener)listener).batchEnd();
                                        break;
                                    }
                                    break block23;
                                }
                                default: {
                                    listener.bundleChanged((BundleEvent)object);
                                    break;
                                }
                            }
                            break;
                        }
                        case 3: {
                            ServiceEvent event = (ServiceEvent)object;
                            ServiceListener listener = (ServiceListener)l;
                            if (Debug.DEBUG_EVENTS) {
                                String listenerName = String.valueOf(listener.getClass().getName()) + "@" + Integer.toHexString(System.identityHashCode(listener));
                                Debug.println("dispatchServiceEvent[" + tmpBundle + "](" + listenerName + ")");
                            }
                            listener.serviceChanged(event);
                            break;
                        }
                        case 4: {
                            FrameworkListener listener = (FrameworkListener)l;
                            if (Debug.DEBUG_EVENTS) {
                                String listenerName = String.valueOf(listener.getClass().getName()) + "@" + Integer.toHexString(System.identityHashCode(listener));
                                Debug.println("dispatchFrameworkEvent[" + tmpBundle + "](" + listenerName + ")");
                            }
                            listener.frameworkEvent((FrameworkEvent)object);
                            break;
                        }
                        default: {
                            throw new InternalError();
                        }
                    }
                }
                catch (Throwable t) {
                    FrameworkEvent event;
                    if (Debug.DEBUG_GENERAL) {
                        Debug.println("Exception in bottom level event dispatcher: " + t.getMessage());
                        Debug.printStackTrace(t);
                    }
                    this.framework.adaptor.handleRuntimeError(t);
                    if (action != 4 || (event = (FrameworkEvent)object).getType() != 2) {
                        this.framework.publishFrameworkEvent(2, tmpBundle, t);
                    }
                    if (previousTCCL != Boolean.FALSE) {
                        Thread.currentThread().setContextClassLoader((ClassLoader)previousTCCL);
                    }
                }
            }
            finally {
                if (previousTCCL != Boolean.FALSE) {
                    Thread.currentThread().setContextClassLoader((ClassLoader)previousTCCL);
                }
            }
        }
    }

    public Filter createFilter(String filter) throws InvalidSyntaxException {
        this.checkValid();
        return FilterImpl.newInstance(filter);
    }

    public void checkValid() {
        if (!this.isValid()) {
            throw new IllegalStateException(Msg.BUNDLE_CONTEXT_INVALID_EXCEPTION);
        }
    }

    protected boolean isValid() {
        return this.valid;
    }

    public Framework getFramework() {
        return this.framework;
    }
}

