/*
 * Decompiled with CFR 0.152.
 */
package org.osgi.framework;

import java.security.Permission;
import java.security.PermissionCollection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import org.osgi.framework.ServicePermission;

final class ServicePermissionCollection
extends PermissionCollection {
    static final long serialVersionUID = 662615640374640621L;
    private final HashMap permissions = new HashMap();
    private boolean all_allowed = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(Permission permission) {
        if (!(permission instanceof ServicePermission)) {
            throw new IllegalArgumentException("invalid permission: " + permission);
        }
        if (this.isReadOnly()) {
            throw new SecurityException("attempt to add a Permission to a readonly PermissionCollection");
        }
        ServicePermission sp = (ServicePermission)permission;
        String name = sp.getName();
        int newMask = sp.getMask();
        ServicePermissionCollection servicePermissionCollection = this;
        synchronized (servicePermissionCollection) {
            ServicePermission existing = (ServicePermission)this.permissions.get(name);
            if (existing != null) {
                int oldMask = existing.getMask();
                if (oldMask != newMask) {
                    this.permissions.put(name, new ServicePermission(name, oldMask | newMask));
                }
            } else {
                this.permissions.put(name, permission);
            }
            if (!this.all_allowed && name.equals("*")) {
                this.all_allowed = true;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean implies(Permission permission) {
        int last;
        ServicePermission x;
        if (!(permission instanceof ServicePermission)) {
            return false;
        }
        ServicePermission sp = (ServicePermission)permission;
        String name = sp.getName();
        int desired = sp.getMask();
        int effective = 0;
        ServicePermissionCollection servicePermissionCollection = this;
        synchronized (servicePermissionCollection) {
            block11: {
                if (!this.all_allowed || (x = (ServicePermission)this.permissions.get("*")) == null || ((effective |= x.getMask()) & desired) != desired) break block11;
                return true;
            }
            x = (ServicePermission)this.permissions.get(name);
        }
        if (x != null && ((effective |= x.getMask()) & desired) == desired) {
            return true;
        }
        int offset = name.length() - 1;
        while ((last = name.lastIndexOf(".", offset)) != -1) {
            name = String.valueOf(name.substring(0, last + 1)) + "*";
            ServicePermissionCollection servicePermissionCollection2 = this;
            synchronized (servicePermissionCollection2) {
                x = (ServicePermission)this.permissions.get(name);
            }
            if (x != null && ((effective |= x.getMask()) & desired) == desired) {
                return true;
            }
            offset = last - 1;
        }
        return false;
    }

    public synchronized Enumeration elements() {
        return Collections.enumeration(this.permissions.values());
    }
}

