/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.internal.permadmin;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.security.Permission;
import java.util.ArrayList;
import java.util.HashMap;
import org.eclipse.osgi.internal.permadmin.BundlePermissions;
import org.eclipse.osgi.internal.permadmin.PermissionInfoCollection;
import org.eclipse.osgi.internal.permadmin.SecurityAdmin;
import org.osgi.framework.Bundle;
import org.osgi.service.condpermadmin.Condition;
import org.osgi.service.condpermadmin.ConditionInfo;
import org.osgi.service.condpermadmin.ConditionalPermissionInfo;
import org.osgi.service.permissionadmin.PermissionInfo;

public final class SecurityRow
implements ConditionalPermissionInfo {
    static final Class[] conditionMethodArgs;
    static Condition[] ABSTAIN_LIST;
    static Condition[] SATISFIED_LIST;
    static final Decision DECISION_ABSTAIN;
    static final Decision DECISION_GRANTED;
    static final Decision DECISION_DENIED;
    private final SecurityAdmin securityAdmin;
    private final String name;
    private final ConditionInfo[] conditionInfos;
    private final PermissionInfoCollection permissionInfoCollection;
    private final boolean deny;
    private final HashMap bundleConditions;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    static {
        Class[] classArray = new Class[2];
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.osgi.framework.Bundle");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[0] = clazz;
        Class<?> clazz2 = class$1;
        if (clazz2 == null) {
            try {
                clazz2 = class$1 = Class.forName("org.osgi.service.condpermadmin.ConditionInfo");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[1] = clazz2;
        conditionMethodArgs = classArray;
        ABSTAIN_LIST = new Condition[0];
        SATISFIED_LIST = new Condition[0];
        DECISION_ABSTAIN = new Decision(4, null, null, null);
        DECISION_GRANTED = new Decision(1, null, null, null);
        DECISION_DENIED = new Decision(2, null, null, null);
    }

    public SecurityRow(SecurityAdmin securityAdmin, String name, ConditionInfo[] conditionInfos, PermissionInfo[] permissionInfos, String decision) {
        this.securityAdmin = securityAdmin;
        this.conditionInfos = conditionInfos;
        this.deny = "deny".equals(decision);
        this.name = name;
        this.permissionInfoCollection = new PermissionInfoCollection(permissionInfos);
        this.bundleConditions = conditionInfos == null || conditionInfos.length == 0 ? null : new HashMap();
    }

    /*
     * Unable to fully structure code
     */
    static SecurityRow createSecurityRow(SecurityAdmin securityAdmin, String encoded) {
        start = encoded.indexOf(123);
        end = encoded.lastIndexOf(125);
        if (start < 0 || end < start) {
            throw new IllegalArgumentException(encoded);
        }
        decision = null;
        if (encoded.charAt(encoded.length() - 1) == '!') {
            decision = "deny";
        }
        encodedName = null;
        if (start != 0) {
            encodedName = encoded.substring(0, start);
        }
        chars = encoded.substring(start + 1, end).toCharArray();
        condList = new ArrayList<ConditionInfo>();
        permList = new ArrayList<PermissionInfo>();
        pos = 0;
        ** GOTO lbl41
        {
            ++pos;
            do {
                if (pos < chars.length && chars[pos] != '[' && chars[pos] != '(') continue block0;
                if (pos == chars.length) break block0;
                startPos = pos;
                endChar = chars[startPos] == '[' ? ']' : ')';
                while (chars[pos] != endChar) {
                    if (chars[pos] == '\"') {
                        ++pos;
                        while (chars[pos] != '\"') {
                            if (chars[pos] == '\\') {
                                ++pos;
                            }
                            ++pos;
                        }
                    }
                    ++pos;
                }
                endPos = pos;
                token = new String(chars, startPos, endPos - startPos + 1);
                if (endChar == ']') {
                    condList.add(new ConditionInfo(token));
                } else {
                    permList.add(new PermissionInfo(token));
                }
                ++pos;
lbl41:
                // 2 sources

            } while (pos < chars.length);
        }
        conds = condList.toArray(new ConditionInfo[condList.size()]);
        perms = permList.toArray(new PermissionInfo[permList.size()]);
        return new SecurityRow(securityAdmin, encodedName, conds, perms, decision);
    }

    public String getName() {
        return this.name;
    }

    public ConditionInfo[] getConditionInfos() {
        return this.conditionInfos;
    }

    public String getGrantDecision() {
        return this.deny ? "deny" : "allow";
    }

    public PermissionInfo[] getPermissionInfos() {
        return this.permissionInfoCollection.getPermissionInfos();
    }

    public void delete() {
        this.securityAdmin.delete(this, true);
    }

    Condition[] getConditions(Bundle bundle) {
        Condition[] conditions = new Condition[this.conditionInfos.length];
        int i = 0;
        while (i < this.conditionInfos.length) {
            block11: {
                Class<?> clazz;
                try {
                    clazz = Class.forName(this.conditionInfos[i].getType());
                }
                catch (ClassNotFoundException classNotFoundException) {
                    return null;
                }
                Constructor<?> constructor = null;
                Method method = null;
                try {
                    method = clazz.getMethod("getCondition", conditionMethodArgs);
                    if ((method.getModifiers() & 8) == 0) {
                        method = null;
                    }
                }
                catch (NoSuchMethodException noSuchMethodException) {}
                if (method == null) {
                    try {
                        constructor = clazz.getConstructor(conditionMethodArgs);
                    }
                    catch (NoSuchMethodException noSuchMethodException) {
                        conditions[i] = Condition.FALSE;
                        break block11;
                    }
                }
                Object[] args = new Object[]{bundle, this.conditionInfos[i]};
                try {
                    conditions[i] = method != null ? (Condition)method.invoke(null, args) : (Condition)constructor.newInstance(args);
                }
                catch (Throwable throwable) {
                    conditions[i] = Condition.FALSE;
                }
            }
            ++i;
        }
        return conditions;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    Decision evaluate(BundlePermissions bundlePermissions, Permission permission) {
        Condition[] conditions;
        if (this.bundleConditions == null) return this.evaluatePermission(permission);
        if (bundlePermissions == null) {
            return this.evaluatePermission(permission);
        }
        HashMap hashMap = this.bundleConditions;
        synchronized (hashMap) {
            conditions = (Condition[])this.bundleConditions.get(bundlePermissions);
            if (conditions == null) {
                conditions = this.getConditions(bundlePermissions.getBundle());
                this.bundleConditions.put(bundlePermissions, conditions);
            }
        }
        if (conditions == ABSTAIN_LIST) {
            return DECISION_ABSTAIN;
        }
        if (conditions == SATISFIED_LIST) {
            return this.evaluatePermission(permission);
        }
        boolean empty = true;
        ArrayList<Condition> postponedConditions = null;
        Decision postponedPermCheck = null;
        int i = 0;
        while (i < conditions.length) {
            block21: {
                block23: {
                    Condition condition;
                    block22: {
                        condition = conditions[i];
                        if (condition == null) break block21;
                        if (this.isPostponed(condition)) break block22;
                        if (condition.isSatisfied()) {
                            if (!condition.isMutable()) {
                                conditions[i] = null;
                            }
                            break block23;
                        } else {
                            if (condition.isMutable()) return DECISION_ABSTAIN;
                            HashMap hashMap2 = this.bundleConditions;
                            synchronized (hashMap2) {
                                this.bundleConditions.put(bundlePermissions, ABSTAIN_LIST);
                                return DECISION_ABSTAIN;
                            }
                        }
                    }
                    if (postponedPermCheck == null) {
                        postponedPermCheck = this.evaluatePermission(permission);
                    }
                    if (postponedPermCheck == DECISION_ABSTAIN) {
                        return postponedPermCheck;
                    }
                    if (postponedConditions == null) {
                        postponedConditions = new ArrayList<Condition>(1);
                    }
                    postponedConditions.add(condition);
                }
                empty &= conditions[i] == null;
            }
            ++i;
        }
        if (empty) {
            HashMap hashMap3 = this.bundleConditions;
            synchronized (hashMap3) {
                this.bundleConditions.put(bundlePermissions, SATISFIED_LIST);
            }
        }
        if (postponedPermCheck == null) return this.evaluatePermission(permission);
        return new Decision(postponedPermCheck.decision | 8, postponedConditions.toArray(new Condition[postponedConditions.size()]), this, bundlePermissions);
    }

    private boolean isPostponed(Condition condition) {
        return condition.isPostponed() && this.securityAdmin.getSupportedSecurityManager() != null;
    }

    private Decision evaluatePermission(Permission permission) {
        return this.permissionInfoCollection.implies(permission) ? (this.deny ? DECISION_DENIED : DECISION_GRANTED) : DECISION_ABSTAIN;
    }

    public String toString() {
        int i;
        StringBuffer result = new StringBuffer();
        if (this.name != null) {
            result.append(this.name);
        }
        ConditionInfo[] curConds = this.getConditionInfos();
        PermissionInfo[] curPerms = this.getPermissionInfos();
        result.append('{').append(' ');
        if (curConds != null) {
            i = 0;
            while (i < curConds.length) {
                result.append(curConds[i].getEncoded()).append(' ');
                ++i;
            }
        }
        if (curPerms != null) {
            i = 0;
            while (i < curPerms.length) {
                result.append(curPerms[i].getEncoded()).append(' ');
                ++i;
            }
        }
        result.append('}');
        if (this.deny) {
            result.append('!');
        }
        return result.toString();
    }

    PermissionInfoCollection getPermissionInfoCollection() {
        return this.permissionInfoCollection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void clearCaches() {
        this.permissionInfoCollection.clearPermissionCache();
        if (this.bundleConditions != null) {
            HashMap hashMap = this.bundleConditions;
            synchronized (hashMap) {
                this.bundleConditions.clear();
            }
        }
    }

    static class Decision {
        final int decision;
        final Condition[] postponed;
        private final SecurityRow row;
        private final BundlePermissions bundlePermissions;

        Decision(int decision, Condition[] postponed, SecurityRow row, BundlePermissions bundlePermissions) {
            this.decision = decision;
            this.postponed = postponed;
            this.row = row;
            this.bundlePermissions = bundlePermissions;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void handleImmutable(Condition condition, boolean isSatisfied) {
            if (condition.isMutable() || !condition.isPostponed()) {
                return;
            }
            if (isSatisfied) {
                HashMap hashMap = this.row.bundleConditions;
                synchronized (hashMap) {
                    Condition[] rowConditions = (Condition[])this.row.bundleConditions.get(this.bundlePermissions);
                    boolean isEmpty = true;
                    int i = 0;
                    while (i < rowConditions.length) {
                        if (rowConditions[i] == condition && isSatisfied) {
                            rowConditions[i] = null;
                        }
                        isEmpty &= rowConditions[i] == null;
                        ++i;
                    }
                    if (isEmpty) {
                        this.row.bundleConditions.put(this.bundlePermissions, SATISFIED_LIST);
                    }
                }
            }
            HashMap hashMap = this.row.bundleConditions;
            synchronized (hashMap) {
                this.row.bundleConditions.put(this.bundlePermissions, ABSTAIN_LIST);
            }
        }
    }
}

