/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.java.ui.junit;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IProjectNature;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeHierarchy;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.junit.launcher.TestKindRegistry;
import org.eclipse.jdt.launching.IJavaLaunchConfigurationConstants;
import org.eclipse.mylyn.context.core.AbstractContextStructureBridge;
import org.eclipse.mylyn.context.core.ContextCorePlugin;
import org.eclipse.mylyn.context.core.IInteractionElement;
import org.eclipse.mylyn.context.core.IInteractionRelation;
import org.eclipse.mylyn.monitor.core.StatusHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InteractionContextTestUtil {
    public static void setupTestConfiguration(Set<IType> contextTestCases, ILaunchConfiguration configuration, IProgressMonitor pm) throws CoreException {
        String testKindId = "org.eclipse.jdt.junit.loader.junit3";
        IJavaProject javaProject = null;
        for (IType type : contextTestCases) {
            IProjectNature nature = type.getJavaProject().getProject().getNature("org.eclipse.pde.PluginNature");
            if (nature == null) continue;
            javaProject = type.getJavaProject();
        }
        ILaunchConfigurationWorkingCopy workingCopy = configuration.getWorkingCopy();
        if (javaProject != null) {
            workingCopy.setAttribute(IJavaLaunchConfigurationConstants.ATTR_PROJECT_NAME, javaProject.getElementName());
        }
        if (contextTestCases.size() > 0) {
            testKindId = TestKindRegistry.getContainerTestKindId((IJavaElement)((IJavaElement)contextTestCases.iterator().next()));
            workingCopy.setAttribute("org.eclipse.jdt.junit.TEST_KIND", testKindId);
        }
        workingCopy.doSave();
    }

    public static Set<IType> getTestCasesInContext() {
        HashSet<IType> testTypes = new HashSet<IType>();
        List interesting = ContextCorePlugin.getContextManager().getActiveContext().getInteresting();
        AbstractContextStructureBridge bridge = ContextCorePlugin.getDefault().getStructureBridge("java");
        try {
            for (IInteractionElement element : interesting) {
                IType type;
                if (!element.getContentType().equals("java")) continue;
                Object javaElement = bridge.getObjectForHandle(element.getHandleIdentifier());
                if (javaElement instanceof IType && InteractionContextTestUtil.isTestType(type = (IType)javaElement)) {
                    testTypes.add(type);
                }
                for (IInteractionRelation relation : element.getRelations()) {
                    IMethod testMethod;
                    IInteractionElement target;
                    Object targetObject;
                    if (!relation.getRelationshipHandle().equals("org.eclipse.mylyn.java.relation.junitreferences") || !((targetObject = bridge.getObjectForHandle((target = relation.getTarget()).getHandleIdentifier())) instanceof IMethod) || !InteractionContextTestUtil.isTestType((IType)(testMethod = (IMethod)targetObject).getParent())) continue;
                    testTypes.add((IType)testMethod.getParent());
                }
            }
        }
        catch (Exception e) {
            StatusHandler.log((IStatus)new Status(4, "org.eclipse.mylyn.java.ui", "Could not add all test types", (Throwable)e));
        }
        return testTypes;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean isTestType(IType type) {
        try {
            if (Flags.isAbstract((int)type.getFlags())) {
                return false;
            }
        }
        catch (JavaModelException javaModelException) {
            return false;
        }
        try {
            ITypeHierarchy hierarchy = type.newSupertypeHierarchy(null);
            IType[] supertypes = hierarchy.getAllSuperclasses(type);
            int i = 0;
            while (true) {
                if (i >= supertypes.length) {
                    return false;
                }
                if (supertypes[i].getFullyQualifiedName().equals("junit.framework.TestCase")) {
                    return true;
                }
                ++i;
            }
        }
        catch (JavaModelException javaModelException) {}
        return false;
    }
}

