/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.java.ui.wizards;

import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.mylyn.internal.tasks.ui.TaskListColorsAndFonts;
import org.eclipse.mylyn.tasks.ui.TasksUiUtil;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.Hyperlink;

public class RecommendedPreferencesWizardPage
extends WizardPage {
    private static final String DESCRIPTION = "You have activated a task for the first time.\nThe following Java preferences are recommended for the Task-Focused UI.\n";
    private static final String AUTO_FOLDING = "Turn automatic Java editor folding on";
    private static final String CONTENT_ASSIST = "Enable task-context ranked content assist, requires Eclipse restart.";
    private static final String CONTENT_ASSIST_WARNING = "Toggle via Preferences->Java->Editor->Content Assist->Advanced ";
    private Button contentAssistButton;
    private Button turnOnAutoFoldingButton;
    private boolean autoFolding = true;
    private boolean openTaskList = true;

    protected RecommendedPreferencesWizardPage(String pageName) {
        super(pageName);
        this.setTitle(pageName);
        this.setDescription(DESCRIPTION);
    }

    public void createControl(Composite parent) {
        Composite containerComposite = new Composite(parent, 0);
        containerComposite.setLayout((Layout)new GridLayout());
        Composite buttonComposite = new Composite(containerComposite, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.makeColumnsEqualWidth = false;
        buttonComposite.setLayout((Layout)layout);
        this.contentAssistButton = new Button(buttonComposite, 32);
        GridData gd = new GridData();
        this.contentAssistButton.setLayoutData((Object)gd);
        this.contentAssistButton.setSelection(true);
        Label label = new Label(buttonComposite, 0);
        label.setText(CONTENT_ASSIST);
        label = new Label(buttonComposite, 0);
        label = new Label(buttonComposite, 0);
        label.setFont(JFaceResources.getFontRegistry().getItalic("org.eclipse.jface.defaultfont"));
        label.setText(CONTENT_ASSIST_WARNING);
        gd = new GridData();
        label.setLayoutData((Object)gd);
        this.turnOnAutoFoldingButton = new Button(buttonComposite, 32);
        gd = new GridData();
        this.turnOnAutoFoldingButton.setLayoutData((Object)gd);
        this.turnOnAutoFoldingButton.setSelection(true);
        this.turnOnAutoFoldingButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                RecommendedPreferencesWizardPage.this.autoFolding = RecommendedPreferencesWizardPage.this.turnOnAutoFoldingButton.getSelection();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        label = new Label(buttonComposite, 0);
        label.setText(AUTO_FOLDING);
        gd = new GridData();
        label.setLayoutData((Object)gd);
        label = new Label(buttonComposite, 0);
        label = new Label(buttonComposite, 0);
        label.setFont(JFaceResources.getFontRegistry().getItalic("org.eclipse.jface.defaultfont"));
        label.setText("Toggle via toolbar button ");
        Label spacer = new Label(buttonComposite, 0);
        spacer.setText(" ");
        spacer = new Label(buttonComposite, 0);
        spacer.setText(" ");
        Hyperlink hyperlink = new Hyperlink(containerComposite, 0);
        hyperlink.setUnderlined(true);
        hyperlink.setForeground(TaskListColorsAndFonts.COLOR_HYPERLINK_WIDGET);
        hyperlink.setText("If this is your first time using Mylyn please watch the Getting Started video");
        label = new Label(containerComposite, 0);
        label.setText("For a legend of the icons used by Mylyn open: Help (menu) -> Mylyn UI Legend");
        gd = new GridData();
        label.setLayoutData((Object)gd);
        hyperlink.addHyperlinkListener(new IHyperlinkListener(){

            public void linkActivated(HyperlinkEvent e) {
                TasksUiUtil.openUrl((String)"http://eclipse.org/mylyn/start.php", (boolean)false);
            }

            public void linkEntered(HyperlinkEvent e) {
            }

            public void linkExited(HyperlinkEvent e) {
            }
        });
        this.setControl((Control)containerComposite);
    }

    public boolean isAutoFolding() {
        return this.autoFolding;
    }

    public boolean isMylarContentAssistDefault() {
        return this.contentAssistButton.getSelection();
    }

    public boolean isOpenTaskList() {
        return this.openTaskList;
    }
}

