/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.java.ui.wizards;

import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.mylyn.context.ui.ContextUiPlugin;
import org.eclipse.mylyn.internal.context.ui.ContextUiImages;
import org.eclipse.mylyn.internal.java.ui.JavaUiBridgePlugin;
import org.eclipse.mylyn.internal.java.ui.JavaUiUtil;
import org.eclipse.mylyn.internal.java.ui.wizards.RecommendedPreferencesWizardPage;
import org.eclipse.mylyn.internal.tasks.ui.views.TaskListView;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;

public class RecommendedPreferencesWizard
extends Wizard
implements INewWizard {
    private RecommendedPreferencesWizardPage preferencePage;
    public static final String MYLAR_FIRST_RUN = "org.eclipse.mylyn.ui.first.run.0_4_9";
    private static final String DEFAULT_FOLDING_PROVIDER = "org.eclipse.jdt.ui.text.defaultFoldingProvider";
    private IPreferenceStore javaPrefs = JavaPlugin.getDefault().getPreferenceStore();

    public void init() {
        this.setDefaultPageImageDescriptor(ContextUiImages.MYLYN);
        this.setWindowTitle("Recommended Preferences");
        super.setDefaultPageImageDescriptor(JavaUiBridgePlugin.imageDescriptorFromPlugin((String)"org.eclipse.mylyn.java.ui", (String)"icons/wizban/banner-prefs.gif"));
        this.preferencePage = new RecommendedPreferencesWizardPage("Mylyn Java Preference Settings");
    }

    public RecommendedPreferencesWizard() {
        this.init();
    }

    public RecommendedPreferencesWizard(String htmlDocs) {
        this.init();
    }

    public boolean performFinish() {
        this.setPreferences();
        if (this.preferencePage.isOpenTaskList()) {
            TaskListView.openInActivePerspective();
        }
        return true;
    }

    private void setPreferences() {
        boolean mylarContentAssist = this.preferencePage.isMylarContentAssistDefault();
        JavaUiUtil.installContentAssist(this.javaPrefs, mylarContentAssist);
        if (this.preferencePage.isAutoFolding()) {
            ContextUiPlugin.getDefault().getPreferenceStore().setValue("org.eclipse.mylyn.context.ui.editor.folding.enabled", true);
            this.javaPrefs.setValue("editor_folding_enabled", true);
            this.javaPrefs.setValue("editor_folding_provider", DEFAULT_FOLDING_PROVIDER);
        } else {
            ContextUiPlugin.getDefault().getPreferenceStore().setValue("org.eclipse.mylyn.context.ui.editor.folding.enabled", false);
        }
    }

    public void addPages() {
        this.addPage((IWizardPage)this.preferencePage);
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
    }
}

