/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.java.ui.views;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeHierarchy;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.util.TransferDragSourceListener;
import org.eclipse.jface.viewers.DecoratingLabelProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IOpenListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.OpenEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.mylyn.context.core.ContextCorePlugin;
import org.eclipse.mylyn.context.core.IInteractionContext;
import org.eclipse.mylyn.context.core.IInteractionContextListener;
import org.eclipse.mylyn.context.core.IInteractionElement;
import org.eclipse.mylyn.internal.context.ui.ActiveViewSelectionDragAdapter;
import org.eclipse.mylyn.internal.context.ui.views.ActiveViewDelegatingDragAdapter;
import org.eclipse.mylyn.internal.context.ui.views.ActiveViewDropAdapter;
import org.eclipse.mylyn.internal.java.ui.JavaContextLabelProvider;
import org.eclipse.mylyn.internal.java.ui.views.TreeParent;
import org.eclipse.mylyn.monitor.core.StatusHandler;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.ResourceTransfer;
import org.eclipse.ui.part.ViewPart;
import org.eclipse.ui.views.navigator.LocalSelectionTransfer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ActiveHierarchyView
extends ViewPart {
    public static final String ID = "org.eclipse.mylyn.ui.views.active.hierarchy";
    private TreeParent root = new TreeParent("<no hierarchy>");
    private TreeViewer viewer;
    private Map<String, TreeParent> nodeMap = new HashMap<String, TreeParent>();
    final IInteractionContextListener MODEL_LISTENER = new IInteractionContextListener(){

        public void contextActivated(IInteractionContext taskscape) {
            ActiveHierarchyView.this.refreshHierarchy();
        }

        public void contextDeactivated(IInteractionContext taskscape) {
            ActiveHierarchyView.this.refreshHierarchy();
        }

        public void contextCleared(IInteractionContext context) {
            ActiveHierarchyView.this.refreshHierarchy();
        }

        public void interestChanged(List<IInteractionElement> nodes) {
        }

        public void landmarkAdded(IInteractionElement element) {
            ActiveHierarchyView.this.refreshHierarchy();
        }

        public void landmarkRemoved(IInteractionElement element) {
            ActiveHierarchyView.this.refreshHierarchy();
        }

        public void relationsChanged(IInteractionElement node) {
        }

        public void elementDeleted(IInteractionElement node) {
        }
    };

    private void refreshHierarchy() {
        this.refreshHierarchy(true);
    }

    public void refreshHierarchy(boolean asyncRefreshMode) {
        try {
            if (this.root != null && this.root.getChildren().length > 0) {
                this.root.removeAllChildren();
            }
            this.nodeMap.clear();
            List landmarks = ContextCorePlugin.getContextManager().getActiveLandmarks();
            for (IInteractionElement node : landmarks) {
                IType type;
                ITypeHierarchy hierarchy;
                IJavaElement element = null;
                if (node.getContentType().equals("java")) {
                    element = JavaCore.create((String)node.getHandleIdentifier());
                }
                if (element == null || !(element instanceof IType) || !element.exists() || (hierarchy = (type = (IType)element).newSupertypeHierarchy(null)) == null) continue;
                IType[] supertypes = hierarchy.getAllSuperclasses(type);
                ArrayList<IType> hierarchyTypes = new ArrayList<IType>((Collection)Arrays.asList(supertypes));
                Collections.reverse(hierarchyTypes);
                hierarchyTypes.add(type);
                this.addHierarchy(this.root, hierarchyTypes);
            }
            if (!asyncRefreshMode) {
                this.refreshViewer();
            } else {
                PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

                    public void run() {
                        ActiveHierarchyView.this.refreshViewer();
                    }
                });
            }
        }
        catch (Throwable t) {
            StatusHandler.fail((Throwable)t, (String)"Could not update viewer", (boolean)false);
        }
    }

    private void addHierarchy(TreeParent node, List<IType> hierarchyTypes) {
        if (hierarchyTypes.isEmpty()) {
            return;
        }
        IType type = hierarchyTypes.get(0);
        if (!type.equals(node.getElement())) {
            TreeParent newNode = this.nodeMap.get(type.getHandleIdentifier());
            if (newNode == null) {
                newNode = new TreeParent((IJavaElement)type);
                this.nodeMap.put(type.getHandleIdentifier(), newNode);
                node.addChild(newNode);
            }
            this.addHierarchy(newNode, hierarchyTypes.subList(1, hierarchyTypes.size()));
        }
    }

    private void refreshViewer() {
        try {
            if (this.viewer != null && !this.viewer.getTree().isDisposed()) {
                this.viewer.getControl().setRedraw(false);
                this.viewer.refresh();
                this.viewer.expandAll();
                this.viewer.getControl().setRedraw(true);
            }
        }
        catch (Throwable t) {
            StatusHandler.fail((Throwable)t, (String)"Could not update viewer", (boolean)false);
        }
    }

    public void createPartControl(Composite parent) {
        try {
            ContextCorePlugin.getContextManager().addListener(this.MODEL_LISTENER);
            this.refreshHierarchy();
            this.viewer = new TreeViewer(parent, 770);
            this.viewer.setContentProvider((IContentProvider)new ViewContentProvider());
            this.viewer.setLabelProvider((IBaseLabelProvider)new DecoratingLabelProvider((ILabelProvider)JavaContextLabelProvider.createJavaUiLabelProvider(), PlatformUI.getWorkbench().getDecoratorManager().getLabelDecorator()));
            this.viewer.setInput((Object)this.getViewSite());
            this.viewer.addOpenListener(new IOpenListener(){

                public void open(OpenEvent event) {
                    StructuredSelection selection = (StructuredSelection)ActiveHierarchyView.this.viewer.getSelection();
                    if (selection.getFirstElement() != null && selection.getFirstElement() instanceof IJavaElement) {
                        IJavaElement element = (IJavaElement)selection.getFirstElement();
                        try {
                            IEditorPart part = JavaUI.openInEditor((IJavaElement)element);
                            JavaUI.revealInEditor((IEditorPart)part, (IJavaElement)element);
                        }
                        catch (Throwable t) {
                            StatusHandler.log((Throwable)t, (String)"Could not open type");
                        }
                    }
                }
            });
            this.hookContextMenu();
            this.contributeToActionBars();
            this.initDrop();
            this.initDrag();
            this.getSite().setSelectionProvider((ISelectionProvider)this.getViewer());
        }
        catch (Throwable t) {
            StatusHandler.log((Throwable)t, (String)"create failed");
        }
    }

    private void initDrop() {
        Transfer[] types = new Transfer[]{LocalSelectionTransfer.getInstance()};
        this.viewer.addDropSupport(2, types, (DropTargetListener)new ActiveViewDropAdapter((Viewer)this.viewer));
    }

    private void initDrag() {
        int ops = 7;
        Transfer[] transfers = new Transfer[]{LocalSelectionTransfer.getInstance(), ResourceTransfer.getInstance()};
        TransferDragSourceListener[] dragListeners = new TransferDragSourceListener[]{new ActiveViewSelectionDragAdapter((ISelectionProvider)this.viewer)};
        this.viewer.addDragSupport(ops, transfers, (DragSourceListener)new ActiveViewDelegatingDragAdapter(dragListeners));
    }

    private void hookContextMenu() {
        MenuManager menuMgr = new MenuManager("#PopupMenu");
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                ActiveHierarchyView.this.fillContextMenu(manager);
            }
        });
        Menu menu = menuMgr.createContextMenu(this.viewer.getControl());
        this.viewer.getControl().setMenu(menu);
        this.getSite().registerContextMenu(menuMgr, (ISelectionProvider)this.viewer);
    }

    private void contributeToActionBars() {
        IActionBars bars = this.getViewSite().getActionBars();
        this.fillLocalPullDown(bars.getMenuManager());
        this.fillLocalToolBar(bars.getToolBarManager());
    }

    private void fillLocalPullDown(IMenuManager manager) {
        manager.add((IContributionItem)new Separator("additions"));
    }

    private void fillContextMenu(IMenuManager manager) {
        manager.add((IContributionItem)new Separator("additions"));
    }

    private void fillLocalToolBar(IToolBarManager manager) {
        manager.add((IContributionItem)new Separator("additions"));
    }

    public void setFocus() {
        this.viewer.getControl().setFocus();
    }

    public TreeViewer getViewer() {
        return this.viewer;
    }

    class ViewContentProvider
    implements IStructuredContentProvider,
    ITreeContentProvider {
        ViewContentProvider() {
        }

        public void inputChanged(Viewer v, Object oldInput, Object newInput) {
        }

        public void dispose() {
        }

        public Object[] getElements(Object parent) {
            Object[] types = new Object[ActiveHierarchyView.this.root.getChildren().length];
            int i = 0;
            while (i < ActiveHierarchyView.this.root.getChildren().length) {
                types[i] = ActiveHierarchyView.this.root.getChildren()[i].getElement();
                ++i;
            }
            return types;
        }

        public Object getParent(Object child) {
            return null;
        }

        public Object[] getChildren(Object parent) {
            TreeParent node;
            if (parent instanceof IType && (node = (TreeParent)ActiveHierarchyView.this.nodeMap.get(((IType)parent).getHandleIdentifier())) != null) {
                Object[] types = new Object[node.getChildren().length];
                int i = 0;
                while (i < node.getChildren().length) {
                    types[i] = node.getChildren()[i].getElement();
                    ++i;
                }
                return types;
            }
            return new Object[0];
        }

        public boolean hasChildren(Object parent) {
            TreeParent node;
            if (parent instanceof IType && (node = (TreeParent)ActiveHierarchyView.this.nodeMap.get(((IType)parent).getHandleIdentifier())) != null) {
                return node.getChildren().length > 0;
            }
            return false;
        }
    }
}

