/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.java.ui.junit;

import java.util.Set;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.internal.junit.launcher.JUnitLaunchConfigurationTab;
import org.eclipse.jdt.launching.IJavaLaunchConfigurationConstants;
import org.eclipse.mylyn.internal.java.ui.JavaUiBridgePlugin;
import org.eclipse.mylyn.internal.java.ui.junit.MylarContextTestUtil;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class MylarJUnitMainTab
extends JUnitLaunchConfigurationTab {
    private static final String DESCRIPTION = "Subclasses of TestCase in the active task context automatically added to suite.";
    private boolean isPdeMode = false;

    public MylarJUnitMainTab(boolean isPdeMode) {
        this.isPdeMode = isPdeMode;
    }

    public void createControl(Composite parent) {
        Composite comp = new Composite(parent, 0);
        this.setControl((Control)comp);
        GridLayout topLayout = new GridLayout();
        topLayout.numColumns = 3;
        comp.setLayout((Layout)topLayout);
        new Label(comp, 0);
        Label label = new Label(comp, 0);
        GridData gd = new GridData();
        gd.horizontalSpan = 3;
        label.setLayoutData((Object)gd);
        label.setText(DESCRIPTION);
    }

    public void performApply(ILaunchConfigurationWorkingCopy config) {
        Set<IType> types;
        if (!this.isPdeMode && !(types = MylarContextTestUtil.getTestCasesInContext()).isEmpty()) {
            IType firstType = types.iterator().next();
            String projectName = firstType.getJavaProject().getElementName();
            config.setAttribute(IJavaLaunchConfigurationConstants.ATTR_PROJECT_NAME, projectName);
        }
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy config) {
    }

    public void initializeFrom(ILaunchConfiguration config) {
    }

    public String getName() {
        return "JUnit";
    }

    public Image getImage() {
        return JavaUiBridgePlugin.getImageDescriptor("icons/etool16/junit-tab.gif").createImage();
    }
}

