/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.java.ui.junit;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeHierarchy;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.junit.launcher.ITestKind;
import org.eclipse.jdt.internal.junit.launcher.TestKind;
import org.eclipse.jdt.internal.junit.launcher.TestKindRegistry;
import org.eclipse.jdt.internal.junit.launcher.TestSearchResult;
import org.eclipse.mylyn.context.core.AbstractContextStructureBridge;
import org.eclipse.mylyn.context.core.ContextCorePlugin;
import org.eclipse.mylyn.context.core.IInteractionElement;
import org.eclipse.mylyn.context.core.IInteractionRelation;
import org.eclipse.mylyn.monitor.core.StatusHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MylarContextTestUtil {
    public static TestSearchResult findTestTypes(ILaunchConfiguration configuration, IProgressMonitor pm) throws CoreException {
        Set<IType> contextTestCases = MylarContextTestUtil.getTestCasesInContext();
        TestKind testKind = TestKindRegistry.getDefault().getKind(configuration);
        if (contextTestCases.size() > 0) {
            testKind = TestKindRegistry.getDefault().getKind(contextTestCases.iterator().next());
        }
        return new TestSearchResult(contextTestCases.toArray(new IType[contextTestCases.size()]), (ITestKind)testKind);
    }

    public static Set<IType> getTestCasesInContext() {
        HashSet<IType> testTypes = new HashSet<IType>();
        List interesting = ContextCorePlugin.getContextManager().getActiveContext().getInteresting();
        AbstractContextStructureBridge bridge = ContextCorePlugin.getDefault().getStructureBridge("java");
        try {
            for (IInteractionElement element : interesting) {
                IType type;
                if (!element.getContentType().equals("java")) continue;
                Object javaElement = bridge.getObjectForHandle(element.getHandleIdentifier());
                if (javaElement instanceof IType && MylarContextTestUtil.isTestType(type = (IType)javaElement)) {
                    testTypes.add(type);
                }
                for (IInteractionRelation relation : element.getRelations()) {
                    IMethod testMethod;
                    IInteractionElement target;
                    Object targetObject;
                    if (!relation.getRelationshipHandle().equals("org.eclipse.mylyn.java.relation.junitreferences") || !((targetObject = bridge.getObjectForHandle((target = relation.getTarget()).getHandleIdentifier())) instanceof IMethod) || !MylarContextTestUtil.isTestType((IType)(testMethod = (IMethod)targetObject).getParent())) continue;
                    testTypes.add((IType)testMethod.getParent());
                }
            }
        }
        catch (Exception e) {
            StatusHandler.fail((Throwable)e, (String)"could not add all test types", (boolean)false);
        }
        return testTypes;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean isTestType(IType type) {
        try {
            if (Flags.isAbstract((int)type.getFlags())) {
                return false;
            }
        }
        catch (JavaModelException javaModelException) {
            return false;
        }
        try {
            ITypeHierarchy hierarchy = type.newSupertypeHierarchy(null);
            IType[] supertypes = hierarchy.getAllSuperclasses(type);
            int i = 0;
            while (true) {
                if (i >= supertypes.length) {
                    return false;
                }
                if (supertypes[i].getFullyQualifiedName().equals("junit.framework.TestCase")) {
                    return true;
                }
                ++i;
            }
        }
        catch (JavaModelException javaModelException) {}
        return false;
    }
}

