/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.java.ui.editor;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IParent;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.ui.javaeditor.JavaEditor;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jdt.ui.text.folding.IJavaFoldingStructureProvider;
import org.eclipse.jdt.ui.text.folding.IJavaFoldingStructureProviderExtension;
import org.eclipse.mylyn.context.core.ContextCorePlugin;
import org.eclipse.mylyn.context.core.IInteractionContext;
import org.eclipse.mylyn.context.core.IInteractionContextListener;
import org.eclipse.mylyn.context.core.IInteractionElement;
import org.eclipse.mylyn.context.ui.ContextUiPlugin;
import org.eclipse.mylyn.internal.java.ui.JavaStructureBridge;
import org.eclipse.mylyn.monitor.core.StatusHandler;
import org.eclipse.ui.IEditorInput;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ActiveFoldingListener
implements IInteractionContextListener {
    private final JavaEditor editor;
    private IJavaFoldingStructureProviderExtension updater;
    private static JavaStructureBridge bridge = (JavaStructureBridge)ContextCorePlugin.getDefault().getStructureBridge("java");
    private boolean enabled = false;
    private Preferences.IPropertyChangeListener PREFERENCE_LISTENER = new Preferences.IPropertyChangeListener(){

        public void propertyChange(Preferences.PropertyChangeEvent event) {
            if (event.getProperty().equals("org.eclipse.mylyn.context.ui.editor.folding.enabled")) {
                if (event.getNewValue().equals(Boolean.TRUE.toString())) {
                    ActiveFoldingListener.this.enabled = true;
                } else {
                    ActiveFoldingListener.this.enabled = false;
                }
                ActiveFoldingListener.this.updateFolding();
            }
        }
    };

    public ActiveFoldingListener(JavaEditor editor) {
        this.editor = editor;
        ContextCorePlugin.getContextManager().addListener((IInteractionContextListener)this);
        ContextUiPlugin.getDefault().getPluginPreferences().addPropertyChangeListener(this.PREFERENCE_LISTENER);
        this.enabled = ContextUiPlugin.getDefault().getPreferenceStore().getBoolean("org.eclipse.mylyn.context.ui.editor.folding.enabled");
        try {
            Object adapter = editor.getAdapter(IJavaFoldingStructureProvider.class);
            if (adapter instanceof IJavaFoldingStructureProviderExtension) {
                this.updater = (IJavaFoldingStructureProviderExtension)adapter;
            } else {
                StatusHandler.log((String)("Could not install active folding on provider: " + adapter + ", must extend " + IJavaFoldingStructureProviderExtension.class.getName()), (Object)this);
            }
        }
        catch (Exception e) {
            StatusHandler.fail((Throwable)e, (String)"could not install auto folding, reflection denied", (boolean)false);
        }
        this.updateFolding();
    }

    public void dispose() {
        ContextCorePlugin.getContextManager().removeListener((IInteractionContextListener)this);
        ContextUiPlugin.getDefault().getPluginPreferences().removePropertyChangeListener(this.PREFERENCE_LISTENER);
    }

    public static void resetProjection(JavaEditor javaEditor) {
    }

    public void updateFolding() {
        if (!this.enabled || !ContextCorePlugin.getContextManager().isContextActive()) {
            this.editor.resetProjection();
        } else {
            if (this.editor.getEditorInput() == null) {
                return;
            }
            try {
                ArrayList<IJavaElement> toExpand = new ArrayList<IJavaElement>();
                ArrayList<IJavaElement> toCollapse = new ArrayList<IJavaElement>();
                IJavaElement element = JavaUI.getEditorInputJavaElement((IEditorInput)this.editor.getEditorInput());
                if (element instanceof ICompilationUnit) {
                    ICompilationUnit compilationUnit = (ICompilationUnit)element;
                    List<IJavaElement> allChildren = ActiveFoldingListener.getAllChildren((IParent)compilationUnit);
                    for (IJavaElement child : allChildren) {
                        IInteractionElement mylarElement = ContextCorePlugin.getContextManager().getElement(bridge.getHandleIdentifier(child));
                        if (mylarElement != null && mylarElement.getInterest().isInteresting()) {
                            toExpand.add(child);
                            continue;
                        }
                        toCollapse.add(child);
                    }
                }
                if (this.updater != null) {
                    this.updater.collapseMembers();
                    this.updater.expandElements(toExpand.toArray(new IJavaElement[toExpand.size()]));
                }
            }
            catch (Exception e) {
                StatusHandler.fail((Throwable)e, (String)"couldn't update folding", (boolean)false);
            }
        }
    }

    private static List<IJavaElement> getAllChildren(IParent parentElement) {
        ArrayList<IJavaElement> allChildren = new ArrayList<IJavaElement>();
        try {
            IJavaElement[] iJavaElementArray = parentElement.getChildren();
            int n = 0;
            int n2 = iJavaElementArray.length;
            while (n < n2) {
                IJavaElement child = iJavaElementArray[n];
                allChildren.add(child);
                if (child instanceof IParent) {
                    allChildren.addAll(ActiveFoldingListener.getAllChildren((IParent)child));
                }
                ++n;
            }
        }
        catch (JavaModelException javaModelException) {}
        return allChildren;
    }

    public void interestChanged(List<IInteractionElement> elements) {
        for (IInteractionElement element : elements) {
            if (this.updater == null || !this.enabled) {
                return;
            }
            Object object = bridge.getObjectForHandle(element.getHandleIdentifier());
            if (!(object instanceof IMember)) continue;
            IMember member = (IMember)object;
            if (element.getInterest().isInteresting()) {
                this.updater.expandElements(new IJavaElement[]{member});
                try {
                    IJavaElement[] childsChildren;
                    IJavaElement[] children = member.getChildren();
                    if (children.length != 1) continue;
                    this.updater.expandElements(new IJavaElement[]{children[0]});
                    if (!(children[0] instanceof IParent) || (childsChildren = ((IParent)children[0]).getChildren()).length != 1) continue;
                    this.updater.expandElements(new IJavaElement[]{childsChildren[0]});
                }
                catch (JavaModelException javaModelException) {}
                continue;
            }
            this.updater.collapseElements(new IJavaElement[]{member});
        }
    }

    public void contextActivated(IInteractionContext context) {
        if (ContextUiPlugin.getDefault().getPreferenceStore().getBoolean("org.eclipse.mylyn.context.ui.editor.folding.enabled")) {
            this.updateFolding();
        }
    }

    public void contextDeactivated(IInteractionContext context) {
        if (ContextUiPlugin.getDefault().getPreferenceStore().getBoolean("org.eclipse.mylyn.context.ui.editor.folding.enabled")) {
            this.updateFolding();
        }
    }

    public void contextCleared(IInteractionContext context) {
        if (ContextUiPlugin.getDefault().getPreferenceStore().getBoolean("org.eclipse.mylyn.context.ui.editor.folding.enabled")) {
            this.updateFolding();
        }
    }

    public void landmarkAdded(IInteractionElement element) {
    }

    public void landmarkRemoved(IInteractionElement element) {
    }

    public void relationsChanged(IInteractionElement node) {
    }

    public void elementDeleted(IInteractionElement node) {
    }
}

