/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.java.ui.actions;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.mylyn.context.ui.AbstractFocusViewAction;
import org.eclipse.mylyn.context.ui.InterestFilter;
import org.eclipse.mylyn.monitor.core.StatusHandler;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FocusBrowsingPerspectiveAction
extends AbstractFocusViewAction
implements IWorkbenchWindowActionDelegate {
    private String packageViewerWrapperClassName = "org.eclipse.jdt.internal.ui.browsing.PackageViewerWrapper";
    private String[] viewNames = new String[]{"org.eclipse.jdt.ui.MembersView", "org.eclipse.jdt.ui.PackagesView", "org.eclipse.jdt.ui.TypesView"};
    private String[] classNames = new String[]{"org.eclipse.jdt.internal.ui.browsing.MembersView", "org.eclipse.jdt.internal.ui.browsing.PackagesView", "org.eclipse.jdt.internal.ui.browsing.TypesView"};
    private IWorkbenchWindow initWindow;

    public FocusBrowsingPerspectiveAction() {
        super(new InterestFilter(), true, true, false);
        this.globalPrefId = "org.eclipse.mylyn.ui.interest.filter.javaBrowsing";
    }

    public void init(IWorkbenchWindow window) {
        this.initWindow = window;
        IWorkbenchPage activePage = this.initWindow.getActivePage();
        this.viewPart = activePage.findView(this.viewNames[0]);
    }

    public List<StructuredViewer> getViewers() {
        ArrayList<StructuredViewer> viewers = new ArrayList<StructuredViewer>();
        int i = 0;
        while (i < this.viewNames.length) {
            StructuredViewer viewer = this.getBrowsingViewerFromActivePerspective(this.viewNames[i], this.classNames[i]);
            if (viewer != null) {
                viewers.add(viewer);
            }
            ++i;
        }
        return viewers;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private StructuredViewer getBrowsingViewerFromActivePerspective(String id, String className) {
        IWorkbenchPage activePage = this.initWindow.getActivePage();
        if (activePage == null) {
            return null;
        }
        IViewPart viewPart = activePage.findView(id);
        Class<?> sub = Class.forName(className);
        if (!sub.isInstance(viewPart)) return null;
        IViewPart view = viewPart;
        if (view == null) return null;
        try {
            Class<?> clazz = sub.getSuperclass();
            Method method = clazz.getDeclaredMethod("getViewer", new Class[0]);
            method.setAccessible(true);
            if (id.compareTo("org.eclipse.jdt.ui.PackagesView") != 0) {
                return (StructuredViewer)method.invoke(sub.cast(view), new Object[0]);
            }
            StructuredViewer viewer = (StructuredViewer)method.invoke(sub.cast(view), new Object[0]);
            if (viewer == null || viewer.getClass().getCanonicalName().compareTo(this.packageViewerWrapperClassName) != 0) return viewer;
            clazz = viewer.getClass();
            method = clazz.getDeclaredMethod("getViewer", new Class[0]);
            method.setAccessible(true);
            return (StructuredViewer)method.invoke((Object)viewer, new Object[0]);
        }
        catch (Exception e) {
            try {
                StatusHandler.log((Throwable)e, (String)("couldn't get " + id + " view tree viewer"));
                return null;
            }
            catch (Exception e2) {
                StatusHandler.log((Throwable)e2, (String)("couldn't get " + id + " view tree viewer"));
            }
        }
        return null;
    }

    public void propertyChange(Preferences.PropertyChangeEvent event) {
    }
}

